local inspect = require("__aswil__/aswil_lib/utils/inspect")

-- -- -- TESTS

local excluded_words
local function printIngredients(_ingredients)
	if _ingredients ~= {} then
		for i = 1, #_ingredients do
			for _key, _value in pairs(_ingredients[i]) do
				if type(_value) ~= "number" and _value ~= "fluid" and _value ~= "item" then
					aswil_utils.log.write(1, _value)
				end
			end		
		end
	end	
end

-- -- ingrdient tests

-- getRecipeFromName
local recipe = aswil.recipes.getRecipeFromName("accumulator")
aswil_utils.log.write(1, string.format("getRecipeFromName| accumulator: %s", inspect(recipe)))

-- getIngredients
local ingredients = aswil.recipes.getIngredients("accumulator")
aswil_utils.log.write(1, string.format("getIngredients|Found: %d ingredients", #ingredients))
aswil_utils.log.write(1, string.format("getIngredients|of accumulator:"))
aswil_utils.log.write(1, string.format("getIngredients|ingredients: %s", inspect(ingredients)))

ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|Found: %d ingredients", #ingredients))
aswil_utils.log.write(1, string.format("getIngredients|of concrete:"))
aswil_utils.log.write(1, string.format("getIngredients|ingredients: %s", inspect(ingredients)))

-- hasIngredient
local has = aswil.recipes.hasIngredient("accumulator", "iron-plate")
aswil_utils.log.write(1, string.format("hasIngredient|accumulator has iron plate: %s", tostring(has)))
has = aswil.recipes.hasIngredient("accumulator", "battery")
aswil_utils.log.write(1, string.format("hasIngredient|accumulator has battery: %s", tostring(has)))
has = aswil.recipes.hasIngredient("accumulator", "copper-plate")
aswil_utils.log.write(1, string.format("hasIngredient|accumulator has copper plate: %s", tostring(has)))

-- hasIngredients
has = aswil.recipes.hasIngredients("accumulator", {"iron-plate", "battery"})
aswil_utils.log.write(1, string.format("hasIngredients|accumulator has iron plate and battery: %s", tostring(has)))
has = aswil.recipes.hasIngredients("accumulator", {"iron-plate", "copper-plate"})
aswil_utils.log.write(1, string.format("hasIngredients|accumulator has iron plate and copper plate: %s", tostring(has)))

-- getProducts
local products = aswil.recipes.getProducts("copper-cable")
aswil_utils.log.write(1, string.format("getProducts|Found products: %s", tostring(products ~= nil and products ~= {})))
aswil_utils.log.write(1, string.format("getProducts| copper-cable products: %s", inspect(products)))
	
-- hasProduct
has = aswil.recipes.hasProduct("copper-cable", "copper-plate")
aswil_utils.log.write(1, string.format("hasProduct|copper-cable produce copper plate: %s", tostring(has)))
has = aswil.recipes.hasProduct("copper-cable", "copper-cable")
aswil_utils.log.write(1, string.format("hasProduct|copper-cable produce copper cable: %s", tostring(has)))

-- hasProducts
has = aswil.recipes.hasProducts("copper-cable", {"copper-cable", "iron-plate"})
aswil_utils.log.write(1, string.format("hasProducts|copper-cable produce copper-cable, iron-plate: %s", tostring(has)))

-- SINGLE TESTS
aswil_utils.log.write(1, "-------------------------------------")
--[[
-- removeIngredient
local removed = aswil.recipes.removeIngredient("concrete", "stone-brick")
aswil_utils.log.write(1, string.format("removeIngredient|removed stone brick from concrete: %s", tostring(removed)))
-- removeIngredients
removed = aswil.recipes.removeIngredients("concrete", {"water", "iron-ore"})
aswil_utils.log.write(1, string.format("removeIngredient|removed iron ore and water from concrete: %s", tostring(removed)))
ingredients = aswil.recipes.getIngredients("concrete")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|Found: %d ingredients", #ingredients))
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
local removed = aswil.recipes.removeIngredient("advanced-circuit", "plastic-bar")
aswil_utils.log.write(1, string.format("removeIngredient|removed plastic-bar from advanced-circuit: %s", tostring(removed)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))

removed = aswil.recipes.removeIngredient("advanced-circuit", "wood")
aswil_utils.log.write(1, string.format("removeIngredient|removed wood from advanced-circuit: %s", tostring(removed)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))
--]]

-- removeIngredientFromAllRecipes
--[[
local removed_count = aswil.recipes.removeIngredientFromAllRecipes("advanced-circuit")
aswil_utils.log.write(1, string.format("removeIngredientFromAllRecipes|removed advanced-circuit from: %d recipes", removed_count))
--]]
-- removeIngredientFromAllRecipes
--[[
local removed_count = aswil.recipes.removeIngredientsFromAllRecipes({"electronic-circuit", "advanced-circuit"})
aswil_utils.log.write(1, string.format("removeIngredientsFromAllRecipes|removed electronic-circuit and advanced-circuit from: %d recipes", removed_count))
--]]
-- addIngredient
--[[
local added = aswil.recipes.addIngredient("concrete", {"electronic-circuit", 1})
aswil_utils.log.write(1, string.format("addIngredient|added electronic-circuit to concrete recipe: %s", tostring(added)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
added = aswil.recipes.addIngredient("concrete", {type="fluid", name="water", amount=100})
aswil_utils.log.write(1, string.format("addIngredient|added water to concrete recipe: %s", tostring(added)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
added = aswil.recipes.addIngredient("concrete", {type="item", name="concrete", amount=2})
aswil_utils.log.write(1, string.format("addIngredient|added concrete to concrete recipe: %s", tostring(added)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))

added = aswil.recipes.addIngredient("advanced-circuit", "wood")
aswil_utils.log.write(1, string.format("addIngredient|added wood from advanced-circuit: %s", tostring(added)))
added = aswil.recipes.addIngredient("advanced-circuit", {"wood", 2})
aswil_utils.log.write(1, string.format("addIngredient|added wood from advanced-circuit: %s", tostring(added)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))
--]]
-- addIngredients
--[[
local added = aswil.recipes.addIngredients("concrete", {{type="fluid", name="water", amount=100}, {"concrete", 2}, {"electronic-circuit", 1}})
aswil_utils.log.write(1, string.format("addIngredients|added electronic-circuit, water, concrete to concrete recipe: %s", tostring(added)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- addIngredientToAllRecipes
--[[
local count = aswil.recipes.addIngredientToAllRecipes({"electronic-circuit", 1})
aswil_utils.log.write(1, string.format("addIngredientToAllRecipes|added electronic circuit to: %d recipes", count))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- addIngredientsToAllRecipes
--[[
local count = aswil.recipes.addIngredientsToAllRecipes({{"electronic-circuit", 1}, {"advanced-circuit", 1}})
aswil_utils.log.write(1, string.format("addIngredientsToAllRecipes|added electronic circuit and advanced circuit to: %d recipes", count))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- replaceIngredient
--[[
local replaced_all = aswil.recipes.replaceIngredient("concrete", "iron-ore", {"electronic-circuit", 1})
aswil_utils.log.write(1, string.format("replaceIngredient|replaced iron-ore to electronic-circuit to concrete recipe: %s", tostring(replaced_all)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))

local replace = aswil.recipes.replaceIngredient("advanced-circuit", "copper-cable", {"copper-plate", 1})
aswil_utils.log.write(1, string.format("replaceIngredient|replace copper-cable to copper-plate in advanced-circuit: %s", tostring(replace)))
replace = aswil.recipes.replaceIngredient("advanced-circuit", "copper-cable", {"copper-plate", 1})
aswil_utils.log.write(1, string.format("replaceIngredient|redo replace copper-cable to copper-plate in advanced-circuit: %s", tostring(replace)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))
--]]
-- replaceIngredients
--[[
local replaced_all = aswil.recipes.replaceIngredients("concrete", {"iron-ore", "water", "copper-cable"}, {{"electronic-circuit", 1}, {type="fluid", name="water", amount=200}, {"copper-plate", 1}})
aswil_utils.log.write(1, string.format("replaceIngredients|replaced electronic-circuit to concrete recipe: %s", tostring(replaced_all)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- replaceIngredientToAllRecipes
--[[
local replaced_all = aswil.recipes.replaceIngredientToAllRecipes("iron-ore", {"electronic-circuit", 1})
aswil_utils.log.write(1, string.format("replaceIngredientToAllRecipes|replaced recipes: %s", tostring(replaced_all)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- replaceIngredientsToAllRecipes
--[[
local replaced_all = aswil.recipes.replaceIngredientsToAllRecipes({"iron-ore", "water", "copper-cable"}, {{"electronic-circuit", 1}, {type="fluid", name="water", amount=200}, {"copper-plate", 1}})
aswil_utils.log.write(1, string.format("replaceIngredientsToAllRecipes|replaced recipes: %s", tostring(replaced_all)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- addOrReplaceIngredient
--[[
replaced_all = aswil.recipes.addOrReplaceIngredient("concrete", "iron-ore", {"electronic-circuit", 1})
aswil_utils.log.write(1, "called addOrReplaceIngredient(concrete, iron-ore, {electronic-circuit, 1}")
replaced_all = aswil.recipes.addOrReplaceIngredient("concrete", "iron-ore", {type="item", name="electronic-circuit", amount=1})
aswil_utils.log.write(1, "called addOrReplaceIngredient(concrete, iron-ore, {electronic-circuit, 1}")
replaced_all = aswil.recipes.addOrReplaceIngredient("concrete", "iron-ore", {"advanced-circuit", 1})
aswil_utils.log.write(1, "called addOrReplaceIngredient(concrete, iron-ore, {advanced-circuit, 1}")
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))

local addreplace = aswil.recipes.addOrReplaceIngredient("advanced-circuit", "copper-cable", {"copper-plate", 1})
aswil_utils.log.write(1, string.format("addOrReplaceIngredient|addreplace copper-cable to copper-plate in advanced-circuit: %s", tostring(addreplace)))
addreplace = aswil.recipes.addOrReplaceIngredient("advanced-circuit", nil, {"copper-cable", 10})
aswil_utils.log.write(1, string.format("addOrReplaceIngredient|redo addreplace copper-cable to copper-plate in advanced-circuit: %s", tostring(addreplace)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))
--]]
-- addOrReplaceIngredients
--[[
replaced_all = aswil.recipes.addOrReplaceIngredients("concrete", {"iron-ore", nil}, {{"electronic-circuit", 1}, {"advanced-circuit", 1}})
aswil_utils.log.write(1, "called addOrReplaceIngredients")
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
--]]
-- addOrReplaceIngredientToAllRecipes
--[[
replaced_all = aswil.recipes.addOrReplaceIngredientToAllRecipes("iron-ore", {"electronic-circuit", 1})
aswil_utils.log.write(1, "called addOrReplaceIngredientToAllRecipes with electronic-circuit 1")
local ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
ingredients = aswil.recipes.getIngredients("electronic-circuit")
aswil_utils.log.write(1, string.format("getIngredients|of electronic-circuit: %s", inspect(ingredients)))
--]]
-- addOrReplaceIngredientsToAllRecipes
--[[
replaced_all = aswil.recipes.addOrReplaceIngredientsToAllRecipes({"iron-ore", nil}, {{"electronic-circuit", 1}, {"advanced-circuit", 1}})
aswil_utils.log.write(1, "called addOrReplaceIngredientsToAllRecipes")
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
ingredients = aswil.recipes.getIngredients("electronic-circuit")
aswil_utils.log.write(1, string.format("getIngredients|of electronic-circuit: %s", inspect(ingredients)))
--]]
-- convertIngredient
--[[
local converted = aswil.recipes.convertIngredient("concrete", "iron-ore", "electronic-circuit")
aswil_utils.log.write(1, string.format("convertIngredient|converted iron-ore to electronic-circuit in concrete recipe: %s", tostring(converted)))
local replaced = aswil.recipes.replaceIngredient("concrete", "electronic-circuit", {type="item", name="iron-ore", amount=1})
aswil_utils.log.write(1, string.format("replaceIngredient|replaced electronic-circuit to iron-ore in concrete recipe: %s", tostring(replaced)))
converted = aswil.recipes.convertIngredient("concrete", "iron-ore", "electronic-circuit")
aswil_utils.log.write(1, string.format("convertIngredient|converted iron-ore to electronic-circuit in concrete recipe: %s", tostring(converted)))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))

local converted = aswil.recipes.convertIngredient("advanced-circuit", "copper-cable", "copper-plate")
aswil_utils.log.write(1, string.format("convertIngredient|convert copper-cable to copper-plate in advanced-circuit: %s", tostring(converted)))
converted = aswil.recipes.convertIngredient("advanced-circuit", "iron-ore", "copper-cable")
aswil_utils.log.write(1, string.format("convertIngredient|convert iron-ore to copper-cable in advanced-circuit: %s", tostring(converted)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
ingredients_ex = aswil.recipes.getExpensiveIngredients("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
aswil_utils.log.write(1, string.format("getExpensiveIngredients|of advanced-circuit: %s", inspect(ingredients_ex)))
--]]
-- convertIngredientsFromAllRecipes
--[[
local converted = aswil.recipes.convertIngredientsFromAllRecipes({"iron-ore", "electronic-circuit"}, {"electronic-circuit", "advanced-circuit"})
aswil_utils.log.write(1, string.format("convertIngredientsFromAllRecipes| converted: %d", converted))
ingredients = aswil.recipes.getIngredients("concrete")
aswil_utils.log.write(1, string.format("getIngredients|of concrete: %s", inspect(ingredients)))
ingredients = aswil.recipes.getIngredients("advanced-circuit")
aswil_utils.log.write(1, string.format("getIngredients|of advanced-circuit: %s", inspect(ingredients)))
ingredients = aswil.recipes.getIngredients("stack-inserter")
aswil_utils.log.write(1, string.format("getIngredients|of stack-inserter: %s", inspect(ingredients)))
--]]

-- -- -- PRODUCTS

--[[
-- removeIngredient
local removed = aswil.recipes.removeProduct("concrete", "concrete")
aswil_utils.log.write(1, string.format("removeProduct|removed concrete from concrete: %s", tostring(removed)))
-- removeIngredients
removed = aswil.recipes.removeProducts("concrete", {"water", "iron-ore"})
aswil_utils.log.write(1, string.format("removeProducts|removed iron ore and water from concrete products: %s", tostring(removed)))
products = aswil.recipes.getProducts("concrete")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|Found: %d products", #products))
aswil_utils.log.write(1, string.format("getProducts|of concrete: %s", inspect(products)))
removed = aswil.recipes.removeProducts("advanced-circuit", {"advanced-circuit", "advanced-circuit"})
aswil_utils.log.write(1, string.format("removeProducts|removed advanced-circuit from advanced-circuit: %s", tostring(removed)))
products = aswil.recipes.getProducts("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|of advanced-circuit: %s", inspect(products)))

removed = aswil.recipes.removeProducts("advanced-circuit", {"wood"})
aswil_utils.log.write(1, string.format("removeProducts|removed wood from advanced-circuit: %s", tostring(removed)))
products = aswil.recipes.getProducts("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|of advanced-circuit: %s", inspect(products)))
--]]

--ADD

--[[
-- removeIngredient
local addProduct = aswil.recipes.addProduct("concrete", "concrete")
aswil_utils.log.write(1, string.format("removeProduct|removed concrete from concrete: %s", tostring(addProduct)))
-- removeIngredients
addProducts = aswil.recipes.addProducts("concrete", {{"wood", 1}, {"iron-ore", 1}})
aswil_utils.log.write(1, string.format("addProducts|removed iron ore and water from concrete products: %s", tostring(addProducts)))
products = aswil.recipes.getProducts("concrete")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|Found: %d products", #products))
aswil_utils.log.write(1, string.format("getProducts|of concrete: %s", inspect(products)))
addProducts = aswil.recipes.addProducts("advanced-circuit", {{"advanced-circuit", 1}, {"advanced-circuit", 1}})
aswil_utils.log.write(1, string.format("removeProducts|removed advanced-circuit from advanced-circuit: %s", tostring(addProducts)))
products = aswil.recipes.getProducts("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|of advanced-circuit: %s", inspect(products)))

addProducts = aswil.recipes.addProducts("advanced-circuit", {"wood", 1})
aswil_utils.log.write(1, string.format("removeProducts|removed wood from advanced-circuit: %s", tostring(addProducts)))
products = aswil.recipes.getProducts("advanced-circuit")
-- checking removed
aswil_utils.log.write(1, string.format("getProducts|of advanced-circuit: %s", inspect(products)))
--]]

-- FIND UNLOCABLE
---[[
aswil.recipes.disable("electronic-circuit")
local recipe = aswil.recipes.getRecipeFromName("electronic-circuit")
aswil_utils.log.write(1, string.format("getRecipeFromName| electronic-circuit: %s", inspect(recipe)))
aswil.recipes.findNotUnlockableRecipes()
--]]

aswil_utils.log.write(1, "------------------END RECIPES TESTS-------------------")