local resistances =    {
      {
        type = "fire",
        percent = 70
      },
	  {
        type = "impact",
        percent = 60
      }
    }
local energy_usage = "150MW"
local max_health = 3000	
	

local stage1=   {
    type = "assembling-machine",
    name = "rsc-silo-stage1",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage1.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage1"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage1",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }


local stage2=     {
    type = "assembling-machine",
    name = "rsc-silo-stage2",
	order= "r-s",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage2.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage2"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage2",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }

 
local stage3=   {
    type = "assembling-machine",
    name = "rsc-silo-stage3",
	order= "r-s",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage3.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage3"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage3",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }

   
local stage4=   {
    type = "assembling-machine",
    name = "rsc-silo-stage4",
	order= "r-s",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage4.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage4"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage4",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }


 
local stage5=   {
    type = "assembling-machine",
    name = "rsc-silo-stage5",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
	order= "r-s",
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage5.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage5"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage5",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }

 
local stage6=   {
    type = "assembling-machine",
    name = "rsc-silo-stage6",
    icon = "__base__/graphics/icons/rocket-silo.png", 
    icon_size = 32,
	order= "r-s",
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 60, result = "rsc-excavation-site"}, 
    max_health = max_health,
    corpse = "rocket-silo-generic-remnants",
    dying_explosion = "medium-explosion",
    alert_icon_shift = util.by_pixel(-3, -12),
    resistances = resistances,
    fluid_boxes = {}, -- zerado
	collision_box = {{-4.40, -4.40}, {4.40, 4.40}}, -- colision do silo
    selection_box = {{-4.5, -4.5}, {4.5, 4.5}},
    animation =
    {
      layers = 
      {	  	  
		{
        filename = "__Rocket-Silo-Construction__/graphics/rs-stage6.png",
        width = 608,
        height = 596,
        shift = util.by_pixel(-5, 16),
        scale = 0.5
		},
	  }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-mining-drill.ogg",
        volume = 1
      },
      apparent_volume = 2
    },
    crafting_categories = {"rsc-stage6"}, --so advanced-crafting
	fixed_recipe = "rsc-construction-stage6",
    crafting_speed = 1, 
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input", -- silo usa primary-input
      emissions_per_minute = 200
    },
    energy_usage = energy_usage,
    module_specification = {module_slots = 0},
	allowed_effects = {}
  }


data:extend({
	stage1,stage2,stage3,stage4,stage5,stage6
})


local function update_proto_serlp(stage,newname) 
local new = table.deepcopy(stage)
 new.name=newname
 new.minable.result = "rsc-excavation-site-serlp"
 new.collision_box = {{-4.85, -4.85}, {4.85, 4.85}}
 new.selection_box = {{-4.85, -4.85}, {4.85, 4.85}}
 return new
end

if data.raw.item['se-rocket-launch-pad'] then
 local ST1 = update_proto_serlp(stage1,'rsc-silo-stage1-serlp')
 local ST2 = update_proto_serlp(stage2,'rsc-silo-stage2-serlp')
 local ST3 = update_proto_serlp(stage3,'rsc-silo-stage3-serlp')
 local ST4 = update_proto_serlp(stage4,'rsc-silo-stage4-serlp')
 local ST5 = update_proto_serlp(stage5,'rsc-silo-stage5-serlp')
 local ST6 = update_proto_serlp(stage6,'rsc-silo-stage6-serlp')
 
data:extend({
ST1,ST2,ST3,ST4,ST5,ST6
 })
end