require("util")
require("utils")
local ticks_1_s  =    60


-- CUSTOM EVENT HANDLING --
--(remote interface is lower in the file, there I describe how to subscribe to my event)
-- if your mod creates the stage 1 construction site via script, you should add the script_raised_built event
-- in this case, the completion status is raised with this custom event, on_silo_stage_finished
local on_silo_stage_finished = script.generate_event_name() --uint



local function ifthen( cond, val1, val2 )
	if cond then
		return val1
	else
		return val2
	end
end

function ModSetup()
if global.rsc_silo_under_construction==nil then global.rsc_silo_under_construction={} end

for f=1, #game.forces do
	local force = game.forces[f]
	if force.technologies then 
		if force.technologies['rocket-silo'] and force.technologies['rocket-silo'].researched then 
			force.recipes['rsc-excavation-site'].enabled = true
			end
		if force.technologies['se-rocket-launch-pad'] and force.technologies['se-rocket-launch-pad'].researched then 
			force.recipes['rsc-serlp-excavation-site'].enabled = true
			end
		end
	end
end


function On_Init() 
ModSetup()
end

function on_configuration_changed(data)
ModSetup()
end
script.on_configuration_changed(on_configuration_changed)
script.on_init(On_Init)


function square_area( origin, radius )
	return {
		{x=origin.x - radius, y=origin.y - radius},
		{x=origin.x + radius, y=origin.y + radius}
	}
end


local function FillWith(surface,position,area,withwhat)
if (not settings.startup["rsc-st-dont-place-tiles"].value) and (not remote.interfaces["warptorio2"]) then
if remote.interfaces["space-exploration"] then 
	local Zone = remote.call("space-exploration", "get_zone_from_name", {zone_name = surface.name})
	if Zone then 
		local zone_index = Zone.index
		local is_space = remote.call("space-exploration", "get_zone_is_space", {zone_index = zone_index})
		if is_space then return end
		end
	end

local solo = {}

	local X = position.x
	local Y = position.y
	
	local x1,x2 = X-area , X+area
	local y1,y2 = Y-area , Y+area
	for y=y1,y2 do
		for x=x1,x2 do
		table.insert(solo, {name=withwhat, position={x=x, y=y}}) 
		end
	end

if #solo>0 then
	surface.set_tiles(solo)
	end
end	
end


local function CallFrenzyAttack(target)
if (target and target.valid) then 
	if target.surface.map_gen_settings.autoplace_controls["enemy-base"].size>0 then
		local Min = 20
		local Max = 40
		local Dist = 400
		local aliens = math.random(Min,Max)
		local spawn = target.surface.find_entities_filtered({type = "unit-spawner",limit=1,position=target.position, radius=Dist})
		if #spawn>0 then
			local force = spawn[1].force
			local sent = target.surface.set_multi_command({
					command = {type=defines.command.attack_area, destination=target.position, radius=50, distraction = defines.distraction.by_anything },
					unit_count = aliens,
					force = force,
					unit_search_distance = Dist,
				})
			end
	end
end
end



local function upgrade_construction_site(silo_data)

local silo=silo_data.silo
if silo and silo.valid then

local name=silo.name
local upgrade_to
local last_user = silo.last_user
local final_building = 'rocket-silo'  -- default

if silo_data.final_building ~= nil then final_building=silo_data.final_building end

local work = settings.startup["rsc-st-work-for-insert-material"].value
local position=silo.position
local surface=silo.surface
local force=silo.force

if name=='rsc-silo-stage1'       then upgrade_to='rsc-silo-stage2' 
  elseif name=='rsc-silo-stage2' then upgrade_to='rsc-silo-stage3'  work = settings.startup["rsc-st-work-for-remove-stone"].value
  elseif name=='rsc-silo-stage3' then upgrade_to='rsc-silo-stage4'  FillWith(surface,position,5,'concrete') 
  elseif name=='rsc-silo-stage4' then upgrade_to='rsc-silo-stage5' 
  elseif name=='rsc-silo-stage5' then upgrade_to='rsc-silo-stage6'  FillWith(surface,position,6,'concrete') FillWith(surface,position,5,'refined-hazard-concrete-left') 
  elseif name=='rsc-silo-stage6' then upgrade_to=final_building 

  elseif name=='rsc-silo-stage1-serlp' then upgrade_to='rsc-silo-stage2-serlp' 
  elseif name=='rsc-silo-stage2-serlp' then upgrade_to='rsc-silo-stage3-serlp'  work = settings.startup["rsc-st-work-for-remove-stone"].value
  elseif name=='rsc-silo-stage3-serlp' then upgrade_to='rsc-silo-stage4-serlp'  FillWith(surface,position,6,'concrete') 
  elseif name=='rsc-silo-stage4-serlp' then upgrade_to='rsc-silo-stage5-serlp' 
  elseif name=='rsc-silo-stage5-serlp' then upgrade_to='rsc-silo-stage6-serlp' FillWith(surface,position,7,'concrete') FillWith(surface,position,6,'refined-hazard-concrete-left') 
  elseif name=='rsc-silo-stage6-serlp' then upgrade_to=final_building end


silo.destroy()
local new_stage = surface.create_entity{name = upgrade_to, position = position, force=force}
if math.random(0,1)==0 then CallFrenzyAttack(new_stage) end

if last_user then new_stage.last_user = last_user end

if  upgrade_to~=final_building then 
	local silo_data = {silo=new_stage,bar_back=nil,progress_bar=nil,work_value=work,final_building=final_building}
	table.insert (global.rsc_silo_under_construction,silo_data)
	if settings.startup["rsc-st-not-removable-site"].value then
		new_stage.minable=false end
	else
	if settings.startup["rsc-st-not-removable-silo"].value then
		new_stage.minable=false end
	end

local player_index
if last_user and  last_user.index then	player_index = last_user.index end
if not player_index then player_index = 1 end
if player_index then
	script.raise_event(defines.events.on_built_entity, {created_entity =new_stage, player_index = player_index, stack = stack})
	end
script.raise_event(on_silo_stage_finished, {created_entity = new_stage})
end
end




local function check_construction_site(silo_data)

local entity=silo_data.silo
local progress=entity.products_finished 
local max_progress=silo_data.work_value

if progress>=max_progress then 
	entity.active  = false
	if entity.get_output_inventory().get_item_count()<1 then
		upgrade_construction_site(silo_data) 
		return 
		end
	end
	

local background = silo_data.bar_back
  if not background then
    background = rendering.draw_line
    {
      color = {r = 1, b = 1, g = 1},
      width = 10,
      from = entity,
      from_offset = {-33/32, 1},
      to = entity,
      to_offset = {33/32, 1},
      surface = entity.surface,
      forces = {entity.force}
    }
    silo_data.bar_back = background
  end

  local progress_bar = silo_data.progress_bar
  if not progress_bar then
    progress_bar = rendering.draw_line
    {
      color = {r = 0, g = 1, b = 0},
      width = 8,
      from = entity,
      from_offset = {-1, 1},
      to = entity,
      to_offset = {1, 1},
      surface = entity.surface,
      forces = {entity.force}
    }
    silo_data.progress_bar = progress_bar
  end
  rendering.set_to(silo_data.progress_bar, entity, {(2 * (progress / max_progress)) - 1, 1})

end


script.on_nth_tick(ticks_1_s, function (event)
		
	for k, silo_data in pairs (global.rsc_silo_under_construction) do 
		local silo = silo_data.silo
		if silo and silo.valid then 
			check_construction_site(silo_data)
			else
			table.remove (global.rsc_silo_under_construction,k)
			end
		end
end)



function On_Built(event)
local ent = event.created_entity
if not ent then ent = event.entity end

if ent and ent.valid then
if  ent.name == 'rsc-silo-stage1' or ent.name == 'rsc-silo-stage1-serlp' then
	local surface = ent.surface
	local final_building = 'rocket-silo'
	local work_value=settings.startup["rsc-st-work-for-remove-stone"].value
	if ent.name == 'rsc-silo-stage1-serlp' then final_building = 'se-rocket-launch-pad' end
	
	-- if space explorarion mod present - if in orbit, then construction starts in stage 4 - no excavation required
	if game.item_prototypes["rsc-excavation-site-serlp"] then
		local Zone = remote.call("space-exploration", "get_zone_from_name", {zone_name = surface.name})
		if Zone then 
			local zone_index = Zone.index
			local is_space = remote.call("space-exploration", "get_zone_is_space", {zone_index = zone_index})
			if is_space then
				local position = ent.position
				local force=ent.force
				local player_index=event.player_index
				ent.destroy()
				local stage4 = ifthen(final_building=='rocket-silo','rsc-silo-stage4','rsc-silo-stage4-serlp')
				ent=surface.create_entity{name=stage4, force=force, position = position}
				if player_index then ent.last_user = game.players[player_index] end
				work_value=settings.startup["rsc-st-work-for-insert-material"].value	
				end
			end
	end

	local silo_data = 
		{
		silo=ent,
		bar_back=nil,
		progress_bar=nil,
		work_value=work_value,
		final_building=final_building
		}
	table.insert (global.rsc_silo_under_construction,silo_data)
	if settings.startup["rsc-st-not-removable-site"].value then
		ent.minable=false end
	end
end
end
--local build_events = {defines.events.on_built_entity, defines.events.on_robot_built_entity, defines.events.script_raised_built}
local filters = {{filter = "name", name = "rsc-silo-stage1"}, {filter = "name", name = "rsc-silo-stage1-serlp"}}
script.on_event(defines.events.on_built_entity, On_Built, filters) 
script.on_event(defines.events.on_robot_built_entity, On_Built, filters) 
script.on_event(defines.events.script_raised_built, On_Built) 




local function UpgradeAllStagesNow()
local tabcopy = table.deepcopy(global.rsc_silo_under_construction)
	for k, silo_data in pairs (tabcopy) do 
	upgrade_construction_site(silo_data)
	end
end




function on_entity_cloned(event)
local destination = event.destination
if in_list({'rsc-silo-stage1','rsc-silo-stage2','rsc-silo-stage3','rsc-silo-stage4','rsc-silo-stage5','rsc-silo-stage6'}, destination.name) then
	game.print('yo1')
	for k,silo_data in pairs (global.rsc_silo_under_construction) do
		if silo_data.silo == event.source then
			game.print('yo')
		   global.rsc_silo_under_construction[k].silo = destination
		   global.rsc_silo_under_construction[k].bar_back=nil
		   global.rsc_silo_under_construction[k].progress_bar=nil
		   break
		   end
		end
	end

end
script.on_event(defines.events.on_entity_cloned, on_entity_cloned)




-- INTERFACE  --
--------------------------------------------------------------------------------------
local interface = {}


function interface.UpgradeConstruction()
UpgradeAllStagesNow()
end


--[[ HOW TO subscribe to my custom event:
	script.on_event(remote.call("RocketSiloCon", "get_on_silo_stage_finished"), function(event)
		--do your stuff
	end)
	WARNING: this has to be done within on_init and on_load, otherwise the game will error about the remote.call
	
	if your dependency on my mod is optional, remember to check if the remote interface exists before calling it:
	if remote.interfaces["RocketSiloCon"] then
		--interface exists
	end]]

function interface.get_on_silo_stage_finished()
return on_silo_stage_finished
end
		-- Returns :
		-- event.created_entity = The stage number that was completed

remote.add_interface("RocketSiloCon", interface )