
--------  Wood, Stone, and Solid Fuel use the "All Scrap Probability" and "All Scrap Amount Modifier" values

scrap2.lib.addScrap("wooden-chest", "wood", 1)
scrap2.lib.addScrap("small-electric-pole", "wood", 1)

scrap2.lib.addScrap("stone-brick",  "stone", 1)
scrap2.lib.addScrap("stone-furnace", "stone", 3)
scrap2.lib.addScrap("boiler", "stone", 3)
scrap2.lib.addScrap("stone-wall", "stone", 5)
scrap2.lib.addScrap("gate", "stone", 5)
scrap2.lib.addScrap("concrete", "stone", 5)
scrap2.lib.addScrap("hazard-concrete", "stone", 5)
scrap2.lib.addScrap("refined-concrete", "stone", 10)
scrap2.lib.addScrap("refined-hazard-concrete", "stone", 10)
scrap2.lib.addScrap("landfill", "stone", 10)
scrap2.lib.addScrap("steel-furnace", "stone", 10)
scrap2.lib.addScrap("steel-furnace", "steel-plate-scrap", 3)
scrap2.lib.addScrap("electric-furnace", "stone", 10)
scrap2.lib.addScrap("electric-furnace", "steel-plate-scrap", 5)
scrap2.lib.addScrap("electric-furnace", "circuit-scrap", 3)
scrap2.lib.addScrap("production-science-pack", "stone", 10)
scrap2.lib.addScrap("production-science-pack", "steel-plate-scrap", 12)
scrap2.lib.addScrap("production-science-pack", "circuit-scrap", 8)

scrap2.lib.addScrap("rocket-fuel", "solid-fuel", 5)

--------

scrap2.lib.addScrap("iron-plate", "iron-plate-scrap", 1)
scrap2.lib.addScrap("iron-stick", "iron-plate-scrap", 1)
scrap2.lib.addScrap("iron-gear-wheel", "iron-plate-scrap", 1)
scrap2.lib.addScrap("pipe", "iron-plate-scrap", 1)
scrap2.lib.addScrap("pipe-to-ground", "iron-plate-scrap", 8)
scrap2.lib.addScrap("burner-inserter", "iron-plate-scrap", 2)
scrap2.lib.addScrap("offshore-pump", "iron-plate-scrap", 3)
scrap2.lib.addScrap("repair-pack", "iron-plate-scrap", 3)
scrap2.lib.addScrap("iron-chest", "iron-plate-scrap", 4)
scrap2.lib.addScrap("burner-mining-drill", "iron-plate-scrap", 5)
scrap2.lib.addScrap("burner-mining-drill", "stone", 3)
scrap2.lib.addScrap("storage-tank", "iron-plate-scrap", 10)
scrap2.lib.addScrap("storage-tank", "steel-plate-scrap", 3)
scrap2.lib.addScrap("car", "iron-plate-scrap", 10)
scrap2.lib.addScrap("car", "engine-scrap", 4)
scrap2.lib.addScrap("steam-engine", "iron-plate-scrap", 16)
scrap2.lib.addScrap("steam-turbine", "iron-plate-scrap", 60)
scrap2.lib.addScrap("steam-turbine", "copper-plate-scrap", 25)

scrap2.lib.addScrap("copper-plate", "copper-plate-scrap", 1)
scrap2.lib.addScrap("copper-cable", "copper-plate-scrap", 1)
scrap2.lib.addScrap("low-density-structure", "copper-plate-scrap", 10)
scrap2.lib.addScrap("heat-pipe", "copper-plate-scrap", 10)
scrap2.lib.addScrap("heat-pipe", "steel-plate-scrap", 5)
scrap2.lib.addScrap("heat-exchanger", "copper-plate-scrap", 50)
scrap2.lib.addScrap("heat-exchanger", "iron-plate-scrap", 5)
scrap2.lib.addScrap("heat-exchanger", "steel-plate-scrap", 5)

scrap2.lib.addScrap("steel-plate", "steel-plate-scrap", 1)
scrap2.lib.addScrap("rail", "steel-plate-scrap", 1)

scrap2.lib.addScrap("empty-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-crude-oil-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-heavy-oil-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-light-oil-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-lubricant-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-petroleum-gas-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-sulfuric-acid-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-water-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("empty-waste-water-barrel", "steel-plate-scrap", 1)
scrap2.lib.addScrap("steel-chest", "steel-plate-scrap", 4)
scrap2.lib.addScrap("nuclear-reactor", "steel-plate-scrap", 200)
scrap2.lib.addScrap("nuclear-reactor", "stone", 200)
scrap2.lib.addScrap("nuclear-reactor", "circuit-scrap", 200)
scrap2.lib.addScrap("rocket-silo", "steel-plate-scrap", 500)
scrap2.lib.addScrap("rocket-silo", "stone", 500)
scrap2.lib.addScrap("rocket-silo", "engine-scrap", 100)
scrap2.lib.addScrap("rocket-silo", "circuit-scrap", 100)

scrap2.lib.addScrap("transport-belt", "belt-scrap", 1)
scrap2.lib.addScrap("fast-transport-belt", "belt-scrap", 3)
scrap2.lib.addScrap("express-transport-belt", "belt-scrap", 8)

scrap2.lib.addScrap("underground-belt", "belt-scrap", 4)
scrap2.lib.addScrap("fast-underground-belt", "belt-scrap", 24)
scrap2.lib.addScrap("express-underground-belt", "belt-scrap", 64)

scrap2.lib.addScrap("splitter", "belt-scrap", 4)
scrap2.lib.addScrap("splitter", "circuit-scrap", 3)
scrap2.lib.addScrap("fast-splitter", "belt-scrap", 12)
scrap2.lib.addScrap("fast-splitter", "circuit-scrap", 5)
scrap2.lib.addScrap("express-splitter", "belt-scrap", 24)
scrap2.lib.addScrap("express-splitter", "circuit-scrap", 10)

scrap2.lib.addScrap("inserter", "inserter-scrap", 1)
scrap2.lib.addScrap("long-handed-inserter", "inserter-scrap", 1)
scrap2.lib.addScrap("fast-inserter", "inserter-scrap", 2)
scrap2.lib.addScrap("filter-inserter", "inserter-scrap", 3)
scrap2.lib.addScrap("stack-inserter", "inserter-scrap", 6)
scrap2.lib.addScrap("stack-filter-inserter", "inserter-scrap", 6)
scrap2.lib.addScrap("logistic-science-pack", "inserter-scrap", 2)

scrap2.lib.addScrap("assembling-machine-1", "machine-scrap", 1)
scrap2.lib.addScrap("assembling-machine-2", "machine-scrap", 2)
scrap2.lib.addScrap("assembling-machine-3", "machine-scrap", 5)
scrap2.lib.addScrap("electric-mining-drill", "machine-scrap", 1)
scrap2.lib.addScrap("lab", "machine-scrap", 2)
scrap2.lib.addScrap("chemical-plant", "machine-scrap", 1)
scrap2.lib.addScrap("chemical-plant", "steel-plate-scrap", 2)
scrap2.lib.addScrap("oil-refinery", "machine-scrap", 2)
scrap2.lib.addScrap("oil-refinery", "steel-plate-scrap", 8)
scrap2.lib.addScrap("pumpjack", "machine-scrap", 2)
scrap2.lib.addScrap("centrifuge", "machine-scrap", 20)
scrap2.lib.addScrap("centrifuge", "circuit-scrap", 10)

scrap2.lib.addScrap("electronic-circuit", "circuit-scrap", 1)
scrap2.lib.addScrap("advanced-circuit", "circuit-scrap", 2)
scrap2.lib.addScrap("processing-unit", "circuit-scrap", 12)
scrap2.lib.addScrap("rocket-control-unit", "circuit-scrap", 20)
scrap2.lib.addScrap("rail-signal", "circuit-scrap", 1)
scrap2.lib.addScrap("rail-chain-signal", "circuit-scrap", 1)
scrap2.lib.addScrap("train-stop", "circuit-scrap", 3)
scrap2.lib.addScrap("train-stop", "iron-plate-scrap", 3)
scrap2.lib.addScrap("arithmetic-combinator", "circuit-scrap", 3)
scrap2.lib.addScrap("decider-combinator", "circuit-scrap", 3)
scrap2.lib.addScrap("constant-combinator", "circuit-scrap", 1)
scrap2.lib.addScrap("power-switch", "circuit-scrap", 2)
scrap2.lib.addScrap("programmable-speaker", "circuit-scrap", 3)
scrap2.lib.addScrap("beacon", "circuit-scrap", 30)
scrap2.lib.addScrap("beacon", "steel-plate-scrap", 5)
scrap2.lib.addScrap("automation-science-pack", "circuit-scrap", 1)
scrap2.lib.addScrap("utility-science-pack", "circuit-scrap", 6)
scrap2.lib.addScrap("utility-science-pack", "battery-scrap", 1)

scrap2.lib.addScrap("radar", "military-scrap", 5)
scrap2.lib.addScrap("gun-turret", "military-scrap", 10)
scrap2.lib.addScrap("laser-turret", "military-scrap", 10)
scrap2.lib.addScrap("laser-turret", "battery-scrap", 6)
scrap2.lib.addScrap("submachine-gun", "military-scrap", 5)
scrap2.lib.addScrap("shotgun", "military-scrap", 2)
scrap2.lib.addScrap("combat-shotgun", "military-scrap", 2)
scrap2.lib.addScrap("rocket-launcher", "military-scrap", 5)
scrap2.lib.addScrap("flamethrower", "military-scrap", 5)
scrap2.lib.addScrap("light-armor", "military-scrap", 20)
scrap2.lib.addScrap("heavy-armor", "military-scrap", 50)
scrap2.lib.addScrap("modular-armor", "military-scrap", 50)
scrap2.lib.addScrap("modular-armor", "circuit-scrap", 15)
scrap2.lib.addScrap("power-armor", "military-scrap", 75)
scrap2.lib.addScrap("power-armor", "engine-scrap", 10)
scrap2.lib.addScrap("power-armor", "circuit-scrap", 20)
scrap2.lib.addScrap("power-armor-mk2", "military-scrap", 100)
scrap2.lib.addScrap("power-armor-mk2", "engine-scrap", 20)
scrap2.lib.addScrap("power-armor-mk2", "circuit-scrap", 100)
scrap2.lib.addScrap("energy-shield-equipment", "military-scrap", 5)
scrap2.lib.addScrap("energy-shield-equipment", "circuit-scrap", 3)
scrap2.lib.addScrap("energy-shield-mk2-equipment", "military-scrap", 25)
scrap2.lib.addScrap("energy-shield-mk2-equipment", "circuit-scrap", 15)
scrap2.lib.addScrap("personal-laser-defense-equipment", "military-scrap", 50)
scrap2.lib.addScrap("personal-laser-defense-equipment", "battery-scrap", 30)
scrap2.lib.addScrap("discharge-defense-equipment", "military-scrap", 50)
scrap2.lib.addScrap("discharge-defense-equipment", "battery-scrap", 60)
scrap2.lib.addScrap("night-vision-equipment", "military-scrap", 5)
scrap2.lib.addScrap("personal-roboport-equipment", "logistic-scrap", 20)
scrap2.lib.addScrap("personal-roboport-mk2-equipment", "logistic-scrap", 100)
scrap2.lib.addScrap("flamethrower-turret", "military-scrap", 15)
scrap2.lib.addScrap("flamethrower-turret", "engine-scrap", 3)
scrap2.lib.addScrap("artillery-turret", "military-scrap", 50)
scrap2.lib.addScrap("artillery-turret", "circuit-scrap", 10)
scrap2.lib.addScrap("satellite", "military-scrap", 300)
scrap2.lib.addScrap("satellite", "battery-scrap", 250)

scrap2.lib.addScrap("firearm-magazine", "ammo-scrap", 1)
scrap2.lib.addScrap("piercing-rounds-magazine", "ammo-scrap", 2)
scrap2.lib.addScrap("grenade", "ammo-scrap", 1)
scrap2.lib.addScrap("cluster-grenade", "ammo-scrap", 7)
scrap2.lib.addScrap("explosives", "ammo-scrap", 1)
scrap2.lib.addScrap("cliff-explosives", "ammo-scrap", 5)
scrap2.lib.addScrap("land-mine", "ammo-scrap", 1)
scrap2.lib.addScrap("uranium-rounds-magazine", "ammo-scrap", 2)
scrap2.lib.addScrap("shotgun-shell", "ammo-scrap", 1)
scrap2.lib.addScrap("piercing-shotgun-shell", "ammo-scrap", 2)
scrap2.lib.addScrap("cannon-shell", "ammo-scrap", 1)
scrap2.lib.addScrap("explosive-cannon-shell", "ammo-scrap", 2)
scrap2.lib.addScrap("uranium-cannon-shell", "ammo-scrap", 1)
scrap2.lib.addScrap("explosive-uranium-cannon-shell", "ammo-scrap", 2)
scrap2.lib.addScrap("artillery-shell", "ammo-scrap", 10)
scrap2.lib.addScrap("rocket", "ammo-scrap", 1)
scrap2.lib.addScrap("explosive-rocket", "ammo-scrap", 2)
scrap2.lib.addScrap("atomic-bomb", "ammo-scrap", 5)
scrap2.lib.addScrap("atomic-bomb", "circuit-scrap", 20)
scrap2.lib.addScrap("flamethrower-ammo", "ammo-scrap", 2)
scrap2.lib.addScrap("poison-capsule", "ammo-scrap", 3)
scrap2.lib.addScrap("slowdown-capsule", "ammo-scrap", 2)
scrap2.lib.addScrap("defender-capsule", "ammo-scrap", 1)
scrap2.lib.addScrap("defender-capsule", "logistic-scrap", 1)
scrap2.lib.addScrap("distractor-capsule", "ammo-scrap", 4)
scrap2.lib.addScrap("distractor-capsule", "logistic-scrap", 4)
scrap2.lib.addScrap("destroyer-capsule", "ammo-scrap", 16)
scrap2.lib.addScrap("destroyer-capsule", "logistic-scrap", 16)

scrap2.lib.addScrap("military-science-pack", "military-intel-scrap", 2)

scrap2.lib.addScrap("engine-unit", "engine-scrap", 1)
scrap2.lib.addScrap("electric-engine-unit", "engine-scrap", 1)
scrap2.lib.addScrap("electric-engine-unit", "circuit-scrap", 1)
scrap2.lib.addScrap("pump", "engine-scrap", 1)
scrap2.lib.addScrap("locomotive", "engine-scrap", 10)
scrap2.lib.addScrap("locomotive", "steel-plate-scrap", 15)
scrap2.lib.addScrap("locomotive", "circuit-scrap", 5)
scrap2.lib.addScrap("cargo-wagon", "engine-scrap", 15)
scrap2.lib.addScrap("fluid-wagon", "engine-scrap", 15)
scrap2.lib.addScrap("tank", "engine-scrap", 16)
scrap2.lib.addScrap("artillery-wagon", "engine-scrap", 32)
scrap2.lib.addScrap("exoskeleton-equipment", "engine-scrap", 15)
scrap2.lib.addScrap("exoskeleton-equipment", "circuit-scrap", 5)
scrap2.lib.addScrap("chemical-science-pack", "engine-scrap", 2)
scrap2.lib.addScrap("chemical-science-pack", "circuit-scrap", 2)

scrap2.lib.addScrap("medium-electric-pole", "electric-scrap", 1)
scrap2.lib.addScrap("big-electric-pole", "electric-scrap", 3)
scrap2.lib.addScrap("substation", "electric-scrap", 5)
scrap2.lib.addScrap("small-lamp", "electric-scrap", 1)
scrap2.lib.addScrap("red-wire", "electric-scrap", 1)
scrap2.lib.addScrap("green-wire", "electric-scrap", 1)
scrap2.lib.addScrap("solar-panel", "electric-scrap", 8)
scrap2.lib.addScrap("solar-panel-equipment", "electric-scrap", 5)
scrap2.lib.addScrap("fusion-reactor-equipment", "electric-scrap", 50)
scrap2.lib.addScrap("fusion-reactor-equipment", "circuit-scrap", 100)
scrap2.lib.addScrap("belt-immunity-equipment", "electric-scrap", 5)

scrap2.lib.addScrap("battery", "battery-scrap", 1)
scrap2.lib.addScrap("accumulator", "battery-scrap", 3)
scrap2.lib.addScrap("battery-equipment", "battery-scrap", 3)
scrap2.lib.addScrap("battery-equipment", "steel-plate-scrap", 5)
scrap2.lib.addScrap("battery-mk2-equipment", "battery-scrap", 8)
scrap2.lib.addScrap("battery-mk2-equipment", "circuit-scrap", 8)

scrap2.lib.addScrap("flying-robot-frame", "logistic-scrap", 2)
scrap2.lib.addScrap("logistic-robot", "logistic-scrap", 1)
scrap2.lib.addScrap("construction-robot", "logistic-scrap", 1)
scrap2.lib.addScrap("logistic-chest-passive-provider", "logistic-scrap", 1)
scrap2.lib.addScrap("logistic-chest-active-provider", "logistic-scrap", 1)
scrap2.lib.addScrap("logistic-chest-storage", "logistic-scrap", 1)
scrap2.lib.addScrap("logistic-chest-buffer", "logistic-scrap", 1)
scrap2.lib.addScrap("logistic-chest-requester", "logistic-scrap", 1)
scrap2.lib.addScrap("roboport", "logistic-scrap", 25)

scrap2.lib.addScrap("speed-module", "module-scrap", 1)
scrap2.lib.addScrap("speed-module-2", "module-scrap", 5)
scrap2.lib.addScrap("speed-module-3", "module-scrap", 25)
scrap2.lib.addScrap("productivity-module", "module-scrap", 1)
scrap2.lib.addScrap("productivity-module-2", "module-scrap", 5)
scrap2.lib.addScrap("productivity-module-3", "module-scrap", 25)
scrap2.lib.addScrap("effectivity-module", "module-scrap", 1)
scrap2.lib.addScrap("effectivity-module-2", "module-scrap", 5)
scrap2.lib.addScrap("effectivity-module-3", "module-scrap", 25)


data:extend(
{

  {
    type = "recipe",
    name = "recycle-iron-plate-scrap",
    category = "smelting",
    subgroup = "recycle-scrap",
    enabled = true,
    icon = "__ProductionScrap2__/graphics/recycle-iron-plate-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients = {{"iron-plate-scrap", 1}},
    results = {{name = "iron-plate", amount = 1},{name = "iron-plate-scrap", probability = scrap2.settings["iron-plate-scrap"].probability, amount = 1 * scrap2.settings["iron-plate-scrap"].amountModifier}}
  },

  {
    type = "recipe",
    name = "recycle-copper-plate-scrap",
    category = "smelting",
    subgroup = "recycle-scrap",
    enabled = true,
    icon = "__ProductionScrap2__/graphics/recycle-copper-plate-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients = {{"copper-plate-scrap", 1}},
    results = {{name = "copper-plate", amount = 1},{name = "copper-plate-scrap", probability = scrap2.settings["copper-plate-scrap"].probability, amount = 1 * scrap2.settings["copper-plate-scrap"].amountModifier}}
  },

  {
    type = "recipe",
    name = "recycle-steel-plate-scrap",
    category = "smelting",
    subgroup = "recycle-scrap",
    enabled = true,
    icon = "__ProductionScrap2__/graphics/recycle-steel-plate-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients = {{"steel-plate-scrap", 1}},
    results = {{name = "steel-plate", amount = 1},{name = "steel-plate-scrap", probability = scrap2.settings["steel-plate-scrap"].probability, amount = 1 * scrap2.settings["steel-plate-scrap"].amountModifier}}
  },

  {
    type = "recipe",
    name = "recycle-belt-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "a",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-belt-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "belt-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-inserter-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "b",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-inserter-scrap.png",
    icon_size = 32,
    energy_required = 3,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=5},
      {name = "inserter-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-machine-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "c",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-machine-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "machine-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-circuit-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "d",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-circuit-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "circuit-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-military-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "e",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-military-scrap.png",
    icon_size = 32,
    energy_required = 6,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=15},
      {name = "military-scrap", amount=15}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-engine-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "f",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-engine-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "engine-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-electric-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "g",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-electric-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "electric-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-battery-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "h",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-battery-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "battery-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-module-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "i",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-module-scrap.png",
    icon_size = 32,
    energy_required = 3,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=18},
      {name = "module-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-logistic-scrap",
    category = "chemistry",
    subgroup = "recycle-scrap",
    order = "j",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/recycle-logistic-scrap.png",
    icon_size = 32,
    energy_required = 2,
    ingredients =
    {
      {type="fluid", name="water", amount=30},
      {type="fluid", name="sulfuric-acid", amount=3},
      {name = "logistic-scrap", amount=1}
    },
    results=
    {
      {type="fluid", name="waste-water", amount=30}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "scrap-chest",
    subgroup = "scrap",
    order = "a",
    enabled = false,
    ingredients = {{"scrap", 25}},
    result = "scrap-chest",
  },

  {
    type = "recipe",
    name = "scrap-landfill",
    category = "crafting",
    subgroup = "scrap",
    order = "b",
    enabled = false,
    energy_required = 1,
    ingredients =
    {
      {"scrap", 20}
    },
    result= "scrap-landfill",
    result_count = 1
  },

  {
    type = "recipe",
    name = "scrap-solid-fuel",
    category = "crafting",
    subgroup = "scrap",
    order = "c",
    enabled = false,
    energy_required = 30,
    ingredients =
    {
      {"scrap", 30}
    },
    result= "solid-fuel"
  },

  {
    type = "recipe",
    name = "scrap-land-mine",
    subgroup = "ammo-scrap",
    enabled = false,
    energy_required = 5,
    ingredients =
    {
      {"scrap", 5},
      {"explosives", 2}
    },
    result = "scrap-land-mine",
    result_count = 4
  },

  {
    type = "recipe",
    name = "scrap-grenade",
    subgroup = "ammo-scrap",
    enabled = false,
    energy_required = 6,
    ingredients =
    {
      {"scrap", 25},
      {"coal", 10},
    },
    result = "scrap-grenade"
  },

  {
    type = "recipe",
    name = "recycle-waste-water",
    category = "chemistry",
    subgroup = "waste-water-treatment",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/scrap.png",
    icon_size = 32,
    energy_required = 3,
    ingredients =
    {
      {type="fluid", name="waste-water", amount=20}
    },
    results=
    {
      {type="fluid", name="sulfuric-acid", amount=2},
      {type="item", name="scrap", amount=1},
      {type="fluid", name="water", amount=20}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-waste-water-ammo",
    category = "chemistry",
    subgroup = "waste-water-treatment",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/ammo-scrap.png",
    icon_size = 32,
    energy_required = 3,
    ingredients =
    {
      {type="item", name="ammo-scrap", amount=4},
      {type="fluid", name="waste-water", amount=20}
    },
    results=
    {
      {type="item", name="explosives", amount=1},
      {type="item", name="iron-plate-scrap", amount=1},
      {type="item", name="steel-plate-scrap", amount=1},
      {type="fluid", name="sulfuric-acid", amount=2},
      {type="fluid", name="water", amount=20}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

  {
    type = "recipe",
    name = "recycle-waste-water-intel",
    category = "chemistry",
    subgroup = "waste-water-treatment",
    enabled = false,
    icon = "__ProductionScrap2__/graphics/military-intel-scrap.png",
    icon_size = 32,
    energy_required = 3,
    ingredients =
    {
      {type="item", name="military-intel-scrap", amount=10},
      {type="fluid", name="waste-water", amount=20}
    },
    results=
    {
      {type="item", name="military-science-pack", amount=1},
      {type="fluid", name="sulfuric-acid", amount=2},
      {type="fluid", name="water", amount=20}

    },
    crafting_machine_tint =
    {
      primary = {r = 1.000, g = 1.000, b = 0.990, a = 0.000}, -- REVIEW COLORS
      secondary = {r = 1.000, g = 0.990, b = 1.000, a = 0.000}, -- REVIEW COLORS
      tertiary = {r = 0.990, g = 1.000, b = 1.000, a = 0.000}, -- REVIEW COLORS
    }
  },

})


for i,j in pairs(scrap2.scrapTypes) do
    if i ~= "iron-plate-scrap" and i ~= "copper-plate-scrap" and i ~= "steel-plate-scrap" then
        local recName = "recycle-" .. tostring(i)
        local rt =  scrap2.scrapTypes[i].recycle
        if rt then
            for n,a in pairs(rt) do
                scrap2.lib.addRecycleScrap(recName, a.name, a.amount)
            end
        end
    end
end

