
if not scrap2.lib then scrap2.lib = {} end

function scrap2.lib.addScrap(recipe, scrapType, scrapAmount)

    if not data.raw.recipe[recipe] then
        log("WARN: recipe \"" .. tostring(recipe) .. "\" not found")
        return
    end

    local typeFound = false
    for i,type in pairs(scrap2.scrapTypes) do
        if i == scrapType then
            typeFound = true
            break
        end
    end
    if not typeFound then
        log("WARN: scrapType \"" .. tostring(scrapType) .. "\" not found.  No result added for recipe \"" .. tostring(recipe) .. "\"")
        return
    end

    if scrap2.debug then
        log("PS2: scrapType >" .. tostring(scrapType) .. "<")
    end

    local result_probability = scrap2.settings["all-scrap"].probability or nil
    local result_amount = scrap2.settings["all-scrap"].amountModifier or nil
    if scrap2.settings[scrapType].probability then
        result_probability = scrap2.settings[scrapType].probability
    else
        log("WARN: scrapType \"" .. tostring(scrapType) .. "\" probability not found; trying default")
    end
    if scrap2.settings[scrapType].amountModifier then
        result_amount = scrap2.settings[scrapType].amountModifier
    else
        log("WARN: scrapType \"" .. tostring(scrapType) .. "\" amountModifier not found; trying default")
    end
    if scrap2.debug then
        log("PS2:        prob/mod/amt >" .. tostring(result_probability) .. "/" .. tostring(result_amount) .. "/" ..  tostring(scrapAmount) .. "<")
    end

    if result_probability and result_amount then
        result_amount = result_amount * scrapAmount
        bobmods.lib.recipe.add_result(recipe, {name = scrapType, probability = result_probability, amount = result_amount})
    else
        log("WARN: scrapType \"" .. tostring(scrapType) .. "\" default value(s) not found.  No result added for recipe \"" .. tostring(recipe) .. "\"")
    end
end

function scrap2.lib.addRecycleScrap(recipe, scrapType, scrapAmount)

    if not data.raw.recipe[recipe] then
        log("WARN: recipe \"" .. tostring(recipe) .. "\" not found")
        return
    end

    local typeFound = false
    for i,type in pairs(scrap2.scrapTypes) do
        if i == scrapType then
            typeFound = true
            break
        end
    end
    if not typeFound then
        log("WARN: scrapType \"" .. tostring(scrapType) .. "\" not found.  No result added for recipe \"" .. tostring(recipe) .. "\"")
        return
    end

    if scrap2.debug then
        log("PS2:  recycle:    recipe/type/amt >" .. tostring(recipe) .. "/" .. tostring(scrapType) .. "/" ..  tostring(scrapAmount) .. "<")
    end

    bobmods.lib.recipe.add_result(recipe, {name = scrapType, amount = scrapAmount})
end

function scrap2.lib.addFurnaceResult(furnace, amount)

    if not data.raw["furnace"][furnace] then
        log("WARN: furnace \"" .. tostring(furnace) .. "\" not found")
        return
    end

    data.raw["furnace"][furnace].result_inventory_size = amount

end

function scrap2.lib.addLootToEntity(entityType, entityName, itemName, probability, countMin, countMax)
    if data.raw[entityType] ~= nil then
        if data.raw[entityType][entityName] ~= nil then
            if data.raw[entityType][entityName].loot == nil then
                data.raw[entityType][entityName].loot = {}
            end
            table.insert(data.raw[entityType][entityName].loot, {item = itemName, probability = probability, count_min = countMin, count_max = countMax})
        end
    end
end

function scrap2.lib.logResults(itemlookup)

    log("PS2: BEG logResults output")

    for x,item in pairs(itemlookup) do
        log("PS2:     ----  " .. tostring(itemlookup[x]) .. "  ----")
        local recipe = data.raw.recipe[item]
        if recipe then
            if recipe.result then
                log("PS2:     result: " .. tostring(recipe.result) .. "  prob: " .. tostring(recipe.probability) .. "  amt: " .. tostring(recipe.amount))
            end
            if recipe.results then
                for i,r2 in pairs(recipe.results) do
                    log("PS2:     results [".. tostring(i) .. "]: " .. tostring(r2.name) .. "  prob: " .. tostring(r2.probability) .. "  amt: " .. tostring(r2.amount))
                end
            end
            if recipe.normal then
                    if recipe.normal.result then
                        log("PS2:     normal result: " .. tostring(recipe.normal.result))
                    end
                    if recipe.normal.results then
                        for i,r2 in pairs(recipe.normal.results) do
                            log("PS2:     normal results [".. tostring(i) .. "]: " .. tostring(r2.name) .. "  prob: " .. tostring(r2.probability) .. "  amt: " .. tostring(r2.amount))
                        end
                    end
            end
            if recipe.expensive then
                    if recipe.expensive.result then
                        log("PS2:     expensive result: " .. tostring(recipe.expensive.result))
                    end
                    if recipe.expensive.results then
                        for i,r2 in pairs(recipe.expensive.results) do
                            log("PS2:     expensive results [".. tostring(i) .. "]: " .. tostring(r2.name) .. "  prob: " .. tostring(r2.probability) .. "  amt: " .. tostring(r2.amount))
                        end
                    end
            end
        else
            log("PS2:    ----  recipe not found  ----")
        end
    end

    log("PS2: END logResults output")
end

function scrap2.lib.logSubgroups()

    log("PS2: BEG logSubgroups output")

    for x,item in pairs(data.raw.item) do
        if item.subgroup then
            log("PS2:    ----  " .. tostring(x) .. "  ----    subg: " .. tostring(item.subgroup))
        end
    end

    log("PS2: END logSubgroups output")
end

