
if not scrap2.ignore then scrap2.ignore = {} end
if not scrap2.scrapTypes then scrap2.scrapTypes = {} end
if not scrap2.settings then scrap2.settings = {} end

---- The following table lists the vanilla recipes that will not produce scrap.
scrap2.ignore = { 
    ["basic-oil-processing"] = true,
    ["advanced-oil-processing"] = true,
    ["coal-liquefaction"] = true,
    ["heavy-oil-cracking"] = true,
    ["light-oil-cracking"] = true,
    ["sulfuric-acid"] = true,
    ["solid-fuel-from-light-oil"] = true,
    ["solid-fuel-from-heavy-oil"] = true,
    ["solid-fuel-from-petroleum-gas"] = true,
    ["lubricant"] = true,
    ["fill-water-barrel"] = true,
    ["fill-crude-oil-barrel"] = true,
    ["fill-heavy-oil-barrel"] = true,
    ["fill-light-oil-barrel"] = true,
    ["fill-petroleum-gas-barrel"] = true,
    ["fill-lubricant-barrel"] = true,
    ["fill-sulfuric-acid-barrel"] = true,
    ["sulfur"] = true,
    ["plastic-bar"] = true,
    ["pistol"] = true,
    ["nuclear-fuel"] = true,
    ["uranium-fuel-cell"] = true,
    ["nuclear-fuel-reprocessing"] = true,
    ["kovarex-enrichment-process"] = true,
    ["discharge-defense-remote"] = true,
    ["artillery-targeting-remote"] = true
  }

scrap2.scrapTypes["iron-plate-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 1 }} }
scrap2.scrapTypes["copper-plate-scrap"] = { recycle = {{ name = "copper-plate-scrap", amount = 1 }} }
scrap2.scrapTypes["steel-plate-scrap"] = { recycle = {{ name = "steel-plate-scrap", amount = 1 }} }
scrap2.scrapTypes["belt-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 2 }} }
scrap2.scrapTypes["inserter-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 2 }, { name =  "circuit-scrap", amount = 1 }} }
scrap2.scrapTypes["machine-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 10 }, { name =  "circuit-scrap", amount = 2 }} }
scrap2.scrapTypes["circuit-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 1 }, { name =  "copper-plate-scrap", amount = 2 }} }
scrap2.scrapTypes["military-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 1 }, { name =  "copper-plate-scrap", amount = 1 }, { name =  "steel-plate-scrap", amount = 1 }} }
scrap2.scrapTypes["engine-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 2 }, { name =  "steel-plate-scrap", amount = 1 }} }
scrap2.scrapTypes["electric-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 1 }, { name =  "copper-plate-scrap", amount = 1 }, { name =  "steel-plate-scrap", amount = 1 }, { name =  "circuit-scrap", amount = 1 }} }
scrap2.scrapTypes["battery-scrap"] = { recycle = {{ name = "iron-plate-scrap", amount = 1 }, { name =  "copper-plate-scrap", amount = 1 }  } }
scrap2.scrapTypes["module-scrap"] = { recycle = {{ name = "circuit-scrap", amount = 5 }} }
scrap2.scrapTypes["logistic-scrap"] = { recycle = {{ name = "circuit-scrap", amount = 1 }, { name =  "battery-scrap", amount = 1 }  } }
scrap2.scrapTypes["wood"] = { recycle = nil }
scrap2.scrapTypes["stone"] = { recycle = nil }
scrap2.scrapTypes["solid-fuel"] = { recycle = nil }
scrap2.scrapTypes["ammo-scrap"] = { recycle = nil }
scrap2.scrapTypes["military-intel-scrap"] = { recycle = nil }

scrap2.settings["all-scrap"] = {}
scrap2.settings["all-scrap"].probability = nil
scrap2.settings["all-scrap"].amountModifier = nil

if settings.startup["all-scrap-toggle"].value == true then
    scrap2.settings["all-scrap"].probability = settings.startup["all-scrap-probability"].value / 100
    scrap2.settings["all-scrap"].amountModifier = settings.startup["all-scrap-amount-modifier"].value
end

for k,type in pairs(scrap2.scrapTypes) do
    local sprob = tostring(k .. "-probability")
    local smodi = tostring(k .. "-amount-modifier")
    scrap2.settings[k] = {}
    if k == "wood" or k == "stone" or k == "solid-fuel" or k == "military-intel-scrap" then
        scrap2.settings[k].probability = settings.startup["all-scrap-probability"].value / 100
        scrap2.settings[k].amountModifier = settings.startup["all-scrap-amount-modifier"].value
    else
        scrap2.settings[k].probability = scrap2.settings["all-scrap"].probability or settings.startup[sprob].value / 100
        scrap2.settings[k].amountModifier = scrap2.settings["all-scrap"].amountModifier or settings.startup[smodi].value
    end
end

if  scrap2.settings["all-scrap"].probability == nil then
    scrap2.settings["all-scrap"].probability = settings.startup["all-scrap-probability"].value / 100
end
if  scrap2.settings["all-scrap"].amountModifier == nil then
    scrap2.settings["all-scrap"].amountModifier = settings.startup["all-scrap-amount-modifier"].value
end

if scrap2.debug then
    local cnt
    log("PS2: serpent:scrap2")
    log(serpent.block(scrap2))
    cnt = 0
    for _,j in pairs(scrap2.scrapTypes) do
        cnt = cnt + 1
    end
    log("PS2:    num scrapTypes = " .. tonumber(cnt))
    cnt = 0
    for _,j in pairs(scrap2.ignore) do
        cnt = cnt + 1
    end
    log("PS2:        num ignore = " .. tonumber(cnt))
end

