local autoplace_utils = require("autoplace_utils")

local function autoplace_settings(noise_layer, rectangles)
  local ret = {}

  if noise_layer then
    ret = {
      {
        influence = 0.1,
        noise_layer = noise_layer,
        noise_persistence = 0.7,
        octaves_difference = -1
      }
    }
  end

  autoplace_utils.peaks(rectangles, ret)

  return { peaks = ret }
end

local grass_vehicle_speed_modifier = 1.6
local dirt_vehicle_speed_modifer = 1.4
local sand_vehicle_speed_modifier = 1.8
local stone_path_vehicle_speed_modifier = 1.1
local concrete_vehicle_speed_modifier = 0.8

function water_autoplace_settings(from_depth, rectangles)
  local ret =
  {
    {
      -- Water and deep water have absolute priority. We simulate this by giving
      -- them absurdly large influence
      influence = 1e3 + from_depth,
      elevation_optimal = -5000 - from_depth,
      elevation_range = 5000,
      elevation_max_range = 5000, -- everywhere below elevation 0 and nowhere else
    }
  }

  if rectangles == nil then
    ret[2] = { influence = 1 }
  end

  autoplace_utils.peaks(rectangles, ret)

  return { peaks = ret }
end

data:extend(
{
  {
    type = "tile",
    name = "stone-path-red",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-red"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-red-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
   {
    type = "tile",
    name = "stone-path-yellow",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-yellow"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-yellow-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
   {
    type = "tile",
    name = "stone-path-blue",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-blue"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-blue-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
   {
    type = "tile",
    name = "stone-path-purple",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-purple"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-purple-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
   {
    type = "tile",
    name = "stone-path-green",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-green"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-green-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
   {
    type = "tile",
    name = "stone-path-black",
    needs_correction = false,
    minable = {hardness = 0.2, mining_time = 0.5, result = "stone-path-black"},
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    collision_mask = {"ground-tile"},
    walking_speed_modifier = 1.5,
    layer = 60,
    decorative_removal_probability = 0.6,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-1.png",
          count = 16,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-2.png",
          count = 4,
          size = 2,
          probability = 0.39,
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-4.png",
          count = 4,
          size = 4,
          probability = 1,
        },
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-inner-corner.png",
        count = 8
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-outer-corner.png",
        count = 1
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-side.png",
        count = 10
      },
      u_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-u.png",
        count = 10
      },
      o_transition =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/stone-path/stone-path-black-o.png",
        count = 10
      }
    },
    walking_sound =
    {
      {
        filename = "__base__/sound/walking/concrete-01.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-02.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-03.ogg",
        volume = 1.2
      },
      {
        filename = "__base__/sound/walking/concrete-04.ogg",
        volume = 1.2
      }
    },
    map_color={r=50, g=50, b=50},
    ageing=0,
    vehicle_friction_modifier = stone_path_vehicle_speed_modifier
  },
  {
      type = "tile",
      name = "express-tile",
      needs_correction = false,
      minable = {hardness = 0.2, mining_time = 0.5, result = "express-tile"},
      mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
      collision_mask = {"ground-tile"},
      walking_speed_modifier = 5,
      layer = 61,
      decorative_removal_probability = 0.9,
      variants =
      {
        main =
        {
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/express1.png",
            count = 16,
            size = 1
          },
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/express2.png",
            count = 4,
            size = 2,
            probability = 0.39,
          },
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/express4.png",
            count = 4,
            size = 4,
            probability = 1,
          },
        },
        inner_corner =
        {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-inner-corner.png",
          count = 8
        },
        outer_corner =
        {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-outer-corner.png",
          count = 8
        },
        side =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-side.png",
          count = 8
        },
        u_transition =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-u.png",
          count = 8
        },
        o_transition =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-o.png",
          count = 1
        }
      },
      walking_sound =
      {
        {
          filename = "__base__/sound/walking/concrete-01.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-02.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-03.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-04.ogg",
          volume = 1.2
        }
      },
      map_color={r=100, g=100, b=100},
      ageing=0,
      vehicle_friction_modifier = concrete_vehicle_speed_modifier
  },
  {
      type = "tile",
      name = "glass-tile",
      needs_correction = false,
      minable = {hardness = 0.2, mining_time = 0.5, result = "glass-tile"},
      mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
      collision_mask = {"ground-tile"},
      walking_speed_modifier = 1.8,
      layer = 61,
      decorative_removal_probability = 0.9,
      variants =
      {
        main =
        {
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass1.png",
            count = 16,
            size = 1
          },
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass2.png",
            count = 4,
            size = 2,
            probability = 0.39,
          },
          {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass4.png",
            count = 4,
            size = 4,
            probability = 1,
          },
        },
        inner_corner =
        {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-inner-corner.png",
          count = 8
        },
        outer_corner =
        {
            picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-outer-corner.png",
          count = 8
        },
        side =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-side.png",
          count = 8
        },
        u_transition =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-u.png",
          count = 8
        },
        o_transition =
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/other-paths/glass-o.png",
          count = 1
        }
      },
      walking_sound =
      {
        {
          filename = "__base__/sound/walking/concrete-01.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-02.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-03.ogg",
          volume = 1.2
        },
        {
          filename = "__base__/sound/walking/concrete-04.ogg",
          volume = 1.2
        }
      },
      map_color={r=100, g=100, b=100},
      ageing=0,
      vehicle_friction_modifier = concrete_vehicle_speed_modifier
  },
  {
    type = "tile",
    name = "mote",
    collision_mask =
    {
      "ground-tile",
      "water-tile",
      "resource-layer",
      "floor-layer",
      "item-layer",
      "object-layer",
      "player-layer",
      "doodad-layer"
    },
    layer = 45,
    variants =
    {
      main =
      {
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole1.png",
          count = 8,
          size = 1
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole2.png",
          count = 8,
          size = 2
        },
        {
          picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole4.png",
          count = 6,
          size = 4
        }
      },
      inner_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole-inner-corner.png",
        count = 6
      },
      outer_corner =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole-outer-corner.png",
        count = 6
      },
      side =
      {
        picture = "__Darkstar_utilities_Low_Spec__/graphics/tiles/hole-side.png",
        count = 8
      }
    },
    map_color={r=0, g=0, b=0},
    ageing=0.0006
  },
})
