data:extend(
{
  {
    type = "generator-equipment",
    name = "dark-matter-reactor",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/dark-matter-2.png",
      width = 256,
      height = 256,
      priority = "medium"
    },
    shape =
    {
      width = 8,
      height = 8,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "primary-output"
    },
    power = "5000kW"
  },
  
  {
          type = "battery-equipment",
          name = "crafting-module",
          sprite =
          {
            filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/craft.png",
            width = 32,
            height = 32,
            priority = "medium"
          },
          shape =
          {
            width = 1,
            height = 1,
            type = "full"
          },
          energy_source =
          {
            type = "electric",
            buffer_capacity = "5kJ",
            input_flow_limit = "250kW",
            usage_priority = "primary-input"
          },
          energy_input = "15kW",
          categories = {"armor"}
   },
  
   {
    type = "active-defense-equipment",
    name = "advanced-electric-discharge-defense-equipment",
	categories = {"armor"},
    ability_icon =
    {
      filename = "__base__/graphics/equipment/discharge-defense-equipment-ability.png",
      width = 32,
      height = 32,
      priority = "medium"
    },
    sprite =
    {
      filename = "__base__/graphics/equipment/discharge-defense-equipment.png",
      width = 96,
      height = 96,
      priority = "medium"
    },
    shape =
    {
      width = 3,
      height = 3,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "804kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      damage_modifier = 12,
      cooldown = 300,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 25,
      sound = make_laser_sounds(),
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "400kJ",
        speed = 2,
        action =
        {
          {
            type = "area",
            radius = 20,
            force = "enemy",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "blue-laser",
                starting_speed = 0.28
              }
            }
          }
        }
      },
    },
    automatic = true
  },
  
  {
    type = "active-defense-equipment",
    name = "advanced-laser-defense-equipment",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/smg-icon.png",
      width = 351,
      height = 516,
      priority = "medium"
    },
    shape =
    {
      width = 7,
      height = 11,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "51kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 1,
      damage_modifier = 0.4,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 10,
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-2.ogg",
        volume = 0.35,
		max_sounds_per_type = 2
      },
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "50kJ",
        projectile = "laser-2",
        speed = 1,
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "laser-2",
                starting_speed = 1.28
              }
            }
          }
        }
      }
    },
    automatic = true
  },
  
  {
    type = "active-defense-equipment",
    name = "advanced-laser-defense-equipment-mk2",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/sniper-icon.png",
      width = 351,
      height = 516,
      priority = "medium"
    },
    shape =
    {
      width = 7,
      height = 11,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "51kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 50,
      damage_modifier = 50,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 50,
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-1.ogg",
        volume = 1
      },
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "50kJ",
        projectile = "laser-2",
        speed = 5,
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "laser-2",
                starting_speed = 1.28
              }
            }
          }
        }
      }
    },
    automatic = true
  },
  
  {
    type = "active-defense-equipment",
    name = "advanced-laser-defense-equipment-mk3",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/rifle-icon.png",
      width = 351,
      height = 516,
      priority = "medium"
    },
    shape =
    {
      width = 7,
      height = 11,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "51kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 8,
      damage_modifier = 1.2,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 25,
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-3.ogg",
        volume = 0.35,
		max_sounds_per_type = 2
      },
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "50kJ",
        projectile = "laser-2",
        speed = 1,
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "laser-2",
                starting_speed = 1.28
              }
            }
          }
        }
      }
    },
    automatic = true
  },
  
  {
    type = "active-defense-equipment",
    name = "shoulder-tank-cannon",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/cannon-icon.png",
      width = 351,
      height = 516,
      priority = "medium"
    },
    shape =
    {
      width = 7,
      height = 11,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "51kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 350,
      damage_modifier = 1,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 200,
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/nuclear-explosion.ogg",
        volume = 0.35,
		max_sounds_per_type = 2
      },
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "50kJ",
        projectile = "explosive-rocket-mk2",
        speed = 1,
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "explosive-rocket-mk2",
                starting_speed = 1.28
              }
            }
          }
        }
      }
    },
    automatic = true
  },
  
   {
    type = "active-defense-equipment",
    name = "shoulder-railgun",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/railgun-icon.png",
      width = 351,
      height = 516,
      priority = "medium"
    },
    shape =
    {
      width = 7,
      height = 11,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      buffer_capacity = "51kJ"
    },
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 350,
      damage_modifier = 1,
      projectile_center = {0, 0},
      projectile_creation_distance = 0.6,
      range = 200,
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/railgun-mk2.ogg",
        volume = 0.35,
		max_sounds_per_type = 2
      },
      ammo_type =
      {
        type = "projectile",
        category = "electric",
        energy_consumption = "50kJ",
        projectile = "railgun-mk2-round2",
        speed = 1,
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "railgun-mk2-round2",
                starting_speed = 1.28
              }
            }
          }
        }
      }
    },
    automatic = true
  },
  
  {
    type = "generator-equipment",
    name = "dark-matter-reactor-mk2",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/4D-power-3.png",
      width = 256,
      height = 256,
      priority = "medium"
    },
    shape =
    {
      width = 8,
      height = 8,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "primary-output"
    },
    power = "16TW"
  },
  
  {
    type = "movement-bonus-equipment",
    name = "advanced-exoskeleton-equipment",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/advanced-exoskeleton-equipment.png",
      width = 64,
      height = 128,
      priority = "medium"
    },
    shape =
    {
      width = 2,
      height = 4,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_consumption = "40kW",
    movement_bonus = 1.5
  },
  {
    type = "roboport-equipment",
    name = "large-personal-roboport-equipment",
	categories = {"armor"},
    take_result = "large-personal-roboport-equipment",
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/large-roboport.png",
      width = 256,
      height = 256,
      priority = "medium"
    },
    shape =
    {
      width = 8,
      height = 8,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      buffer_capacity = "35MJ",
      input_flow_limit = "3500KW",
      usage_priority = "secondary-input"
    },
    charging_energy = "1000kW",
    energy_consumption = "0kW",

    robot_limit = 60,
    construction_radius = 70,
    spawn_and_station_height = 0.4,
    charge_approach_distance = 2.6,

    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-radius-visualization.png",
      width = 12,
      height = 12
    },
    construction_radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-construction-radius-visualization.png",
      width = 12,
      height = 12
    },

    recharging_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      priority = "high",
      width = 37,
      height = 35,
      frame_count = 16,
      scale = 1.5,
      animation_speed = 0.5
    },
    recharging_light = {intensity = 1.4, size = 15},
    stationing_offset = {0, -0.6},
    charging_station_shift = {0, 0.5},
    charging_station_count = 25,
    charging_distance = 2.6,
    charging_threshold_distance = 5
  },
   {
    type = "energy-shield-equipment",
    name = "energy-shield-mk3-equipment",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/energy-shield-mk3-equipment.png",
      width = 64,
      height = 64,
      priority = "medium"
    },
    shape =
    {
      width = 2,
      height = 2,
      type = "full"
    },
    max_shield_value = 520,
    energy_source =
    {
      type = "electric",
      buffer_capacity = "30kJ",
      input_flow_limit = "900kW",
      usage_priority = "primary-input"
    },
    energy_per_shield = "59kJ"
  },
   {
    type = "battery-equipment",
    name = "battery-mk3",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/battery-mk3.png",
      width = 32,
      height = 64,
      priority = "medium"
    },
    shape =
    {
      width = 1,
      height = 2,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      buffer_capacity = "5000kJ",
      input_flow_limit = "500MW",
      output_flow_limit = "500MW",
      usage_priority = "terciary"
    }
  },
  {
    type = "battery-equipment",
    name = "battery-mk4",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/battery-mk4.png",
      width = 32,
      height = 64,
      priority = "medium"
    },
    shape =
    {
      width = 1,
      height = 2,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      buffer_capacity = "800000kJ",
      input_flow_limit = "80000MW",
      output_flow_limit = "80000MW",
      usage_priority = "terciary"
    }
  },
  {
    type = "energy-shield-equipment",
    name = "energy-shield-mk4-equipment",
	categories = {"armor"},
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/energy-shield-mk4-equipment.png",
      width = 64,
      height = 64,
      priority = "medium"
    },
    shape =
    {
      width = 2,
      height = 2,
      type = "full"
    },
    max_shield_value = 220,
    energy_source =
    {
      type = "electric",
      buffer_capacity = "2000kJ",
      input_flow_limit = "2000kW",
      usage_priority = "primary-input"
    },
    energy_per_shield = "59kJ"
  },
  {
    type = "roboport-equipment",
    name = "personal-roboport-equipment-mk2",
	categories = {"armor"},
    take_result = "personal-roboport-equipment-mk2",
    sprite =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/equipment/personal-roboport-equipment-mk2.png",
      width = 64,
      height = 64,
      priority = "medium"
    },
    shape =
    {
      width = 2,
      height = 2,
      type = "full"
    },
    energy_source =
    {
      type = "electric",
      buffer_capacity = "35MJ",
      input_flow_limit = "9500KW",
      usage_priority = "secondary-input"
    },
    charging_energy = "1000kW",
    energy_consumption = "40kW",

    robot_limit = 40,
    construction_radius = 30,
    spawn_and_station_height = 0.4,
    charge_approach_distance = 2.6,

    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-radius-visualization.png",
      width = 12,
      height = 12
    },
    construction_radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-construction-radius-visualization.png",
      width = 12,
      height = 12
    },

    recharging_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      priority = "high",
      width = 37,
      height = 35,
      frame_count = 16,
      scale = 1.5,
      animation_speed = 0.5
    },
    recharging_light = {intensity = 0.4, size = 5},
    stationing_offset = {0, -0.6},
    charging_station_shift = {0, 0.5},
    charging_station_count = 2,
    charging_distance = 1.6,
    charging_threshold_distance = 5
  }
 }
 )