
  data:extend(
  {
  
  {
    type = "player",
    name = "player",
    icon = "__base__/graphics/icons/player.png",
    icon_size = 32,
    flags = {"placeable-off-grid", "breaths-air", "not-repairable", "not-on-map", "not-flammable"},
    max_health = 250,
    alert_when_damaged = false,
    healing_per_tick = 0.15,
    collision_box = {{-0.2, -0.2}, {0.2, 0.2}},
    selection_box = {{-0.4, -1.4}, {0.4, 0.2}},
    sticker_box = {{-0.2, -1}, {0.2, 0}},
    crafting_categories = {"crafting"},
    mining_categories = {"basic-solid"},
    character_corpse = "character-corpse",
    inventory_size = 60,
    build_distance = 6,
    drop_item_distance = 6,
    reach_distance = 6,
    item_pickup_distance = 1,
    loot_pickup_distance = 2,
    enter_vehicle_distance = 3,
    reach_resource_distance = 2.7,
    ticks_to_keep_gun = 600,
    ticks_to_keep_aiming_direction = 100,
    --ticks you need to wait after firing a weapon or taking damate to get out of combat and get healed
    ticks_to_stay_in_combat = 600,
    damage_hit_tint = {r = 1, g = 0, b = 0, a = 0},
    running_speed = 0.15,
    distance_per_frame = 0.13,
    maximum_corner_sliding_distance = 0.7,
    subgroup = "creatures",
    order="a",
    eat =
    {
      {
        filename = "__base__/sound/eat.ogg",
        volume = 1
      }
    },
    heartbeat =
    {
      {
        filename = "__base__/sound/heartbeat.ogg"
      }
    },

    animations =
    {
      {
        idle =
        {
          layers =
          {
            playeranimations.level1.idle,
            playeranimations.level1.idle_mask,
            playeranimations.level1.idle_shadow,
          }
        },
        idle_with_gun =
        {
          layers =
          {
            playeranimations.level1.idle_gun,
            playeranimations.level1.idle_gun_mask,
            playeranimations.level1.idle_gun_shadow,
          }
        },
        mining_with_hands =
        {
          layers =
          {
            playeranimations.level1.mining_hands,
            playeranimations.level1.mining_hands_mask,
            playeranimations.level1.mining_hands_shadow,
          }
        },
        mining_with_tool =
        {
          layers =
          {
            playeranimations.level1.mining_tool,
            playeranimations.level1.mining_tool_mask,
            playeranimations.level1.mining_tool_shadow,
          }
        },
        running_with_gun =
        {
          layers =
          {
            playeranimations.level1.running_gun,
            playeranimations.level1.running_gun_mask,
            playeranimations.level1.running_gun_shadow,
          }
        },
        running =
        {
          layers =
          {
            playeranimations.level1.running,
            playeranimations.level1.running_mask,
            playeranimations.level1.running_shadow,
          }
        }
      },
      {
        -- heavy-armor is not in the demo
        armors = data.is_demo and {"light-armor"} or {"light-armor", "heavy-armor"},
        idle =
        {
          layers =
          {
            playeranimations.level1.idle,
            playeranimations.level1.idle_mask,
            playeranimations.level2addon.idle,
            playeranimations.level2addon.idle_mask,
            playeranimations.level1.idle_shadow,
          }
        },
        idle_with_gun =
        {
          layers =
          {
            playeranimations.level1.idle_gun,
            playeranimations.level1.idle_gun_mask,
            playeranimations.level2addon.idle_gun,
            playeranimations.level2addon.idle_gun_mask,
            playeranimations.level1.idle_gun_shadow,
          }
        },
        mining_with_hands =
        {
          layers =
          {
            playeranimations.level1.mining_hands,
            playeranimations.level1.mining_hands_mask,
            playeranimations.level2addon.mining_hands,
            playeranimations.level2addon.mining_hands_mask,
            playeranimations.level1.mining_hands_shadow,
          }
        },
        mining_with_tool =
        {
          layers =
          {
            playeranimations.level1.mining_tool,
            playeranimations.level1.mining_tool_mask,
            playeranimations.level2addon.mining_tool,
            playeranimations.level2addon.mining_tool_mask,
            playeranimations.level1.mining_tool_shadow,
          }
        },
        running_with_gun =
        {
          layers =
          {
            playeranimations.level1.running_gun,
            playeranimations.level1.running_gun_mask,
            playeranimations.level2addon.running_gun,
            playeranimations.level2addon.running_gun_mask,
            playeranimations.level1.running_gun_shadow,
          }
        },
        running =
        {
          layers =
          {
            playeranimations.level1.running,
            playeranimations.level1.running_mask,
            playeranimations.level2addon.running,
            playeranimations.level2addon.running_mask,
            playeranimations.level1.running_shadow,
          }
        }
      },
      {
        -- modular armors are not in the demo
        armors = data.is_demo and {} or {"modular-armor", "power-armor", "power-armor-mk2", "power-armor-mk3"},
        idle =
        {
          layers =
          {
            playeranimations.level1.idle,
            playeranimations.level1.idle_mask,
            playeranimations.level3addon.idle,
            playeranimations.level3addon.idle_mask,
            playeranimations.level1.idle_shadow,
          }
        },
        idle_with_gun =
        {
          layers =
          {
            playeranimations.level1.idle_gun,
            playeranimations.level1.idle_gun_mask,
            playeranimations.level3addon.idle_gun,
            playeranimations.level3addon.idle_gun_mask,
            playeranimations.level1.idle_gun_shadow,
          }
        },
        mining_with_hands =
        {
          layers =
          {
            playeranimations.level1.mining_hands,
            playeranimations.level1.mining_hands_mask,
            playeranimations.level3addon.mining_hands,
            playeranimations.level3addon.mining_hands_mask,
            playeranimations.level1.mining_hands_shadow,
          }
        },
        mining_with_tool =
        {
          layers =
          {
            playeranimations.level1.mining_tool,
            playeranimations.level1.mining_tool_mask,
            playeranimations.level3addon.mining_tool,
            playeranimations.level3addon.mining_tool_mask,
            playeranimations.level1.mining_tool_shadow,
          }
        },
        running_with_gun =
        {
          layers =
          {
            playeranimations.level1.running_gun,
            playeranimations.level1.running_gun_mask,
            playeranimations.level3addon.running_gun,
            playeranimations.level3addon.running_gun_mask,
            playeranimations.level1.running_gun_shadow,
          }
        },
        running =
        {
          layers =
          {
            playeranimations.level1.running,
            playeranimations.level1.running_mask,
            playeranimations.level3addon.running,
            playeranimations.level3addon.running_mask,
            playeranimations.level1.running_shadow,
          }
        }
      }
    },
    light =
    {
      {
        minimum_darkness = 0.3,
        intensity = 0.4,
        size = 25,
        color = {r=1.0, g=1.0, b=1.0}
      },
      {
        type = "oriented",
        minimum_darkness = 0.3,
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "extra-high",
          flags = { "light" },
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {0, -13},
        size = 2,
        intensity = 0.6,
        color = {r=1.0, g=1.0, b=1.0}
      },
    },
    mining_speed = 0.01,
    mining_with_hands_particles_animation_positions = {29, 63},
    mining_with_tool_particles_animation_positions = {28},
    running_sound_animation_positions = {5, 16}
  },

  {
    type = "ammo-turret",
    name = "assult-turret",
    icon = "__base__/graphics/icons/gun-turret.png",
    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 0.5, result = "assult-turret"},
    max_health = 800,
    corpse = "medium-remnants",
    collision_box = {{-0.7, -0.7 }, {0.7, 0.7}},
    selection_box = {{-1, -1 }, {1, 1}},
    rotation_speed = 0.055,
    preparing_speed = 0.38,
    folding_speed = 0.28,
    dying_explosion = "medium-explosion",
    inventory_size = 2,
    automated_ammo_count = 10,
    attacking_speed = 2,
    alert_when_attacking = true,
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    folded_animation =
    {
      layers =
      {
        gun_turret_extension{frame_count=1, line_length = 1},
        gun_turret_extension_mask{frame_count=1, line_length = 1},
        gun_turret_extension_shadow{frame_count=1, line_length = 1}
      }
    },
    preparing_animation =
    {
      layers =
      {
        gun_turret_extension{},
        gun_turret_extension_mask{},
        gun_turret_extension_shadow{}
      }
    },
    prepared_animation = gun_turret_attack{frame_count=1},
    attacking_animation = gun_turret_attack{},
    folding_animation =
    {
      layers =
      {
        gun_turret_extension{run_mode = "backward"},
        gun_turret_extension_mask{run_mode = "backward"},
        gun_turret_extension_shadow{run_mode = "backward"}
      }
    },
    base_picture =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base.png",
          priority = "high",
          width = 90,
          height = 75,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.046875},
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base-mask.png",
          flags = { "mask" },
          line_length = 1,
          width = 52,
          height = 47,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.234375},
          apply_runtime_tint = true
        }
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },

    attack_parameters =
    {
      type = "projectile",
      ammo_category = "bullet-mk2",
      cooldown = 3,
      projectile_creation_distance = 1.39375,
      projectile_center = {0, -0.0875}, -- same as gun_turret_attack shift
      shell_particle =
      {
        name = "shell-particle",
        direction_deviation = 0.1,
        speed = 0.1,
        speed_deviation = 0.03,
        center = {-0.0625, 0},
        creation_distance = -1.925,
        starting_frame_speed = 0.2,
        starting_frame_speed_deviation = 0.1
      },
      range = 38,
      sound = make_heavy_gunshot_sounds(),
    },

    call_for_help_radius = 40
  },

  {
    type = "ammo-turret",
    name = "sniper-turret",
    icon = "__base__/graphics/icons/gun-turret.png",
    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 0.5, result = "sniper-turret"},
    max_health = 800,
    corpse = "medium-remnants",
    collision_box = {{-0.7, -0.7 }, {0.7, 0.7}},
    selection_box = {{-1, -1 }, {1, 1}},
    rotation_speed = 0.055,
    preparing_speed = 0.58,
    folding_speed = 0.58,
    dying_explosion = "medium-explosion",
    inventory_size = 2,
    automated_ammo_count = 10,
    attacking_speed = 5.,
    alert_when_attacking = true,
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    folded_animation =
    {
      layers =
      {
        gun_turret_extension{frame_count=1, line_length = 1},
        gun_turret_extension_mask{frame_count=1, line_length = 1},
        gun_turret_extension_shadow{frame_count=1, line_length = 1}
      }
    },
    preparing_animation =
    {
      layers =
      {
        gun_turret_extension{},
        gun_turret_extension_mask{},
        gun_turret_extension_shadow{}
      }
    },
    prepared_animation = gun_turret_attack{frame_count=1},
    attacking_animation = gun_turret_attack{},
    folding_animation =
    {
      layers =
      {
        gun_turret_extension{run_mode = "backward"},
        gun_turret_extension_mask{run_mode = "backward"},
        gun_turret_extension_shadow{run_mode = "backward"}
      }
    },
    base_picture =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base.png",
          priority = "high",
          width = 90,
          height = 75,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.046875},
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base-mask.png",
          flags = { "mask" },
          line_length = 1,
          width = 52,
          height = 47,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.234375},
          apply_runtime_tint = true
        }
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },

    attack_parameters =
    {
      type = "projectile",
      ammo_category = "sniper-round",
      cooldown = 102,
      projectile_creation_distance = 1.39375,
      projectile_center = {0, -0.0875}, -- same as gun_turret_attack shift
      shell_particle =
      {
        name = "shell-particle",
        direction_deviation = 0.1,
        speed = 2.1,
        speed_deviation = 0.03,
        center = {-0.0625, 0},
        creation_distance = -1.925,
        starting_frame_speed = 0.2,
        starting_frame_speed_deviation = 0.1
      },
      range = 175,
      sound = make_heavy_gunshot_sounds(),
    },

    call_for_help_radius = 40
  },

  {
    type = "ammo-turret",
    name = "sniper-turret-mk2",
    icon = "__base__/graphics/icons/gun-turret.png",
    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 0.5, result = "sniper-turret-mk2"},
    max_health = 800,
    corpse = "medium-remnants",
    collision_box = {{-0.7, -0.7 }, {0.7, 0.7}},
    selection_box = {{-1, -1 }, {1, 1}},
    rotation_speed = 0.055,
    preparing_speed = 0.58,
    folding_speed = 0.58,
    dying_explosion = "medium-explosion",
    inventory_size = 2,
    automated_ammo_count = 10,
    attacking_speed = 10.,
    alert_when_attacking = true,
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    folded_animation =
    {
      layers =
      {
        gun_turret_extension{frame_count=1, line_length = 1},
        gun_turret_extension_mask{frame_count=1, line_length = 1},
        gun_turret_extension_shadow{frame_count=1, line_length = 1}
      }
    },
    preparing_animation =
    {
      layers =
      {
        gun_turret_extension{},
        gun_turret_extension_mask{},
        gun_turret_extension_shadow{}
      }
    },
    prepared_animation = gun_turret_attack{frame_count=1},
    attacking_animation = gun_turret_attack{},
    folding_animation =
    {
      layers =
      {
        gun_turret_extension{run_mode = "backward"},
        gun_turret_extension_mask{run_mode = "backward"},
        gun_turret_extension_shadow{run_mode = "backward"}
      }
    },
    base_picture =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base.png",
          priority = "high",
          width = 90,
          height = 75,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.046875},
        },
        {
          filename = "__base__/graphics/entity/gun-turret/gun-turret-base-mask.png",
          flags = { "mask" },
          line_length = 1,
          width = 52,
          height = 47,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0, -0.234375},
          apply_runtime_tint = true
        }
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },

    attack_parameters =
    {
      type = "projectile",
      ammo_category = "sniper-round",
      cooldown = 602,
      projectile_creation_distance = 1.39375,
      projectile_center = {0, -0.0875}, -- same as gun_turret_attack shift
      shell_particle =
      {
        name = "shell-particle",
        direction_deviation = 0.1,
        speed = 20.1,
        speed_deviation = 0.03,
        center = {-0.0625, 0},
        creation_distance = -1.925,
        starting_frame_speed = 0.2,
        starting_frame_speed_deviation = 0.1
      },
      range = 975,
      sound = make_heavy_gunshot_sounds(),
    },

    call_for_help_radius = 40
  },

  {
    type = "electric-turret",
    name = "laser-turret-mk2",
    icon = "__base__/graphics/icons/laser-turret.png",
    icon_size = 32,
    flags = { "placeable-player", "placeable-enemy", "player-creation"},
    minable = { mining_time = 0.5, result = "laser-turret-mk2" },
    max_health = 1000,
    corpse = "medium-remnants",
    collision_box = {{ -0.7, -0.7}, {0.7, 0.7}},
    selection_box = {{ -1, -1}, {1, 1}},
    rotation_speed = 0.51,
    preparing_speed = 0.15,
    dying_explosion = "medium-explosion",
    folding_speed = 0.15,
    energy_source =
    {
      type = "electric",
      buffer_capacity = "8001kJ",
      input_flow_limit = "9600kW",
      drain = "84kW",
      usage_priority = "primary-input"
    },
    folded_animation =
    {
      layers =
      {
        laser_turret_extension{frame_count=1, line_length = 1},
        laser_turret_extension_shadow{frame_count=1, line_length=1},
        laser_turret_extension_mask{frame_count=1, line_length=1}
      }
    },
    preparing_animation =
    {
      layers =
      {
        laser_turret_extension{},
        laser_turret_extension_shadow{},
        laser_turret_extension_mask{}
      }
    },
    prepared_animation =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/laser-turret/laser-turret-gun.png",
          line_length = 8,
          width = 68,
          height = 68,
          frame_count = 1,
          axially_symmetrical = false,
          direction_count = 64,
          shift = {-0.03125, -1}
        },
        {
          filename = "__base__/graphics/entity/laser-turret/laser-turret-gun-mask.png",
          flags = { "mask" },
          line_length = 8,
          width = 54,
          height = 44,
          frame_count = 1,
          axially_symmetrical = false,
          apply_runtime_tint = true,
          direction_count = 64,
          shift = {-0.03125, -1.3125},
        },
        {
          filename = "__base__/graphics/entity/laser-turret/laser-turret-gun-shadow.png",
          line_length = 8,
          width = 88,
          height = 52,
          frame_count = 1,
          axially_symmetrical = false,
          direction_count = 64,
          draw_as_shadow = true,
          shift = {1.5, 0}
        }
      }
    },
    folding_animation =
    {
      layers =
      {
        laser_turret_extension{run_mode = "backward"},
        laser_turret_extension_shadow{run_mode = "backward"},
        laser_turret_extension_mask{run_mode = "backward"}
      }
    },
    base_picture =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/laser-turret/laser-turret-base.png",
          priority = "high",
          width = 98,
          height = 82,
          axially_symmetrical = false,
          direction_count = 1,
          frame_count = 1,
          shift = {0.015625, 0.03125}
        },
        {
          filename = "__base__/graphics/entity/laser-turret/laser-turret-base-mask.png",
          flags = { "mask" },
          line_length = 1,
          width = 54,
          height = 46,
          axially_symmetrical = false,
          apply_runtime_tint = true,
          direction_count = 1,
          frame_count = 1,
          shift = {-0.046875, -0.109375},
        },
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },

    attack_parameters =
    {
      type = "projectile",
      ammo_category = "electric",
      cooldown = 40,
      projectile_center = {-0.09375, -0.2},
      projectile_creation_distance = 1.4,
      range = 44,
      damage_modifier = 8,
      ammo_type =
      {
        type = "projectile",
        category = "laser-turret",
        energy_consumption = "8001kJ",
        action =
        {
          {
            type = "direct",
            action_delivery =
            {
              {
                type = "projectile",
                projectile = "laser",
                starting_speed = 0.65
              }
            }
          }
        }
      },
      sound = make_laser_sounds()
    },
    call_for_help_radius = 40
  },
  
  {
    type = "furnace",
    name = "terra-electric-furnace",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/electric-furnace2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "terra-electric-furnace"},
    max_health = 150,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    light = {intensity = 1, size = 10},
    resistances =
    {
      {
        type = "fire",
        percent = 80
      }
    },
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    crafting_categories = {"smelting"},
    result_inventory_size = 2,
    crafting_speed = 4,
    energy_usage = "200kW",
    source_inventory_size = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.005
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-furnace.ogg",
        volume = 0.7
      },
      apparent_volume = 1.5
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-furnace/electric-furnace-base.png",
      priority = "high",
      width = 129,
      height = 100,
      frame_count = 1,
      shift = {0.421875, 0}
    },
    working_visualisations =
    {
      {
        animation =
        {
          filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-furnace/electric-furnace-heater.png",
          priority = "high",
          width = 25,
          height = 15,
          frame_count = 12,
          animation_speed = 0.5,
          shift = {0.015625, 0.890625}
        },
        light = {intensity = 0.4, size = 6, shift = {0.0, 1.0}}
      },
      {
        animation =
        {
          filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-furnace/electric-furnace-propeller-1.png",
          priority = "high",
          width = 19,
          height = 13,
          frame_count = 4,
          animation_speed = 0.5,
          shift = {-0.671875, -0.640625}
        }
      },
      {
        animation =
        {
          filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-furnace/electric-furnace-propeller-2.png",
          priority = "high",
          width = 12,
          height = 9,
          frame_count = 4,
          animation_speed = 0.5,
          shift = {0.0625, -1.234375}
        }
      }
    },
    fast_replaceable_group = "furnace"
  },
  
  {
    type = "loader",
    name = "terra-loader",
    icon = "__base__/graphics/icons/loader.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-build-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "express-loader"},
    max_health = 170,
    filter_count = 5,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.4, -0.9}, {0.4, 0.9}},
    selection_box = {{-0.5, -1}, {0.5, 1}},
    animation_speed_coefficient = 32,
    belt_horizontal = express_belt_horizontal,
    belt_vertical = express_belt_vertical,
    ending_top = express_belt_ending_top,
    ending_bottom = express_belt_ending_bottom,
    ending_side = express_belt_ending_side,
    starting_top = express_belt_starting_top,
    starting_bottom = express_belt_starting_bottom,
    starting_side = express_belt_starting_side,
    fast_replaceable_group = "loader",
    speed = 1.99375,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/loader/loader-structure.png",
          priority = "extra-high",
          width = 64,
          height = 64
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/loader/loader-structure.png",
          priority = "extra-high",
          width = 64,
          height = 64,
          y = 64
        }
      }
    },
    ending_patch = ending_patch_prototype
  },
  
  {
    type = "splitter",
    name = "terra-splitter",
    icon = "__base__/graphics/icons/express-splitter.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "express-splitter"},
    max_health = 190,
    corpse = "medium-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.9, -0.4}, {0.9, 0.4}},
    selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
    animation_speed_coefficient = 62,
    structure_animation_speed_coefficient = 1.2,
    structure_animation_movement_cooldown = 10,
    belt_horizontal = express_belt_horizontal, -- specified in transport-belt-pictures.lua
    belt_vertical = express_belt_vertical,
    ending_top = express_belt_ending_top,
    ending_bottom = express_belt_ending_bottom,
    ending_side = express_belt_ending_side,
    starting_top = express_belt_starting_top,
    starting_bottom = express_belt_starting_bottom,
    starting_side = express_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.59375,
    structure =
    {
      north =
      {
        filename = "__base__/graphics/entity/express-splitter/express-splitter-north.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 83,
        height = 36,
        shift = {0.21875, 0},
        hr_version =
        {
          filename = "__base__/graphics/entity/express-splitter/hr-express-splitter-north.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 164,
          height = 70,
          shift = {0.265625, 0},
          scale = 0.5
        }
      },
      east =
      {
        filename = "__base__/graphics/entity/express-splitter/express-splitter-east.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 51,
        height = 80,
        shift = {0.109375, -0.03125},
        hr_version =
        {
          filename = "__base__/graphics/entity/express-splitter/hr-express-splitter-east.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 93,
          height = 157,
          shift = {0.148438, -0.179688},
          scale = 0.5
        }
      },
      south =
      {
        filename = "__base__/graphics/entity/express-splitter/express-splitter-south.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 85,
        height = 35,
        shift = {0.140625, -0.015625},
        hr_version =
        {
          filename = "__base__/graphics/entity/express-splitter/hr-express-splitter-south.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 168,
          height = 67,
          shift = {0.140625, 0.0234375},
          scale = 0.5
        }
      },
      west =
      {
        filename = "__base__/graphics/entity/express-splitter/express-splitter-west.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 51,
        height = 78,
        shift = {0.296875, -0.03125},
        hr_version =
        {
          filename = "__base__/graphics/entity/express-splitter/hr-express-splitter-west.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 94,
          height = 154,
          shift = {0.203125, -0.109375},
          scale = 0.5
        }
      },
    }
  },
  
  {
    type = "pump",
    name = "pump-mk2",
    icon = "__base__/graphics/icons/pump.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "pump-mk2"},
    max_health = 180,
    fast_replaceable_group = "pipe",
    corpse = "small-remnants",
    collision_box = {{-0.29, -0.79}, {0.29, 0.79}},
    selection_box = {{-0.5, -1}, {0.5, 1}},
    resistances =
    {
      {
        type = "fire",
        percent = 80
      },
      {
        type = "impact",
        percent = 30
      }
    },
    fluid_box =
    {
      base_area = 1,
      height = 2,
      pipe_covers = pipecoverspictures(),
      pipe_connections =
      {
        { position = {0, -1.5}, type="output" },
        { position = {0, 1.5}, type="input" },
      },
    },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.01 / 2.5
    },
    energy_usage = "120kW",
    pumping_speed = 120,
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },

    animations =
    {
      north =
      {
        filename = "__base__/graphics/entity/pump/pump-north.png",
        width = 53,
        height = 79,
        line_length =8,
        frame_count =32,
        animation_speed = 0.5,
        shift = util.by_pixel(8.000, 7.500),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-north.png",
          width = 103,
          height = 164,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          animation_speed = 0.5,
          shift = util.by_pixel(8, 3.5) -- {0.515625, 0.21875}
        },
      },
      east =
      {
        filename = "__base__/graphics/entity/pump/pump-east.png",
        width = 66,
        height = 60,
        line_length =8,
        frame_count =32,
        animation_speed = 0.5,
        shift = util.by_pixel(0, 4),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-east.png",
          width = 130,
          height = 109,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          animation_speed = 0.5,
          shift = util.by_pixel(-0.5, 1.75) --{-0.03125, 0.109375}
        },
      },

      south =
      {
        filename = "__base__/graphics/entity/pump/pump-south.png",
        width = 62,
        height = 87,
        line_length =8,
        frame_count =32,
        animation_speed = 0.5,
        shift = util.by_pixel(13.5, 0.5),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-south.png",
          width = 114,
          height = 160,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          animation_speed = 0.5,
          shift = util.by_pixel(12.5, -8) -- {0.75, -0.5}
        },
      },
      west =
      {
        filename = "__base__/graphics/entity/pump/pump-west.png",
        width = 69,
        height = 51,
        line_length =8,
        frame_count =32,
        animation_speed = 0.5,
        shift = util.by_pixel(0.5, -0.5),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-west.png",
          width = 131,
          height = 111,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          animation_speed = 0.5,
          shift = util.by_pixel(-0.25, 1.25) -- {-0.015625, 0.078125}
        },
      },
    },

    fluid_wagon_connector_frame_count = 35,

    fluid_wagon_connector_graphics = require("prototypes.entity.pump-connector"),

    fluid_animation =
    {
      north =
      {
        filename = "__base__/graphics/entity/pump/pump-north-liquid.png",
        apply_runtime_tint = true,
        width = 20,
        height = 13,
        line_length =8,
        frame_count =32,
        shift = util.by_pixel(-0.500, -14.500),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-north-liquid.png",
          apply_runtime_tint = true,
          width = 38,
          height = 22,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          shift = util.by_pixel(-0.250, -16.750)
        }
      },

      east =
      {
        filename = "__base__/graphics/entity/pump/pump-east-liquid.png",
        width = 18,
        height = 24,
        line_length =8,
        frame_count =32,
        shift = util.by_pixel(6.000, -8.000),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-east-liquid.png",
          width = 35,
          height = 46,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          shift = util.by_pixel(6.250, -8.500)
        },
      },

      south =
      {
        filename = "__base__/graphics/entity/pump/pump-south-liquid.png",
        width = 26,
        height = 55,
        line_length =8,
        frame_count =32,
        shift = util.by_pixel(3.500, 6.500),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-south-liquid.png",
          width = 38,
          height = 45,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          shift = util.by_pixel(0.500, -9.250)
        },
      },
      west =
      {
        filename = "__base__/graphics/entity/pump/pump-west-liquid.png",
        width = 18,
        height = 24,
        line_length =8,
        frame_count =32,
        shift = util.by_pixel(-6.000, -9.000),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-west-liquid.png",
          width = 35,
          height = 47,
          scale = 0.5,
          line_length =8,
          frame_count =32,
          shift = util.by_pixel(-6.500, -9.500)
        },
      }
    },

    glass_pictures =
    {
      north = {
        filename = "__base__/graphics/entity/pump/pump-north-glass.png",
        width = 32,
        height = 64,
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-north-glass.png",
          width = 64,
          height = 128,
          scale = 0.5,
        },
      },
      east = {
        filename = "__base__/graphics/entity/pump/pump-east-glass.png",
        width = 32,
        height = 32,
        shift = util.by_pixel(0.000, -16.000),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-east-glass.png",
          width = 128,
          height = 192,
          scale = 0.5,
        },
      },
      south = {
        filename = "__base__/graphics/entity/pump/pump-south-glass.png",
        width = 32,
        height = 64,
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-south-glass.png",
          width = 64,
          height = 128,
          scale = 0.5,
        },
      },
      west = {
        filename = "__base__/graphics/entity/pump/pump-west-glass.png",
        width = 32,
        height = 96,
        shift = util.by_pixel(0.000, 15.000),
        hr_version = {
          filename = "__base__/graphics/entity/pump/hr-pump-west-glass.png",
          width = 192,
          height = 192,
          scale = 0.5,
          shift = util.by_pixel(-16.000, 0.000)
        },
      }
    },
  },
  {
    type = "mining-drill",
    name = "laser-miner",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon1.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "laser-miner"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -4.25, -3.75}, {4.45, 4.45}},
    selection_box = {{ -4.35, -3.85}, {4.55, 3.65}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-drill.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 481,
        height = 270,
        line_length = 4,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/laser-miner.png",
        frame_count = 28,
        animation_speed = 0.325,
        run_mode = "forward-then-backward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity = 10,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.163,
      usage_priority = "secondary-input"
    },
    energy_usage = "1600kW",
    mining_power = 6,
    resource_searching_radius = 4.3,
    vector_to_place_result = {0, -5},
    module_specification =
    {
      module_slots = 2,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "neural-miner",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon1.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "neural-miner"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -1, -1}, {1, 1}},
    selection_box = {{ -1, -1}, {1, 1}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/neural-miner.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 300,
        height = 300,
        line_length = 5,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/neural-miner.png",
                scale = 2,
        frame_count = 30,
        animation_speed = 0.325,
        run_mode = "forward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity = 60,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.163,
      usage_priority = "secondary-input"
    },
    energy_usage = "1600kW",
    mining_power = 25,
    resource_searching_radius = 5.3,
    vector_to_place_result = {0.5, -1.5},
    module_specification =
    {
      module_slots = 3,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "laser-miner2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "laser-miner2"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -4.25, -3.75}, {4.45, 4.45}},
    selection_box = {{ -4.35, -3.85}, {4.55, 3.65}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-drill.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 481,
        height = 270,
        line_length = 4,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/laser-miner2.png",
        frame_count = 28,
        animation_speed = 0.825,
        run_mode = "forward-then-backward",
      }
    },
    mining_speed = 7,
    mining_drill_productivity = 20,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.563,
      usage_priority = "secondary-input"
    },
    energy_usage = "2800kW",
    mining_power = 14,
    resource_searching_radius = 4.3,
    vector_to_place_result = {0, -5},
    module_specification =
    {
      module_slots = 4,
      module_info_icon_shift = {0, 0.8}
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "neural-miner-2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon1.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "neural-miner-2"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -1, -1}, {1, 1}},
    selection_box = {{ -1, -1}, {1, 1}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/neural-miner.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        width = 300,
        height = 300,
        line_length = 5,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/neural-miner-2.png",
                scale = 2,
        frame_count = 30,
        animation_speed = 0.325,
        run_mode = "forward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity = 120,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.163,
      usage_priority = "secondary-input"
    },
    energy_usage = "1600kW",
    mining_power = 50,
    resource_searching_radius = 20.3,
    vector_to_place_result = {0.5, -1.5},
    module_specification =
    {
      module_slots = 4,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "laser-miner3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "laser-miner3"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -4.25, -3.75}, {4.45, 4.45}},
    selection_box = {{ -4.35, -3.85}, {4.55, 3.65}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-drill.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 481,
        height = 270,
        line_length = 4,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/laser-miner3.png",
        frame_count = 28,
        animation_speed = 0.925,
        run_mode = "forward-then-backward",
      }
    },
    mining_speed = 7,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.663,
      usage_priority = "secondary-input"
    },
    energy_usage = "4000kW",
    mining_power = 24,
	mining_drill_productivity = 30,
    resource_searching_radius = 4.3,
    vector_to_place_result = {0, -5},
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 0.8}
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "neural-miner-3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon1.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "neural-miner-3"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -1, -1}, {1, 1}},
    selection_box = {{ -1, -1}, {1, 1}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/neural-miner.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 300,
        height = 300,
        line_length = 5,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/neural-miner-3.png",
                scale = 2,
        frame_count = 30,
        animation_speed = 0.325,
        run_mode = "forward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity = 180,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.163,
      usage_priority = "secondary-input"
    },
    energy_usage = "1600kW",
    mining_power = 100,
    resource_searching_radius = 40.1,
    vector_to_place_result = {0.5, -1.5},
    module_specification =
    {
      module_slots = 5,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "laser-miner4",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon4.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "laser-miner4"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -4.25, -3.75}, {4.45, 4.45}},
    selection_box = {{ -4.35, -3.85}, {4.55, 3.65}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/laser-drill.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 481,
        height = 270,
        line_length = 4,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/laser-miner4.png",
        frame_count = 28,
        animation_speed = 0.825,
        run_mode = "forward-then-backward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity_bonus = 70,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 1.063,
      usage_priority = "secondary-input"
    },
    energy_usage = "10000kW",
    mining_power = 75,
    resource_searching_radius = 4.3,
    vector_to_place_result = {0, -5},
    module_specification =
    {
      module_slots = 8,
      module_info_icon_shift = {0, 0.8}
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  {
    type = "mining-drill",
    name = "neural-miner-4",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/laser-drill-icon1.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "neural-miner-4"},
    max_health = 1200,
    resource_categories = {"basic-solid"},
    corpse = "big-remnants",
    collision_box = {{ -1, -1}, {1, 1}},
    selection_box = {{ -1, -1}, {1, 1}},
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/neural-miner.ogg",
        volume = 0.75
      },
      apparent_volume = 1.5,
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 300,
        height = 300,
        line_length = 5,
        shift = {0.2, -0.2},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/laser-miner/neural-miner-4.png",
        scale = 2,
        frame_count = 30,
        animation_speed = 0.325,
        run_mode = "forward",
      }
    },
    mining_speed = 7,
	mining_drill_productivity = 940,
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.163,
      usage_priority = "secondary-input"
    },
    energy_usage = "1600kW",
    mining_power = 250,
    resource_searching_radius = 80.3,
    vector_to_place_result = {0.5, -1.5},
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 0.8}
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/electric-mining-drill/electric-mining-drill-radius-visualization.png",
      width = 12,
      height = 12
    }
  },
  
  -----Rocket
  {
    type = "rocket-silo",
    name = "rocket-silo-2",
    icon = "__base__/graphics/icons/rocket-silo.png",
	icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    crafting_categories = {"rocket-building"},
    ingredient_count = 3,
    rocket_parts_required = 120,
    crafting_speed = 2,
    rocket_result_inventory_size = 1,
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 4.3}
    },
    fixed_recipe = "rocket-part",
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    minable = {hardness = 0.2, mining_time = 5, result = "rocket-silo"},
    max_health = 5000,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-4.2, -4.7}, {4.2, 4.7}},
    selection_box = {{-4.5, -5}, {4.5, 5}},
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 60
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "primary-input"
    },
    energy_usage = "250kW", --energy usage used when crafting the rocket
    idle_energy_usage = "10KW",
    lamp_energy_usage = "10KW",
    active_energy_usage = "3990KW",
    rocket_entity = "rocket-silo-2-rocket",

    times_to_blink = 3,
    light_blinking_speed = 1 / (3 * 60),
    door_opening_speed = 1 / (4.25 * 60),

    base_light =
    {
      {
        type = "oriented",
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "extra-high",
          flags = { "light" },
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {0.25, 1.25},
        size = 1,
        intensity = 1,
        rotation_shift = 0.6,
        color = {r = 0.7, g = 0.9, b = 1.0}
      },
      {
        type = "oriented",
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "extra-high",
          flags = { "light" },
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {-0.25, 1},
        size = 1,
        intensity = 1,
        rotation_shift = 0.5,
        color = {r = 0.7, g = 0.9, b = 1.0}
      }
    },
    base_engine_light =
    {
      intensity = 1,
      size = 25,
      shift = {0, 1.5}
    },

    shadow_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/00-shadow/00-silo-shadow.png",
      priority = "medium",
      width = 447,
      height = 351,
      draw_as_shadow = true,
      shift = {1.5, 0.5}
    },
    satellite_shadow_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/00-shadow/00-satellite-shadow.png",
      priority = "medium",
      width = 44,
      height = 22,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.25,
      draw_as_shadow = true,
      shift = {7.875, -2.1875}
    },

    hole_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/01-hole/01-hole.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },
    hole_light_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/01-hole/01-hole-light.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },

    rocket_shadow_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-shadow-over-rocket.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },
    rocket_glow_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-glow.png",
      blend_mode = "additive",
      width = 224,
      height = 128,
      shift = {0, 2}
    },


    door_back_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/04-05-doors/04-door-back.png",
      width = 192,
      height = 108,
      shift = {0, 1.53125}
    },
    door_back_open_offset = {1.75, -1.75},
    door_front_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/04-05-doors/05-door-front.png",
      width = 192,
      height = 112,
      shift = {0, 2.0625}
    },
    door_front_open_offset = {-1.75, 1.75},

    base_day_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/06-silo-base/06-silo-base-day.png",
      width = 352,
      height = 384,
      shift = {0, 0}
    },
    base_night_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/06-silo-base/06-silo-base-night.png",
      width = 352,
      height = 384,
      shift = {0, 0}
    },


    red_lights_back_sprites =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {1.34375, 0.28125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.3125, 0.9375}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.65625, 1.90625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.65625, 1.90625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.3125, 0.9375}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-1.34375, 0.28125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {0, 0}
        }
      }
    },

    red_lights_front_sprites =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.3125, 2.8125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {1.34375, 3.40625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {0, 3.75}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-1.34375, 3.40625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.3125, 2.8125}
        }
      }
    },
    satellite_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/satellite.png",
      priority = "medium",
      width = 27,
      height = 28,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.25,
      shift = {3.3125, -4.82813}
    },

    arm_01_back_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/arm-01-back.png",
      priority = "medium",
      width = 54,
      height = 50,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {-1.34375, -0.875}
    },

    arm_02_right_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/arm-02-right.png",
      priority = "medium",
      width = 81,
      height = 43,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {2.71875, 0.96875}
    },

    arm_03_front_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/13-arm-front-red-lights-front/arm-03-front.png",
      priority = "medium",
      width = 54,
      height = 70,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {-1.34375, 2.4375}
    },

    base_front_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/14-silo-front/14-silo-front.png",
      width = 352,
      height = 96,
      shift = {0, 3.5}
    },
    silo_fade_out_start_distance = 8,
    silo_fade_out_end_distance = 15,

    alarm_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-alarm.ogg",
            volume = 1.5
          }
        }
      }
    },
    clamps_on_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-clamps-on.ogg",
            volume = 1.5
          }
        }
      }
    },
    clamps_off_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-clamps-off.ogg",
            volume = 1.5
          }
        }
      }
    },
    doors_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-doors.ogg",
            volume = 1.5
          }
        }
      }
    },
    raise_rocket_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-raise-rocket.ogg",
            volume = 1.5
          }
        }
      }
    }
  },
  {
    type = "rocket-silo-rocket",
    name = "rocket-silo-2-rocket",
    flags = {"not-on-map"},
    collision_mask = {"not-colliding-with-itself"},
    collision_box = {{-2, -7}, {2, 4}},
    selection_box = {{0, 0}, {0, 0}},
    dying_explosion = "massive-explosion",
    shadow_slave_entity = "rocket-silo-rocket-shadow",
    inventory_size = 1,
    rising_speed = 1 / (7 * 60),
    engine_starting_speed = 1 / (5.5 * 60),
    flying_speed = 2 / (2000 * 60),
    flying_acceleration = 0.01,
    result_items =
    {
      {"laser-quarry3", 1, "asteroid-quarry"}
    },

    glow_light =
    {
      intensity = 1,
      size = 30,
      shift = {0, 1.5},
      color = {r = 1.0, g = 1.0, b = 1.0}
    },

    rocket_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/02-11-rocket/02-rocket.png",
      width = 192,
      height = 288,
      shift = {0, 5.5}
    },

    rocket_shadow_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/09-rocket-shadow/09-rocket-shadow.png",
      priority = "medium",
      width = 384,
      height = 128,
      draw_as_shadow = true,
      shift = {-2.5, 2}
    },

    rocket_glare_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-glare.png",
      blend_mode = "additive",
      width = 509,
      height = 509,
      shift = {0, 9}
    },
    rocket_smoke_top1_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {-1.59375, 7.34375}
    },
    rocket_smoke_top2_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {0.46875, 8.28125}
    },
    rocket_smoke_top3_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {1.28125, 7.90625},
    },

    rocket_smoke_bottom1_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.7 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {-1.65625, 6.71875}
    },
    rocket_smoke_bottom2_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.7 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {1.65625, 6.71875}
    },
    rocket_flame_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.93,
      shift = {0.04, 10}
    },
    rocket_flame_left_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.345,
      shift = {-1.275, 8.6}
    },
    rocket_flame_left_rotation = 0.0611,

    rocket_flame_right_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.368,
      shift = {1.25, 8.875}
    },
    rocket_flame_right_rotation = 0.952,


    rocket_rise_offset = {0, -3.5},
    rocket_launch_offset = {0, -256},
    rocket_render_layer_switch_distance = 6.5,
    full_render_layer_switch_distance = 8,
    effects_fade_in_start_distance = 4.5,
    effects_fade_in_end_distance = 8,
    shadow_fade_out_start_ratio = 0.25,
    shadow_fade_out_end_ratio = 0.75,
    rocket_visible_distance_from_center = 3.75,

    flying_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-rocket.ogg",
            volume = 1.8
          },
        }
      },
    }
  },
  
  
  {
    type = "rocket-silo",
    name = "rocket-silo-3",
    icon = "__base__/graphics/icons/rocket-silo.png",
	icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    crafting_categories = {"rocket-building"},
    ingredient_count = 3,
    rocket_parts_required = 320,
    crafting_speed = 2,
    rocket_result_inventory_size = 1,
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 4.3}
    },
    fixed_recipe = "rocket-part",
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    minable = {hardness = 0.2, mining_time = 5, result = "rocket-silo"},
    max_health = 5000,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-4.2, -4.7}, {4.2, 4.7}},
    selection_box = {{-4.5, -5}, {4.5, 5}},
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 60
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "primary-input"
    },
    energy_usage = "250kW", --energy usage used when crafting the rocket
    idle_energy_usage = "10KW",
    lamp_energy_usage = "10KW",
    active_energy_usage = "3990KW",
    rocket_entity = "rocket-silo-3-rocket",

    times_to_blink = 3,
    light_blinking_speed = 1 / (3 * 60),
    door_opening_speed = 1 / (4.25 * 60),

    base_light =
    {
      {
        type = "oriented",
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "extra-high",
          flags = { "light" },
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {0.25, 1.25},
        size = 1,
        intensity = 1,
        rotation_shift = 0.6,
        color = {r = 0.7, g = 0.9, b = 1.0}
      },
      {
        type = "oriented",
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "extra-high",
          flags = { "light" },
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {-0.25, 1},
        size = 1,
        intensity = 1,
        rotation_shift = 0.5,
        color = {r = 0.7, g = 0.9, b = 1.0}
      }
    },
    base_engine_light =
    {
      intensity = 1,
      size = 25,
      shift = {0, 1.5}
    },

    shadow_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/00-shadow/00-silo-shadow.png",
      priority = "medium",
      width = 447,
      height = 351,
      draw_as_shadow = true,
      shift = {1.5, 0.5}
    },
    satellite_shadow_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/00-shadow/00-satellite-shadow.png",
      priority = "medium",
      width = 44,
      height = 22,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.25,
      draw_as_shadow = true,
      shift = {7.875, -2.1875}
    },

    hole_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/01-hole/01-hole.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },
    hole_light_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/01-hole/01-hole-light.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },

    rocket_shadow_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-shadow-over-rocket.png",
      width = 224,
      height = 128,
      shift = {0, 2}
    },
    rocket_glow_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-glow.png",
      blend_mode = "additive",
      width = 224,
      height = 128,
      shift = {0, 2}
    },


    door_back_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/04-05-doors/04-door-back.png",
      width = 192,
      height = 108,
      shift = {0, 1.53125}
    },
    door_back_open_offset = {1.75, -1.75},
    door_front_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/04-05-doors/05-door-front.png",
      width = 192,
      height = 112,
      shift = {0, 2.0625}
    },
    door_front_open_offset = {-1.75, 1.75},

    base_day_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/06-silo-base/06-silo-base-day.png",
      width = 352,
      height = 384,
      shift = {0, 0}
    },
    base_night_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/06-silo-base/06-silo-base-night.png",
      width = 352,
      height = 384,
      shift = {0, 0}
    },


    red_lights_back_sprites =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {1.34375, 0.28125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.3125, 0.9375}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.65625, 1.90625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.65625, 1.90625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.3125, 0.9375}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-1.34375, 0.28125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {0, 0}
        }
      }
    },

    red_lights_front_sprites =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {2.3125, 2.8125}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {1.34375, 3.40625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {0, 3.75}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-1.34375, 3.40625}
        },
        {
          filename = "__base__/graphics/entity/rocket-silo/07-red-lights-back/red-light.png",
          width = 32,
          height = 32,
          shift = {-2.3125, 2.8125}
        }
      }
    },
    satellite_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/satellite.png",
      priority = "medium",
      width = 27,
      height = 28,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.25,
      shift = {3.3125, -4.82813}
    },

    arm_01_back_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/arm-01-back.png",
      priority = "medium",
      width = 54,
      height = 50,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {-1.34375, -0.875}
    },

    arm_02_right_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/08-arms-back-satellite-animation/arm-02-right.png",
      priority = "medium",
      width = 81,
      height = 43,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {2.71875, 0.96875}
    },

    arm_03_front_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/13-arm-front-red-lights-front/arm-03-front.png",
      priority = "medium",
      width = 54,
      height = 70,
      frame_count = 12,
      line_length = 4,
      animation_speed = 0.2,
      shift = {-1.34375, 2.4375}
    },

    base_front_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/14-silo-front/14-silo-front.png",
      width = 352,
      height = 96,
      shift = {0, 3.5}
    },
    silo_fade_out_start_distance = 8,
    silo_fade_out_end_distance = 15,

    alarm_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-alarm.ogg",
            volume = 1.5
          }
        }
      }
    },
    clamps_on_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-clamps-on.ogg",
            volume = 1.5
          }
        }
      }
    },
    clamps_off_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-clamps-off.ogg",
            volume = 1.5
          }
        }
      }
    },
    doors_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-doors.ogg",
            volume = 1.5
          }
        }
      }
    },
    raise_rocket_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-raise-rocket.ogg",
            volume = 1.5
          }
        }
      }
    }
  },
  {
    type = "rocket-silo-rocket",
    name = "rocket-silo-3-rocket",
    flags = {"not-on-map"},
    collision_mask = {"not-colliding-with-itself"},
    collision_box = {{-2, -7}, {2, 4}},
    selection_box = {{0, 0}, {0, 0}},
    dying_explosion = "massive-explosion",
    shadow_slave_entity = "rocket-silo-rocket-shadow",
    inventory_size = 1,
    rising_speed = 1 / (7 * 60),
    engine_starting_speed = 1 / (5.5 * 60),
    flying_speed = 0.5 / (2000 * 60),
    flying_acceleration = 0.01,
    result_items =
    {
      {"laser-quarry4", 4, "planet-quarry"}
    },

    glow_light =
    {
      intensity = 1,
      size = 30,
      shift = {0, 1.5},
      color = {r = 1.0, g = 1.0, b = 1.0}
    },

    rocket_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/02-11-rocket/02-rocket.png",
      width = 192,
      height = 288,
      shift = {0, 5.5}
    },

    rocket_shadow_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/09-rocket-shadow/09-rocket-shadow.png",
      priority = "medium",
      width = 384,
      height = 128,
      draw_as_shadow = true,
      shift = {-2.5, 2}
    },

    rocket_glare_overlay_sprite =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/03-rocket-over-glare.png",
      blend_mode = "additive",
      width = 509,
      height = 509,
      shift = {0, 9}
    },
    rocket_smoke_top1_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {-1.59375, 7.34375}
    },
    rocket_smoke_top2_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {0.46875, 8.28125}
    },
    rocket_smoke_top3_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.8 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {1.28125, 7.90625},
    },

    rocket_smoke_bottom1_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.7 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {-1.65625, 6.71875}
    },
    rocket_smoke_bottom2_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/03-12-rocket-over/rocket-top-smoke.png",
      priority = "medium",
      tint = { r = 0.8, g = 0.8, b = 1, a = 0.7 },
      width = 47,
      height = 149,
      frame_count = 24,
      line_length = 8,
      animation_speed = 0.5,
      scale = 1.5,
      shift = {1.65625, 6.71875}
    },
    rocket_flame_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.93,
      shift = {0.04, 10}
    },
    rocket_flame_left_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.345,
      shift = {-1.275, 8.6}
    },
    rocket_flame_left_rotation = 0.0611,

    rocket_flame_right_animation =
    {
      filename = "__base__/graphics/entity/rocket-silo/10-rocket-under/jet-flame.png",
      priority = "medium",
      blend_mode = "additive",
      width = 88,
      height = 132,
      frame_count = 8,
      line_length = 8,
      animation_speed = 0.5,
      scale = 0.368,
      shift = {1.25, 8.875}
    },
    rocket_flame_right_rotation = 0.952,


    rocket_rise_offset = {0, -3.5},
    rocket_launch_offset = {0, -256},
    rocket_render_layer_switch_distance = 6.5,
    full_render_layer_switch_distance = 8,
    effects_fade_in_start_distance = 4.5,
    effects_fade_in_end_distance = 8,
    shadow_fade_out_start_ratio = 0.25,
    shadow_fade_out_end_ratio = 0.75,
    rocket_visible_distance_from_center = 3.75,

    flying_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/silo-rocket.ogg",
            volume = 1.8
          },
        }
      },
    }
  },
  
 {
type = "lamp",
name = "large-lamp",
icon = "__base__/graphics/icons/small-lamp.png",
icon_size = 32,
flags = {"placeable-neutral", "player-creation"},
minable = {hardness = 0.2, mining_time = 0.5, result = "large-lamp"},
max_health = 100,
corpse = "big-remnants",
collision_box = {{-1.8, -1.8}, {1.8, 1.8}},
selection_box = {{-2.0, -2.0}, {2.0, 2.0}},
vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
energy_source =
{
type = "electric",
usage_priority = "secondary-input"
},
energy_usage_per_tick = "30KW",
light = {intensity = 5, size = 260, color = {r=1, g=1, b=1}},
light_when_colored = {intensity = 5, size = 260, color = {r=1, g=1, b=1}},
glow_size = 120,
glow_color_intensity = 0.125,
picture_off =
{
filename = "__base__/graphics/entity/small-lamp/light-off.png",
priority = "high",
width = 67,
height = 58,
frame_count = 1,
axially_symmetrical = false,
direction_count = 1,
shift = {-0.015625, 0.15625},
scale = 4,
},
picture_on =
{
filename = "__base__/graphics/entity/small-lamp/light-on-patch.png",
priority = "high",
width = 62,
height = 62,
frame_count = 1,
axially_symmetrical = false,
direction_count = 1,
shift = {-0.03125, -0.03125},
scale = 4,
},

signal_to_color_mapping =
{
  {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
  {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
  {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
  {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
  {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
  {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
},
circuit_wire_connection_point = circuit_connector_definitions["lamp"].points,
circuit_connector_sprites = circuit_connector_definitions["lamp"].sprites,
circuit_wire_max_distance = default_circuit_wire_max_distance
},
  {
    type = "car",
    name = "car",
    icon = "__base__/graphics/icons/car.png",
	    icon_size = 32,
    flags = {"pushable", "placeable-neutral", "player-creation", "placeable-off-grid"},
    minable = {mining_time = 1, result = "car"},
    max_health = 200,
    corpse = "medium-remnants",
    dying_explosion = "medium-explosion",
    energy_per_hit_point = 1,
    crash_trigger = crash_trigger(),
    resistances =
    {
      {
        type = "fire",
        percent = 50
      },
      {
        type = "impact",
        percent = 30,
        decrease = 30
      }
    },
    collision_box = {{-0.7, -1}, {0.7, 1}},
    selection_box = {{-0.7, -1}, {0.7, 1}},
    effectivity = 0.5,
    braking_power = "200kW",
    burner =
    {
      effectivity = 0.6,
      fuel_inventory_size = 1,
      smoke =
      {
        {
          name = "car-smoke",
          deviation = {0.25, 0.25},
          frequency = 200,
          position = {0, 1.5},
          starting_frame = 0,
          starting_frame_deviation = 60
        }
      }
    },
    consumption = "150kW",
    friction = 2e-3,
    light =
    {
      {
        type = "oriented",
        minimum_darkness = 0.3,
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "medium",
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {-0.6, -14},
        size = 2,
        intensity = 0.6
      },
      {
        type = "oriented",
        minimum_darkness = 0.3,
        picture =
        {
          filename = "__core__/graphics/light-cone.png",
          priority = "medium",
          scale = 2,
          width = 200,
          height = 200
        },
        shift = {0.6, -14},
        size = 2,
        intensity = 0.6
      }
    },
    animation =
    {
      layers =
      {
        {
          width = 102,
          height = 86,
          frame_count = 2,
          direction_count = 64,
          shift = {0, -0.1875},
          animation_speed = 8,
          max_advance = 0.2,
          stripes =
          {
            {
             filename = "__base__/graphics/entity/car/car-1.png",
             width_in_frames = 2,
             height_in_frames = 22,
            },
            {
             filename = "__base__/graphics/entity/car/car-2.png",
             width_in_frames = 2,
             height_in_frames = 22,
            },
            {
             filename = "__base__/graphics/entity/car/car-3.png",
             width_in_frames = 2,
             height_in_frames = 20,
            },
          }
        },
        {
          width = 100,
          height = 75,
          frame_count = 2,
          apply_runtime_tint = true,
          direction_count = 64,
          max_advance = 0.2,
          line_length = 2,
          shift = {0, -0.171875},
          stripes = util.multiplystripes(2,
          {
            {
              filename = "__base__/graphics/entity/car/car-mask-1.png",
              width_in_frames = 1,
              height_in_frames = 22,
            },
            {
              filename = "__base__/graphics/entity/car/car-mask-2.png",
              width_in_frames = 1,
              height_in_frames = 22,
            },
            {
              filename = "__base__/graphics/entity/car/car-mask-3.png",
              width_in_frames = 1,
              height_in_frames = 20,
            },
          })
        },
        {
          width = 114,
          height = 76,
          frame_count = 2,
          draw_as_shadow = true,
          direction_count = 64,
          shift = {0.28125, 0.25},
          max_advance = 0.2,
          stripes = util.multiplystripes(2,
          {
           {
            filename = "__base__/graphics/entity/car/car-shadow-1.png",
            width_in_frames = 1,
            height_in_frames = 22,
           },
           {
            filename = "__base__/graphics/entity/car/car-shadow-2.png",
            width_in_frames = 1,
            height_in_frames = 22,
           },
           {
            filename = "__base__/graphics/entity/car/car-shadow-3.png",
            width_in_frames = 1,
            height_in_frames = 20,
           },
          })
        }
      }
    },
    turret_animation =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/car/car-turret.png",
          line_length = 8,
          width = 36,
          height = 29,
          frame_count = 1,
          direction_count = 64,
          shift = {0.03125, -0.890625},
          animation_speed = 8,
        },
        {
          filename = "__base__/graphics/entity/car/car-turret-shadow.png",
          line_length = 8,
          width = 46,
          height = 31,
          frame_count = 1,
          draw_as_shadow = true,
          direction_count = 64,
          shift = {0.875, 0.359375},
        }
      }
    },
    turret_rotation_speed = 0.35 / 60,
    sound_no_fuel =
    {
      {
        filename = "__base__/sound/fight/car-no-fuel-1.ogg",
        volume = 0.6
      },
    },
    stop_trigger_speed = 0.2,
    stop_trigger =
    {
      {
        type = "play-sound",
        sound =
        {
          {
            filename = "__base__/sound/car-breaks.ogg",
            volume = 0.6
          },
        }
      },
    },
    sound_minimum_speed = 0.2;
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/car-engine.ogg",
        volume = 0.6
      },
      activate_sound =
      {
        filename = "__base__/sound/car-engine-start.ogg",
        volume = 0.6
      },
      deactivate_sound =
      {
        filename = "__base__/sound/car-engine-stop.ogg",
        volume = 0.6
      },
      match_speed_to_activity = true,
    },
    open_sound = { filename = "__base__/sound/car-door-open.ogg", volume=0.7 },
    close_sound = { filename = "__base__/sound/car-door-close.ogg", volume = 0.7 },
    rotation_speed = 0.015,
    weight = 600,
    guns = { "vehicle-machine-gun" },
    inventory_size = 120
  },
  
  {
    type = "transport-belt",
    name = "terra-transport-belt-mk2",
    icon = "__base__/graphics/icons/express-transport-belt.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "terra-transport-belt-mk2"},
    max_health = 50,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__base__/graphics/entity/express-transport-belt/express-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 32,
      direction_count = 12
    },
	connector_frame_sprites = transport_belt_connector_frame_sprites,
    belt_horizontal = express_belt_horizontal, -- specified in transport-belt-pictures.lua
    belt_vertical = express_belt_vertical,
    ending_top = express_belt_ending_top,
    ending_bottom = express_belt_ending_bottom,
    ending_side = express_belt_ending_side,
    starting_top = express_belt_starting_top,
    starting_bottom = express_belt_starting_bottom,
    starting_side = express_belt_starting_side,
    ending_patch = ending_patch_prototype,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.59375
  },
  
  {
    type = "transport-belt",
    name = "terra-transport-belt",
    icon = "__base__/graphics/icons/express-transport-belt.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "terra-transport-belt"},
    max_health = 50,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__base__/graphics/entity/express-transport-belt/express-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 32,
      direction_count = 12
    },
	connector_frame_sprites = transport_belt_connector_frame_sprites,
    belt_horizontal = express_belt_horizontal, -- specified in transport-belt-pictures.lua
    belt_vertical = express_belt_vertical,
    ending_top = express_belt_ending_top,
    ending_bottom = express_belt_ending_bottom,
    ending_side = express_belt_ending_side,
    starting_top = express_belt_starting_top,
    starting_bottom = express_belt_starting_bottom,
    starting_side = express_belt_starting_side,
    ending_patch = ending_patch_prototype,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.29375
  },
  
  {
    type = "furnace",
    name = "stone-furnace-mk2",
    icon = "__base__/graphics/icons/stone-furnace.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "stone-furnace-mk2"},
    max_health = 250,
    corpse = "medium-remnants",
    repair_sound = { filename = "__base__/sound/manual-repair-simple.ogg" },
    mined_sound = { filename = "__base__/sound/deconstruct-bricks.ogg" },
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-stone-impact.ogg", volume = 1.0 },
    working_sound =
    {
      sound = { filename = "__base__/sound/furnace.ogg", }
    },
    resistances =
    {
      {
        type = "fire",
        percent = 80
      },
      {
        type = "explosion",
        percent = 30
      }
    },
    collision_box = {{-0.7, -0.7}, {0.7, 0.7}},
    selection_box = {{-0.8, -1}, {0.8, 1}},
    crafting_categories = {"smelting"},
    result_inventory_size = 2,
    energy_usage = "1800kW",
    crafting_speed = 1.7,
    source_inventory_size = 1,
    energy_source =
    {
      type = "burner",
      effectivity = 2,
      fuel_inventory_size = 1,
      emissions = 0.12,
      smoke =
      {
        {
          name = "smoke",
          deviation = {0.1, 0.1},
          frequency = 5,
          position = {0.0, -0.8},
          starting_vertical_speed = 0.08,
          starting_frame_deviation = 60
        }
      }
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/brick-furnace/brick-furnace.png",
      priority = "extra-high",
      width = 81,
      height = 64,
      frame_count = 1,
      shift = {0.5, 0.05 }
    },
    working_visualisations =
    {
      {
        north_position = {0.0, 0.0},
        east_position = {0.0, 0.0},
        south_position = {0.0, 0.0},
        west_position = {0.0, 0.0},
        animation =
        {
          filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/brick-furnace/stone-furnace-fire.png",
          priority = "extra-high",
          width = 23,
          height = 27,
          frame_count = 12,
          shift = { 0.078125, 0.5234375}
        },
        light = {intensity = 2, size = 2}
      }
    },
    fast_replaceable_group = "furnace"
  },
  
  {
    type = "solar-panel",
    name = "geothermal-generator",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "geothermal-generator"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/geothermal-generator.png",
      priority = "high",
      width = 132,
      height = 144,
      shift = {0.9, -1}
    },
    production = "1MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk2"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel.png",
      priority = "high",
      width = 104,
      height = 96
    },
    production = "4MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk3"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk2.png",
      priority = "high",
      width = 104,
      height = 96
    },
    production = "40MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk4",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk4"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk3.png",
      priority = "high",
      width = 104,
      height = 96
    },
    production = "400MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk5",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk4.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk5"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -2.8}, {2.4, 2.8}},
    selection_box = {{-2.9, -2.9}, {2.9, 2.9}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk4.png",
      priority = "high",
      width = 208,
      height = 192
    },
    production = "4000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk6",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk5.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk6"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -2.8}, {2.4, 2.8}},
    selection_box = {{-2.9, -2.9}, {2.9, 2.9}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk5.png",
      priority = "high",
      width = 208,
      height = 192
    },
    production = "40000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk7",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk6.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk7"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -2.8}, {2.4, 2.8}},
    selection_box = {{-2.9, -2.9}, {2.9, 2.9}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk6.png",
      priority = "high",
      width = 208,
      height = 192
    },
    production = "400000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk2-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk2-G"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-g.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "6MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk3-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk2-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk3-G"},
    max_health = 900,
    corpse = "big-remnants",
       collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk2-g.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "60MW"
	},
	
	 {
    type = "solar-panel",
    name = "solar-panel-mk4-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk3-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk4-G"},
    max_health = 900,
    corpse = "big-remnants",
     collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk3-g.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "600MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk5-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk4-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk5-G"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk4-g.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "6000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk6-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk5-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk6-G"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk5-g.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "60000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk7-G",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk6-g.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk7-G"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk6-g.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "600000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk2-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk2-G2"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-g2.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "8MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk3-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk2-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk3-G2"},
    max_health = 900,
    corpse = "big-remnants",
       collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk2-g2.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "80MW"
	},
	
	 {
    type = "solar-panel",
    name = "solar-panel-mk4-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk3-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk4-G2"},
    max_health = 900,
    corpse = "big-remnants",
     collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk3-g2.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "800MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk5-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk4-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk5-G2"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk4-g2.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "8000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk6-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk5-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk6-G2"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk5-g2.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "80000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk7-G2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk6-g2.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk7-G2"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk6-g2.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "800000MW"
	},
  
    {
    type = "solar-panel",
    name = "solar-panel-mk2-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk2-G3"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-g3.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "10MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk3-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk2-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk3-G3"},
    max_health = 900,
    corpse = "big-remnants",
       collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk2-g3.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "100MW"
	},
	
    {
    type = "solar-panel",
    name = "solar-panel-mk4-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk3-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk4-G3"},
    max_health = 900,
    corpse = "big-remnants",
     collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk3-g3.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "1000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk5-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk4-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk5-G3"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk4-g3.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "10000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk6-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk5-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk6-G3"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk5-g3.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "100000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk7-G3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk6-g3.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk7-G3"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk6-g3.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "1000000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk2-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-gl.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk2-GL"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-gl.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "16MW"
  },
  
  {
    type = "solar-panel",
    name = "solar-panel-mk3-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk2-gl.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk3-GL"},
    max_health = 900,
    corpse = "big-remnants",
       collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk2-gl.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "160MW"
	},
	
	 {
    type = "solar-panel",
    name = "solar-panel-mk4-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk3-gl.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk4-GL"},
    max_health = 900,
    corpse = "big-remnants",
     collision_box = {{-3.4, -1.8}, {1.8, 1.4}},
    selection_box = {{-3.4, -1.8}, {1.8, 1.4}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk3-gl.png",
      priority = "high",
      width = 209,
      height = 96
    },
    production = "1600MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk5-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk4-gl.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk5-GL"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk4-gl.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "16000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk6-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk5.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk6-GL"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk5-gl.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "160000MW"
	},
	
	{
    type = "solar-panel",
    name = "solar-panel-mk7-GL",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel-mk6.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "solar-panel-mk7-GL"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-6.8, -3.4}, {3.4, 2.8}},
    selection_box = {{-6.8, -3.4}, {3.4, 2.8}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel-mk6-gl.png",
      priority = "high",
      width = 416,
      height = 192
    },
    production = "1600000MW"
	},
	
    {
    type = "solar-panel",
    name = "dyson",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-solar-panel.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "dyson"},
    max_health = 900,
    corpse = "big-remnants",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    energy_source =
    {
      type = "electric",
      usage_priority = "solar"
    },
    {
      type = "electric",
      buffer_capacity = "5000000000GJ",
      usage_priority = "terciary",
      input_flow_limit = "5500000000GW",
      output_flow_limit = "5500000000GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/solar-panel/advanced-solar-panel.png",
      priority = "high",
      width = 104,
      height = 96
    },
    production = "500000000000000000GW"
  },
  
  {
    type = "accumulator",
    name = "dyson-storage",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "dyson-storage"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "500000000000000000GW",
      usage_priority = "terciary",
      input_flow_limit = "500000000000000000GW",
      output_flow_limit = "500000000000000000GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 0.9, size = 7},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1.2, size = 14},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power_idle.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
  
  {
    type = "assembling-machine",
    name = "advanced-chemical-plant",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-chemical-plant/advanced-chemical-plant-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "advanced-chemical-plant"},
    max_health = 300,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    module_specification =
    {
      module_slots = 6
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    animation =
    {
      north =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-chemical-plant/advanced-chemical-plant.png",
        width = 156,
        height = 141,
        frame_count = 1,
        shift = {0.5, -0.078125}
      },
      west =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-chemical-plant/advanced-chemical-plant.png",
        x = 468,
        width = 156,
        height = 141,
        frame_count = 1,
        shift = {0.5, -0.078125}
      },
      south =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-chemical-plant/advanced-chemical-plant.png",
        x = 312,
        width = 156,
        height = 141,
        frame_count = 1,
        shift = {0.5, -0.078125}
      },
      east =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-chemical-plant/advanced-chemical-plant.png",
        x = 156,
        width = 156,
        height = 141,
        frame_count = 1,
        shift = {0.5, -0.078125}
      }
    },
    working_visualisations =
    {
      {
        north_position = {0.94, -0.73},
        west_position = {0.05, -1.46},
        south_position = {-0.97, -1.47},
        east_position = {-0.3, 0.02},
        animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-green-patch.png",
          frame_count = 32,
          width = 15,
          height = 10,
          animation_speed = 0.5,
        }
      },
      {
        north_position = {1.4, -0.23},
        west_position = {0.05, -0.96},
        south_position = {-1, -1},
        east_position = {-0.3, 0.55},
        north_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          frame_count = 1,
          width = 21,
          height = 10
        },
        east_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          x = 21,
          frame_count = 1,
          width = 21,
          height = 10
        },
        south_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          x = 42,
          frame_count = 1,
          width = 21,
          height = 10
        }
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        {
          filename = "__base__/sound/chemical-plant.ogg",
          volume = 0.8
        }
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    crafting_speed = 2.25,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    energy_usage = "410kW",
    ingredient_count = 9,
    crafting_categories = {"chemistry"},
    fluid_boxes =
    {
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {-1, -2} }}
      },
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {1, -2} }}
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        base_level = 1,
        pipe_connections = {{ position = {-1, 2} }}
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        base_level = 1,
        pipe_connections = {{ position = {1, 2} }}
      }
    }
  },
  
  {
    type = "electric-pole",
    name = "substation-mk2",
    icon = "__base__/graphics/icons/substation.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "substation-mk2"},
    max_health = 200,
    corpse = "medium-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    drawing_box = {{-1, -3}, {1, 1}},
    maximum_wire_distance = 28,
    supply_area_distance = 14,
    pictures =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/substation-mk2/substation.png",
      priority = "high",
      width = 132,
      height = 144,
      direction_count = 4,
      shift = {0.9, -1}
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/substation.ogg" },
      apparent_volume = 1.5,
      audible_distance_modifier = 0.5,
      probability = 1 / (3 * 60) -- average pause between the sound is 3 seconds
    },
    connection_points =
    {
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.3, -0.6},
          red = {2.65, -0.6}
        },
        wire =
        {
          copper = {-0.23, -2.65},
          green = {-0.85,-2.65},
          red = {0.35,-2.65}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.2, -0.8},
          red = {2.5, -0.35}
        },
        wire =
        {
          copper = {-0.26, -2.71},
          green = {-0.67,-3},
          red = {0.17,-2.47}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.9, -0.9},
          red = {1.9, -0.3}
        },
        wire =
        {
          copper = {-0.23, -2.7},
          green = {-0.23,-3.2},
          red = {-0.23,-2.35}
        }
      },
      {
        shadow =
        {
          copper = {1.8, -0.7},
          green = {1.3, -0.6},
          red = {2.4, -1.15}
        },
        wire =
        {
          copper = {-0.2, -2.7},
          green = {-0.62,-2.45},
          red = {0.25,-2.98}
        }
      }
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/small-electric-pole/electric-pole-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
  },
  
  {
    type = "electric-pole",
    name = "tesla-coil",
    icon = "__base__/graphics/icons/substation.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "tesla-coil"},
    max_health = 200,
    corpse = "medium-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    drawing_box = {{-1, -3}, {1, 1}},
    maximum_wire_distance = 0,
    supply_area_distance = 60,
    pictures =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/tesla-coil/tesla-coil-2.png",
      priority = "high",
      width = 132,
      height = 158,
      direction_count = 4,
      shift = {0.3, -1.5}
    },
	 animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/tesla-coil/tesla-coil-animation.png",
      priority = "high",
      width = 1056,
      height = 158,
      frame_count = 8,
      line_length = 8,
      shift = {0.84, -0.09}
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/substation.ogg" },
      apparent_volume = 1.5,
      audible_distance_modifier = 0.5,
      probability = 1 / (3 * 60) -- average pause between the sound is 3 seconds
    },
    connection_points =
    {
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.3, -0.6},
          red = {2.65, -0.6}
        },
        wire =
        {
          copper = {-0.23, -2.65},
          green = {-0.85,-2.65},
          red = {0.35,-2.65}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.2, -0.8},
          red = {2.5, -0.35}
        },
        wire =
        {
          copper = {-0.26, -2.71},
          green = {-0.67,-3},
          red = {0.17,-2.47}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.9, -0.9},
          red = {1.9, -0.3}
        },
        wire =
        {
          copper = {-0.23, -2.7},
          green = {-0.23,-3.2},
          red = {-0.23,-2.35}
        }
      },
      {
        shadow =
        {
          copper = {1.8, -0.7},
          green = {1.3, -0.6},
          red = {2.4, -1.15}
        },
        wire =
        {
          copper = {-0.2, -2.7},
          green = {-0.62,-2.45},
          red = {0.25,-2.98}
        }
      }
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/small-electric-pole/electric-pole-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
  },
  
  {
    type = "electric-pole",
    name = "terra-coil",
    icon = "__base__/graphics/icons/substation.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "terra-coil"},
    max_health = 200,
    corpse = "medium-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    drawing_box = {{-1, -3}, {1, 1}},
    maximum_wire_distance = 0,
    supply_area_distance = 64,
    pictures =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/tesla-coil/tesla-coil-2.png",
      priority = "high",
      width = 132,
      height = 144,
      direction_count = 4,
      shift = {0.9, -1}
    },
	 animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/tesla-coil/tesla-coil-animation.png",
      priority = "high",
      width = 1056,
      height = 158,
      frame_count = 8,
      line_length = 8,
      shift = {0.84, -0.09}
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/substation.ogg" },
      apparent_volume = 1.5,
      audible_distance_modifier = 0.5,
      probability = 1 / (3 * 60) -- average pause between the sound is 3 seconds
    },
    connection_points =
    {
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.3, -0.6},
          red = {2.65, -0.6}
        },
        wire =
        {
          copper = {-0.23, -2.65},
          green = {-0.85,-2.65},
          red = {0.35,-2.65}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.2, -0.8},
          red = {2.5, -0.35}
        },
        wire =
        {
          copper = {-0.26, -2.71},
          green = {-0.67,-3},
          red = {0.17,-2.47}
        }
      },
      {
        shadow =
        {
          copper = {1.9, -0.6},
          green = {1.9, -0.9},
          red = {1.9, -0.3}
        },
        wire =
        {
          copper = {-0.23, -2.7},
          green = {-0.23,-3.2},
          red = {-0.23,-2.35}
        }
      },
      {
        shadow =
        {
          copper = {1.8, -0.7},
          green = {1.3, -0.6},
          red = {2.4, -1.15}
        },
        wire =
        {
          copper = {-0.2, -2.7},
          green = {-0.62,-2.45},
          red = {0.25,-2.98}
        }
      }
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/small-electric-pole/electric-pole-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
  },
  
   {
    type = "logistic-robot",
    name = "logistic-robot-mk2",
    icon = "__base__/graphics/icons/logistic-robot.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-on-map"},
    minable = {hardness = 0.1, mining_time = 0.1, result = "logistic-robot-mk2"},
    max_health = 100,
    collision_box = {{0, 0}, {0, 0}},
    selection_box = {{-0.5, -1.5}, {0.5, -0.5}},
    max_payload_size = 15,
    speed = 0.25,
    transfer_distance = 0.5,
    max_energy = "3000kJ",
    energy_per_tick = "0.01kJ",
    speed_multiplier_when_out_of_energy = 0.2,
    energy_per_move = "1kJ",
    min_to_charge = 0.2,
    max_to_charge = 0.95,
    idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 42
    },
    idle_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16
    },
    in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 126
    },
    in_motion_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 84
    },
    shadow_idle =
    {
      filename = "__base__/graphics/entity/logistic-robot/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16,
      y = 23
    },
    shadow_idle_with_cargo =
    {
      filename = "__base__/graphics/entity/logistic-robot/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16
    },
    shadow_in_motion =
    {
      filename = "__base__/graphics/entity/logistic-robot/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16,
      y = 23
    },
    shadow_in_motion_with_cargo =
    {
      filename = "__base__/graphics/entity/logistic-robot/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16
    },
    working_sound = flying_robot_sounds(),
    cargo_centered = {0.0, 0.2},
  },

  {
    type = "construction-robot",
    name = "construction-robot-mk2",
    icon = "__base__/graphics/icons/construction-robot.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-on-map"},
    minable = {hardness = 0.1, mining_time = 0.1, result = "construction-robot-mk2"},
    max_health = 100,
    collision_box = {{0, 0}, {0, 0}},
    selection_box = {{-0.5, -1.5}, {0.5, -0.5}},
    max_payload_size = 1,
    speed = 0.25,
    transfer_distance = 0.5,
    max_energy = "3000kJ",
    energy_per_tick = "0.01kJ",
    speed_multiplier_when_out_of_energy = 0.2,
    energy_per_move = "1kJ",
    min_to_charge = 0.2,
    max_to_charge = 0.95,
    working_light = {intensity = 1.8, size = 16},
    idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/construction-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 32,
      height = 36,
      frame_count = 1,
      shift = {0, -0.15625},
      direction_count = 16
    },
    in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/construction-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 32,
      height = 36,
      frame_count = 1,
      shift = {0, -0.15625},
      direction_count = 16,
      y = 36
    },
    shadow_idle =
    {
      filename = "__base__/graphics/entity/construction-robot/construction-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 50,
      height = 24,
      frame_count = 1,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    shadow_in_motion =
    {
      filename = "__base__/graphics/entity/construction-robot/construction-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 50,
      height = 24,
      frame_count = 1,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    working =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots/construction-robot-mk2-working.png",
      priority = "high",
      line_length = 2,
      width = 28,
      height = 36,
      frame_count = 2,
      shift = {0, -0.15625},
      direction_count = 16,
      animation_speed = 0.3,
    },
    shadow_working =
    {
      stripes = util.multiplystripes(2,
      {
        {
          filename = "__base__/graphics/entity/construction-robot/construction-robot-shadow.png",
          width_in_frames = 16,
          height_in_frames = 1,
        }
      }),
      priority = "high",
      width = 50,
      height = 24,
      frame_count = 2,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    smoke =
    {
      filename = "__base__/graphics/entity/smoke-construction/smoke-01.png",
      width = 39,
      height = 32,
      frame_count = 19,
      line_length = 19,
      shift = {0.078125, -0.15625},
      animation_speed = 0.3,
    },
    sparks =
    {
      {
        filename = "__base__/graphics/entity/sparks/sparks-01.png",
        width = 39,
        height = 34,
        frame_count = 19,
        line_length = 19,
        shift = {-0.109375, 0.3125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-02.png",
        width = 36,
        height = 32,
        frame_count = 19,
        line_length = 19,
        shift = {0.03125, 0.125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-03.png",
        width = 42,
        height = 29,
        frame_count = 19,
        line_length = 19,
        shift = {-0.0625, 0.203125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-04.png",
        width = 40,
        height = 35,
        frame_count = 19,
        line_length = 19,
        shift = {-0.0625, 0.234375},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-05.png",
        width = 39,
        height = 29,
        frame_count = 19,
        line_length = 19,
        shift = {-0.109375, 0.171875},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-06.png",
        width = 44,
        height = 36,
        frame_count = 19,
        line_length = 19,
        shift = {0.03125, 0.3125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
    },
    repair_pack = "repair-pack",
    working_sound = flying_robot_sounds(),
    cargo_centered = {0.0, 0.2},
    construction_vector = {0.30, 0.22},
  },
  
  {
    type = "logistic-robot",
    name = "logistic-robot-mk3",
    icon = "__base__/graphics/icons/logistic-robot.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-on-map"},
    minable = {hardness = 0.1, mining_time = 0.1, result = "logistic-robot-mk3"},
    max_health = 100,
    collision_box = {{0, 0}, {0, 0}},
    selection_box = {{-0.5, -1.5}, {0.5, -0.5}},
    max_payload_size = 500,
    speed = 50000,
    transfer_distance = 0.5,
    max_energy = "3000kJ",
    energy_per_tick = "0.01kJ",
    speed_multiplier_when_out_of_energy = 0.2,
    energy_per_move = "1kJ",
    min_to_charge = 0.2,
    max_to_charge = 0.95,
    idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 42
    },
    idle_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16
    },
    in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 126
    },
    in_motion_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 41,
      height = 42,
      frame_count = 1,
      shift = {0.015625, -0.09375},
      direction_count = 16,
      y = 84
    },
    shadow_idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16,
      y = 23
    },
    shadow_idle_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16
    },
    shadow_in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16,
      y = 23
    },
    shadow_in_motion_with_cargo =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/logistic-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 59,
      height = 23,
      frame_count = 1,
      shift = {0.96875, 0.609375},
      direction_count = 16
    },
    working_sound = flying_robot_sounds(),
    cargo_centered = {0.0, 0.2},
  },

  {
    type = "construction-robot",
    name = "construction-robot-mk3",
    icon = "__base__/graphics/icons/construction-robot.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-on-map"},
    minable = {hardness = 0.1, mining_time = 0.1, result = "construction-robot-mk3"},
    max_health = 100,
    collision_box = {{0, 0}, {0, 0}},
    selection_box = {{-0.5, -1.5}, {0.5, -0.5}},
    max_payload_size = 5000,
    speed = 50000,
    transfer_distance = 2.5,
    max_energy = "0.1kJ",
    energy_per_tick = "0.001kJ",
    speed_multiplier_when_out_of_energy = 0.2,
    energy_per_move = "0.001kJ",
    min_to_charge = 0.2,
    max_to_charge = 0.3,
    working_light = {intensity = 1.8, size = 16},
    idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 32,
      height = 36,
      frame_count = 1,
      shift = {0, -0.15625},
      direction_count = 16
    },
    in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot-mk2.png",
      priority = "high",
      line_length = 16,
      width = 32,
      height = 36,
      frame_count = 1,
      shift = {0, -0.15625},
      direction_count = 16,
      y = 36
    },
    shadow_idle =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot/construction-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 50,
      height = 24,
      frame_count = 1,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    shadow_in_motion =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot/construction-robot-shadow.png",
      priority = "high",
      line_length = 16,
      width = 50,
      height = 24,
      frame_count = 1,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    working =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot-mk2-working.png",
      priority = "high",
      line_length = 2,
      width = 28,
      height = 36,
      frame_count = 2,
      shift = {0, -0.15625},
      direction_count = 16,
      animation_speed = 0.3,
    },
    shadow_working =
    {
      stripes = util.multiplystripes(2,
      {
        {
          filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/robots2/construction-robot/construction-robot-shadow.png",
          width_in_frames = 16,
          height_in_frames = 1,
        }
      }),
      priority = "high",
      width = 50,
      height = 24,
      frame_count = 2,
      shift = {1.09375, 0.59375},
      direction_count = 16
    },
    smoke =
    {
      filename = "__base__/graphics/entity/smoke-construction/smoke-01.png",
      width = 39,
      height = 32,
      frame_count = 19,
      line_length = 19,
      shift = {0.078125, -0.15625},
      animation_speed = 0.3,
    },
    sparks =
    {
      {
        filename = "__base__/graphics/entity/sparks/sparks-01.png",
        width = 39,
        height = 34,
        frame_count = 19,
        line_length = 19,
        shift = {-0.109375, 0.3125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-02.png",
        width = 36,
        height = 32,
        frame_count = 19,
        line_length = 19,
        shift = {0.03125, 0.125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-03.png",
        width = 42,
        height = 29,
        frame_count = 19,
        line_length = 19,
        shift = {-0.0625, 0.203125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-04.png",
        width = 40,
        height = 35,
        frame_count = 19,
        line_length = 19,
        shift = {-0.0625, 0.234375},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-05.png",
        width = 39,
        height = 29,
        frame_count = 19,
        line_length = 19,
        shift = {-0.109375, 0.171875},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
      {
        filename = "__base__/graphics/entity/sparks/sparks-06.png",
        width = 44,
        height = 36,
        frame_count = 19,
        line_length = 19,
        shift = {0.03125, 0.3125},
        tint = { r = 1.0, g = 0.9, b = 0.0, a = 1.0 },
        animation_speed = 0.3,
      },
    },
    repair_pack = "repair-pack",
    working_sound = flying_robot_sounds(),
    cargo_centered = {0.0, 0.2},
    construction_vector = {0.30, 0.22},
  },
  
   {
    type = "accumulator",
    name = "advanced-accumulator",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "advanced-accumulator"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "25MJ",
      usage_priority = "terciary",
      input_flow_limit = "1500kW",
      output_flow_limit = "1500kW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-accumulator/advanced-accumulator.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-accumulator/advanced-accumulator-charge-animation.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 1.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 0.3, size = 7},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/advanced-accumulator/advanced-accumulator-discharge-animation.png",
      width = 147,
      height = 128,
      line_length = 8,
      frame_count = 24,
      shift = {0.395, -0.525},
      animation_speed = 1.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1.2, size = 14},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/accumulator-working.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__base__/sound/accumulator-idle.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 5
   }
   },
   
   {
    type = "accumulator",
    name = "energy-sphere",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-sphere"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "125MJ",
      usage_priority = "terciary",
      input_flow_limit = "5500kW",
      output_flow_limit = "5500kW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/power.png",
      width = 187,
      height = 343,
      line_length = 10,
      frame_count = 60,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 0.9, size = 7},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/power.png",
      width = 187,
      height = 343,
      line_length = 10,
      frame_count = 60,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1.2, size = 14},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power_idle.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
        
   {
    type = "accumulator",
    name = "energy-liquid",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "125MJ",
      usage_priority = "terciary",
      input_flow_limit = "5500kW",
      output_flow_limit = "5500kW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power_idle.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
   
   {
    type = "accumulator",
    name = "energy-liquid-2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo2-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-2"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-1, -1}, {1, 1}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "725MJ",
      usage_priority = "terciary",
      input_flow_limit = "55000GW",
      output_flow_limit = "55000GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/silo2.png",
      priority = "low",
      width = 279,
      height = 300,
      shift = {2.1, -1.9},
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/charge.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/discharge.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      max_sounds_per_type = 1
   }
   },
   
   {
    type = "accumulator",
    name = "energy-liquid-3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo3-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-3"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-10.1, -13.1}, {12.1, 8}},
    selection_box = {{-10.1, -13.1}, {12.1, 8}},
    collision_mask = { "item-layer", "object-layer", "water-tile"},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "72500MJ",
      usage_priority = "terciary",
      input_flow_limit = "5GW",
      output_flow_limit = "5GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/silo3.png",
      priority = "low",
      width = 793,
      height = 678,
      shift = {1, -3}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank-charge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank-discharge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
   
   {
    type = "accumulator",
    name = "energy-liquid-U",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-U"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "250MJ",
      usage_priority = "terciary",
      input_flow_limit = "10500kW",
      output_flow_limit = "10500kW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid2.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation2.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation2.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power_idle.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
   
   {
    type = "accumulator",
    name = "energy-liquid-2-U",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo2-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-2-U"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-1, -1}, {1, 1}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "1450MJ",
      usage_priority = "terciary",
      input_flow_limit = "55000GW",
      output_flow_limit = "55000GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/silo4.png",
      priority = "low",
      width = 279,
      height = 300,
      shift = {2.1, -1.9},
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/charge2.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/discharge2.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      max_sounds_per_type = 1
   }
   },
   
   {
    type = "accumulator",
    name = "energy-liquid-3-U",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo3-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-3-U"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-10.1, -13.1}, {12.1, 8}},
    selection_box = {{-10.1, -13.1}, {12.1, 8}},
	collision_mask = { "item-layer", "object-layer", "water-tile"},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "145000MJ",
      usage_priority = "terciary",
      input_flow_limit = "55000GW",
      output_flow_limit = "55000GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank.png",
      priority = "low",
      width = 793,
      height = 678,
      shift = {1, -3}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank2-charge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank2-discharge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },

   {
    type = "accumulator",
    name = "energy-liquid-D",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/advanced-accumulator.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-D"},
    max_health = 150,
    corpse = "medium-remnants",
    collision_box = {{-0.9, -0.9}, {0.9, 0.9}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "850MJ",
      usage_priority = "terciary",
      input_flow_limit = "50050kW",
      output_flow_limit = "50050kW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid3.png",
      priority = "extra-high",
      width = 124,
      height = 103,
      shift = {0.7, -0.2}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-charge-animation3.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/energy-liquid-discharge-animation3.png",
      width = 138,
      height = 135,
      line_length = 8,
      frame_count = 24,
      shift = {0.482, -0.638},
      animation_speed = 0.5
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 32, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/water_power_idle.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },

    {
    type = "accumulator",
    name = "energy-liquid-2-D",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo2-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-2-D"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-1, -1}, {1, 1}},
    selection_box = {{-1, -1}, {1, 1}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "3450MJ",
      usage_priority = "terciary",
      input_flow_limit = "1GW",
      output_flow_limit = "1GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/silo5.png",
      priority = "low",
      width = 279,
      height = 300,
      shift = {2.1, -1.9},
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/charge3.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.2
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/discharge3.png",
	  priority = "low",
      width = 279,
      height = 300,
      line_length = 3,
      frame_count = 9,
      shift = {2.1, -1.9},
      animation_speed = 0.2
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 64, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/reactor.ogg",
        volume = 2
      },
      max_sounds_per_type = 1
   }
   },

   {
    type = "accumulator",
    name = "energy-liquid-3-D",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/silo3-icon.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "energy-liquid-3-D"},
    max_health = 300,
    corpse = "medium-remnants",
    collision_box = {{-10.1, -13.1}, {12.1, 8}},
    selection_box = {{-10.1, -13.1}, {12.1, 8}},
	collision_mask = { "item-layer", "object-layer", "water-tile"},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "545000MJ",
      usage_priority = "terciary",
      input_flow_limit = "55GW",
      output_flow_limit = "55GW"
    },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/silo6.png",
      priority = "low",
      width = 793,
      height = 678,
      shift = {1, -3}
    },
    charge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank3-charge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    charge_cooldown = 30,
    charge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    discharge_animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/energy-liquid/tank3-discharge.png",
	  priority = "low",
      width = 793,
      height = 678,
      line_length = 2,
      frame_count = 4,
      shift = {1, -3},
      animation_speed = 0.2
    },
    discharge_cooldown = 60,
    discharge_light = {intensity = 1, size = 128, color = {r=0, g=0.5, b=1}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound =
      {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      idle_sound = {
        filename = "__Darkstar_utilities_Low_Spec__/sounds/silo3.ogg",
        volume = 1
      },
      max_sounds_per_type = 5
   }
   },
  
  {
    type = "resource",
    name = "gold-ore",
    icon = "__base__/graphics/icons/iron-ore.png",
	    icon_size = 32,
    flags = {"placeable-neutral"},
    order="a-b-b",
    minable =
    {
      hardness = 0.9,
      mining_particle = "iron-ore-particle",
      mining_time = 2,
      result = "gold-ore"
    },
    collision_box = {{ -0.1, -0.1}, {0.1, 0.1}},
    selection_box = {{ -0.5, -0.5}, {0.5, 0.5}},
    autoplace =
    {
      control = "gold-ore",
      sharpness = 15/16,
      richness_multiplier = 1500,
      richness_multiplier_distance_bonus = 20,
      richness_base = 10,
      peaks = {
        {
          influence = 0.02,
          starting_area_weight_optimal = 0,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.01,
          starting_area_weight_optimal = 1,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.2,
          noise_layer = "gold-ore",
          noise_octaves_difference = -1.9,
          noise_persistence = 0.1,
          starting_area_weight_optimal = 0,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.1,
          noise_layer = "gold-ore",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.2,
          starting_area_weight_optimal = 1,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = -0.1,
          max_influence = 0.3,
          noise_layer = "copper-ore",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.45,
        },
        {
          influence = -0.1,
          max_influence = 0.1,
          noise_layer = "coal",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.45,
        },
        {
          influence = 0.1,
          max_influence = 0.1,
          noise_layer = "stone",
          noise_octaves_difference = -3,
          noise_persistence = 0.45,
        },
      },
    },
    stage_counts = {1000, 600, 400, 200, 100, 50, 20, 1},
    stages =
    {
      sheet =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/gold-ore.png",
        priority = "extra-high",
        width = 64,
        height = 64,
        frame_count = 8,
        variation_count = 8
      }
    },
    map_color = {r=0.937, g=0.919, b=0.127}
  },
  
  {
    type = "resource",
    name = "lead-ore",
    icon = "__base__/graphics/icons/iron-ore.png",
	    icon_size = 32,
    flags = {"placeable-neutral"},
    order="a-b-b",
    minable =
    {
      hardness = 0.9,
      mining_particle = "iron-ore-particle",
      mining_time = 4,
      result = "lead-ore"
    },
    collision_box = {{ -0.1, -0.1}, {0.1, 0.1}},
    selection_box = {{ -0.5, -0.5}, {0.5, 0.5}},
    autoplace =
    {
      control = "lead-ore",
      sharpness = 15/16,
      richness_multiplier = 1500,
      richness_multiplier_distance_bonus = 20,
      richness_base = 10,
      peaks = {
        {
          influence = 0.03,
          starting_area_weight_optimal = 0,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.03,
          starting_area_weight_optimal = 1,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.1,
          noise_layer = "lead-ore",
          noise_octaves_difference = -1.9,
          noise_persistence = 0.1,
          starting_area_weight_optimal = 0,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = 0.2,
          noise_layer = "lead-ore",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.2,
          starting_area_weight_optimal = 1,
          starting_area_weight_range = 0,
          starting_area_weight_max_range = 2,
        },
        {
          influence = -0.1,
          max_influence = 0.2,
          noise_layer = "copper-ore",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.45,
        },
        {
          influence = -0.1,
          max_influence = 0.2,
          noise_layer = "coal",
          noise_octaves_difference = -2.3,
          noise_persistence = 0.45,
        },
        {
          influence = 0.1,
          max_influence = 0.25,
          noise_layer = "stone",
          noise_octaves_difference = -3,
          noise_persistence = 0.45,
        },
      },
    },
    stage_counts = {1000, 600, 400, 200, 100, 50, 20, 1},
    stages =
    {
      sheet =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lead-ore.png",
        priority = "extra-high",
        width = 64,
        height = 64,
        frame_count = 8,
        variation_count = 8
      }
    },
    map_color = {r=0, g=0, b=0.227}
  },
  
  {
    type = "radar",
    name = "radar-2",
    icon = "__base__/graphics/icons/radar.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "radar"},
    max_health = 250,
    corpse = "big-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 70
      },
      {
        type = "impact",
        percent = 30
      }
    },
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    energy_per_sector = "5MJ",
    max_distance_of_sector_revealed = 140,
    max_distance_of_nearby_sector_revealed = 12,
    energy_per_nearby_scan = "50kJ",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage = "900kW",
    integration_patch =
    {
      filename = "__base__/graphics/entity/radar/radar-integration.png",
      priority = "low",
      width = 119,
      height = 108,
      apply_projection = false,
      direction_count = 1,
      repeat_count = 64,
      line_length = 1,
      shift = util.by_pixel(1.5, 4),
      hr_version =
      {
        filename = "__base__/graphics/entity/radar/hr-radar-integration.png",
        priority = "low",
        width = 238,
        height = 216,
        apply_projection = false,
        direction_count = 1,
        repeat_count = 64,
        line_length = 1,
        shift = util.by_pixel(1.5, 4),
        scale = 0.5
      }
    },
    pictures =
    {
      layers =
      {
        {
          filename = "__base__/graphics/entity/radar/radar.png",
          priority = "low",
          width = 98,
          height = 128,
          apply_projection = false,
          direction_count = 64,
          line_length = 8,
          shift = util.by_pixel(1, -16),
          hr_version = {
            filename = "__base__/graphics/entity/radar/hr-radar.png",
            priority = "low",
            width = 196,
            height = 254,
            apply_projection = false,
            direction_count = 64,
            line_length = 8,
            shift = util.by_pixel(1, -16),
            scale = 0.5
          }
        },
        {
          filename = "__base__/graphics/entity/radar/radar-shadow.png",
          priority = "low",
          width = 172,
          height = 94,
          apply_projection = false,
          direction_count = 64,
          line_length = 8,
          shift = util.by_pixel(39,3),
          draw_as_shadow = true,
          hr_version = {
            filename = "__base__/graphics/entity/radar/hr-radar-shadow.png",
            priority = "low",
            width = 343,
            height = 186,
            apply_projection = false,
            direction_count = 64,
            line_length = 8,
            shift = util.by_pixel(39.25,3),
            draw_as_shadow = true,
            scale = 0.5
          }
        }
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/radar.ogg"
        }
      },
      apparent_volume = 2,
    },
    radius_minimap_visualisation_color = { r = 0.059, g = 0.092, b = 0.235, a = 0.275 },
  },
  
   {
    type = "beacon",
    name = "ultra-beacon",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/ultra-beacon-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "ultra-beacon"},
    max_health = 200,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "pollution"},
    base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/ultra-beacon/ultra-beacon-base.png",
      width = 116,
      height = 93,
      shift = { 0.34, 0.06}
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/ultra-beacon/ultra-beacon-antenna.png",
      width = 54,
      height = 50,
      line_length = 8,
      frame_count = 32,
      shift = { -0.03, -1.72},
      animation_speed = 0.5
    },
    animation_shadow =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/misc/beacon-shadow.png",
      width = 63,
      height = 49,
      line_length = 8,
      frame_count = 32,
      shift = { 3.12, 0.5},
      animation_speed = 0.5
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/beacon/beacon-radius-visualization.png",
      width = 10,
      height = 10
    },
    supply_area_distance = 50,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_usage = "50MW",
    distribution_effectivity = 0.7,
    module_specification =
    {
      module_slots = 6,
      module_info_icon_shift = {0, 0.5},
      module_info_multi_row_initial_height_modifier = -0.3
    
    },
   },
   
   {
    type = "beacon",
    name = "power-boost-beacon",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/power-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "power-boost-beacon"},
    max_health = 200,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "pollution", "productivity"},
    base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/power-boost-beacon/power-base.png",
      width = 116,
      height = 93,
      shift = { 0.34, 0.06}
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/power-boost-beacon/power-antenna.png",
      width = 54,
      height = 50,
      line_length = 8,
      frame_count = 32,
      shift = { -0.03, -1.72},
      animation_speed = 0.5
    },
    animation_shadow =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/misc/beacon-shadow.png",
      width = 63,
      height = 49,
      line_length = 8,
      frame_count = 32,
      shift = { 3.12, 0.5},
      animation_speed = 0.5
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/beacon/beacon-radius-visualization.png",
      width = 10,
      height = 10
    },
    supply_area_distance = 1,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_usage = "750MW",
    distribution_effectivity = 7,
    module_specification =
    {
      module_slots = 1,
      module_info_icon_shift = {0, 0.5},
      module_info_multi_row_initial_height_modifier = -0.3
    
    },
   },
   
   {
    type = "beacon",
    name = "basic-beacon-mk2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/mk2-beacon-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "basic-beacon-mk2"},
    max_health = 200,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "pollution"},
    base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/basic-beacon-mk2/basic-beacon-mk2-base.png",
      width = 116,
      height = 93,
      shift = { 0.34, 0.06}
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/basic-beacon-mk2/basic-beacon-mk2-antenna.png",
      width = 54,
      height = 50,
      line_length = 8,
      frame_count = 32,
      shift = { -0.03, -1.72},
      animation_speed = 0.5
    },
    animation_shadow =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/misc/beacon-shadow.png",
      width = 63,
      height = 49,
      line_length = 8,
      frame_count = 32,
      shift = { 3.12, 0.5},
      animation_speed = 0.5
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/beacon/beacon-radius-visualization.png",
      width = 10,
      height = 10
    },
    supply_area_distance = 25,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_usage = "1MW",
    distribution_effectivity = 0.40,
    module_specification =
    {
      module_slots = 4,
      module_info_icon_shift = {0, 0.5},
      module_info_multi_row_initial_height_modifier = -0.3
    
    },
   },
   
   {
    type = "beacon",
    name = "world-array",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/world-array-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "world-array"},
    max_health = 200,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "pollution", "productivity"},
    base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/world-array/world-array-base.png",
      width = 116,
      height = 93,
      shift = { 0.34, 0.06}
    },
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/world-array/world-array-antenna.png",
      width = 54,
      height = 50,
      line_length = 8,
      frame_count = 32,
      shift = { -0.03, -1.72},
      animation_speed = 1.5
    },
    animation_shadow =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/misc/beacon-shadow.png",
      width = 63,
      height = 49,
      line_length = 8,
      frame_count = 32,
      shift = { 3.12, 0.5},
      animation_speed = 1.5
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/beacon/beacon-radius-visualization.png",
      width = 10,
      height = 10
    },
    supply_area_distance = 64,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_usage = "6000MW",
    distribution_effectivity = 5,
    module_specification =
    {
      module_slots = 12,
      module_info_icon_shift = {0, 0.5},
      module_info_multi_row_initial_height_modifier = -0.3
    
    },
   },
	
   {
    type = "roboport",
    name = "roboport-mk2",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk2-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "roboport-mk2"},
    max_health = 500,
    corpse = "big-remnants",
    collision_box = {{-1.7, -1.7}, {1.7, 1.7}},
    selection_box = {{-2, -2}, {2, 2}},
    dying_explosion = "medium-explosion",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      input_flow_limit = "4MW",
      buffer_capacity = "48MJ"
    },
    recharge_minimum = "40MJ",
    energy_usage = "400kW",
    charging_station_count = 50,
    charging_energy = "400kW",
    logistics_radius = 50,
    construction_radius = 100,
    charge_approach_distance = 5,
    robot_slots_count = 14,
    material_slots_count = 14,
    stationing_offset = {0, 0},
    charging_offsets =
    {
      {-1.5, -0.5}, {1.5, -0.5}, {1.5, 1.5}, {-1.5, 1.5},
    },
    base =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk2-base.png",
      width = 143,
      height = 135,
      shift = {0.5, 0.25}
    },
    base_patch =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-patch.png",
      priority = "medium",
      width = 69,
      height = 50,
      frame_count = 1,
      shift = {0.03125, 0.203125}
    },
    base_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-animation.png",
      priority = "medium",
      width = 42,
      height = 31,
      frame_count = 8,
      animation_speed = 0.5,
      shift = {-0.5315, -1.9375}
    },
    door_animation_up =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-up.png",
      priority = "medium",
      width = 52,
      height = 20,
      frame_count = 16,
      shift = {0.015625, -0.890625}
    },
    door_animation_down =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-down.png",
      priority = "medium",
      width = 52,
      height = 22,
      frame_count = 16,
      shift = {0.015625, -0.234375}
    },
    recharging_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      priority = "high",
      width = 37,
      height = 35,
      frame_count = 16,
      scale = 1.5,
      animation_speed = 0.9
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/roboport-working.ogg", volume = 0.6 },
      max_sounds_per_type = 3,
      audible_distance_modifier = 0.5,
      probability = 1 / (5 * 60) -- average pause between the sound is 5 seconds
    },
    recharging_light = {intensity = 0.4, size = 5},
    request_to_open_door_timeout = 15,
    spawn_and_station_height = -0.1,
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    construction_radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-construction-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    open_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 1.2 }
      },
    },
    close_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 0.75 }
      },
    },
  },
  
  {
    type = "roboport",
    name = "roboport-mk3",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk3-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "roboport-mk3"},
    max_health = 500,
    corpse = "big-remnants",
    collision_box = {{-1.7, -1.7}, {1.7, 1.7}},
    selection_box = {{-2, -2}, {2, 2}},
    dying_explosion = "medium-explosion",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      input_flow_limit = "8MW",
      buffer_capacity = "48MJ"
    },
    recharge_minimum = "80MJ",
    energy_usage = "800kW",
    charging_station_count = 100,
    charging_energy = "8000kW",
    logistics_radius = 100,
    construction_radius = 200,
    charge_approach_distance = 5,
    robot_slots_count = 28,
    material_slots_count = 28,
    stationing_offset = {0, 0},
    charging_offsets =
    {
      {-1.5, -0.5}, {1.5, -0.5}, {1.5, 1.5}, {-1.5, 1.5},
    },
    base =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk3-base.png",
      width = 143,
      height = 135,
      shift = {0.5, 0.25}
    },
    base_patch =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-patch.png",
      priority = "medium",
      width = 69,
      height = 50,
      frame_count = 1,
      shift = {0.03125, 0.203125}
    },
    base_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-animation.png",
      priority = "medium",
      width = 42,
      height = 31,
      frame_count = 8,
      animation_speed = 0.5,
      shift = {-0.5315, -1.9375}
    },
    door_animation_up =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-up.png",
      priority = "medium",
      width = 52,
      height = 20,
      frame_count = 16,
      shift = {0.015625, -0.890625}
    },
    door_animation_down =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-down.png",
      priority = "medium",
      width = 52,
      height = 22,
      frame_count = 16,
      shift = {0.015625, -0.234375}
    },
    recharging_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      priority = "high",
      width = 37,
      height = 35,
      frame_count = 16,
      scale = 1.5,
      animation_speed = 0.5
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/roboport-working.ogg", volume = 0.6 },
      max_sounds_per_type = 3,
      audible_distance_modifier = 0.5,
      probability = 1 / (5 * 60) -- average pause between the sound is 5 seconds
    },
    recharging_light = {intensity = 0.4, size = 5},
    request_to_open_door_timeout = 15,
    spawn_and_station_height = -0.1,
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    construction_radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-construction-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    open_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 1.2 }
      },
    },
    close_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 0.75 }
      },
    },
  },
  
  {
    type = "mining-drill",
    name = "pumpjack-mk2",
    icon = "__base__/graphics/icons/pumpjack.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 1, result = "pumpjack"},
    resource_categories = {"basic-fluid"},
    max_health = 200,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{ -1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{ -1.5, -1.5}, {1.5, 1.5}},
    drawing_box = {{-1.6, -2.5}, {1.5, 1.6}},
    energy_source =
    {
      type = "electric",
      -- will produce this much * energy pollution units per tick
      emissions = 0.15 / 1.5,
      usage_priority = "secondary-input"
    },
    output_fluid_box =
    {
      base_area = 1,
      base_level = 1,
      pipe_covers = pipecoverspictures(),
      pipe_connections =
      {
        {
          positions = { {1, -2}, {2, -1}, {-1, 2}, {-2, 1} }
        }
      },
    },
    energy_usage = "180kW",
    mining_speed = 2,
    mining_power = 7,
    resource_searching_radius = 0.79,
    vector_to_place_result = {0, 0},
    module_specification =
    {
      module_slots = 4
    },
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/pumpjack/pumpjack-radius-visualization.png",
      width = 12,
      height = 12
    },
    monitor_visualization_tint = {r=78, g=173, b=255},
    base_picture =
    {
      sheet =
      {
        filename = "__base__/graphics/entity/pumpjack/pumpjack-base.png",
        priority = "extra-high",
        width = 114,
        height = 113,
        shift = util.by_pixel(6, -0.5)
      }
    },
    animations =
    {
      north =
      {
        priority = "extra-high",
        width = 116,
        height = 110,
        line_length = 10,
        shift = {0.125, -0.71875},
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/pumpjack/pumpjack-animation.png",
        frame_count = 40,
        animation_speed = 0.5
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/pumpjack.ogg" },
      apparent_volume = 1.5,
    },
    fast_replaceable_group = "pumpjack",
  },
  
  {
    type = "assembling-machine",
    name = "oil-refinery-mk2",
    icon = "__base__/graphics/icons/oil-refinery.png",
	    icon_size = 32,
    flags = {"placeable-neutral","player-creation"},
    minable = {mining_time = 1, result = "oil-refinery-mk2"},
    max_health = 600,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-2.4, -2.4}, {2.4, 2.4}},
    selection_box = {{-2.5, -2.5}, {2.5, 2.5}},
    module_specification =
    {
      module_slots = 6
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    crafting_categories = {"oil-processing"},
    crafting_speed = 3,
    has_backer_name = true,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    energy_usage = "1264kW",
    ingredient_count = 4,
    animation =
    {
      north =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/oil-refinery-mk2/oil-refinery.png",
        width = 337,
        height = 255,
        frame_count = 1,
        shift = {2.515625, 0.484375}
      },
      east =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/oil-refinery-mk2/oil-refinery.png",
        x = 337,
        width = 337,
        height = 255,
        frame_count = 1,
        shift = {2.515625, 0.484375}
      },
      south =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/oil-refinery-mk2/oil-refinery.png",
        x = 674,
        width = 337,
        height = 255,
        frame_count = 1,
        shift = {2.515625, 0.484375}
      },
      west =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/oil-refinery-mk2/oil-refinery.png",
        x = 1011,
        width = 337,
        height = 255,
        frame_count = 1,
        shift = {2.515625, 0.484375}
      }
    },
    working_visualisations =
    {
      {
        north_position = {1.03125, -1.55},
        east_position = {-1.65625, -1.3},
        south_position = {-1.875, -2.0},
        west_position = {1.8437, -1.2},
        animation =
        {
          filename = "__base__/graphics/entity/oil-refinery/oil-refinery-fire.png",
          line_length = 10,
          width = 20,
          height = 40,
          frame_count = 60,
          animation_speed = 0.75,
          shift = util.by_pixel(0, -14),
          run_mode="backward"
        },
        light = {intensity = 0.4, size = 6}
      }
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/oil-refinery.ogg" },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 2.5,
    },
    fluid_boxes =
    {
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {-1, 3} }}
      },
      {
        production_type = "input",
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {1, 3} }}
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        base_level = 1,
        pipe_connections = {{ position = {-2, -3} }}
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        base_level = 1,
        pipe_connections = {{ position = {0, -3} }}
      },
      {
        production_type = "output",
        pipe_covers = pipecoverspictures(),
        base_level = 1,
        pipe_connections = {{ position = {2, -3} }}
      }
    },
    pipe_covers = pipecoverspictures()
  },

  
  {
    type = "roboport",
    name = "roboport-mk4",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk3-icon.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "roboport-mk4"},
    max_health = 500,
    corpse = "big-remnants",
    collision_box = {{-1.7, -1.7}, {1.7, 1.7}},
    selection_box = {{-2, -2}, {2, 2}},
    dying_explosion = "medium-explosion",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      input_flow_limit = "8000MW",
      buffer_capacity = "48MJ"
    },
    recharge_minimum = "80MJ",
    energy_usage = "8000kW",
    charging_station_count = 500,
    charging_energy = "80000kW",
    logistics_radius = 900,
    construction_radius = 900,
    charge_approach_distance = 5,
    robot_slots_count = 50,
    material_slots_count = 28,
    stationing_offset = {0, 0},
    charging_offsets =
    {
      {-1.5, -0.5}, {1.5, -0.5}, {1.5, 1.5}, {-1.5, 1.5},
    },
    base =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/roboports/roboport-mk3-base.png",
      width = 143,
      height = 135,
      shift = {0.5, 0.25}
    },
    base_patch =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-patch.png",
      priority = "medium",
      width = 69,
      height = 50,
      frame_count = 1,
      shift = {0.03125, 0.203125}
    },
    base_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-base-animation.png",
      priority = "medium",
      width = 42,
      height = 31,
      frame_count = 8,
      animation_speed = 0.5,
      shift = {-0.5315, -1.9375}
    },
    door_animation_up =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-up.png",
      priority = "medium",
      width = 52,
      height = 20,
      frame_count = 16,
      shift = {0.015625, -0.890625}
    },
    door_animation_down =
    {
      filename = "__base__/graphics/entity/roboport/roboport-door-down.png",
      priority = "medium",
      width = 52,
      height = 22,
      frame_count = 16,
      shift = {0.015625, -0.234375}
    },
    recharging_animation =
    {
      filename = "__base__/graphics/entity/roboport/roboport-recharging.png",
      priority = "high",
      width = 37,
      height = 35,
      frame_count = 16,
      scale = 1.5,
      animation_speed = 0.5
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__base__/sound/roboport-working.ogg", volume = 0.6 },
      max_sounds_per_type = 3,
      audible_distance_modifier = 0.5,
      probability = 1 / (5 * 60) -- average pause between the sound is 5 seconds
    },
    recharging_light = {intensity = 0.4, size = 5},
    request_to_open_door_timeout = 15,
    spawn_and_station_height = -0.1,
    radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    construction_radius_visualisation_picture =
    {
      filename = "__base__/graphics/entity/roboport/roboport-construction-radius-visualization.png",
      width = 12,
      height = 12,
      priority = "extra-high-no-scale"
    },
    open_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 1.2 }
      },
    },
    close_door_trigger_effect =
    {
      {
        type = "play-sound",
        sound = { filename = "__base__/sound/roboport-door.ogg", volume = 0.75 }
      },
    },
  },
	
  {
    type = "logistic-container",
    name = "logistic-chest-passive-provider-4d",
    icon = "__base__/graphics/icons/logistic-chest-passive-provider.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-chest-passive-provider-4d"},
    max_health = 150,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fast_replaceable_group = "container",
    inventory_size = 50000,
    logistic_mode = "passive-provider",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__base__/graphics/entity/logistic-chest/logistic-chest-passive-provider.png",
      priority = "extra-high",
      width = 38,
      height = 32,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-chest-active-provider-4d",
    icon = "__base__/graphics/icons/logistic-chest-active-provider.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-chest-active-provider-4d"},
    max_health = 150,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fast_replaceable_group = "container",
    inventory_size = 50000,
    logistic_mode = "active-provider",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__base__/graphics/entity/logistic-chest/logistic-chest-active-provider.png",
      priority = "extra-high",
      width = 38,
      height = 32,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-chest-storage-4d",
    icon = "__base__/graphics/icons/logistic-chest-storage.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-chest-storage-4d"},
    max_health = 150,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fast_replaceable_group = "container",
    inventory_size = 50000,
    logistic_mode = "storage",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__base__/graphics/entity/logistic-chest/logistic-chest-storage.png",
      priority = "extra-high",
      width = 38,
      height = 32,
      shift = {0.1, 0}
    },

  },
  {
    type = "explosion",
    name = "nuke-explosion",
    flags = {"not-on-map"},
    animations =
    {
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/big-explosion.png",
        priority = "extra-high",
        width = 197,
        height = 245,
        frame_count = 47,
        line_length = 6,
        axially_symmetrical = false,
        direction_count = 1,
        shift = {0.1875, -0.75},
        animation_speed = 0.25,
        scale = 40
      }
    },
    light = {intensity = 1, size = 50},
    sound =
    {
      {
        filename = "__base__/sound/fight/large-explosion-1.ogg",
        volume = 1.0
      },
      {
        filename = "__base__/sound/fight/large-explosion-2.ogg",
        volume = 1.0
      }
    },
    created_effect =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "create-particle",
            repeat_count = 20,
            entity_name = "explosion-remnants-particle",
            initial_height = 0.5,
            speed_from_center = 0.08,
            speed_from_center_deviation = 0.15,
            initial_vertical_speed = 0.08,
            initial_vertical_speed_deviation = 0.15,
            offset_deviation = {{-0.2, -0.2}, {0.2, 0.2}}
          }
        }
      }
    }
  },
  {
    type = "explosion",
    name = "megumin-explosion",
    flags = {"not-on-map"},
    animations =
    {
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/big-explosion.png",
        priority = "extra-high",
        width = 197,
        height = 245,
        frame_count = 47,
        line_length = 6,
        axially_symmetrical = false,
        direction_count = 1,
        shift = {0.1875, -0.75},
        animation_speed = 0.25,
        scale = 1000
      }
    },
    light = {intensity = 1, size = 50},
    sound =
    {
      {
        filename = "__base__/sound/fight/large-explosion-1.ogg",
        volume = 1.0
      },
      {
        filename = "__base__/sound/fight/large-explosion-2.ogg",
        volume = 1.0
      }
    },
    created_effect =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "create-particle",
            repeat_count = 20,
            entity_name = "explosion-remnants-particle",
            initial_height = 0.5,
            speed_from_center = 0.08,
            speed_from_center_deviation = 0.15,
            initial_vertical_speed = 0.08,
            initial_vertical_speed_deviation = 0.15,
            offset_deviation = {{-0.2, -0.2}, {0.2, 0.2}}
          }
        }
      }
    }
  },
 {
    type = "storage-tank",
    name = "storage-tank-mk2",
    icon = "__base__/graphics/icons/storage-tank.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {mining_time = 1.5, result = "storage-tank-mk2"},
    max_health = 500,
    corpse = "medium-remnants",
    collision_box = {{-1.3, -1.3}, {1.3, 1.3}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    fluid_box =
    {
      base_area = 1250,
      pipe_covers = pipecoverspictures(),
      pipe_connections =
      {
        { position = {-1, -2} },
        { position = {2, 1} },
        { position = {1, 2} },
        { position = {-2, -1} },
      },
    },
    two_direction_only = true,
    window_bounding_box = {{-0.125, 0.6875}, {0.1875, 1.1875}},
    pictures =
    {
      picture =
      {
        sheets =
        {
          {
            filename = "__base__/graphics/entity/storage-tank/storage-tank.png",
            priority = "extra-high",
            frames = 2,
            width = 110,
            height = 108,
            shift = util.by_pixel(0, 4),
            hr_version = {
              filename = "__base__/graphics/entity/storage-tank/hr-storage-tank.png",
              priority = "extra-high",
              frames = 2,
              width = 219,
              height = 215,
              shift = util.by_pixel(-0.25, 3.75),
              scale = 0.5
            }
          },
          {
            filename = "__base__/graphics/entity/storage-tank/storage-tank-shadow.png",
            priority = "extra-high",
            frames = 2,
            width = 146,
            height = 77,
            shift = util.by_pixel(30, 22.5),
            draw_as_shadow = true,
            hr_version = {
              filename = "__base__/graphics/entity/storage-tank/hr-storage-tank-shadow.png",
              priority = "extra-high",
              frames = 2,
              width = 291,
              height = 153,
              shift = util.by_pixel(29.75, 22.25),
              scale = 0.5,
              draw_as_shadow = true
            }
          }
        }
      },
      fluid_background =
      {
        filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
        priority = "extra-high",
        width = 32,
        height = 15
      },
      window_background =
      {
        filename = "__base__/graphics/entity/storage-tank/window-background.png",
        priority = "extra-high",
        width = 17,
        height = 24,
        hr_version = {
          filename = "__base__/graphics/entity/storage-tank/hr-window-background.png",
          priority = "extra-high",
          width = 34,
          height = 48,
          scale = 0.5
        }
      },
      flow_sprite =
      {
        filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
        priority = "extra-high",
        width = 160,
        height = 20
      },
      gas_flow =
      {
        filename = "__base__/graphics/entity/pipe/steam.png",
        priority = "extra-high",
        line_length = 10,
        width = 24,
        height = 15,
        frame_count = 60,
        axially_symmetrical = false,
        direction_count = 1,
        animation_speed = 0.25,
        hr_version =
        {
          filename = "__base__/graphics/entity/pipe/hr-steam.png",
          priority = "extra-high",
          line_length = 10,
          width = 48,
          height = 30,
          frame_count = 60,
          axially_symmetrical = false,
          animation_speed = 0.25,
          direction_count = 1
        }
      }
    },
    flow_length_in_ticks = 360,
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = {
          filename = "__base__/sound/storage-tank.ogg",
          volume = 0.8
      },
      apparent_volume = 1.5,
      max_sounds_per_type = 3
    },

    circuit_wire_connection_points = circuit_connector_definitions["storage-tank"].points,
    circuit_connector_sprites = circuit_connector_definitions["storage-tank"].sprites,
    circuit_wire_max_distance = default_circuit_wire_max_distance
  },
  {
    type = "assembling-machine",
    name = "assembling-machine-4",
    icon = "__base__/graphics/icons/assembling-machine-3.png",
	    icon_size = 32,
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "assembling-machine-4"},
    max_health = 300,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    resistances =
    {
      {
        type = "fire",
        percent = 70
      }
    },
    open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
    close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/assembling-machine-t3-1.ogg",
          volume = 0.8
        },
        {
          filename = "__base__/sound/assembling-machine-t3-2.ogg",
          volume = 0.8
        },
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    collision_box = {{-2.5, -2}, {1.5, 2}},
    selection_box = {{-2.5, -2}, {1.5, 2}},
    fast_replaceable_group = "assembling-machine",
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/assembuling-machine-4/assembling-machine-4.png",
      priority = "high",
      width = 213,
      height = 169,
      frame_count = 32,
      line_length = 8,
      shift = {0.84, -0.09}
    },
    crafting_categories = {"crafting", "advanced-crafting",},
    crafting_speed = 2.25,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    energy_usage = "510kW",
    ingredient_count = 12,
    module_specification =
    {
      module_slots = 8
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"}
  },
  {
    type = "underground-belt",
    name = "underground-belt-2",
    icon = "__base__/graphics/icons/underground-belt.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "underground-belt-2"},
    max_health = 150,
    corpse = "small-remnants",
    max_distance = 50,
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
	underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    animation_speed_coefficient = 32,
    belt_horizontal = basic_belt_horizontal,
    belt_vertical = basic_belt_vertical,
    ending_top = basic_belt_ending_top,
    ending_bottom = basic_belt_ending_bottom,
    ending_side = basic_belt_ending_side,
    starting_top = basic_belt_starting_top,
    starting_bottom = basic_belt_starting_bottom,
    starting_side = basic_belt_starting_side,
    fast_replaceable_group = "underground-belt",
    speed = 0.03125,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/underground-belt/underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/underground-belt/hr-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/underground-belt/underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.25, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/underground-belt/hr-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }

        }

      }
    },
    ending_patch = ending_patch_prototype
  },
  {
    type = "underground-belt",
    name = "fast-underground-belt-2",
    icon = "__base__/graphics/icons/fast-underground-belt.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "fast-underground-belt-2"},
    max_health = 160,
    corpse = "small-remnants",
    max_distance = 50,
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
	underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    animation_speed_coefficient = 32,
    belt_horizontal = fast_belt_horizontal, -- specified in transport-belt-pictures.lua
    belt_vertical = fast_belt_vertical,
    ending_top = fast_belt_ending_top,
    ending_bottom = fast_belt_ending_bottom,
    ending_side = fast_belt_ending_side,
    starting_top = fast_belt_starting_top,
    starting_bottom = fast_belt_starting_bottom,
    starting_side = fast_belt_starting_side,
    fast_replaceable_group = "underground-belt",
    speed = 0.0625,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/fast-underground-belt/fast-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/fast-underground-belt/hr-fast-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/fast-underground-belt/fast-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/fast-underground-belt/hr-fast-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      }
    },
    ending_patch = ending_patch_prototype
  },
  {
    type = "underground-belt",
    name = "express-underground-belt-2",
    icon = "__base__/graphics/icons/express-underground-belt.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "express-underground-belt-2"},
    max_health = 170,
    corpse = "small-remnants",
    max_distance = 50,
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
	underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances =
    {
      {
        type = "fire",
        percent = 60
      },
      {
        type = "impact",
        percent = 30
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    animation_speed_coefficient = 32,
    belt_horizontal = express_belt_horizontal, -- specified in transport-belt-pictures.lua
    belt_vertical = express_belt_vertical,
    ending_top = express_belt_ending_top,
    ending_bottom = express_belt_ending_bottom,
    ending_side = express_belt_ending_side,
    starting_top = express_belt_starting_top,
    starting_bottom = express_belt_starting_bottom,
    starting_side = express_belt_starting_side,
    fast_replaceable_group = "underground-belt",
    speed = 0.09375,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/express-underground-belt/express-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/express-underground-belt/hr-express-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__base__/graphics/entity/express-underground-belt/express-underground-belt-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__base__/graphics/entity/express-underground-belt/hr-express-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      }
    },
    ending_patch = ending_patch_prototype
  },
  {
    type = "inserter",
    name = "rapid-inserter",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/rapid-inserter.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
	module_specification =
    {
      module_slots = 8
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    minable =
    {
      hardness = 0.2,
      mining_time = 0.5,
      result = "rapid-inserter"
    },
    max_health = 120,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.15, -0.15}, {0.15, 0.15}},
    selection_box = {{-0.4, -0.35}, {0.4, 0.45}},
    pickup_position = {0, -1},
    insert_position = {0, 1.2},
    energy_per_movement = 5000,
    energy_per_rotation = 5000,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      drain = "50.4kW"
    },
    extension_speed = 1.70,
    rotation_speed = 1.70,
    fast_replaceable_group = "inserter",
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      match_progress_to_activity = true,
      sound =
      {
        {
          filename = "__base__/sound/inserter-fast-1.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-2.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-3.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-4.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-5.ogg",
          volume = 0.75
        }
      }
    },
    hand_base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/rapid-inserter/rapid-inserter-hand-base.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/rapid-inserter/rapid-inserter-hand-closed.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/rapid-inserter/rapid-inserter-hand-open.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_base_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-base-shadow.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-closed-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-open-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    platform_picture =
    {
      sheet =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-inserter/terra-inserter-platform.png",
        priority = "extra-high",
        width = 46,
        height = 46
      }
    }
  },
  {
    type = "inserter",
    name = "terra-inserter",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/terra-inserter.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    stack = true,
	module_specification =
    {
      module_slots = 8
    },
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    minable =
    {
      hardness = 0.2,
      mining_time = 0.5,
      result = "terra-inserter"
    },
    max_health = 120,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.15, -0.15}, {0.15, 0.15}},
    selection_box = {{-0.4, -0.35}, {0.4, 0.45}},
    pickup_position = {0, -1},
    insert_position = {0, 1.2},
    energy_per_movement = 5000,
    energy_per_rotation = 5000,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      drain = "50.4kW"
    },
    extension_speed = 1.70,
    rotation_speed = 1.70,
    fast_replaceable_group = "inserter",
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      match_progress_to_activity = true,
      sound =
      {
        {
          filename = "__base__/sound/inserter-fast-1.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-2.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-3.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-4.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-5.ogg",
          volume = 0.75
        }
      }
    },
    hand_base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-inserter/terra-inserter-hand-base.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-inserter/terra-inserter-hand-closed.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-inserter/terra-inserter-hand-open.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_base_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-base-shadow.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-closed-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-open-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    platform_picture =
    {
      sheet =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/terra-inserter/terra-inserter-platform.png",
        priority = "extra-high",
        width = 46,
        height = 46
      }
    }
  },
  {
    type = "inserter",
    name = "smart-terra-inserter",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/icons/smart-terra-inserter.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    stack = true,
    minable =
    {
      hardness = 0.2,
      mining_time = 0.5,
      result = "smart-terra-inserter"
    },
    max_health = 120,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 90
      }
    },
    collision_box = {{-0.15, -0.15}, {0.15, 0.15}},
    selection_box = {{-0.4, -0.35}, {0.4, 0.45}},
    pickup_position = {0, -1},
    insert_position = {0, 1.2},
    energy_per_movement = 5000,
    energy_per_rotation = 5000,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      drain = "50.4kW"
    },
    extension_speed = 1.70,
    rotation_speed = 1.70,
	filter_count = 5,
    fast_replaceable_group = "inserter",
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      match_progress_to_activity = true,
      sound =
      {
        {
          filename = "__base__/sound/inserter-fast-1.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-2.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-3.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-4.ogg",
          volume = 0.75
        },
        {
          filename = "__base__/sound/inserter-fast-5.ogg",
          volume = 0.75
        }
      }
    },
    hand_base_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/smart-terra-inserter/smart-terra-inserter-hand-base.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/smart-terra-inserter/smart-terra-inserter-hand-closed.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/smart-terra-inserter/smart-terra-inserter-hand-open.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_base_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-base-shadow.png",
      priority = "extra-high",
      width = 8,
      height = 34
    },
    hand_closed_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-closed-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    hand_open_shadow =
    {
      filename = "__base__/graphics/entity/burner-inserter/burner-inserter-hand-open-shadow.png",
      priority = "extra-high",
      width = 18,
      height = 41
    },
    platform_picture =
    {
      sheet =
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/smart-terra-inserter/smart-terra-inserter-platform.png",
        priority = "extra-high",
        width = 46,
        height = 46
      }
    }
  },
  {
    type = "explosion",
    name = "railgun-explosion",
    flags = {"not-on-map"},
    animations =
    {
      {
        filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/railgun-explosion.png",
        priority = "extra-high",
        width = 197,
        height = 245,
        frame_count = 47,
        line_length = 6,
        axially_symmetrical = false,
        direction_count = 1,
        shift = {0.1875, -0.75},
        animation_speed = 0.25,
                       
      }
    },
    light = {intensity = 1, size = 50},
    sound =
    {
      {
        filename = "__base__/sound/fight/large-explosion-1.ogg",
        volume = 1.0
      },
      {
        filename = "__base__/sound/fight/large-explosion-2.ogg",
        volume = 1.0
      }
    },
    created_effect =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          {
            type = "create-particle",
            repeat_count = 20,
            entity_name = "explosion-remnants-particle",
            initial_height = 0.5,
            speed_from_center = 0.08,
            speed_from_center_deviation = 0.15,
            initial_vertical_speed = 0.08,
            initial_vertical_speed_deviation = 0.15,
            offset_deviation = {{-0.2, -0.2}, {0.2, 0.2}}
          }
        }
      }
    }
  },
  {
    type = "smoke-with-trigger",
    name = "poison-cloud2",
    flags = {"not-on-map"},
    show_when_smoke_off = true,
    animation =
    {
      filename = "__base__/graphics/entity/cloud/cloud-45-frames.png",
      priority = "low",
      width = 256,
      height = 256,
      frame_count = 45,
      animation_speed = 0.7,
      line_length = 7,
      scale = 3,
    },
    slow_down_factor = 0.8,
    affected_by_wind = false,
    cyclic = true,
    duration = 20 * 20,
    fade_away_duration = 5 * 5,
    spread_duration = 10,
    color = { r = 0.2, g = 1, b = 1 },
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "nested-result",
          action =
          {
            type = "area",
            radius = 22,
            entity_flags = {"breaths-air"},
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                type = "damage",
                damage = { amount = 16, type = "poison"}
              }
            }
          }
        }
      }
    },
    action_frequency = 30
  },
  {
    type = "smoke-with-trigger",
    name = "black-hole",
    flags = {"not-on-map"},
    show_when_smoke_off = true,
    animation =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/black-hole.png",
      priority = "low",
      width = 1920,
      height = 1920,
      frame_count = 1,
      animation_speed = 1,
      line_length = 1,
      scale = 3,
    },
    slow_down_factor = 1,
    affected_by_wind = false,
    cyclic = true,
    duration = 155 * 20,
    fade_away_duration = 4 * 60,
    spread_duration = 10,
    color = { r = 1, g = 1, b = 1 },
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "nested-result",
          action =
          {
            type = "area",
            radius = 88,
            entity_flags = {"breaths-air"},
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                type = "damage",
                damage = { amount = 160000, type = "poison"}
              }
            }
          }
        }
      }
    },
    action_frequency = 30
  },
  {
    type = "smoke-with-trigger",
    name = "poison-cloud3",
    flags = {"not-on-map"},
    show_when_smoke_off = true,
    animation =
    {
      filename = "__base__/graphics/entity/cloud/cloud-45-frames.png",
      priority = "low",
      width = 256,
      height = 256,
      frame_count = 45,
      animation_speed = 0.4,
      line_length = 7,
      scale = 9,
    },
    slow_down_factor = 1,
    affected_by_wind = false,
    cyclic = true,
    duration = 1 * 20,
    fade_away_duration = 0 * 0,
    spread_duration = 10,
    color = { r = 0, g = 1, b = 1 },
    action =
    {
      type = "direct",
      action_delivery =
      {
        type = "instant",
        target_effects =
        {
          type = "nested-result",
          action =
          {
            type = "area",
            radius = 26,
            entity_flags = {"breaths-air"},
            action_delivery =
            {
              type = "instant",
              target_effects =
              {
                type = "damage",
                damage = { amount = 46, type = "poison"}
              }
            }
          }
        }
      }
    },
    action_frequency = 30
  },
  {
    type = "logistic-container",
    name = "logistic-chest-requester-4d",
    icon = "__base__/graphics/icons/logistic-chest-requester.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-chest-requester-4d"},
    max_health = 150,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fast_replaceable_group = "container",
    inventory_size = 50000,
    logistic_mode = "requester",
	logistic_slots_count = 32,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    picture =
    {
      filename = "__base__/graphics/entity/logistic-chest/logistic-chest-requester.png",
      priority = "extra-high",
      width = 38,
      height = 32,
      shift = {0.1, 0}
    },
  },
  {
    type = "logistic-container",
    name = "logistic-chest-buffer-4d",
    icon = "__base__/graphics/icons/logistic-chest-buffer.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-chest-buffer-4d"},
    max_health = 150,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fast_replaceable_group = "container",
    inventory_size = 50000,
    logistic_mode = "buffer",
	logistic_slots_count = 32,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    picture =
    {
      filename = "__base__/graphics/entity/logistic-chest/logistic-chest-buffer.png",
      priority = "extra-high",
      width = 38,
      height = 32,
      shift = {0.1, 0}
    },
  },
  
  ----Lights
  {
    type = "lamp",
    name = "red-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/red-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "red-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=1, g=0, b=0}},
    light_when_colored = {intensity = 1, size = 30, color = {r=1, g=0, b=0}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/red-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
  },
  {
    type = "lamp",
    name = "blue-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/blue-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "blue-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=0, g=0, b=1}},
    light_when_colored = {intensity = 1, size = 30, color = {r=1, g=0, b=0}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/blue-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },

  },
  {
    type = "lamp",
    name = "yellow-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/yellow-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "yellow-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=1, g=1, b=0}},
    light_when_colored = {intensity = 1, size = 30, color = {r=1, g=1, b=0}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/yellow-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
  },
  {
    type = "lamp",
    name = "green-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/green-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "green-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=0, g=1, b=0}},
    light_when_colored = {intensity = 1, size = 30, color = {r=1, g=0, b=0}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/green-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
	  },
  {
    type = "lamp",
    name = "purple-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/purple-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "purple-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=0.6, g=0, b=1}},
    light_when_colored = {intensity = 1, size = 30, color = {r=0.6, g=0, b=1}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/purple-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
  },
  {
    type = "lamp",
    name = "cyan-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/purple-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "cyan-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=0, g=1, b=1}},
    light_when_colored = {intensity = 1, size = 30, color = {r=0, g=1, b=1}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/cyan-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
  },
  {
    type = "lamp",
    name = "white-lamp",
    icon = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/purple-on.png",
	    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "white-lamp"},
    max_health = 100,
    corpse = "small-remnants",
    collision_box = {{-0, -0}, {0, 0}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input"
    },
    energy_usage_per_tick = "3KW",
    light = {intensity = 1, size = 10, color = {r=1, g=1, b=1}},
    light_when_colored = {intensity = 1, size = 30, color = {r=1, g=1, b=1}},
    glow_size = 6,
    glow_color_intensity = 0.135,
    picture_off =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/light-off.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    picture_on =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/lights/white-on.png",
      priority = "high",
      width = 32,
      height = 32,
      frame_count = 1,
      axially_symmetrical = false,
      direction_count = 1,
      shift = {-0, -0},
    },
    signal_to_color_mapping =
    {
      {type="virtual", name="signal-red", color={r=1,g=0,b=0}},
      {type="virtual", name="signal-green", color={r=0,g=1,b=0}},
      {type="virtual", name="signal-blue", color={r=0,g=0,b=1}},
      {type="virtual", name="signal-yellow", color={r=1,g=1,b=0}},
      {type="virtual", name="signal-pink", color={r=1,g=0,b=1}},
      {type="virtual", name="signal-cyan", color={r=0,g=1,b=1}},
    },
  },
  --------------Storage
  {
    type = "logistic-container",
    name = "logistic-house-passive-provider",
    icon = "__base__/graphics/icons/logistic-chest-passive-provider.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-house-passive-provider"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    logistic_mode = "passive-provider",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse-passive-provider.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-house-buffer",
    icon = "__base__/graphics/icons/logistic-chest-passive-provider.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-house-buffer"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    logistic_mode = "buffer",
    logistic_slots_count = 32,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse-buffer.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-house-active-provider",
    icon = "__base__/graphics/icons/logistic-chest-active-provider.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-house-active-provider"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    logistic_mode = "active-provider",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse-active-provider.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-house-storage",
    icon = "__base__/graphics/icons/logistic-chest-storage.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-house-storage"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    logistic_mode = "storage",
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse-storage.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  {
    type = "logistic-container",
    name = "logistic-house-requester",
    icon = "__base__/graphics/icons/logistic-chest-requester.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "logistic-house-requester"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    logistic_mode = "requester",
	logistic_slots_count = 32,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse-requester.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  {
    type = "container",
    name = "storage-house",
    icon = "__base__/graphics/icons/logistic-chest-requester.png",
	    icon_size = 32,
    flags = {"placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "storage-house"},
    max_health = 150,
    corpse = "small-remnants",
	collision_box = {{-8.5, -5.0}, {3.0, 7.0}},
	selection_box = {{-8.5, -5.0}, {3.0, 7.0}},
    fast_replaceable_group = "container",
    inventory_size = 2000,
    open_sound = { filename = "__base__/sound/metallic-chest-open.ogg", volume=0.65 },
    close_sound = { filename = "__base__/sound/metallic-chest-close.ogg", volume = 0.7 },
    picture =
    {
      filename = "__Darkstar_utilities_Low_Spec__/graphics/entity/storage/warehouse.png",
      priority = "extra-high",
      width = 550,
      height = 550,
      shift = {0.1, 0}
    },

  },
  --------------alien edits
  {
    type = "unit",
    name = "small-biter",
    icon = "__base__/graphics/icons/small-biter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air"},
    max_health = 15,
    order = "b-b-a",
    subgroup="enemies",
    healing_per_tick = 0.01,
    collision_box = {{-0.2, -0.2}, {0.2, 0.2}},
    selection_box = {{-0.4, -0.7}, {0.7, 0.4}},
    attack_parameters =
    {
      type = "projectile",
      range = 0.5,
      cooldown = 35,
      ammo_category = "melee",
      ammo_type = make_unit_melee_ammo_type(6),
      sound = make_biter_roars(0.5),
      animation = biterattackanimation(smallbiterscale, small_biter_tint1, small_biter_tint2)
    },
    vision_distance = 30,
    movement_speed = 0.2,
    distance_per_frame = 0.1,
    pollution_to_join_attack = 200,
    distraction_cooldown = 300,
    corpse = "small-biter-corpse",
    dying_explosion = "blood-explosion-small",
		loot =
    {
      {
        count_max = 3,
        count_min = 1,
        item = "chitin",
        probability = 1
      }
    },
    dying_sound =  make_biter_dying_sounds(1.0),
    working_sound =  make_biter_calls(0.7),
    run_animation = biterrunanimation(smallbiterscale, small_biter_tint1, small_biter_tint2)
  },
  
  {
    type = "unit",
    name = "medium-biter",
    icon = "__base__/graphics/icons/medium-biter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 75,
    order="b-b-b",
    subgroup="enemies",
    resistances =
    {
      {
        type = "physical",
        decrease = 4,
        percent = 10
      },
      {
        type = "explosion",
        percent = 10
      },
    },
    healing_per_tick = 0.01,
    collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
    selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
    sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters =
    {
      type = "projectile",
      ammo_category = "melee",
      ammo_type = make_unit_melee_ammo_type(15),
      range = 1,
      cooldown = 35,
      sound = make_biter_roars(0.5),
      animation = biterattackanimation(mediumbiterscale, medium_biter_tint1, medium_biter_tint2)
    },
    vision_distance = 30,
    movement_speed = 0.185,
    distance_per_frame = 0.15,
    -- in pu
    pollution_to_join_attack = 1000,
    corpse = "medium-biter-corpse",
    dying_explosion = "blood-explosion-small",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.4),
    dying_sound = make_biter_dying_sounds(0.5),
    run_animation = biterrunanimation(mediumbiterscale, medium_biter_tint1, medium_biter_tint2)
  },

  {
    type = "unit",
    name = "big-biter",
    order="b-b-c",
    icon = "__base__/graphics/icons/big-biter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 375,
    subgroup="enemies",
    resistances =
    {
      {
        type = "physical",
        decrease = 8,
        percent = 10,
      },
      {
        type = "explosion",
        percent = 10
      }
    },
    spawning_time_modifier = 3,
    healing_per_tick = 0.02,
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
    sticker_box = {{-0.6, -0.8}, {0.6, 0}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters =
    {
      type = "projectile",
      range = 1.5,
      cooldown = 35,
      ammo_category = "melee",
      ammo_type = make_unit_melee_ammo_type(30),
      sound =  make_biter_roars(0.6),
      animation = biterattackanimation(bigbiterscale, big_biter_tint1, big_biter_tint2)
    },
    vision_distance = 30,
    movement_speed = 0.17,
    distance_per_frame = 0.2,
    -- in pu
    pollution_to_join_attack = 4000,
    corpse = "big-biter-corpse",
    dying_explosion = "blood-explosion-big",
		loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.5),
    dying_sound = make_biter_dying_sounds(0.6),
    run_animation = biterrunanimation(bigbiterscale, big_biter_tint1, big_biter_tint2)
  },

  {
    type = "unit",
    name = "behemoth-biter",
    order="b-b-d",
    icon = "__base__/graphics/icons/behemoth-biter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 3000,
    subgroup="enemies",
    resistances =
    {
      {
        type = "physical",
        decrease = 12,
        percent = 10
      },
      {
        type = "explosion",
        decrease = 12,
        percent = 10
      }
    },
    spawning_time_modifier = 12,
    healing_per_tick = 0.1,
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
    sticker_box = {{-0.6, -0.8}, {0.6, 0}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters =
    {
      type = "projectile",
      range = 1.5,
      cooldown = 50,
      ammo_category = "melee",
      ammo_type = make_unit_melee_ammo_type(90),
      sound =  make_biter_roars(0.8),
      animation = biterattackanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
    },
    vision_distance = 30,
    movement_speed = 0.17,
    distance_per_frame = 0.2,
    -- in pu
    pollution_to_join_attack = 20000,
    corpse = "behemoth-biter-corpse",
    dying_explosion = "blood-explosion-big",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.7),
    dying_sound = make_biter_dying_sounds(0.8),
    run_animation = biterrunanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
  },

  {
    type = "unit",
    name = "small-spitter",
    icon = "__base__/graphics/icons/small-spitter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 10,
    order="b-b-d",
    subgroup="enemies",
    healing_per_tick = 0.01,
    collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
    selection_box = {{-0.4, -0.4}, {0.4, 0.4}},
    sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters = spitter_attack_parameters(
    {
      range=13,
      min_attack_distance=10,
      cooldown=100,
      damage_modifier=1,
      scale=smallspitterscale,
      tint=smallspittertint,
      roarvolume=0.4
    }),
    vision_distance = 30,
    movement_speed = 0.185,
    distance_per_frame = 0.04,
    -- in pu
    pollution_to_join_attack = 200,
    corpse = "small-spitter-corpse",
    dying_explosion = "blood-explosion-small",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.3),
    dying_sound = make_spitter_dying_sounds(0.4),
    run_animation = spitterrunanimation(smallspitterscale, smallspittertint)
  },

  {
    type = "unit",
    name = "medium-spitter",
    icon = "__base__/graphics/icons/medium-spitter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 50,
    order="b-b-e",
    subgroup="enemies",
    resistances =
    {
      {
        type = "explosion",
        percent = 10
      }
    },
    healing_per_tick = 0.01,
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.7}, {0.5, 0.7}},
    sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters = spitter_attack_parameters(
    {
      range=14,
      min_attack_distance=10,
      cooldown=100,
      damage_modifier=2,
      scale=mediumspitterscale,
      tint=mediumspittertint,
      roarvolume=0.5
    }),
    vision_distance = 30,
    movement_speed = 0.165,
    distance_per_frame = 0.055,
    -- in pu
    pollution_to_join_attack = 600,
    corpse = "medium-spitter-corpse",
    dying_explosion = "blood-explosion-small",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.4),
    dying_sound = make_spitter_dying_sounds(0.5),
    run_animation = spitterrunanimation(mediumspitterscale, mediumspittertint)
  },

  {
    type = "unit",
    name = "big-spitter",
    icon = "__base__/graphics/icons/big-spitter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 200,
    order="b-b-f",
    subgroup="enemies",
    resistances =
    {
      {
        type = "explosion",
        percent = 15
      }
    },
    spawning_time_modifier = 3,
    healing_per_tick = 0.01,
    collision_box = {{-0.5, -0.5}, {0.5, 0.5}},
    selection_box = {{-0.7, -1.0}, {0.7, 1.0}},
    sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters = spitter_attack_parameters(
    {
      range=15,
      min_attack_distance=10,
      cooldown=100,
      damage_modifier=3,
      scale=bigspitterscale,
      tint=bigspittertint,
      roarvolume=0.6
    }),
    vision_distance = 30,
    movement_speed = 0.15,
    distance_per_frame = 0.07,
    -- in pu
    pollution_to_join_attack = 1500,
    corpse = "big-spitter-corpse",
    dying_explosion = "blood-explosion-big",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.5),
    dying_sound = make_spitter_dying_sounds(0.6),
    run_animation = spitterrunanimation(bigspitterscale, bigspittertint)
  },

  {
    type = "unit",
    name = "behemoth-spitter",
    icon = "__base__/graphics/icons/behemoth-spitter.png",
	icon_size = 32,
    flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air", "not-repairable"},
    max_health = 1500,
    order="b-b-f",
    subgroup="enemies",
    resistances =
    {
      {
        type = "explosion",
        percent = 30
      }
    },
    spawning_time_modifier = 12,
    healing_per_tick = 0.1,
    collision_box = {{-0.5, -0.5}, {0.5, 0.5}},
    selection_box = {{-0.7, -1.0}, {0.7, 1.0}},
    sticker_box = {{-0.3, -0.5}, {0.3, 0.1}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 50,
    attack_parameters = spitter_attack_parameters(
    {
      range=16,
      min_attack_distance=10,
      cooldown=100,
      damage_modifier=5,
      scale=behemothspitterscale,
      tint=behemothspittertint,
      roarvolume=0.8
    }),
    vision_distance = 30,
    movement_speed = 0.15,
    distance_per_frame = 0.084,
    pollution_to_join_attack = 10000,
    corpse = "behemoth-spitter-corpse",
    dying_explosion = "blood-explosion-big",
    working_sound = make_biter_calls(0.7),
    dying_sound = make_spitter_dying_sounds(0.8),
    run_animation = spitterrunanimation(behemothspitterscale, behemothspittertint)
  },
  
  {
    type = "unit",
    name = "behemoth-biter-2",
    order="b-b-d",
    icon = "__base__/graphics/icons/behemoth-biter.png",
	icon_size = 32,
    flags = {"placeable-player", "player-creation", "placeable-off-grid", "not-on-map", "not-repairable"},
    max_health = 3000,
    subgroup="enemies",
    resistances =
    {
      {
        type = "physical",
        decrease = 12,
        percent = 10
      },
      {
        type = "explosion",
        decrease = 12,
        percent = 10
      }
    },
    spawning_time_modifier = 12,
    healing_per_tick = 0.1,
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.7, -1.5}, {0.7, 0.3}},
    sticker_box = {{-0.6, -0.8}, {0.6, 0}},
    distraction_cooldown = 300,
    min_pursue_time = 10 * 60,
    max_pursue_distance = 500,
    attack_parameters =
    {
      type = "projectile",
      range = 3.5,
      cooldown = 50,
      ammo_category = "melee",
      ammo_type = make_unit_melee_ammo_type(90),
      sound =  make_biter_roars(0.8),
      animation = biterattackanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
    },
    vision_distance = 90,
    movement_speed = 0.22,
    distance_per_frame = 0.2,
    -- in pu
    pollution_to_join_attack = 20000,
    corpse = "behemoth-biter-corpse",
    dying_explosion = "blood-explosion-big",
	loot =
    {
      {
        count_max = 6,
        count_min = 3,
        item = "chitin",
        probability = 1
      }
    },
    working_sound = make_biter_calls(0.7),
    dying_sound = make_biter_dying_sounds(0.8),
    run_animation = biterrunanimation(behemothbiterscale, behemoth_biter_tint1, behemoth_biter_tint2)
  },
  
  }
  )