require("util")
require("config")

script.on_event({defines.events.on_tick},
   function (e)
      if e.tick % 5 == 0 then --common trick to reduce how often this runs, we don't want it running every tick, just 1/second
         for index,player in pairs(game.connected_players) do  --loop through all online players on the server
            
            --if they're wearing our armor
            if player.character and player.get_inventory(defines.inventory.player_armor).get_item_count("power-armor-mk4") >= 1 then
               --create the fire where they're standing
               player.surface.create_entity{name="fire-flame", position=player.position, force="neutral"} 
            end
         end
      end
   end
)

script.on_event(defines.events.on_player_placed_equipment, function(event)

	local player = game.players[event.player_index]   
    local craftingSpeed = player.character_crafting_speed_modifier
	local miningSpeed = player.character_mining_speed_modifier
	

    if event.equipment.name == "crafting-module" then


		player.character_crafting_speed_modifier = craftingSpeed + 0.5
		player.character_mining_speed_modifier = miningSpeed + 1
				
    end
end
)




script.on_event(defines.events.on_player_removed_equipment, function(event)

    local player = game.players[event.player_index]
    local crafting_speed_bonus = player.character_crafting_speed_modifier
	local mining_speed_modifier = player.character_mining_speed_modifier


  	if event.equipment == "crafting-module" then

  		if event.count >= 0 then

	  		local craftingCount = crafting_speed_bonus - (0.5 * event.count)
			local msCount = mining_speed_modifier - (1 * event.count)
			
	  		if craftingCount >= 0 then

				crafting_speed_bonus = craftingCount


				player.character_crafting_speed_modifier = crafting_speed_bonus
			end
			
			if msCount >= 0 then
			mining_speed_modifier = msCount
			player.character_mining_speed_modifier = mining_speed_modifier
			
		end


		end
    end
    end
	)
	
	script.on_event(defines.events.on_player_armor_inventory_changed, function(event)
 
  	local player = game.players[event.player_index]
	local armor = player.get_inventory(defines.inventory.player_armor)
	

	if not armor.is_empty() then
		
		local total_crafting = 0
		local total_ms = 0
				
		local grid = armor[1].grid


		if grid ~= nil then


			for i = 1, #grid.equipment do
			

				if grid.equipment[i].name == "crafting-module" then
					total_crafting = total_crafting + 0.5
					total_ms = total_ms + 1
				end

			end

			set_inventory1(player, total_crafting)	
            set_inventory3(player, total_ms)			
			
		else
			clear_all_bonuses(player)			

		end	

	else
		clear_all_bonuses(player)
	end


end
)

function clear_all_bonuses(player)

	player.character_crafting_speed_modifier = 0
	player.character_mining_speed_modifier = 0
	
end

function set_inventory1(player, count)
	-- set the player's inventory slot bonus count to total_slots
	player.character_crafting_speed_modifier = count
end


function log_crafting_Bonus(player)
	player.print("Character crafting speed: +" .. player.character_crafting_speed_modifier)	
end

function set_inventory3(player, count)
	player.character_mining_speed_modifier = count
	
end

function log_mining_speed_modifier(player)
	player.print("Bonus manual mining speed: +" .. player.character_mining_speed_modifier)	
end

---------------------------------------------------------
-- Constants
local laser_quarry_period = 6		-- how often to perform mining, in ticks
local laser_quarry_2_period = 3
local laser_quarry_3_period = 1.5	-- how often to perform advanced mining, in ticks
local laser_quarry_4_period = 0.1

---------------------------------------------------------
-- Process all ongoing events
function onTick()
	if not mixed_ores then populateMixedOreList() end
	
	if (game.tick % laser_quarry_period == 0) then
		processQuarries(global.laser_quarries)
	end
	if (game.tick % laser_quarry_2_period == 0) then
		processQuarries(global.laser_quarries_2)
	end
	if (game.tick % laser_quarry_3_period == 0) then
		processQuarries(global.laser_quarries_3)
	end
	if (game.tick % laser_quarry_4_period == 0) then
		processQuarries(global.laser_quarries_4)
	end
end

function populateMixedOreList()
	mixed_ores = {}
	for __, ore in pairs(potential_ores) do
		if game.item_prototypes[ore] then
			table.insert(mixed_ores, ore)
		end
	end
end

---------------------------------------------------------
-- Initialize various objects
function onInit()
	global.laser_quarries = global.laser_quarries or {}
	global.laser_quarries_2 = global.laser_quarries_2 or {}
	global.laser_quarries_3 = global.laser_quarries_3 or {}
	global.laser_quarries_4 = global.laser_quarries_4 or {}
	script.on_event(defines.events.on_tick, onTick)
end
script.on_init(onInit)

---------------------------------------------------------
-- On reload, make sure that processing continues
function onLoad()
	script.on_event(defines.events.on_tick, onTick)
end
script.on_load(onLoad)

---------------------------------------------------------
-- On mod update, 
function onConfigurationChange(change_data)
	if global.quarries then
		global.laser_quarries = util.table.deepcopy(global.quarries)
		global.laser_quarries_2 = util.table.deepcopy(global.quarries)
		global.laser_quarries_3 = util.table.deepcopy(global.quarries)
		global.laser_quarries_4 = util.table.deepcopy(global.quarries)
		global.quarries = nil
	end
	global.laser_quarries = global.laser_quarries or {}
	global.laser_quarries_2 = global.laser_quarries_2 or {}
	global.laser_quarries_3 = global.laser_quarries_3 or {}
	global.laser_quarries_4 = global.laser_quarries_4 or {}
	script.on_event(defines.events.on_tick, onTick)
end
script.on_configuration_changed(onConfigurationChange)

---------------------------------------------------------
-- Keep track of built objects
function builtEntity(event)
	local ent = event.created_entity
	local name = ent.name
	if name == "laser-quarry" then
		table.insert(global.laser_quarries, ent)
	elseif name == "laser-quarry2" then
		table.insert(global.laser_quarries_2, ent)
	elseif name == "laser-quarry3" then
		table.insert(global.laser_quarries_3, ent)
	elseif name == "laser-quarry4" then
		table.insert(global.laser_quarries_4, ent)
	end
end
script.on_event(defines.events.on_built_entity, builtEntity)
script.on_event(defines.events.on_robot_built_entity, builtEntity)

---------------------------------------------------------
-- Simulate mining in deep quarries
function processQuarries(quarries)
	for index, quarry in pairs(quarries) do
		if quarry and quarry.valid then
			local inventory = quarry.get_inventory(defines.inventory.item_main)
			if result_ore == "mixed" then
				ore = insertRandomOre(inventory, ore_per_second)
			else
				inventory.insert({name = result_ore, count = ore_per_second})
			end
			quarry.surface.pollute(quarry.position, deep_mining_pollution)
		else
			table.remove(quarries, index)
		end
	end
end

---------------------------------------------------------
-- Random ore if the quarry gives "mixed" ore
function insertRandomOre(inventory)
	for i = 3, ore_per_second do
		inventory.insert({name = mixed_ores[math.random(1, #mixed_ores)], count = 164})
	end
end