require "mod-gui"
require("utils")

--[[
  ** SISTEMA DE XP E LEVEL UP**
by MFerrari  
]]


function printXP(player,XP)
if settings.get_player_settings(player)["charxpmod_print_xp_user"].value then
	player.print('+XP: ' .. XP)
	end
end


function ResetXPTables()

local xp = settings.startup["charxpmod_xpinilevel"].value
global.xp_table = {[1] = xp}

for k=2,100 do
	xp = math.ceil(xp * settings.startup["charxpmod_xpmult"].value)
	global.xp_table[k] = xp
	end
end

function InitPlayer(player)
local nome = player.name

-- remove previous versions
if (mod_gui.get_button_flow(player).chartopframe) then
	mod_gui.get_button_flow(player).chartopframe.destroy() end
if (mod_gui.get_button_flow(player).btcharxp) then
	mod_gui.get_button_flow(player).btcharxp.destroy() end

-- setup player vars if needed	
if not (global.personalxp.Level[nome]) then
    SetupPlayer(player,true)
    end 
	
	
--player.gui.top.add{name="btcharxp", type="sprite-button", sprite = "entity/player", tooltip = {"panel-title"}}
--
if (not player.gui.top.chartopframe) then
local Topframe = player.gui.top.add{name="chartopframe", direction = "horizontal", type="frame", style=mod_gui.frame_style}
--local Topframe = player.gui.top.add{type="frame", name="chartopframe", direction = "horizontal", style=mod_gui.frame_style} --caption={"panel-title"}
 	Topframe.style.minimal_height = 30
 	Topframe.style.maximal_height = 37
	Topframe.style.minimal_width = 200
--X	Topframe.style.maximal_width  = 250
local Level=1
if global.personalxp.Level[nome] then Level = global.personalxp.Level[nome] end
local pnivel = Topframe.add{type="label", name='chartoplvtxt', caption={'actual_lv',Level}}
    pnivel.style.font="charxpmod_font_17b"
local TopXPbar = Topframe.add{type = "progressbar", name = "TopXPbar"}
end

if not player.gui.top.btcharxp then --(not player.gui.top.btcharxp) then
    player.gui.top.add{name="btcharxp", type="sprite-button", sprite = "entity/player", tooltip = {"panel-title"}, style = mod_gui.top_button_style} -- "mod_gui_button"}
	end
end

function resetAllPlayerStats()
	for _, player in pairs(game.players) do
		if (not player.gui.top.btcharxp ) or (not player.gui.top.chartopframe) then
			InitPlayer(player)
			else
			SetupPlayer(player,false)
			end
		end
end



function VersionChange()

if global.personalxp.opt_Pick_Extender == nil then
	global.personalxp.opt_Pick_Extender = {}
	for _, player in pairs(game.players) do
		global.personalxp.opt_Pick_Extender[player.name] = false
	end
end



if global.XP_MAX_PLAYTIME == nil then 
	global.XP_MAX_PLAYTIME={} 
		for name, force in pairs (game.forces) do
			if name~='neutral' and name~='enemy' then
			global.XP_MAX_PLAYTIME[name] = 0
			end
		end
	end
	
	
if global.XP_AVG_PLAYTIME == nil then 
	global.XP_AVG_PLAYTIME={} 
		for name, force in pairs (game.forces) do
			if name~='neutral' and name~='enemy' then
			global.XP_AVG_PLAYTIME[name] = 0
			end
		end
	end	
end


	
function XPSetup()

if global.CharXPMOD == nil then 
	global.CharXPMOD = 1
	global.kills_spawner={}
	global.kills_units={}
	global.kills_worms={}
	global.XP={}
	global.XP_GANHO={}
	global.XP_KILL_HP={}
	global.XP_TECH={}
	global.XP_LEVEL={}
	global.XP_LEVEL_MIN={}
	
	
	global.personalxp = {}
	global.personalxp.Level = {}
	global.personalxp.XP = {}
	global.personalxp.Death = {}
	
    global.personalxp.LV_Craft_Speed = {}
    global.personalxp.LV_Mining_Speed = {}
    global.personalxp.LV_Run_Speed = {}
    global.personalxp.LV_Build_Dist = {}
    global.personalxp.LV_Reach_Dist = {}
    global.personalxp.LV_Inv_Bonus = {}
    global.personalxp.LV_InvQB_Bonus = {}
    global.personalxp.LV_InvLog_Bonus = {}
    global.personalxp.LV_InvTrash_Bonus = {}
    global.personalxp.LV_Robot_Bonus = {}
    global.personalxp.LV_Health_Bonus = {}
    global.personalxp.LV_Health_Bonus = {}


-- new	
	global.personalxp.opt_Pick_Extender = {}

	
	for name, force in pairs (game.forces) do
		if name~='neutral' and name~='enemy' then
		
		global.kills_spawner[name] = 0
		global.kills_units[name] = 0
		global.kills_worms[name] = 0
		global.XP[name] = 0
		global.XP_GANHO[name] = 0
		global.XP_KILL_HP[name]=0
		global.XP_TECH[name] = 0
		global.XP_LEVEL[name] = 1
		global.XP_LEVEL_MIN[name] = 0
		end
		end
	
	resetAllPlayerStats()
	end
	
VersionChange()
ResetXPTables()
	
end



function RatioXP(player)
local ratioXP = 1
	if settings.global["charxpmod_time_ratio_xp"].value and global.XP_AVG_PLAYTIME[player.force.name]>0 then
		ratioXP = player.online_time/global.XP_AVG_PLAYTIME[player.force.name]
		if ratioXP >= 1.10 then ratioXP = 1.10
			elseif ratioXP < 0.05 then ratioXP = 0.05 end
		end	
return ratioXP
end


function XP_Player_upd()

 	for name, force in pairs (game.forces) do
	if name~='neutral' and name~='enemy' then

		local cp = #force.connected_players
		local afk = settings.global["charxpmod_afk"].value
		if cp>0 then
			local XP = global.XP[name]   --math.ceil(global.XP[name] / cp)
			
			if XP>0 then
			for p, PL in pairs (force.connected_players) do 
				if afk==0 or PL.afk_time<afk*3600 then
				local ratioXP = RatioXP(PL)
				XP = math.ceil(XP*ratioXP)	
				global.personalxp.XP[PL.name] = global.personalxp.XP[PL.name] + XP
				printXP(PL,XP)
				UpdatePanel(PL)
				end
				end
			end	
		global.XP[name]=0	
		end
	end
	end
end



function XP_PlayerLv_upd()

	for _, player in pairs(game.players) do
		if player.connected then
			local name = player.name
			local Lv = global.personalxp.Level[name]
			for L=Lv, #global.xp_table do
				if global.personalxp.XP[name]< global.xp_table[L] then
					global.personalxp.Level[name]=L
					break
				end
			end
			
			if global.personalxp.Level[name] > Lv then
				player.print({'player_lv_up',global.personalxp.Level[name]})
				player.play_sound{path = 'player_level_up'}
				UpdatePanel(player)
				end
		end
	end
end


function XP_Time_upd()
 	for name, force in pairs (game.forces) do
	if name~='neutral' and name~='enemy' then
	local PT
	local TT=0
	local QP=0

		for p, PL in pairs (force.players) do 
			PT = PL.online_time
			if PT > global.XP_AVG_PLAYTIME[name]/20 then  -- a player time count for avg if he has at least 5% of the avg time
				TT = TT + PT
				QP = QP + 1
				end

			if global.XP_MAX_PLAYTIME[name] < PT then
				global.XP_MAX_PLAYTIME[name] = PT
				end
			end
	if QP>0 then global.XP_AVG_PLAYTIME[name] = TT/QP end
	end
	end
end


function XP_UPDATE_tick()

XP_Time_upd()
XP_Player_upd()
XP_PlayerLv_upd()

end


function SetupPlayer(player,all)
name= player.name
	
	if all then
		global.personalxp.XP[name] = 0
		global.personalxp.Death[name] = 0
		end

	global.personalxp.Level[name] = 1
    global.personalxp.LV_Craft_Speed[name]  = 0
    global.personalxp.LV_Mining_Speed[name] = 0
    global.personalxp.LV_Run_Speed[name]    = 0
    global.personalxp.LV_Build_Dist[name]   = 0
    global.personalxp.LV_Reach_Dist[name]   = 0
    global.personalxp.LV_Inv_Bonus[name]    = 0
    global.personalxp.LV_InvQB_Bonus[name]  = 0
    global.personalxp.LV_InvLog_Bonus[name] = 0
    global.personalxp.LV_InvTrash_Bonus[name] = 0
    global.personalxp.LV_Robot_Bonus[name]  = 0
    global.personalxp.LV_Health_Bonus[name] = 0
	
	global.personalxp.opt_Pick_Extender[name] = false

end





function FormulaSumLv(lv)
local pt = 0
if lv>0 then
for k=1,lv do pt=pt+ 1 + math.floor((k-1)/2)  end end
return pt
end

function SumPoitSpent(name)
local sum = (FormulaSumLv(global.personalxp.LV_Craft_Speed[name]) + 
    FormulaSumLv(global.personalxp.LV_Mining_Speed[name]) +
    FormulaSumLv(global.personalxp.LV_Run_Speed[name])    +
    --FormulaSumLv(global.personalxp.LV_Build_Dist[name])   +
    FormulaSumLv(global.personalxp.LV_Reach_Dist[name])   +
    FormulaSumLv(global.personalxp.LV_Inv_Bonus[name])    +
    FormulaSumLv(global.personalxp.LV_InvQB_Bonus[name])  +
    FormulaSumLv(global.personalxp.LV_InvLog_Bonus[name]) +
    FormulaSumLv(global.personalxp.LV_InvTrash_Bonus[name]) +
    FormulaSumLv(global.personalxp.LV_Robot_Bonus[name])  +
    FormulaSumLv(global.personalxp.LV_Health_Bonus[name]))
	
if global.personalxp.LV_InvQB_Bonus[name]>0 then
	sum = sum + global.personalxp.LV_InvQB_Bonus[name]
	end

return sum	
end





local function Cria_GUI(event)
    local player = game.players[event.player_index]
    if (not player.gui.top.btcharxp) or (not player.gui.top.chartopframe) then
		InitPlayer(player)
	end
end


function update_char_panel(player)
XP_Time_upd() 
 
  local force = player.force.name
  local painel = player.gui.center["char-panel"]
  local frame = painel.tabcharScroll
  local nome = player.name
  local Level = global.personalxp.Level[nome] 


local ptime = player.online_time
local txtPTime = {"time-played" ,string.format("%d:%02d:%02d", math.floor(ptime / 216000), math.floor(ptime / 3600) % 60, math.floor(ptime / 60) % 60)}

local PontosXP = Level - 1 - SumPoitSpent(nome)
if PontosXP<0 then PontosXP=0 end

--	local img = frame.add{type = "sprite", sprite = "msi_win"}
--  local evo   = {"missions.evolution-factor", string.format("%.2f", math.floor(game.forces["enemy"].evolution_factor * 10000) / 100)}

  local tabChar = frame.add{type = "table", name = "tab_tbchar", column_count = 2}
  tabChar.add{type = "sprite", sprite = "charxpmod_space_suit"}

  local tabScroll = tabChar.add{type = "scroll-pane", name= "tabScroll2", vertical_scroll_policy="auto", horizontal_scroll_policy="auto"}
	tabScroll.style.minimal_height = 150
	tabScroll.style.minimal_width = 320
	tabScroll.style.maximal_width = 350		

 
  local tabPName = tabScroll.add{type = "table", name = "tab_pname", column_count = 3}
  local pname = tabPName.add{type="label", name='ocharname',  caption=nome}
  pname.style.font="charxpmod_font_30b"
  pname.style.font_color=player.color 
  tabPName.add{type="label", name='blanklab1', caption='        - '}
  local pnivel = tabPName.add{type="label", name='ocharlevel', caption={'actual_lv',Level}}
  pnivel.style.font="charxpmod_font_30"
  pnivel.style.font_color=player.color 


  local tabPStat = tabScroll.add{type = "table", name = "tab_PStat", column_count = 2}
  tabPStat.add{type="label", name='STT1', caption= txtPTime}.style.font="charxpmod_font_17"
  tabPStat.add{type="label", name='STT2', caption={'xp_deaths',global.personalxp.Death[nome]}}.style.font="charxpmod_font_17"
   
  tabScroll.add{type="label", name='blankL1', caption=' '}
  
  -- stats
  local tabStats = tabScroll.add{type = "table", name = "tabStats", column_count = 2}
  tabStats.add{type="label", name='STT3', caption={'xp_spawnk',global.kills_spawner[force]}}
  tabStats.add{type="label", name='STT4', caption={'xp_techs',global.XP_TECH[force]}}
  tabStats.add{type="label", name='STT5', caption={'xp_wormk',global.kills_worms[force]}}
  tabStats.add{type="label", name='STT6', caption={'xp_unitk',global.kills_units[force]}}

  
local pbvalue = CalculateXP_PB(player)
--local pbvalue = player.gui.top.chartopframe.TopXPbar.value
local XP = global.personalxp.XP[nome] 
local NextLevel = global.xp_table[Level]

  
  local tabXP = frame.add{type = "table", name = "tab_XP", column_count = 3}
  tabXP.add{type="label", name='lbxpatual', caption='XP: ' .. XP }.style.font="charxpmod_font_17"
  local bar = tabXP.add{type = "progressbar", size = 150, value = pbvalue, name = "tab_XPbar"}
  tabXP.add{type="label", name='lbxpnext', caption={'next_lv',NextLevel}}.style.font="charxpmod_font_17"

	
-- XP RATIO	
  local ratioXP = RatioXP(player)
  ratioXP = math.floor(ratioXP*100)
  frame.add{type="label", name='lbxratioxp', caption={'xp_ratio', ratioXP}}
  
  frame.add{type="label", name='blankL3', caption=' '}
  frame.add{type="label", name='lbxPAGastar', caption={'xp_points',PontosXP}}.style.font="charxpmod_font_20"   
  
-- LEVELS / UPGRADES
  local tabUpgrades = frame.add{type = "table", name = "tabUpgrades", column_count = 6}
  
  local Max = 20
  local vchar = 'global.personalxp.LV_Health_Bonus' 
  local atual = global.personalxp.LV_Health_Bonus[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,50}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

	 
  local vchar = 'global.personalxp.LV_Run_Speed'
  atual = global.personalxp.LV_Run_Speed[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,20}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo},name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

  local vchar = 'global.personalxp.LV_Craft_Speed'
  atual = global.personalxp.LV_Craft_Speed[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,20}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end
  
  local vchar = 'global.personalxp.LV_Mining_Speed'
  atual = global.personalxp.LV_Mining_Speed[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,20}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

--[[
  local vchar = 'global.personalxp.LV_Build_Dist'
  atual = global.personalxp.LV_Build_Dist[nome]
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,20}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=atual+1 and atual<=Max  then tabUpgrades.add{type="button", style = mod_gui.button_style, caption='+', name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='    '} end
]]
	 
  local vchar = 'global.personalxp.LV_Reach_Dist'
  atual = global.personalxp.LV_Reach_Dist[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,1}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

  local vchar = 'global.personalxp.LV_Inv_Bonus'
  atual = global.personalxp.LV_Inv_Bonus[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,5}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button",  caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

	 
  local vchar = 'global.personalxp.LV_InvQB_Bonus'
  atual = global.personalxp.LV_InvQB_Bonus[nome]
  local custo = 2 + math.floor(atual/2)
  Max = 5
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,10}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button", caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end
 
  Max = 20
  local vchar = 'global.personalxp.LV_InvLog_Bonus'
  atual = global.personalxp.LV_InvLog_Bonus[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,5}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button", caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

  local vchar = 'global.personalxp.LV_InvTrash_Bonus'
  atual = global.personalxp.LV_InvTrash_Bonus[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,5}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button", caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end

  local vchar = 'global.personalxp.LV_Robot_Bonus'
  atual = global.personalxp.LV_Robot_Bonus[nome]
  local custo = 1 + math.floor(atual/2)
  tabUpgrades.add{type="label", name='lmChar1'..vchar, caption={vchar}, tooltip={'xp_hint_'..vchar,5}}
  tabUpgrades.add{type="label", name='lmChar2'..vchar, caption=atual}.style.font="charxpmod_font_17b"
  if PontosXP>=custo and atual<=Max  then tabUpgrades.add{type="button", caption='+', tooltip={'xp_costbt',custo}, name='btLVU_'..vchar} else
     tabUpgrades.add{type="label", name='lmChar3'..vchar, caption='      ', tooltip={'xp_costbt',custo}} end
	 
local pickbutton = frame.add{type = "checkbox", name = "cb_pick_extender", caption={'xp_opt_Pick_Extender'}, state = global.personalxp.opt_Pick_Extender[nome]}

---
   frame.add{type="label", name='blankL4', caption=' '}
  
   
  --TAG 
  local tabtag = frame.add{type = "table", name = "tabchartag", column_count = 3}	
  tabtag.add{type="label", name="lab_ctag", caption="Tag  "}
  tabtag.add{type="textfield", name="ctag_field", text=player.tag}
  local btTagOK= tabtag.add{name="btTagCharOK", type="button", style = mod_gui.button_style, caption='OK'}
  end


function ListAll(player)
  
expand_char_gui(player)
expand_char_gui(player)  
  
  local force = player.force
  local painel = player.gui.center["char-panel"]
  local frame = painel.tabcharScroll
  
  
  frame.add{type="label", name='lbxplayerlst', caption=Players}.style.font="charxpmod_font_20"
  local tabpllst = frame.add{type = "table", name = "tabpllst", column_count = 3}
  for p,PL in pairs (force.players) do

	local ptime = PL.online_time
	local txtPTime = string.format("%d:%02d", math.floor(ptime / 216000), math.floor(ptime / 3600) % 60)
	local ratioXP = math.floor(RatioXP(PL) * 100)
	tabpllst.add{type="label", name='pllstname'..p, caption=PL.name .. ' '..global.personalxp.Level[PL.name] .. ' (' ..txtPTime.. ' '..ratioXP..'%)'}
	end
end  
  

function CalculateXP_PB(player)
local nome = player.name
local Level = global.personalxp.Level[nome] 
local XP = global.personalxp.XP[nome] 
local NextLevel = global.xp_table[Level]
local XP_ant
if Level==1 then XP_ant = 0 else XP_ant = global.xp_table[Level-1] end
local Interval_XP = NextLevel - XP_ant
local pbvalue = (XP-XP_ant)/Interval_XP
return pbvalue
end


  
function UpdatePanel(player)
-- BARRA DE XP  
local TopXPbar = player.gui.top.chartopframe.TopXPbar
local txtlv = player.gui.top.chartopframe.chartoplvtxt

local Level = global.personalxp.Level[player.name] 
local pbvalue = CalculateXP_PB(player)

txtlv.caption={'actual_lv',Level}
TopXPbar.value=pbvalue

local frame = player.gui.center["char-panel"]
    if frame then
	local textImput = player.gui.center["char-panel"].tabcharScroll.tabchartag.ctag_field.text
	if player.tag~=textImput then return end
	expand_char_gui(player)
	expand_char_gui(player)
	end

end

function expand_char_gui(player)
    local frame = player.gui.center["char-panel"]
    if frame then
        frame.destroy()
    else
		frame = player.gui.center.add{type="frame", name="char-panel", direction = "vertical", style=mod_gui.frame_style, caption={"panel-title"}} 
		frame.style.minimal_height = 430
  		--frame.style.maximal_height = 430
		frame.style.minimal_width = 485
		frame.style.maximal_width = 485
		local tabcharScroll = frame.add{type = "scroll-pane", name= "tabcharScroll", vertical_scroll_policy="auto", horizontal_scroll_policy="auto"}
		tabcharScroll.style.minimal_height = 400
		--tabcharScroll.style.maximal_height = 1000
		tabcharScroll.style.minimal_width = 455
		tabcharScroll.style.maximal_width = 455		
		update_char_panel(player) 
    end
end





local function on_tick(event)
if game.tick % 1200 == 0 then
	XP_UPDATE_tick()
	end
end


function Cria_Player(event) 
local player = game.players[event.player_index]
SetupPlayer(player,true)
end



function on_force_created(event) 

local name = event.force.name

	global.kills_spawner[name] = 0
	global.kills_units[name] = 0
	global.kills_worms[name] = 0
	global.XP[name] = 0
	global.XP_GANHO[name] = 0
	global.XP_TECH[name] = 0
	global.XP_LEVEL[name] = 1
	global.XP_LEVEL_MIN[name] = 0
	global.XP_KILL_HP[name] = 0
	global.XP_MAX_PLAYTIME[name] = 0
	global.XP_AVG_PLAYTIME[name] = 0
	
end



script.on_event(defines.events.on_player_created, Cria_Player)
script.on_event(defines.events.on_player_joined_game, Cria_GUI)
script.on_event(defines.events.on_tick, on_tick )
script.on_event(defines.events.on_force_created,on_force_created)

--------------------------------------------------------------------------------------
function On_Init_MAF() 
XPSetup()
end


function on_configuration_changed(data)
--VersionChange()
XPSetup()
end



script.on_configuration_changed(on_configuration_changed)
script.on_init(On_Init_MAF)


function UpdatePlayerLvStats(player)
local name=player.name

if player.character ~= nil then
 	player.character.character_crafting_speed_modifier = global.personalxp.LV_Craft_Speed[name] / 5
	player.character.character_mining_speed_modifier =  global.personalxp.LV_Mining_Speed[name] /5
	player.character.character_running_speed_modifier  =  global.personalxp.LV_Run_Speed[name] / 5
	player.character.character_build_distance_bonus   =  global.personalxp.LV_Reach_Dist[name]	--global.personalxp.LV_Build_Dist[name]
	player.character.character_reach_distance_bonus   =  global.personalxp.LV_Reach_Dist[name]
	player.character.character_item_drop_distance_bonus 	= global.personalxp.LV_Reach_Dist[name]
	player.character.character_resource_reach_distance_bonus = global.personalxp.LV_Reach_Dist[name]
	player.character.character_inventory_slots_bonus    =  global.personalxp.LV_Inv_Bonus[name] * 5
	player.character.quickbar_count_bonus    =  global.personalxp.LV_InvQB_Bonus[name]
	player.character.character_logistic_slot_count_bonus    =  global.personalxp.LV_InvLog_Bonus[name] * 5
	player.character.character_trash_slot_count_bonus =  global.personalxp.LV_InvTrash_Bonus[name] * 5
	player.character.character_maximum_following_robot_count_bonus =  global.personalxp.LV_Robot_Bonus[name] * 5
	player.character.character_health_bonus =  global.personalxp.LV_Health_Bonus[name] * 50

	if global.personalxp.opt_Pick_Extender[name] then 
		player.character.character_item_pickup_distance_bonus = global.personalxp.LV_Reach_Dist[name]
		else player.character.character_item_pickup_distance_bonus = 0
		end
	
end

end


function LevelUPPlayer(player,btname)

local name=player.name
if btname=='btLVU_global.personalxp.LV_Craft_Speed' then
	global.personalxp.LV_Craft_Speed[name] = global.personalxp.LV_Craft_Speed[name] + 1

elseif btname=='btLVU_global.personalxp.LV_Mining_Speed' then
	global.personalxp.LV_Mining_Speed[name] =  global.personalxp.LV_Mining_Speed[name] + 1

elseif btname=='btLVU_global.personalxp.LV_Run_Speed' then
	global.personalxp.LV_Run_Speed[name] =  global.personalxp.LV_Run_Speed[name] + 1

elseif btname=='btLVU_global.personalxp.LV_Build_Dist' then
	global.personalxp.LV_Build_Dist[name] =  global.personalxp.LV_Build_Dist[name] + 1

elseif btname=='btLVU_global.personalxp.LV_Reach_Dist' then
	global.personalxp.LV_Reach_Dist[name] =  global.personalxp.LV_Reach_Dist[name] + 1
	
elseif btname=='btLVU_global.personalxp.LV_Inv_Bonus' then
	global.personalxp.LV_Inv_Bonus[name] =  global.personalxp.LV_Inv_Bonus[name] + 1

elseif btname=='btLVU_global.personalxp.LV_InvQB_Bonus' then
	global.personalxp.LV_InvQB_Bonus[name] =  global.personalxp.LV_InvQB_Bonus[name] + 1

elseif btname=='btLVU_global.personalxp.LV_InvLog_Bonus' then
	global.personalxp.LV_InvLog_Bonus[name] =  global.personalxp.LV_InvLog_Bonus[name] + 1

elseif btname=='btLVU_global.personalxp.LV_InvTrash_Bonus' then
	global.personalxp.LV_InvTrash_Bonus[name] =  global.personalxp.LV_InvTrash_Bonus[name] + 1
	
elseif btname=='btLVU_global.personalxp.LV_Robot_Bonus' then
	global.personalxp.LV_Robot_Bonus[name] =  global.personalxp.LV_Robot_Bonus[name] + 1

elseif btname=='btLVU_global.personalxp.LV_Health_Bonus' then
	global.personalxp.LV_Health_Bonus[name] =  global.personalxp.LV_Health_Bonus[name] + 1
end
  
UpdatePlayerLvStats(player)
	
end


function ResetAll()
ResetXPTables()
resetAllPlayerStats()
end


script.on_event("key-I", function(event) expand_char_gui(game.players[event.player_index]) end)

local function on_gui_click(event)
--	message_all(global.debug)

local player = game.players[event.element.player_index]
local name = event.element.name

    if (name == "btcharxp") then
        expand_char_gui(player)
    elseif (name == "btTagCharOK")then
		local textImput = player.gui.center["char-panel"].tabcharScroll.tabchartag.ctag_field.text
		
		if textImput == "{resetall}" then 
			if player.admin then
				expand_char_gui(player) 
				ResetAll()
				message_all({'xp_reset_altert'})
				end
			return 
		elseif textImput == "{list}" then 
			ListAll(player) 
			player.gui.center["char-panel"].tabcharScroll.tabchartag.ctag_field.text = "{list}"
			return 
			end
		
		player.tag = textImput
		expand_char_gui(player)
	
	elseif string.sub(name,1,6)=='btLVU_' then
		if player.character ~= nil then
		LevelUPPlayer(player,name)
		expand_char_gui(player)
		expand_char_gui(player)
		end

	elseif name == "cb_pick_extender" then
		if player.character == nil then
			player.gui.center["char-panel"].tabcharScroll.cb_pick_extender.state = global.personalxp.opt_Pick_Extender[player.name]
			return
			end
		local cb_pick_extender = player.gui.center["char-panel"].tabcharScroll.cb_pick_extender.state
		global.personalxp.opt_Pick_Extender[player.name] = cb_pick_extender
		UpdatePlayerLvStats(player)
	end
	
end
script.on_event(defines.events.on_gui_click, on_gui_click)




--- XP FOR KILL
script.on_event(defines.events.on_entity_died, function(event)

if event.force == nil then return end

local force=event.force.name  -- force that kill
local killer=event.cause


if event.entity.force.name == 'enemy' and force~='neutral' and force~='enemy' then --aliens
	local XP = event.entity.prototype.max_health

	if event.entity.type == 'unit' then
		global.kills_units[force] = global.kills_units[force] + 1
		elseif event.entity.type == 'unit-spawner' then
		XP = XP * 2
		global.kills_spawner[force] = global.kills_spawner[force] +1
		elseif event.entity.type == 'turret' then
		global.kills_worms[force] = global.kills_worms[force] +1
		end
	if XP > 99999 then XP=99999 end
	XP = math.ceil(XP/100)
	if XP<1 then XP=1 end

	local teamxp = true

--[[	if killer~=nil then
	if killer.valid then
		if killer.type=='player' then
			local plname = killer.player.name
			global.personalxp.XP[plname] = global.personalxp.XP[plname] + XP
			teamxp = false
			end 
		end
		end ]]

	if teamxp then
		global.XP_KILL_HP[force] = global.XP_KILL_HP[force] + XP
		global.XP[force] = global.XP[force] + XP
		
		end
	end


end)

script.on_event(defines.events.on_player_respawned, function(event)
local player = game.players[event.player_index]
UpdatePlayerLvStats(player)
end)

script.on_event(defines.events.on_pre_player_died, function(event)
local player = game.players[event.player_index]
local name = player.name
local XP = global.personalxp.XP[name] 
local Level = global.personalxp.Level[name] 
local NextLevel = global.xp_table[Level]
local XP_ant
if Level==1 then XP_ant = 0 else XP_ant = global.xp_table[Level-1] end
local Interval_XP = NextLevel - XP_ant
local Penal = math.floor((XP-XP_ant)*settings.global["charxpmod_afk"].value/100)
global.personalxp.Death[name] = global.personalxp.Death[name]+1

if Penal>0 then 
global.personalxp.XP[name] = global.personalxp.XP[name]-Penal
player.print({'xp_lost'})
player.print(Penal)
end

end)

-- XP by research
script.on_event(defines.events.on_research_finished, function(event)
if event.research.force ~= nil then
	local force = event.research.force.name
	if name~='neutral' and name~='enemy' then
	if global.XP_TECH[force] then
		local techXP = event.research.research_unit_count * #event.research.research_unit_ingredients
		techXP = math.ceil(techXP * (1+ (5*game.forces["enemy"].evolution_factor)))
		global.XP_TECH[force] = global.XP_TECH[force]  +techXP
		global.XP[force] = global.XP[force]  +techXP 
		end
	end
	end
end)

-- XP by Rocket
script.on_event(defines.events.on_rocket_launched, function(event)
local rocket = event.rocket
local force = rocket.force
local XP

	for p, PL in pairs (force.connected_players) do 
		XP = math.ceil(global.personalxp.XP[PL.name]/5) --20%
		global.personalxp.XP[PL.name] = global.personalxp.XP[PL.name] + XP
		printXP(PL,XP)
	end
end)


-- INTERFACE  --
--------------------------------------------------------------------------------------
-- /c remote.call("RPG","TeamXP","player",150)
local interface = {}

-- Give XP to Team (may be negative)
function interface.TeamXP(forcename,XP)
global.XP[forcename] = global.XP[forcename] + XP
end

-- Give XP to a player (may be negative)
function interface.PlayerXP(playername,XP)
global.personalxp.XP[playername] = global.personalxp.XP[playername] + XP
printXP(game.players[playername],XP)
end

-- Give a player a XP % of his own XP
function interface.PlayerXPPerc(playername,Perc)
local XP = math.ceil(global.personalxp.XP[playername]*Perc/100) 
global.personalxp.XP[playername] = global.personalxp.XP[playername] + XP
printXP(game.players[playername],XP)
end

-- Penalty XP for a % of his own XP
function interface.PlayerXPPenalPerc(playername,Perc)
global.personalxp.XP[playername] = global.personalxp.XP[playername] - math.ceil(global.personalxp.XP[playername]*Perc/100) 
end

-- Give all force players a XP% of his own XP
function interface.TeamXPPerc(forcename,Perc)
local XP
	for p, PL in pairs (game.forces[forcename].connected_players) do 
		XP = math.ceil(global.personalxp.XP[PL.name]*Perc/100) 
		global.personalxp.XP[PL.name] = global.personalxp.XP[PL.name] + XP
		printXP(PL,XP)
	end
end

remote.add_interface("RPG", interface )

