ending_patch_prototype =
  {
    sheet =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/start-end-integration-patches.png",
      width = 40,
      height = 40,
      priority = "extra-high",
      hr_version =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/hr-start-end-integration-patches.png",
        width = 80,
        height = 80,
        priority = "extra-high",
        scale = 0.5
      }
    }
  }


---------------------- GREEN BELT PICTURES
green_belt_horizontal =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      scale = 0.5
    }
  }
green_belt_vertical =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 40,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 160,
      scale = 0.5
    }
  }
green_belt_ending_top =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 80,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 320,
      scale = 0.5
    }
  }
green_belt_ending_bottom =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 120,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 480,
      scale = 0.5
    }
  }
green_belt_ending_side =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 160,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 640,
      scale = 0.5
    }
  }
green_belt_starting_top =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 200,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 800,
      scale = 0.5
    }
  }
green_belt_starting_bottom =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 240,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 960,
      scale = 0.5
    }
  }
green_belt_starting_side =
  {
    filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
    priority = "extra-high",
    width = 40,
    height = 40,
    frame_count = 32,
    y = 280,
    hr_version =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-transport-belt.png",
      priority = "extra-high",
      width = 80,
      height = 80,
      frame_count = 32,
      line_length = 16,
      y = 1120,
      scale = 0.5
    }
  }


data:extend(
{
  {
    type = "item",
    name = "green-transport-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt.png",
    icon_size = 32,
    flags = {"goes-to-quickbar"},
    subgroup = "bob-logistic-tier-4",
    order = "a[transport-belt]-d[green-transport-belt]",
    place_result = "green-transport-belt",
    stack_size = 100
  },
  {
    type = "item",
    name = "green-underground-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt-to-ground.png",
    icon_size = 32,
    flags = {"goes-to-quickbar"},
    subgroup = "bob-logistic-tier-4",
    order = "b[underground-belt]-d[green-underground-belt]",
    place_result = "green-underground-belt",
    stack_size = 50
  },
  {
    type = "item",
    name = "green-splitter",
    icon = "__boblogistics__/graphics/icons/green-splitter.png",
    icon_size = 32,
    flags = {"goes-to-quickbar"},
    subgroup = "bob-logistic-tier-4",
    order = "c[splitter]-d[green-splitter]",
    place_result = "green-splitter",
    stack_size = 50
  },

  {
    type = "transport-belt",
    name = "green-transport-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.3, result = "green-transport-belt"},
    max_health = 50,
    corpse = "small-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 50
      }
    },
    collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/express-transport-belt.ogg",
        volume = 0.4
      },
      max_sounds_per_type = 3
    },
    animation_speed_coefficient = 32,
    animations =
    {
      filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt.png",
      priority = "extra-high",
      width = 40,
      height = 40,
      frame_count = 32,
      direction_count = 12
    },
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    connector_frame_sprites = transport_belt_connector_frame_sprites,
    circuit_connector_sprites = transport_belt_circuit_connector_sprites,
    circuit_wire_connection_point = transport_belt_circuit_wire_connection_point,
    circuit_wire_max_distance = transport_belt_circuit_wire_max_distance
  },

  {
    type = "underground-belt",
    name = "green-underground-belt",
    icon = "__boblogistics__/graphics/icons/green-transport-belt-to-ground.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation", "fast-replaceable-no-build-while-moving"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "green-underground-belt"},
    max_health = 60,
    corpse = "small-remnants",
    underground_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    underground_remove_belts_sprite =
    {
      filename = "__core__/graphics/arrows/underground-lines-remove.png",
      priority = "high",
      width = 64,
      height = 64,
      x = 64,
      scale = 0.5
    },
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.4, -0.15}, {0.4, 0.1}},
    selection_box = {{-0.5, -0.25}, {0.5, 0.75}},
    distance_to_enter = 0.5,
    animation_speed_coefficient = 32,
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    max_distance = 20,
    structure =
    {
      direction_in =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          y = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            y = 85,
            scale = 0.5
          }
        }
      },
      direction_out =
      {
        sheet =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/green-transport-belt-to-ground-structure.png",
          priority = "extra-high",
          shift = {0.26, 0},
          width = 57,
          height = 43,
          hr_version =
          {
            filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-underground-belt-structure.png",
            priority = "extra-high",
            shift = {0.15625, 0.0703125},
            width = 106,
            height = 85,
            scale = 0.5
          }
        }
      }
    },
  },

  {
    type = "splitter",
    name = "green-splitter",
    icon = "__boblogistics__/graphics/icons/green-splitter.png",
    icon_size = 32,
    flags = {"placeable-neutral", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "green-splitter"},
    max_health = 80,
    corpse = "medium-remnants",
    resistances = 
    {
      {
        type = "fire",
        percent = 60
      }
    },
    collision_box = {{-0.9, -0.1}, {0.9, 0.1}},
    selection_box = {{-0.9, -0.5}, {0.9, 0.5}},
    animation_speed_coefficient = 32,
    structure_animation_speed_coefficient = 1.2,
    structure_animation_movement_cooldown = 10,
    belt_horizontal = green_belt_horizontal,
    belt_vertical = green_belt_vertical,
    ending_top = green_belt_ending_top,
    ending_bottom = green_belt_ending_bottom,
    ending_side = green_belt_ending_side,
    starting_top = green_belt_starting_top,
    starting_bottom = green_belt_starting_bottom,
    starting_side = green_belt_starting_side,
    ending_patch = ending_patch_prototype,
    fast_replaceable_group = "transport-belt",
    speed = 0.125,
    structure =
    {
      north =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-north.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 80,
        height = 35,
        shift = {0.225, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-north.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 164,
          height = 70,
          shift = {0.25, 0.046875},
          scale = 0.5
        }
      },
      east =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-east.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 46,
        height = 81,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-east.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 93,
          height = 157,
          shift = {0.148438, -0.179688},
          scale = 0.5
        }
      },
      south =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-south.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 82,
        height = 36,
        shift = {0.075, 0},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-south.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 168,
          height = 67,
          shift = {0.140625, 0.0234375},
          scale = 0.5
        }
      },
      west =
      {
        filename = "__boblogistics__/graphics/entity/transport-belt/green-splitter-west.png",
        frame_count = 32,
        line_length = 16,
        priority = "extra-high",
        width = 47,
        height = 79,
        shift = {0.25, 0.05},
        hr_version =
        {
          filename = "__boblogistics__/graphics/entity/transport-belt/hr-green-splitter-west.png",
          frame_count = 32,
          line_length = 8,
          priority = "extra-high",
          width = 94,
          height = 154,
          shift = {0.203125, -0.109375},
          scale = 0.5
        }
      },
    },
  },
  {
    type = "recipe",
    name = "green-transport-belt",
    enabled = "false",
    ingredients =
    {
      {"steel-plate", 2},
      {"iron-gear-wheel", 4},
    },
    result = "green-transport-belt"
  },
}
)

if settings.startup["bobmods-logistics-beltrequireprevious"].value == true then

bobmods.lib.recipe.add_ingredient("green-transport-belt", {"express-transport-belt", })

data:extend(
{
  {
    type = "recipe",
    name = "green-underground-belt",
    enabled = "false",
    ingredients =
    {
      {"express-underground-belt", 2},
      {"steel-plate", 14},
      {"iron-gear-wheel", 20},
    },
    result_count = 2,
    result = "green-underground-belt"
  },
  {
    type = "recipe",
    name = "green-splitter",
    enabled = "false",
    energy_required = 2,
    ingredients =
    {
      {"express-splitter", 1},
      {"steel-plate", 8},
      {"iron-gear-wheel", 14},
      {"processing-unit", 5},
    },
    result = "green-splitter"
  },
}
)

else

data:extend(
{
  {
    type = "recipe",
    name = "green-underground-belt",
    enabled = "false",
    ingredients =
    {
      {"green-transport-belt", 5},
      {"steel-plate", 4},
    },
    result_count = 2,
    result = "green-underground-belt"
  },
  {
    type = "recipe",
    name = "green-splitter",
    enabled = "false",
    energy_required = 2,
    ingredients =
    {
      {"green-transport-belt", 2},
      {"steel-plate", 4},
      {"iron-gear-wheel", 4},
      {"processing-unit", 5},
    },
    result = "green-splitter"
  },
}
)

end



data:extend(
{
  {
    type = "technology",
    name = "bob-logistics-4",
    icon = "__base__/graphics/technology/logistics.png",
    icon_size = 128,
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "green-transport-belt"
      },
      {
        type = "unlock-recipe",
        recipe = "green-underground-belt"
      },
      {
        type = "unlock-recipe",
        recipe = "green-splitter"
      }
    },
    prerequisites = {
      "logistics-3",
      "advanced-electronics-2"
    },
    unit =
    {
      count = 350,
      ingredients =
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
        {"production-science-pack", 1},
      },
      time = 20
    },
    order = "a-f-d",
  },
}
)

