
local trees = {
  -- wetland
  {
    name = "tree-wetland-a",
    model = "01",
    noise = "tree-01",
    temperature_low = 0.65,
    temperature_high = 1,
    aux_low = 0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 241, g = 238, b = 14},
      {r = 245, g = 165, b = 11},
      {r = 105, g = 184, b = 40}
    }
  },
  {
    name = "tree-wetland-b",
    model = "05",
    noise = "tree-02",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.2,
    aux_high = 0.7,
    water_band = 4,
    density = 4,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 163, g = 113, b = 21},
      {r = 184, g = 32, b = 32},
    }
  },
  {
    name = "tree-wetland-c",
    model = "05",
    noise = "tree-03",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 227, g = 169, b = 209},
      {r = 184, g = 31, b = 31},
      {r = 107, g = 70, b = 25},
    }
  },
  {
    name = "tree-wetland-d",
    model = "03",
    noise = "tree-04",
    temperature_low = 0.35,
    temperature_high = 0.9,
    aux_low = 0.2,
    aux_high = 0.4,
    water_band = 4,
    density = 4,
    colors = {
      {r = 130, g = 57, b = 35},
      {r = 79, g = 119, b = 21},
      {r = 17, g = 62, b = 5},
    }
  },
  {
    name = "tree-wetland-e",
    model = "05",
    noise = "tree-05",
    temperature_low = 0.35,
    temperature_high = 0.9,
    aux_low = 0.4,
    aux_high = 0.8,
    water_band = 4,
    density = 4,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
      {r = 109, g = 53, b = 33},
      {r = 106, g = 89, b = 32},
      {r = 96, g = 101, b = 40},
      {r = 174, g = 130, b = 34},
    }
  },
  {
    name = "tree-wetland-f",
    model = "07",
    noise = "tree-06",
    temperature_low = 0.55,
    temperature_high = 0.9,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 220, g = 47, b = 222},
      {r = 184, g = 31, b = 31},
      {r = 192, g = 180, b = 237},
    }
  },
  {
    name = "tree-wetland-g",
    model = "05",
    noise = "tree-07",
    temperature_low = 0.4,
    temperature_high = 0.65,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 241, g = 238, b = 14},
      {r = 142, g = 99, b = 23},
    }
  },
  {
    name = "tree-wetland-h",
    model = "07",
    noise = "tree-08",
    temperature_low = 0.4,
    temperature_high = 0.65,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 192, g = 180, b = 237},
      {r = 220, g = 47, b = 222},
      {r = 17, g = 202, b = 248},
    }
  },
  {
    name = "tree-wetland-i",
    model = "03",
    noise = "tree-09",
    temperature_low = 0.35,
    temperature_high = 0.4,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 176, g = 220, b = 165},
      {r = 105, g = 184, b = 40},
      {r = 79, g = 119, b = 21},
    }
  },
  {
    name = "tree-wetland-j",
    model = "03",
    noise = "tree-01",
    temperature_low = 0.1,
    temperature_high = 0.35,
    aux_low = 0.2,
    aux_high = 0.55,
    water_band = 4,
    density = 4,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
    }
  },
  {
    name = "tree-wetland-k",
    model = "03",
    noise = "tree-02",
    temperature_low = 0.1,
    temperature_high = 0.35,
    aux_low = 0.55,
    aux_high = 0.8,
    water_band = 4,
    density = 4,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 184, g = 31, b = 31},
      {r = 55, g = 22, b = 74},
    }
  },
  {
    name = "tree-wetland-l",
    model = "07",
    noise = "tree-03",
    temperature_low = 0.1,
    temperature_high = 0.3,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 17, g = 202, b = 248},
      {r = 192, g = 180, b = 237},
      {r = 176, g = 220, b = 165},
    }
  },
  {
    name = "tree-wetland-m",
    model = "07",
    noise = "tree-04",
    temperature_low = 0.0,
    temperature_high = 0.25,
    aux_low = 0.0,
    aux_high = 0.2,
    water_band = 4,
    density = 4,
    colors = {
      {r = 36, g = 225, b = 187},
      {r = 176, g = 220, b = 165},
      {r = 105, g = 184, b = 40},
    }
  },
  {
    name = "tree-wetland-n",
    model = "07",
    noise = "tree-05",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.2,
    aux_high = 0.6,
    water_band = 4,
    density = 4,
    colors = {
      {r = 44, g = 65, b = 126},
      {r = 75, g = 92, b = 123},
      {r = 17, g = 62, b = 5},
    }
  },
  {
    name = "tree-wetland-o",
    model = "03",
    noise = "tree-06",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.6,
    aux_high = 1,
    water_band = 4,
    density = 4,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 69, g = 73, b = 9},
      {r = 105, g = 184, b = 40},
    }
  },

  -- Grassland
  {
    name = "tree-grassland-a",
    model = "03",
    noise = "tree-07",
    temperature_low = 0.6,
    temperature_high = 1,
    aux_low = 0,
    aux_high = 0.15,
    water_band = 3,
    density = 3,
    colors = {
      {r = 165, g = 184, b = 40},
      {r = 79, g = 119, b = 21},
      {r = 69, g = 73, b = 9},
    },
  },
  {
    name = "tree-grassland-b",
    model = "04",
    noise = "tree-08",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.15,
    aux_high = 0.35,
    water_band = 3,
    density = 3,
    colors = {
      {r = 142, g = 99, b = 23},
      {r = 184, g = 31, b = 31},
      {r = 218, g = 187, b = 44},
    },
  },
  {
    name = "tree-grassland-c",
    model = "01",
    noise = "tree-09",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.35,
    aux_high = 0.7,
    water_band = 3,
    density = 3,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 245, g = 165, b = 11},
      {r = 109, g = 53, b = 33},
    },
  },
  {
    name = "tree-grassland-d",
    model = "03",
    noise = "tree-01",
    temperature_low = 0.9,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 109, g = 53, b = 33},
      {r = 128, g = 28, b = 120},
      {r = 184, g = 31, b = 31},
    },
  },
  {
    name = "tree-grassland-e",
    model = "04",
    noise = "tree-02",
    temperature_low = 0.75,
    temperature_high = 0.9,
    aux_low = 0.7,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 109, g = 53, b = 33},
      {r = 55, g = 22, b = 74},
    },
  },
  {
    name = "tree-grassland-f",
    model = "03",
    noise = "tree-03",
    temperature_low = 0.6,
    temperature_high = 0.85,
    aux_low = 0.15,
    aux_high = 0.35,
    water_band = 3,
    density = 3,
    colors = {
      {r = 218, g = 187, b = 44},
      {r = 245, g = 165, b = 11},
      {r = 142, g = 99, b = 23},
    },
  },
  {
    name = "tree-grassland-g",
    model = "03",
    noise = "tree-04",
    temperature_low = 0.4,
    temperature_high = 0.75,
    aux_low = 0.35,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 69, g = 73, b = 9},
      {r = 165, g = 184, b = 40},
      {r = 79, g = 119, b = 21},
      {r = 210, g = 185, b = 48},
      {r = 218, g = 187, b = 44},
    },
  },
  {
    name = "tree-grassland-h",
    model = "05",
    noise = "tree-05",
    temperature_low = 0.1,
    temperature_high = 0.75,
    aux_low = 0.55,
    aux_high = 0.65,
    water_band = 3,
    density = 3,
    colors = {
      {r = 79, g = 119, b = 21},
      {r = 165, g = 184, b = 40},
      {r = 69, g = 73, b = 9},
    },
  },
  {
    name = "tree-grassland-h2",
    model = "04",
    noise = "tree-06",
    temperature_low = 0.4,
    temperature_high = 0.75,
    aux_low = 0.65,
    aux_high = 0.85,
    water_band = 2,
    density = 2.1,
    colors = {
      {r = 128, g = 28, b = 75},
      {r = 219, g = 78, b = 173},
      {r = 95, g = 75, b = 147},
      {r = 184, g = 31, b = 67},
    },
  },
  {
    name = "tree-grassland-h3",
    model = "04",
    noise = "tree-07",
    temperature_low = 0.1,
    temperature_high = 0.4,
    aux_low = 0.65,
    aux_high = 0.85,
    water_band = 2,
    density = 2.1,
    colors = {
      {r = 67, g = 67, b = 142},
      {r = 115, g = 67, b = 142},
      {r = 128, g = 28, b = 75},
      {r = 95, g = 75, b = 147},
    },
  },
  {
    name = "tree-grassland-i",
    model = "02",
    noise = "tree-08",
    temperature_low = 0.3,
    temperature_high = 0.75,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 128, g = 28, b = 120},
      {r = 192, g = 180, b = 237},
      {r = 230, g = 120, b = 255},
    },
  },
  {
    name = "tree-grassland-k",
    model = "02",
    noise = "tree-09",
    temperature_low = 0.1,
    temperature_high = 0.4,
    aux_low = 0,
    aux_high = 0.3,
    water_band = 3,
    density = 3,
    colors = {
      {r = 76, g = 61, b = 16},
      {r = 32, g = 76, b = 69},
      {r = 142, g = 99, b = 23},
    },
  },
  {
    name = "tree-grassland-l",
    model = "03",
    noise = "tree-01",
    temperature_low = 0.25,
    temperature_high = 0.4,
    aux_low = 0.3,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 142, g = 99, b = 23},
      {r = 76, g = 61, b = 16},
    },
  },
  {
    name = "tree-grassland-m",
    model = "05",
    noise = "tree-02",
    temperature_low = 0.1,
    temperature_high = 0.3,
    aux_low = 0.8,
    aux_high = 1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 192, g = 180, b = 237},
      {r = 128, g = 28, b = 120},
      {r = 167, g = 198, b = 220},
    },
  },
  {
    name = "tree-grassland-n",
    model = "02",
    noise = "tree-03",
    temperature_low = 0.1,
    temperature_high = 0.25,
    aux_low = 0.3,
    aux_high = 0.55,
    water_band = 3,
    density = 3,
    colors = {
      {r = 221, g = 176, b = 207},
      {r = 184, g = 31, b = 31},
      {r = 75, g = 92, b = 123},
    },
  },
  {
    name = "tree-grassland-0",
    model = "02",
    noise = "tree-04",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.0,
    aux_high = 0.3,
    water_band = 3,
    density = 3,
    colors = {
      {r = 32, g = 76, b = 69},
      {r = 75, g = 92, b = 123},
      {r = 76, g = 61, b = 16},
    },
  },
  {
    name = "tree-grassland-p",
    model = "05",
    noise = "tree-05",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.3,
    aux_high = 0.7,
    water_band = 3,
    density = 3,
    colors = {
      {r = 75, g = 92, b = 123},
      {r = 44, g = 65, b = 126},
      {r = 32, g = 76, b = 69},
    },
  },
  {
    name = "tree-grassland-q",
    model = "05",
    noise = "tree-06",
    temperature_low = 0.0,
    temperature_high = 0.1,
    aux_low = 0.7,
    aux_high = 0.1,
    water_band = 3,
    density = 3,
    colors = {
      {r = 167, g = 198, b = 220},
      {r = 44, g = 65, b = 126},
      {r = 192, g = 180, b = 237},
    },
  },


  -- dryland
  {
    name = "tree-dryland-a",
    model = "06",
    noise = "tree-07",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.0,
    aux_high = 0.4,
    water_band = 2,
    density = 2,
    colors = {
      {r = 142, g = 99, b = 23},
      {r = 245, g = 165, b = 11},
      {r = 79, g = 119, b = 21},
    },
  },
  {
    name = "tree-dryland-b",
    model = "04",
    noise = "tree-08",
    temperature_low = 0.85,
    temperature_high = 1,
    aux_low = 0.4,
    aux_high = 0.7,
    water_band = 2,
    density = 2,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 142, g = 99, b = 23},
      {r = 79, g = 119, b = 21},
    },
  },
  {
    name = "tree-dryland-c",
    model = "04",
    noise = "tree-09",
    temperature_low = 0.7,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 2,
    density = 2,
    colors = {
      {r = 241, g = 238, b = 14},
      {r = 79, g = 119, b = 21},
      {r = 245, g = 165, b = 11},
    },
  },
  {
    name = "tree-dryland-d",
    model = "01",
    noise = "tree-01",
    temperature_low = 0.7,
    temperature_high = 1,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 2,
    density = 2,
    colors = {
      {r = 44, g = 65, b = 126},
      {r = 128, g = 28, b = 21},
      {r = 55, g = 22, b = 74},
    },
  },
  {
    name = "tree-dryland-e",
    model = "01",
    noise = "tree-02",
    temperature_low = 0.45,
    temperature_high = 0.85,
    aux_low = 0,
    aux_high = 0.2,
    water_band = 2,
    density = 2,
    colors = {
      {r = 105, g = 184, b = 40},
      {r = 176, g = 220, b = 165},
      {r = 142, g = 99, b = 23},
    },
  },
  {
    name = "tree-dryland-f",
    model = "06",
    noise = "tree-03",
    temperature_low = 0.7,
    temperature_high = 0.85,
    aux_low = 0.2,
    aux_high = 0.7,
    water_band = 2,
    density = 2,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 241, g = 238, b = 14},
      {r = 142, g = 99, b = 23},
    },
  },
  {
    name = "tree-dryland-g",
    model = "01",
    noise = "tree-04",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.2,
    aux_high = 0.5,
    water_band = 2,
    density = 2,
    colors = {
      {r = 174, g = 156, b = 56},
      {r = 163, g = 88, b = 33},
      {r = 152, g = 99, b = 23},
      {r = 79, g = 119, b = 21},
    },
  },
  {
    name = "tree-dryland-h",
    model = "04",
    noise = "tree-05",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.5,
    aux_high = 0.85,
    water_band = 2,
    density = 2,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 84, g = 17, b = 17},
      {r = 245, g = 165, b = 11},
      {r = 55, g = 22, b = 74},
      {r = 241, g = 238, b = 14},
    },
  },
  {
    name = "tree-dryland-i",
    model = "06",
    noise = "tree-06",
    temperature_low = 0.45,
    temperature_high = 0.7,
    aux_low = 0.85,
    aux_high = 1,
    water_band = 2,
    density = 2,
    colors = {
      {r = 128, g = 28, b = 120},
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
    },
  },
  {
    name = "tree-dryland-j",
    model = "04",
    noise = "tree-07",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 2,
    density = 2,
    colors = {
      {r = 176, g = 220, b = 165},
      {r = 105, g = 184, b = 40},
      {r = 75, g = 92, b = 123},
    },
  },
  {
    name = "tree-dryland-k",
    model = "02",
    noise = "tree-08",
    temperature_low = 0.15,
    temperature_high = 0.45,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 2,
    density = 2,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 79, g = 119, b = 21},
      {r = 75, g = 92, b = 123},
    },
  },
  {
    name = "tree-dryland-l",
    model = "04",
    noise = "tree-09",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.45,
    aux_high = 0.75,
    water_band = 2,
    density = 2,
    colors = {
      {r = 32, g = 76, b = 69},
      {r = 84, g = 17, b = 17},
      {r = 17, g = 62, b = 5},
    },
  },
  {
    name = "tree-dryland-m",
    model = "04",
    noise = "tree-01",
    temperature_low = 0.2,
    temperature_high = 0.45,
    aux_low = 0.75,
    aux_high = 1,
    water_band = 2,
    density = 2,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 55, g = 22, b = 74},
      {r = 128, g = 28, b = 120},
    },
  },
  {
    name = "tree-dryland-n",
    model = "06",
    noise = "tree-02",
    temperature_low = 0,
    temperature_high = 0.15,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 2,
    density = 2,
    colors = {
      {r = 75, g = 92, b = 123},
      {r = 32, g = 76, b = 69},
      {r = 17, g = 62, b = 5},
    },
  },
  {
    name = "tree-dryland-o",
    model = "06",
    noise = "tree-03",
    temperature_low = 0,
    temperature_high = 0.2,
    aux_low = 0.85,
    aux_high = 1,
    water_band = 2,
    density = 2,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 32, g = 76, b = 69},
      {r = 84, g = 17, b = 17},
    },
  },

  -- desert
  {
    name = "tree-desert-a",
    model = "08",
    noise = "tree-04",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 142, g = 99, b = 23},
      {r = 241, g = 238, b = 14},
      {r = 69, g = 73, b = 9},
    },
  },
  {
    name = "tree-desert-b",
    model = "08",
    noise = "tree-05",
    temperature_low = 0.8,
    temperature_high = 1,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 1,
    density = 1,
    colors = {
      {r = 227, g = 169, b = 209},
      {r = 220, g = 47, b = 222},
      {r = 184, g = 31, b = 31},
    },
  },
  {
    name = "tree-desert-c",
    model = "08",
    noise = "tree-06",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.45,
    aux_high = 0.7,
    water_band = 1,
    density = 1,
    colors = {
      {r = 218, g = 187, b = 44},
      {r = 79, g = 119, b = 21},
      {r = 105, g = 184, b = 40},
    },
  },
  {
    name = "tree-desert-d",
    model = "08",
    noise = "tree-07",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 1,
    density = 1,
    colors = {
      {r = 79, g = 119, b = 21},
      {r = 176, g = 220, b = 165},
      {r = 76, g = 61, b = 16},
    },
  },
  {
    name = "tree-desert-e",
    model = "08",
    noise = "tree-08",
    temperature_low = 0.75,
    temperature_high = 1,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 167, g = 198, b = 86},
      {r = 176, g = 220, b = 165},
      {r = 79, g = 119, b = 21},
    },
  },
  {
    name = "tree-desert-f",
    model = "08",
    noise = "tree-09",
    temperature_low = 0.5,
    temperature_high = 0.8,
    aux_low = 0.15,
    aux_high = 0.45,
    water_band = 1,
    density = 1,
    colors = {
      {r = 105, g = 184, b = 40},
      {r = 69, g = 73, b = 9},
      {r = 79, g = 119, b = 21},
    },
  },
  {
    name = "tree-desert-g",
    model = "08",
    noise = "tree-01",
    temperature_low = 0.45,
    temperature_high = 0.75,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 55, g = 22, b = 74},
      {r = 245, g = 165, b = 11},
    },
  },
  {
    name = "tree-desert-h",
    model = "09",
    noise = "tree-02",
    temperature_low = 0.5,
    temperature_high = 0.75,
    aux_low = 0.45,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 84, g = 17, b = 17},
      {r = 184, g = 31, b = 31},
      {r = 76, g = 61, b = 16},
    },
  },
  {
    name = "tree-desert-i",
    model = "04",
    noise = "tree-03",
    temperature_low = 0.0,
    temperature_high = 0.5,
    aux_low = 0.15,
    aux_high = 0.5,
    water_band = 1,
    density = 1,
    colors = {
      {r = 17, g = 62, b = 5},
      {r = 32, g = 76, b = 69},
      {r = 105, g = 184, b = 40},
    },
  },
  {
    name = "tree-desert-j",
    model = "09",
    noise = "tree-04",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.5,
    aux_high = 0.7,
    water_band = 1,
    density = 1,
    colors = {
      {r = 245, g = 165, b = 11},
      {r = 241, g = 238, b = 14},
      {r = 184, g = 31, b = 31},
    },
  },
  {
    name = "tree-desert-k",
    model = "09",
    noise = "tree-05",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.7,
    aux_high = 0.9,
    water_band = 1,
    density = 1,
    colors = {
      {r = 184, g = 31, b = 31},
      {r = 84, g = 17, b = 17},
      {r = 245, g = 165, b = 11},
    },
  },
  {
    name = "tree-desert-l",
    model = "09",
    noise = "tree-06",
    temperature_low = 0.15,
    temperature_high = 0.5,
    aux_low = 0.9,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 227, g = 169, b = 209},
      {r = 126, g = 28, b = 118},
      {r = 184, g = 31, b = 31},
    },
  },
  {
    name = "tree-desert-m",
    model = "09",
    noise = "tree-07",
    temperature_low = 0.0,
    temperature_high = 0.45,
    aux_low = 0.0,
    aux_high = 0.15,
    water_band = 1,
    density = 1,
    colors = {
      {r = 55, g = 22, b = 74},
      {r = 126, g = 28, b = 118},
      {r = 76, g = 61, b = 16},
      {r = 32, g = 76, b = 69},
    },
  },
  {
    name = "tree-desert-n",
    model = "09",
    noise = "tree-08",
    temperature_low = 0.0,
    temperature_high = 0.15,
    aux_low = 0.5,
    aux_high = 1,
    water_band = 1,
    density = 1,
    colors = {
      {r = 192, g = 180, b = 237},
      {r = 128, g = 28, b = 120},
      {r = 227, g = 169, b = 209},
    },
  },
  -- frozen
  {
    name = "tree-snow-a",
    model = "conifer-01",
    noise = "tree-01",
    stump = "tree-02-stump",
    temperature_low = -0.15,
    temperature_high = 0,
    aux_low = 0,
    aux_high = 1,
    density = 2,
    colors = {
      {r = 255, g = 255, b = 255},
      {r = 167, g = 198, b = 220},
      {r = 32, g = 76, b = 42},
      {r = 17, g = 62, b = 5},
    },
    tile_restriction = alien_biomes.list_tiles(alien_biomes.exclude_tags(alien_biomes.all_tiles(), {"ice", "volcanic"}))
  },
  -- volcanic
  {
    name = "tree-volcanic-a",
    model = "medusa-01",
    noise = "tree-01",
    stump = "tree-02-stump",
    temperature_low = 1,
    temperature_high = 1.25,
    aux_low = 0,
    aux_high = 1,
    density = 1,
    colors = {
      {r = 194, g = 31, b = 31},
      {r = 245, g = 165, b = 11},
      {r = 241, g = 208, b = 14},
      {r = 162, g = 99, b = 23},
    },
    tile_restriction = alien_biomes.list_tiles(alien_biomes.require_tag(alien_biomes.all_tiles(), {"heat-1"}))
  },
}
return trees
