-- globals container
DSB = {}

-- print to log for non-errors
DSB.LOGGING = false

-- "contents" of a stacked item. don't change this, bad stuff happens
DSB.STACK_SIZE = 5

-- base time for all stacking recipes, based on vanilla stack size, belt speed, machine speed, to perfectly compress a belt
DSB.CRAFT_TIME = 3*DSB.STACK_SIZE/80

-- menu order for items which are auto-generated and with hidden recipes
DSB.GLOBAL_ORDER = 0

-- tier colours e.g. stripe, map colours
DSB.TIERS = 3
DSB.TIER_COLOURS = {
	[1] = {r=225,g=165,b=10},
	[2] = {r=225,g=25,b=10},
	[3] = {r=10,g=165,b=225}
}
DSB.PREREQS = {
	[1] = {"logistics", "electronics"},
	[2] = {"logistics-2", "deadlock-stacking-1"},
	[3] = {"logistics-3", "deadlock-stacking-2"},
}
DSB.BASE_RESEARCH = {
	[1] = "logistics",
	[2] = "logistics-2",
	[3] = "logistics-3",
}

if mods["boblogistics"] then 
	DSB.TIER_COLOURS[4] = {r=10,g=225,b=25}
	DSB.TIER_COLOURS[5] = {r=165,g=10,b=225}
	DSB.PREREQS[4] = {"bob-logistics-4", "deadlock-stacking-3"}
	DSB.PREREQS[5] = {"bob-logistics-5", "deadlock-stacking-4"}
	DSB.BASE_RESEARCH[4] = "bob-logistics-4"
	DSB.BASE_RESEARCH[5] = "bob-logistics-5"
	if settings.startup["bobmods-logistics-extremelyfastbelt"].value then DSB.TIERS = 5 else DSB.TIERS = 4 end
elseif mods["FactorioExtended-Transport"] then 
	DSB.TIER_COLOURS[4] = {r=10,g=225,b=25}
	DSB.TIER_COLOURS[5] = {r=10,g=25,b=225}
	DSB.PREREQS[4] = {"logistics-4", "deadlock-stacking-3"}
	DSB.PREREQS[5] = {"logistics-5", "deadlock-stacking-4"}
	DSB.BASE_RESEARCH[4] = "logistics-4"
	DSB.BASE_RESEARCH[5] = "logistics-5"
	DSB.TIERS = 5
end

-- internal name prefixes
DSB.ITEM_PREFIX = "deadlock-stack-"
DSB.RECIPE_PREFIX = "deadlock-stacks-"
DSB.TECH_PREFIX = "deadlock-stacking-"

-- what vanilla items are stackable, and which research tier are they in
DSB.ITEM_TIER = {
	[1] = { "raw-wood", "iron-ore", "copper-ore", "stone", "coal", "iron-plate", "copper-plate", "steel-plate", "stone-brick" },
	[2] = { "copper-cable", "iron-gear-wheel", "iron-stick", "sulfur", "plastic-bar", "solid-fuel", "electronic-circuit", "advanced-circuit" },
	[3] = { "processing-unit", "battery", "uranium-ore", "uranium-235", "uranium-238" },
	[4] = {}, -- not used without other mods
	[5] = {}, -- not used without other mods
}

-- concat list of all stackable items
DSB.ITEM_LIST = {}
for i=1,DSB.TIERS do
	for i,v in pairs(DSB.ITEM_TIER[i]) do table.insert(DSB.ITEM_LIST,v) end
end

-- use custom sprites for these item stacks, better for fps
local icons = {
	"iron-plate",
	"copper-plate",
	"steel-plate",
	"stone-brick",
	"plastic-bar",
	"copper-cable",
	"iron-gear-wheel",
	"electronic-circuit",
	"advanced-circuit",
	"processing-unit",
	"raw-wood",
	"solid-fuel",
	"iron-ore",
	"copper-ore",
	"stone",
	"coal",
	"uranium-ore",
	"uranium-235",
	"uranium-238",
	"battery",
	"iron-stick",
	"sulfur",
}
DSB.ITEMS_WITH_ICONS = {}
for _,v in pairs(icons) do
	DSB.ITEMS_WITH_ICONS[v] = true
end


