local biome = require("biome")
local function autoplace_settings(noise_layer, settings)

  local peaks = {}

  --table.insert(peaks, {influence = 0.1})

  table.insert(peaks, {
    -- own layer
    influence = settings.influence or 0.6,
    noise_layer = noise_layer,
    noise_persistence = settings.noise_persistence or 0.7,
    octaves_difference = settings.octaves_difference or -1,
  })

  local terrain = {
    influence = settings.terrain_influence or 1,
    min_influence = 0,
  }
  for factor_layer, factor in pairs(settings.terrain) do
    local range = (factor[2] - factor[1]) / 2
    local step = (biome[factor_layer.."_range"][3] - biome[factor_layer.."_range"][2])/ biome[factor_layer.."_steps"]
    terrain[factor_layer.."_optimal"] = (factor[1] + factor[2]) / 2
    terrain[factor_layer.."_range"] = range
    terrain[factor_layer.."_max_range"] = range + step
  end
  table.insert(peaks, terrain)

  return { peaks = peaks }
end


local function set_tile(info)

  local tile
  if info.base then
    -- new variant
    tile = table.deepcopy(data.raw.tile[info.base]);
  else
    -- modify original
    tile = data.raw.tile[info.name]
  end

  tile.needs_correction = false
  tile.name = info.name
  tile.layer = info.layer
  tile.map_color = info.map_color
  if info.autoplace then
    tile.autoplace = autoplace_settings(tile.name, info.autoplace)
  else
    tile.autoplace = nil
  end

  local hr = tile.variants.main[1].hr_version and true or false
  --local hr = false

  tile.variants.main[1].picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile1.png"
  if hr then
    tile.variants.main[1].hr_version.picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile1.png"
  else
    tile.variants.main[1].hr_version = nil
  end
  tile.variants.main[2].picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile2.png"
  if hr then
    tile.variants.main[2].hr_version.picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile2.png"
  else
    tile.variants.main[2].hr_version = nil
  end
  tile.variants.main[3].picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile4.png"
  if hr then
    tile.variants.main[3].hr_version.picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile4.png"
  else
    tile.variants.main[3].hr_version = nil
  end
  if tile.variants.main[4] then
    tile.variants.main[4].picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile8.png"
    if hr then
      tile.variants.main[4].hr_version.picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile8.png"
    else
      tile.variants.main[4].hr_version = nil
    end
  end
  if tile.variants.main[5] then
    tile.variants.main[5].picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile16.png"
    if hr then
      tile.variants.main[5].hr_version.picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile16.png"
    else
      tile.variants.main[5].hr_version = nil
    end
  end

  tile.variants.inner_corner = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile-inner-corner.png", count = 8}
  if hr then
    tile.variants.inner_corner.hr_version = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile-inner-corner.png", count = 8, scale = 0.5}
  end

  tile.variants.outer_corner = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile-outer-corner.png", count = 8}
  if hr then
    tile.variants.outer_corner.hr_version = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile-outer-corner.png", count = 8, scale = 0.5}
  end

  tile.variants.side = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile-side.png", count = 8}
  if hr then
    tile.variants.side.hr_version = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile-side.png", count = 8, scale = 0.5}
  end

  tile.variants.u_transition = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile-u.png", count = 1}
  if hr then
    tile.variants.u_transition.hr_version = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile-u.png", count = 1, scale = 0.5}
  end

  tile.variants.o_transition = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/tile-o.png", count = 1}
  if hr then
    tile.variants.o_transition.hr_version = {picture = "__alien-biomes__/graphics/terrain/"..tile.name.."/hr-tile-o.png", count = 1, scale = 0.5}
  end

  if info.base then
    data:extend({ tile, { type = "noise-layer", name = info.name } })
  end

end

-- built in has temperature, elevation, water
--{{max_temp, max_water}, {min_temp, min_water}, influence}
-- temperatures range from 35 to -25 (°C), water from 0 to 1.
-- the peak resulting from each rectangle has a preset influence
-- within the rectangle and goes to zero after 5°C or 0.1 water level outside
-- of the rectangle.
-- Influence is optional and has default value of default_influence or 1.
-- elevation is up to 5000,  < 0 is probably water
-- roughness is -1.5 to 1.5


data.raw.tile["sand"].walking_speed_modifier = 0.9
data.raw.tile["sand"].vehicle_friction_modifier = 4
data.raw.tile["sand-dark"].walking_speed_modifier = 0.9
data.raw.tile["sand-dark"].vehicle_friction_modifier = 4
data.raw.tile["dirt"].walking_speed_modifier = 1
data.raw.tile["dirt"].vehicle_friction_modifier = 0.9
data.raw.tile["dirt-dark"].walking_speed_modifier = 1
data.raw.tile["dirt-dark"].vehicle_friction_modifier = 0.9
data.raw.tile["red-desert"].walking_speed_modifier = 1
data.raw.tile["red-desert"].vehicle_friction_modifier = 1
data.raw.tile["red-desert-dark"].walking_speed_modifier = 1
data.raw.tile["red-desert-dark"].vehicle_friction_modifier = 1

set_tile({name="grass-red",         base="grass",     layer = 6,  map_color={r=081, g=027, b=019}, autoplace = {terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[7],biome.temperature[8]}}} })
set_tile({name="grass-orange",      base="grass",     layer = 7,  map_color={r=098, g=054, b=016}, autoplace = {terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[6],biome.temperature[7]}}} })
set_tile({name="grass-yellow",      base="grass",     layer = 8,  map_color={r=118, g=080, b=014}, autoplace = {terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[5],biome.temperature[6]}}} })
set_tile({name="grass-yellow-fade", base="grass",     layer = 9,  map_color={r=096, g=072, b=017}, autoplace = {terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[4],biome.temperature[6]}}} })
set_tile({name="grass-medium",                        layer = 05, map_color={r=060, g=058, b=017}, autoplace = {terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[4],biome.temperature[5]}}} })
set_tile({name="grass",                               layer = 10, map_color={r=071, g=062, b=021}, autoplace = {terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[3],biome.temperature[4]}}} })
set_tile({name="grass-purple-fade", base="grass",     layer = 11, map_color={r=071, g=054, b=031}, autoplace = {terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="grass-purple",      base="grass",     layer = 12, map_color={r=071, g=046, b=042}, autoplace = {terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[2]}}, terrain_influence=1.1} })

set_tile({name="dirt-red-dark",     base="dirt-dark", layer = 15, map_color={r=101, g=059, b=038}, autoplace = {terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[7],biome.temperature[8]}}} })
set_tile({name="dirt-brown-dark",   base="dirt-dark", layer = 16, map_color={r=093, g=068, b=048}, autoplace = {terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[6],biome.temperature[7]}}} })
set_tile({name="grass-dry",                           layer = 04, map_color={r=064, g=052, b=021}, autoplace = {terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[4],biome.temperature[5]}}} })
set_tile({name="grass-blue-fade",   base="grass",     layer = 13, map_color={r=071, g=062, b=034}, autoplace = {terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="grass-blue",        base="grass",     layer = 14, map_color={r=063, g=062, b=045}, autoplace = {terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[1],biome.temperature[2]}}, terrain_influence=1.2} })

set_tile({name="dirt-red",          base="dirt",      layer = 21, map_color={r=123, g=071, b=046}, autoplace = {terrain={water={biome.water[3], biome.water[4]}, temperature={biome.temperature[7],biome.temperature[8]}}} })
set_tile({name="dirt-brown",        base="dirt",      layer = 22, map_color={r=129, g=095, b=065}, autoplace = {terrain={water={biome.water[3], biome.water[4]}, temperature={biome.temperature[6],biome.temperature[7]}}} })
set_tile({name="dirt-tan-dark",     base="dirt-dark", layer = 17, map_color={r=116, g=080, b=043}, autoplace = {terrain={water={biome.water[3], biome.water[5]}, temperature={biome.temperature[5],biome.temperature[6]}}} })
set_tile({name="dirt-dark",                           layer = 18, map_color={r=140, g=101, b=038}, autoplace = {terrain={water={biome.water[3], biome.water[4]}, temperature={biome.temperature[3],biome.temperature[5]}}} })
set_tile({name="dirt-dull-dark",    base="dirt-dark", layer = 19, map_color={r=108, g=087, b=059}, autoplace = {terrain={water={biome.water[3], biome.water[4]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="dirt-grey-dark",    base="dirt-dark", layer = 20, map_color={r=075, g=066, b=059}, autoplace = {terrain={water={biome.water[3], biome.water[4]}, temperature={biome.temperature[1],biome.temperature[2]}}} })

set_tile({name="red-desert-dark",                     layer = 11, map_color={r=100, g=063, b=050}, autoplace = {terrain={water={biome.water[1], biome.water[3]}, temperature={biome.temperature[7],biome.temperature[8]}}} })
set_tile({name="red-desert",                          layer = 12, map_color={r=119, g=085, b=064}, autoplace = {terrain={water={biome.water[2], biome.water[3]}, temperature={biome.temperature[5],biome.temperature[7]}}} })
set_tile({name="dirt-tan",          base="dirt",      layer = 23, map_color={r=139, g=098, b=053}, autoplace = {terrain={water={biome.water[2], biome.water[3]}, temperature={biome.temperature[4],biome.temperature[5]}}} })
set_tile({name="dirt",                                layer = 24, map_color={r=152, g=109, b=042}, autoplace = {terrain={water={biome.water[2], biome.water[3]}, temperature={biome.temperature[3],biome.temperature[4]}}} })
set_tile({name="dirt-dull",         base="dirt",      layer = 25, map_color={r=131, g=106, b=069}, autoplace = {terrain={water={biome.water[2], biome.water[3]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="dirt-grey",         base="dirt",      layer = 26, map_color={r=100, g=086, b=076}, autoplace = {terrain={water={biome.water[2], biome.water[3]}, temperature={biome.temperature[1],biome.temperature[2]}}} })

set_tile({name="sand-red-dark",     base="sand-dark", layer = 27, map_color={r=132, g=059, b=042}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[6],biome.temperature[7]}}} })
set_tile({name="sand-orange-dark",  base="sand-dark", layer = 28, map_color={r=142, g=078, b=046}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[5],biome.temperature[6]}}} })
set_tile({name="sand-gold-dark",    base="sand-dark", layer = 29, map_color={r=145, g=095, b=045}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[4],biome.temperature[5]}}} })
set_tile({name="sand-dark",                           layer = 30, map_color={r=157, g=122, b=048}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[3],biome.temperature[4]}}} })
set_tile({name="sand-dull-dark",    base="sand-dark", layer = 31, map_color={r=134, g=113, b=069}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="sand-grey-dark",    base="sand-dark", layer = 32, map_color={r=114, g=102, b=087}, autoplace = {terrain={water={biome.water[1], biome.water[2]}, temperature={biome.temperature[1],biome.temperature[2]}}} })

set_tile({name="sand-red",          base="sand",      layer = 33, map_color={r=149, g=074, b=053}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[6],biome.temperature[8]}}} })
set_tile({name="sand-orange",       base="sand",      layer = 34, map_color={r=150, g=089, b=055}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[5],biome.temperature[6]}}} })
set_tile({name="sand-gold",         base="sand",      layer = 35, map_color={r=173, g=122, b=064}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[4],biome.temperature[5]}}} })
set_tile({name="sand",                                layer = 36, map_color={r=174, g=141, b=063}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[3],biome.temperature[4]}}} })
set_tile({name="sand-dull",         base="sand",      layer = 37, map_color={r=154, g=134, b=087}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[2],biome.temperature[3]}}} })
set_tile({name="sand-grey",         base="sand",      layer = 38, map_color={r=127, g=118, b=105}, autoplace = {terrain={water={biome.water[0], biome.water[1]}, temperature={biome.temperature[1],biome.temperature[2]}}} })

set_tile({name="snow",              base="sand",      layer = 55, map_color={r=214, g=218, b=227}, autoplace = {terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[1]}}} })

set_tile({name="volcanic-cool",     base="dirt",      layer = 58, map_color={r=041, g=036, b=031}, autoplace = {terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[8],biome.temperature["e"]}}, noise_persistence=0.9} })
set_tile({name="volcanic-medium",   base="dirt",      layer = 57, map_color={r=050, g=037, b=030}, autoplace = {terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[8]+0.25,biome.temperature["e"]+0.25}}, influence = 0.65, noise_persistence=0.9} })
set_tile({name="volcanic-hot",      base="dirt",      layer = 56, map_color={r=057, g=039, b=030}, autoplace = {terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[8]+0.5,biome.temperature["e"]+0.5}}, influence = 0.7, noise_persistence=0.9} })

-- landfill
--local tile = table.deepcopy(data.raw.tile["red-desert"])
--tile.name = "landfill"
--data:extend({tile})
set_tile({name="landfill", base="red-desert-dark", layer = 59, map_color={r=080, g=075, b=070} })
data.raw.tile["landfill"].needs_correction = true

-- constructed tiles are layer 60 and above

data.raw.tile["snow"].vehicle_friction_modifier = 8
data.raw.tile["snow"].walking_speed_modifier = 0.8
data.raw.tile["volcanic-cool"].vehicle_friction_modifier = 8
data.raw.tile["volcanic-cool"].walking_speed_modifier = 0.8
data.raw.tile["volcanic-medium"].vehicle_friction_modifier = 12
data.raw.tile["volcanic-medium"].walking_speed_modifier = 0.6
data.raw.tile["volcanic-hot"].vehicle_friction_modifier = 16
data.raw.tile["volcanic-hot"].walking_speed_modifier = 0.4


local snow_volume = 0.75
data.raw.tile["snow"].walking_sound = {
  {
    filename = "__alien-biomes__/sound/walking/snow-01.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-02.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-03.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-04.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-05.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-05.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-06.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-07.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-08.ogg",
    volume = snow_volume
  },
  {
    filename = "__alien-biomes__/sound/walking/snow-10.ogg",
    volume = snow_volume
  }
}


for _, tile in pairs(data.raw.tile) do
  if tile.ageing then tile.ageing = tile.ageing / 2 end
end
data.raw.tile["landfill"].ageing = 0.0
data.raw.tile["volcanic-cool"].ageing = 0.0
data.raw.tile["volcanic-medium"].ageing = 0.0
data.raw.tile["volcanic-hot"].ageing = 0.0
data.raw.tile["water"].ageing = 0.0007
data.raw.tile["deepwater"].ageing = 0.0008
data.raw.tile["out-of-map"].ageing = 0.00001


-- fix the order
data.raw.tile["water"].order = "a[water]-a[water]"
data.raw.tile["deepwater"].order = "a[water]-b[deepwater]"
data.raw.tile["deepwater-green"].order = "a[water]-c[deepwater-green]"
data.raw.tile["water-green"].order = "a[water]-d[water-green]"

data.raw.tile["grass-red"].order = "b[grass]-a[grass-red]"
data.raw.tile["grass-orange"].order = "b[grass]-b[grass-orange]"
data.raw.tile["grass-yellow"].order = "b[grass]-c[grass-yellow]"
data.raw.tile["grass-yellow-fade"].order = "b[grass]-d[grass-yellow-fade]"
data.raw.tile["grass-dry"].order = "b[grass]-e[grass-dry]"
data.raw.tile["grass-medium"].order = "b[grass]-f[grass-medium]"
data.raw.tile["grass"].order = "b[grass]-g[grass]"
data.raw.tile["grass-blue-fade"].order = "b[grass]-h[grass-blue-fade]"
data.raw.tile["grass-blue"].order = "b[grass]-i[grass-blue]"
data.raw.tile["grass-purple-fade"].order = "b[grass]-j[grass-purple-fade]"
data.raw.tile["grass-purple"].order = "b[grass]-k[grass-purple]"

data.raw.tile["dirt-red-dark"].order = "c[dirt-dark]-a[dirt-red-dark]"
data.raw.tile["dirt-brown-dark"].order = "c[dirt-dark]-b[dirt-brown-dark]"
data.raw.tile["dirt-tan-dark"].order = "c[dirt-dark]-c[dirt-tan-dark]"
data.raw.tile["dirt-dark"].order = "c[dirt-dark]-d[dirt-dark]"
data.raw.tile["dirt-dull-dark"].order = "c[dirt-dark]-e[dirt-dull-dark]"
data.raw.tile["dirt-grey-dark"].order = "c[dirt-dark]-f[dirt-grey-dark]"
data.raw.tile["red-desert-dark"].order = "c[dirt-dark]-g[red-desert-dark]"

data.raw.tile["dirt-red"].order = "d[dirt]-a[dirt-red]"
data.raw.tile["dirt-brown"].order = "d[dirt]-b[dirt-brown]"
data.raw.tile["dirt-tan"].order = "d[dirt]-c[dirt-tan]"
data.raw.tile["dirt"].order = "d[dirt]-d[dirt]"
data.raw.tile["dirt-dull"].order = "d[dirt]-e[dirt-dull]"
data.raw.tile["dirt-grey"].order = "d[dirt]-f[dirt-grey]"
data.raw.tile["red-desert"].order = "d[dirt]-g[red-desert]"

data.raw.tile["sand-red-dark"].order = "e[sand-dark]-a[sand-red-dark]"
data.raw.tile["sand-orange-dark"].order = "e[sand-dark]-b[sand-orange-dark]"
data.raw.tile["sand-gold-dark"].order = "e[sand-dark]-c[sand-gold-dark]"
data.raw.tile["sand-dark"].order = "e[sand-dark]-d[sand-dark]"
data.raw.tile["sand-dull-dark"].order = "e[sand-dark]-e[sand-dull-dark]"
data.raw.tile["sand-grey-dark"].order = "e[sand-dark]-f[sand-grey-dark]"

data.raw.tile["sand-red"].order = "f[sand]-a[sand-red]"
data.raw.tile["sand-orange"].order = "f[sand]-b[sand-orange]"
data.raw.tile["sand-gold"].order = "f[sand]-c[sand-gold]"
data.raw.tile["sand"].order = "f[sand]-d[sand]"
data.raw.tile["sand-dull"].order = "f[sand]-e[sand-dull]"
data.raw.tile["sand-grey"].order = "f[sand]-f[sand-grey]"

data.raw.tile["snow"].order = "g[snow]-a[snow]"

data.raw.tile["volcanic-cool"].order = "h[volcanic]-a[volcanic-cool]"
data.raw.tile["volcanic-medium"].order = "h[volcanic]-b[volcanic-medium]"
data.raw.tile["volcanic-hot"].order = "h[volcanic]-c[volcanic-hot]"

data.raw.tile["landfill"].order = "i[landfill]-a[landfill]"

--log( serpent.block( data.raw.tile, {comment = false, numformat = '%1.8g' } ) )
