local biome = require("biome")
local function autoplace_settings(settings)

	local peaks = {}

	table.insert(peaks, {influence = -0.1})
	if settings.noise_layer then
		table.insert(peaks, {
				influence = 0.3,
				noise_layer = settings.noise_layer,
				noise_octaves_difference = -1,
				noise_persistence = 0.9
		})
	end

	local terrain = {
		influence = settings.terrain_influence or 0.4,
		min_influence = 0,
		noise_persistence = 0.9,
		noise_octaves_difference = -2,
	}
	for noise_layer, range in pairs(settings.terrain) do
		terrain[noise_layer.."_optimal"] = (range[1] + range[2]) / 2
		terrain[noise_layer.."_range"] = (range[2] - range[1]) / 2
		terrain[noise_layer.."_max_range"] = (range[2] - range[1]) / 2 + (biome[noise_layer.."_range"][3] - biome[noise_layer.."_range"][3])/ biome[noise_layer.."_steps"]
	end
	table.insert(peaks, terrain)

	return {
		order = "b[decorative]-z[other]",
		max_probability = (settings.max or 1) * 0.25,
		sharpness = 0.4,
		peaks = peaks
	}
end

local function replace(str, what, with)
    what = string.gsub(what, "[%(%)%.%+%-%*%?%[%]%^%$%%]", "%%%1") -- escape pattern
    with = string.gsub(with, "[%%]", "%%%%") -- escape replacement
    return string.gsub(str, what, with)
end

local function add_decorative(info)
	local doodad = table.deepcopy(data.raw["optimized-decorative"][info.base]);
	doodad.name = info.name
	doodad.autoplace = autoplace_settings(info.autoplace)
	for _, picture in pairs(doodad.pictures) do
		picture.filename = tostring(replace(picture.filename, "__base__/graphics/decorative/"..info.base, "__alien-biomes__/graphics/decorative/"..info.name))
	end
	data:extend({doodad})

  -- legacy maps
  local legacy = table.deepcopy(doodad);
  legacy.autoplace = nil
  legacy.type = "simple-entity"
  legacy.render_layer = "decorative"
  legacy.collision_mask = {"not-colliding-with-itself"}

	data:extend({legacy})

end

local red_doodad_biomes = {"red-desert", "red-desert-dark", }
for _, decorative in pairs(data.raw["optimized-decorative"]) do
  if decorative.autoplace and decorative.autoplace.tile_restriction and  decorative.autoplace.tile_restriction[1] == "red-desert" then
    decorative.autoplace.tile_restriction = red_doodad_biomes
  end
end
for _, decorative in pairs(data.raw["simple-entity"]) do
  if decorative.autoplace and decorative.autoplace.tile_restriction and  decorative.autoplace.tile_restriction[1] == "red-desert" then
    decorative.autoplace.tile_restriction = red_doodad_biomes
  end
end

--{"blue-asterisk", "blue-cane-cluster","blue-cane-single","blue-carpet-grass","yellow-carpet-grass","orange-carpet-grass","orange-carpet-grass","red-carpet-grass","blue-hairy-grass","orange-hairy-grass","purple-asterisk","purple-carpet-grass","purple-garballo","red-garballo"}
--blue-asterisk - all cold
add_decorative({name="blue-asterisk", base="brown-asterisk", autoplace={max=0.5, terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[3]}}, }})
--blue-cane-cluster  - cold non-desert

add_decorative({name="blue-cane-cluster", base="brown-cane-cluster", autoplace={max=0.45, terrain={water={biome.water[2], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[3]}}, noise_layer="brown-cane", }})
--blue-cane-single -  cold non-desert
add_decorative({name="blue-cane-single", base="brown-cane-single", autoplace={max=0.5, terrain={water={biome.water[2], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[3]}}, noise_layer="brown-cane", }})

--blue-carpet-grass - blue and purple
add_decorative({name="blue-carpet-grass", base="green-carpet-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[3]}},noise_layer="grass2", }})
--yellow-carpet-grass - green to yellow
add_decorative({name="yellow-carpet-grass", base="green-carpet-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[4],biome.temperature[6]}},noise_layer="grass2", }})
--orange-carpet-grass - yellow to orange
add_decorative({name="orange-carpet-grass", base="green-carpet-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[5],biome.temperature[7]}},noise_layer="grass1", }})
--red-carpet-grass - orange to red
add_decorative({name="red-carpet-grass", base="green-carpet-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[6],biome.temperature[8]}},noise_layer="grass2", }})

--blue-hairy-grass - blue and purple
add_decorative({name="blue-hairy-grass", base="green-hairy-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[3]}},noise_layer="grass1", }})
--orange-hairy-grass - yellow and red grass
add_decorative({name="orange-hairy-grass", base="green-hairy-grass", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[5],biome.temperature[8]}},noise_layer="grass1", }})
--purple-asterisk - any high humid
add_decorative({name="purple-asterisk", base="green-asterisk", autoplace={max=0.5, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[8]}}}})
--purple-carpet-grass - any high humid
add_decorative({name="purple-carpet-grass", base="green-carpet-grass", autoplace={max=0.5, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[3]}},noise_layer="grass2", }})
--purple-garballo - red grass
add_decorative({name="purple-garballo", base="garballo", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[7],biome.temperature[8]}},noise_layer="garballo", }})
--red-garballo - red desert and dirt
add_decorative({name="red-garballo", base="garballo", autoplace={max=0.5, terrain={water={biome.water[0], biome.water[4]}, temperature={biome.temperature[6],biome.temperature[9]}},noise_layer="garballo", }})

--log( serpent.block( data.raw["optimized-decorative"], {comment = false, numformat = '%1.8g' } ) )
