local poles = {}

local function generateIcon(entity)
  if entity.icon then
    local icons =
    {
      { icon = entity.icon,
        tint = {r=1, g=1, b=1, a=1}
      },
      { icon = "__LightedPolesPlus__/graphics/icons/lighted.png",
        tint = {r=1, g=1, b=1, a=0.85}
      },
    }
    return icons
  elseif entity.icons then
    local icons = entity.icons
    table.insert(icons, { icon = "__LightedPolesPlus__/graphics/icons/lighted.png", tint = {r=1, g=1, b=1, a=0.85} })
    return icons
  else
    --log(entity.name.." didn't contain an icon.")
    return nil
  end
end

--generate entities
for k, pole in pairs(data.raw["electric-pole"]) do
  if pole.minable then
    log("copying "..pole.name)
    local newPole = table.deepcopy(pole)
    local newName = "lighted-"..pole.name

    newPole.name = newName
    newPole.minable.result = newName
    newPole.icon = nil
    newPole.icons = generateIcon(pole)
    newPole.localised_name = {"entity-name.lighted-pole", {"entity-name." .. pole.name}}
    poles[pole.name] = newPole -- make sure we don't incidentally generate recursive poles
  end
end

 -- add entities, items, recipes
for poleName, newPole in pairs(poles) do
  local item = table.deepcopy(data.raw["item"][poleName])
  item.name = newPole.name
  item.place_result = newPole.name
  item.icon = nil
  item.icons = generateIcon(data.raw["item"][poleName])
  item.localised_name = newPole.localised_name

  newPole.icons = newPole.icons or item.icons -- use item icon for lighted pole in case base pole entity had none

  local recipe =
  {
    type = "recipe",
    name = newPole.name,
    enabled = "false",
    ingredients =
    {
      {poleName, 1},
      {"small-lamp",1}
    },
    result = newPole.name
  }

  data:extend({newPole, item, recipe})
 end

 -- add to technology
 for _, tech in pairs(data.raw["technology"]) do
  if tech.effects then
    for _, effect in pairs(tech.effects) do
      if effect.recipe and data.raw["recipe"][effect.recipe] then
        local recres = data.raw["recipe"][effect.recipe].result
        if recres and poles[recres] then
          --log("inserting "..poles[recres].name.." into technology "..tech.name)
          table.insert(data.raw["technology"][tech.name].effects, {type="unlock-recipe",recipe=poles[recres].name})
        end
      end
    end
  end
 end

 if data.raw["recipe"]["lighted-small-electric-pole"] then table.insert(data.raw["technology"]["optics"].effects,{type="unlock-recipe",recipe="lighted-small-electric-pole"}) end
