function Initialize(event)
  -- enable researched recipes
  for i, force in pairs(game.forces) do
    for _, tech in pairs(force.technologies) do
      if tech.researched then
        for _, effect in pairs(tech.effects) do
          if effect.type == "unlock-recipe" then          
            force.recipes[effect.recipe].enabled = true
          end
        end
      end
    end
  end
end


function BuiltEntity(event)
	local entity = event.created_entity

	if entity.type == "electric-pole" and string.find(entity.name, "lighted-") then
    --log("placing hidden lamp for "..entity.name.." at "..entity.position.x..","..entity.position.y )
		local lamp = entity.surface.create_entity{name = "hidden-small-lamp", position = entity.position, force = entity.force}
		lamp.destructible = false
    lamp.minable = false
	end
end


function MinedEntity(event)
	local entity = event.entity

	if entity.type == "electric-pole" and string.find(entity.name, "lighted-") then
		local found = entity.surface.find_entities_filtered {
			name = 'hidden-small-lamp',
			position = entity.position,
		}
		if found[1] then
      --log("removing hidden lamp of "..entity.name.." at "..entity.position.x..","..entity.position.y )
			found[1].destroy()
		end
	end
end

script.on_event(defines.events.on_built_entity, BuiltEntity)
script.on_event(defines.events.on_robot_built_entity, BuiltEntity)

script.on_event(defines.events.on_preplayer_mined_item, MinedEntity)
script.on_event(defines.events.on_entity_died, MinedEntity)
script.on_event(defines.events.on_robot_pre_mined, MinedEntity)

script.on_configuration_changed(Initialize)