local colors = {
  red = {r = 1.0, g = 0.0, b = 0.0},
	blue = {r = 0.2, g = 0.3, b = 1.0},
	yellow =  {r = 1, g = 0.8, b = 0.2},
	green = {r = 0.0, g = 1.0, b = 0.0},
	white = {r = 1.0, g = 1.0, b = 1.0},
}

local make_beam = function(name, color)
  return {
    type = "beam",
    name = name,
    flags = {"not-on-map"},
    width = 0.5,
    damage_interval = 20,
    light = {intensity = 0.5, size = 10},
    working_sound = {
      {
        filename = "__Laser_Beam_Turrets__/laser-beam-01.ogg",
        volume = 0.9
      },
      {
        filename = "__Laser_Beam_Turrets__/laser-beam-02.ogg",
        volume = 0.9
      },
      {
        filename = "__Laser_Beam_Turrets__/laser-beam-03.ogg",
        volume = 0.9
      }
    },
    action = {
      type = "direct",
      action_delivery = {
        type = "instant",
        target_effects = {
          {
            type = "damage",
            damage = {amount = 20, type = "laser"}
          }
        }
      }
    },
    head = {
      filename = "__Laser_Beam_Turrets__/laser-beam-head-2.png",
      line_length = 16,
      tint = color,
      frame_count = 12,
      x = 45 * 4,
      width = 45,
      height = 1,
      priority = "high",
      animation_speed = 0.5,
      blend_mode = "additive-soft"
    },
    start = {
      filename = "__Laser_Beam_Turrets__/laser-beam-head-2.png",
      line_length = 16,
      tint = color,
      frame_count = 12,
      x = 45 * 4,
      width = 45,
      height = 1,
      priority = "high",
      animation_speed = 0.5,
      blend_mode = "additive-soft"
    },
	ending = {
      filename = "__Laser_Beam_Turrets__/laser-beam-head-2.png",
      line_length = 16,
      tint = color,
      frame_count = 12,
      x = 45 * 4,
      width = 45,
      height = 1,
      priority = "high",
      animation_speed = 0.5,
      blend_mode = "additive-soft"
    },
    tail = {
      filename = "__Laser_Beam_Turrets__/laser-beam-tail-3.png",
      line_length = 16,
      tint = color,
      frame_count = 12,
      x = 48 * 4,
      width = 48,
      height = 24,
      priority = "high",
      animation_speed = 0.5,
      blend_mode = "additive-soft"
    },
    body = {
      {
        filename = "__Laser_Beam_Turrets__/laser-beam-body-2.png",
        line_length = 16,
        tint = color,
        frame_count = 12,
        x = 48 * 4,
        width = 48,
        height = 24,
        priority = "high",
        animation_speed = 0.5,
        blend_mode = "additive-soft"
      }
    }
  }
end

for name, color in pairs (colors) do
	local name = "laser-beam-"..name
	data:extend({make_beam(name, color)})
end

local make_attack_parameters = function(param)
	local param = param or {}
	return {
		type = "beam",
		ammo_category = "electric",
		cooldown = 20,
		--projectile_center = {0, -0.2},
		--projectile_creation_distance = 1.4,
		range = param.range or 25,
		damage_modifier = param.damage_modifier or 1,
		sound = {
			{
				filename = "__Laser_Beam_Turrets__/laser-beam-01.ogg",
				volume = 0.9
			},
			{
				filename = "__Laser_Beam_Turrets__/laser-beam-02.ogg",
				volume = 0.9
			},
			{
				filename = "__Laser_Beam_Turrets__/laser-beam-03.ogg",
				volume = 0.9
			}
		},
		ammo_type = {
			category = "laser-turret",
			energy_consumption = param.energy_consumption or "800kJ",
			action = {
				type = "direct",
				action_delivery = {
					type = "beam",
					beam = param.beam or "laser-beam-red",
					max_length = param.range or 25,
					duration = 20,
					source_offset = {0, -1.3}
				}
			}
		}
	}
end

data.raw["electric-turret"]["laser-turret"].attack_parameters = make_attack_parameters()

if data.raw["electric-turret"]["bob-laser-turret-2"] then
	data.raw["electric-turret"]["bob-laser-turret-2"].attack_parameters = make_attack_parameters{range = 26.25, damage_modifier = 1.5, energy_consumption = "1000kJ", beam = "laser-beam-blue"}
  data.raw["electric-turret"]["bob-laser-turret-3"].attack_parameters = make_attack_parameters{range = 27.5, damage_modifier = 2.1, energy_consumption = "1200kJ", beam = "laser-beam-green"}
  data.raw["electric-turret"]["bob-laser-turret-4"].attack_parameters = make_attack_parameters{range = 28.75, damage_modifier = 2.8, energy_consumption = "1400kJ", beam = "laser-beam-yellow"}
  data.raw["electric-turret"]["bob-laser-turret-5"].attack_parameters = make_attack_parameters{range = 30, damage_modifier = 3.6, energy_consumption = "1600kJ", beam = "laser-beam-red"}
end
