local DCL = require("prototypes.shared")
if DCL.PARADOX then return end

-- generate research by tier, only if base research and corresponding items exist
for i=1,DCL.TIERS do
	if data.raw.technology[DCL.BASE_RESEARCH[i]] and data.raw["transport-belt"][DCL.BELTS[i]] then
		local recipe_effects = {
			{
			type = "unlock-recipe",
			recipe = "deadlock-loader-recipe-"..i,
			},
		}
		local research = table.deepcopy(data.raw.technology[DCL.BASE_RESEARCH[i]])
		research.effects = recipe_effects
		research.icon = "__DeadlockLoaders__/graphics/deadlock-loaders.png"
		research.name = "deadlock-loaders-"..i
		research.unit.count = research.unit.count * 1.5
		research.prerequisites = DCL.PREREQS[i]
		research.upgrade = false
		data:extend({research})
	end
end