local DCL = {}

-- print to log for non-errors
DCL.LOGGING = false
function DCL.debug(message)
	if DCL.LOGGING then log("DCL: "..message) end
end

-- loaders without loaders. the spice must flow
DCL.PARADOX = settings.startup["deadlock-loaders-paradox-mode"].value

-- how many tech tiers?
DCL.TIERS = 3

-- tier colours
DCL.TIER_COLOURS = {
	[1] = {r=225,g=165,b=10,a=255},
	[2] = {r=225,g=25,b=10,a=255},
	[3] = {r=10,g=165,b=225,a=255}
}

-- vanilla entities
DCL.LOADERS  = {
	[1] = "loader",
	[2] = "fast-loader",
	[3] = "express-loader",
}
DCL.BELTS = {
	[1] = "transport-belt",
	[2] = "fast-transport-belt",
	[3] = "express-transport-belt",
}
DCL.UNDERGROUND = {
	[1] = "underground-belt",
	[2] = "fast-underground-belt",
	[3] = "express-underground-belt",
}
DCL.SPLITTERS = {
	[1] = "splitter",
	[2] = "fast-splitter",
	[3] = "express-splitter",
}
DCL.BELT_COMPONENTS = {
    ["belt_horizontal"] = 0,
    ["belt_vertical"] = 80,
    ["ending_top"] = 160,
    ["ending_bottom"] = 240,
    ["ending_side"] = 320,
    ["starting_top"] = 400,
    ["starting_bottom"] = 480,
    ["starting_side"] = 560,
}
DCL.LOCALISATION_PREFIX = "deadlock"

-- research
DCL.BASE_RESEARCH = {
	[1] = "logistics",
	[2] = "logistics-2",
	[3] = "logistics-3",
}
DCL.PREREQS = {
	[1] = {"logistics", "electronics"},
	[2] = {"logistics-2", "deadlock-loaders-1"},
	[3] = {"logistics-3", "deadlock-loaders-2"},
}

if mods["xander-mod"] then
	DCL.TIERS = 5
	DCL.TIER_COLOURS[3] = {r=10,g=225,b=25,a=255}
	DCL.TIER_COLOURS[4] = {r=10,g=165,b=225,a=255}
	DCL.TIER_COLOURS[5] = {r=166,g=166,b=110,a=255}
	DCL.BELTS[3] = "expedited-transport-belt"
	DCL.BELTS[4] = "express-transport-belt"
	DCL.BELTS[5] = "slow-transport-belt"
	DCL.UNDERGROUND[3] = "expedited-underground-belt"
	DCL.UNDERGROUND[4] = "express-underground-belt"
	DCL.UNDERGROUND[5] = "slow-underground-belt"
	DCL.SPLITTERS[3] = "expedited-splitter"
	DCL.SPLITTERS[4] = "express-splitter"
	DCL.SPLITTERS[5] = "slow-splitter"
	DCL.PREREQS[4] = {"logistics-4", "deadlock-loaders-3"}
	DCL.BASE_RESEARCH[4] = "logistics-4"
    DCL.LOCALISATION_PREFIX = "xander"
elseif mods["boblogistics"] then 
	DCL.TIERS = 6
	DCL.TIER_COLOURS[4] = {r=165,g=10,b=225,a=255}
	DCL.TIER_COLOURS[5] = {r=10,g=225,b=25,a=255}
	DCL.TIER_COLOURS[6] = {r=192,g=192,b=192,a=255}
	DCL.BELTS[4] = "turbo-transport-belt"
	DCL.BELTS[5] = "ultimate-transport-belt"
	DCL.BELTS[6] = "basic-transport-belt"
	DCL.UNDERGROUND[4] = "turbo-underground-belt"
	DCL.UNDERGROUND[5] = "ultimate-underground-belt"
	DCL.UNDERGROUND[6] = "basic-underground-belt"
	DCL.SPLITTERS[4] = "turbo-splitter"
	DCL.SPLITTERS[5] = "ultimate-splitter"
	DCL.SPLITTERS[6] = "basic-splitter"
	DCL.PREREQS[4] = {"bob-logistics-4", "deadlock-loaders-3"}
	DCL.PREREQS[5] = {"bob-logistics-5", "deadlock-loaders-4"}
	DCL.BASE_RESEARCH[4] = "bob-logistics-4"
	DCL.BASE_RESEARCH[5] = "bob-logistics-5"
    DCL.LOCALISATION_PREFIX = "bob"
elseif mods["FactorioExtended-Transport"] then 
	DCL.TIERS = 5
	DCL.TIER_COLOURS[4] = {r=10,g=225,b=25,a=255}
	DCL.TIER_COLOURS[5] = {r=10,g=25,b=225,a=255}
	DCL.BELTS[4] = "blistering-transport-belt"
	DCL.BELTS[5] = "furious-transport-belt"
	DCL.UNDERGROUND[4] = "blistering-transport-belt-to-ground"
	DCL.UNDERGROUND[5] = "furious-transport-belt-to-ground"
	DCL.SPLITTERS[4] = "blistering-splitter"
	DCL.SPLITTERS[5] = "furious-splitter"
	DCL.PREREQS[4] = {"logistics-4", "deadlock-loaders-3"}
	DCL.PREREQS[5] = {"logistics-5", "deadlock-loaders-4"}
	DCL.BASE_RESEARCH[4] = "logistics-4"
	DCL.BASE_RESEARCH[5] = "logistics-5"
    DCL.LOCALISATION_PREFIX = "factorioextended"
end

function DCL.multiply_colour(colour, factor)
	return {r=colour.r*factor, g=colour.g*factor, b=colour.b*factor, a=colour.a}
end

return DCL