local DCL = require("prototypes.shared")
if DCL.PARADOX then return end

-- crafting tab groups
if not data.raw["item-subgroup"]["beltboxes"] then data:extend({
	{
	type = "item-subgroup",
	name = "beltboxes",
	group = "logistics",
	order = "bb",
	},
})
end

-- loader recipe ingredients per tier
local prereq_item1 = {
	[1] = {"transport-belt",2},
	[2] = {"deadlock-loader-item-1",1},
	[3] = {"deadlock-loader-item-2",1},
	[4] = {"deadlock-loader-item-3",1},
	[5] = {"deadlock-loader-item-4",1},
}
local prereq_item2 = {
	[1] = {"electronic-circuit",2},
	[2] = {"advanced-circuit",1},
	[3] = {amount = 80, name = "lubricant", type = "fluid"},
	[4] = {"processing-unit",1},
	[5] = {"processing-unit",4},
}
local crafting_category = {
	[1] = "crafting",
	[2] = "crafting",
	[3] = "crafting-with-fluid",
	[4] = "crafting",
	[5] = "crafting",
}

-- loader recipes
for i=1,DCL.TIERS do
    if data.raw["transport-belt"][DCL.BELTS[i]] then
        data:extend({
            {
            type = "recipe",
            name = "deadlock-loader-recipe-"..i,
            localised_name = {"entity-name."..DCL.LOCALISATION_PREFIX.."-loader-"..i},
            localised_description = {"entity-description.deadlock-loader"},
            category = crafting_category[i],
            group = "logistics",
            subgroup = "beltboxes",
            order = string.char(105+i),
            enabled = false,
            ingredients = {
             prereq_item1[i],
             {"iron-plate",i*5},
             {"iron-gear-wheel",i*5},
             prereq_item2[i],
            },
            result = "deadlock-loader-item-"..i,
            energy_required = 2.0,
            },
        })
    end
end
