local DCL = require("prototypes.shared")
if DCL.PARADOX then return end

-- compact loaders
for i=1,DCL.TIERS do
    if data.raw["transport-belt"][DCL.BELTS[i]] then
        data:extend({
            {
                type = "item",
                name = "deadlock-loader-item-"..i,
                localised_name = {"entity-name."..DCL.LOCALISATION_PREFIX.."-loader-"..i},
                localised_description = {"entity-description.deadlock-loader"},
                icons = {
                    { icon = "__DeadlockLoaders__/graphics/loader-icon-base.png" },
                    { icon = "__DeadlockLoaders__/graphics/loader-icon-mask.png", tint = DCL.TIER_COLOURS[i] },
                },
                icon_size = 32,
                stack_size = 50,
                flags = { "goes-to-quickbar" },
                place_result = "deadlock-loader-entity-"..i,
                group = "logistics",
                subgroup = "beltboxes",
                order = string.char(97+i),
            }
        })
    end
end