local DCL = require("prototypes.shared")

if not DCL.PARADOX then
    -- the loader entity
    for i=1,DCL.TIERS do
        if data.raw["transport-belt"][DCL.BELTS[i]] then
            local entity = table.deepcopy(data.raw["loader"]["loader"])
            entity.name = "deadlock-loader-entity-"..i
            entity.localised_name = {"entity-name."..DCL.LOCALISATION_PREFIX.."-loader-"..i}
            entity.localised_description = {"entity-description.deadlock-loader"}
            entity.icons = data.raw["item"]["deadlock-loader-item"..i]
            entity.icon_size = 32
            entity.map_color = DCL.multiply_colour(DCL.TIER_COLOURS[i], 0.833)
            entity.vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 1.0 }	
            entity.open_sound = { filename = "__base__/sound/wooden-chest-open.ogg", volume = 1.0 }	
            entity.close_sound = { filename = "__base__/sound/wooden-chest-close.ogg", volume = 1.0 }	
            entity.collision_box = { {-0.2, -0.2}, {0.2, 0.2} }
            entity.collision_mask = {"item-layer", "object-layer", "player-layer", "water-tile"}
            entity.selection_box = { {-0.5, -0.5}, {0.5, 0.5} }
            entity.minable = { hardness = 0.2, mining_time = 0.5, result = "deadlock-loader-item-"..i }
            entity.belt_distance = 0
            entity.container_distance = 1.0
            entity.belt_length = 0.5
            entity.speed = data.raw["transport-belt"][DCL.BELTS[i]].speed
            entity.structure = {
                direction_in = {
                    sheets = {
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-loader-base.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                shift = { 0.125, 0 }
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-loader-base.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            shift = { 0.125, 0 }
                        },
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-loader-mask.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                tint = DCL.TIER_COLOURS[i],
                                shift = { 0.125, 0 }
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-loader-mask.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            tint = DCL.TIER_COLOURS[i],
                            shift = { 0.125, 0 }
                        },
                    },
                },
                direction_out = {
                    sheets = {
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-loader-base.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                shift = { 0.125, 0 },
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-loader-base.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            shift = { 0.125, 0 },
                        },
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-loader-mask.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                tint = DCL.TIER_COLOURS[i],
                                shift = { 0.125, 0 },
                                y = 64
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-loader-mask.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            tint = DCL.TIER_COLOURS[i],
                            shift = { 0.125, 0 },
                            y = 32
                        },
                    },
                }
            }
            -- do it
            data:extend({entity})
        end
    end
end
    
-- functions for belt styling
local function generate_layer(target, filename, w, h, ll, fc, y, s, nc)
    if not target then return nil end
    target.filename = filename
    target.width = w
    target.height = h
    target.line_length = ll
    target.frame_count = fc
    target.y = y
    target.scale = s
    target.priority = "extra-high"
    if nc then target.flags = { "no-crop", "low-object" } end
    return target
end

local function generate_belt_graphic(target, tier, y, nc)
    if not target then return nil end
    local new = { layers = {} }
    local sheets = {"belt-base", "belt-mask"}
    for i,sheet in ipairs(sheets) do
        new.layers[i] = table.deepcopy(target)
        if not new.layers[i].hr_version then new.layers[i].hr_version = table.deepcopy(target) end
        new.layers[i] = generate_layer(new.layers[i], "__DeadlockLoaders__/graphics/lr-"..sheet..".png", 40, 40, 32, 32, y/2, 1.0, nc)
        new.layers[i].hr_version = generate_layer(new.layers[i].hr_version, "__DeadlockLoaders__/graphics/hr-"..sheet..".png", 80, 80, 32, 32, y, 0.5, nc)
        if sheet == "belt-mask" then
            new.layers[i].hr_version.tint = DCL.TIER_COLOURS[tier]
            new.layers[i].tint = DCL.TIER_COLOURS[tier]
        end
    end
    return new
end

-- optionally restyle belts
if not mods["DeadlockIndustry"] and settings.startup["deadlock-loaders-belt-style"].value then
	for tier=1,DCL.TIERS do
        for i,proto in pairs( {data.raw["loader"]["deadlock-loader-entity-"..tier], data.raw["loader"][DCL.LOADERS[tier]], data.raw["transport-belt"][DCL.BELTS[tier]], data.raw["splitter"][DCL.SPLITTERS[tier]], data.raw["underground-belt"][DCL.UNDERGROUND[tier]]} ) do
            if proto then
                proto.animations = generate_belt_graphic(proto.animations, tier, 0, true)
                for bc,y in pairs(DCL.BELT_COMPONENTS) do
                    proto[bc] = generate_belt_graphic(proto[bc], tier, y, true)
                end
                proto.animation_speed_coefficient = 32
                proto.ending_patch = {
                    sheet = {
                        filename = "__DeadlockLoaders__/graphics/blank.png",
                        height = 1,
                        width = 1,
                        priority = "low",
                    }
                }
                DCL.debug("\n\nDUMP: "..proto.name.."\n\n"..serpent.block(proto).."\n\n")
            end
        end
    end
elseif not DCL.PARADOX then
	for i=1,DCL.TIERS do
        local entity = data.raw["loader"]["deadlock-loader-entity-"..i]
        if entity then
            for bc,y in pairs(DCL.BELT_COMPONENTS) do
                entity[bc] = generate_layer(entity[bc],
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].filename,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].width,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].height,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].line_length,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].frame_count,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].y,
                    data.raw["transport-belt"][DCL.BELTS[i]][bc].scale
                )
                if (data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version) then
                    entity[bc].hr_version = generate_layer(entity[bc].hr_version,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.filename,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.width,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.height,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.line_length,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.frame_count,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.y,
                        data.raw["transport-belt"][DCL.BELTS[i]][bc].hr_version.scale
                    )
                end
            end
        end
    end
end

-- optionally restyle underneathies
if settings.startup["deadlock-loaders-underneathie-style"].value then
	for i=1,DCL.TIERS do
		local entity = data.raw["underground-belt"][DCL.UNDERGROUND[i]]
        if entity then
            entity.structure = {
                direction_in = {
                    sheets = {
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-under-base.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                shift = { 0.125, 0 },
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-under-base.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            shift = { 0.125, 0 },
                        },
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-under-mask.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                tint = DCL.TIER_COLOURS[i],
                                shift = { 0.125, 0 },
                                y = 64,
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-under-mask.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            tint = DCL.TIER_COLOURS[i],
                            shift = { 0.125, 0 },
                            y = 32,
                        },
                    },
                },
                direction_out = {
                    sheets = {
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-under-base.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                shift = { 0.125, 0 },
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-under-base.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            shift = { 0.125, 0 },
                        },
                        {
                            hr_version = {
                                filename = "__DeadlockLoaders__/graphics/hr-under-mask.png",
                                height = 64,
                                priority = "extra-high",
                                width = 80,
                                scale = 0.5,
                                tint = DCL.TIER_COLOURS[i],
                                shift = { 0.125, 0 },
                            },
                            filename = "__DeadlockLoaders__/graphics/lr-under-mask.png",
                            height = 32,
                            priority = "extra-high",
                            width = 40,
                            scale = 1,
                            tint = DCL.TIER_COLOURS[i],
                            shift = { 0.125, 0 },
                        },
                    },
                }
            }
            local item = data.raw["item"][DCL.UNDERGROUND[i]]
            item.icon = nil
            item.icons = {
                    { icon = "__DeadlockLoaders__/graphics/under-icon-base.png" },
                    { icon = "__DeadlockLoaders__/graphics/under-icon-mask.png", tint = DCL.TIER_COLOURS[i] },
            }
            item.icon_size = 32
            entity.icon = nil
            entity.icons = item.icons
            entity.icon_size = 32
        end
	end
end

