require "prototypes.globals"
require "prototypes.functions"

-- generate research by tier, only if base research exists
for i=1,TIERS do
	if data.raw.technology[BASE_RESEARCH[i]] then
		local recipe_effects = {
			{
			type = "unlock-recipe",
			recipe = "deadlock-loader-recipe-"..i,
			},
		}
		local research = table.deepcopy(data.raw.technology[BASE_RESEARCH[i]])
		research.effects = recipe_effects
		research.icon = "__DeadlockLoaders__/graphics/deadlock-loaders.png"
		research.name = "deadlock-loaders-"..i
		research.unit.count = research.unit.count * 1.5
		research.prerequisites = PREREQS[i]
		research.upgrade = false
		data:extend({research})
	else
		debug("Skipping research tier "..i..", no base exists")
	end
end