require("prototypes.globals")
require("prototypes.functions")

-- compact loaders
for i=1,TIERS do
	data:extend({
		{
			type = "item",
			name = "deadlock-loader-item-"..i,
			localised_name = {"item-name.deadlock-loader-"..i},
			icons = {
				{ icon = "__DeadlockLoaders__/graphics/loader-icon-base"..THEME_SUFFIX..".png" },
				{ icon = "__DeadlockLoaders__/graphics/loader-icon-mask.png", tint = TIER_COLOURS[i] },
			},
			icon_size = 32,
			stack_size = 50,
			flags = { "goes-to-quickbar" },
			place_result = "deadlock-loader-entity-"..i,
			group = "logistics",
			subgroup = "beltboxes",
			order = string.char(97+i),
		}
	})
end