-- print to log for non-errors
LOGGING = true

-- theme
THEME_SUFFIX = ""
--if settings.startup["deadlock-loaders-theme"].value == "Brass" then THEME_SUFFIX = "-brass" end

-- tier colours e.g. stripe, map colours
TIER_COLOURS = {
	[1] = {r=225,g=165,b=10,a=255},
	[2] = {r=225,g=25,b=10,a=255},
	[3] = {r=10,g=165,b=225,a=255}
}

-- how many technology tiers? support bob's logistics & factorioextended
TIERS = 3
LOADERS  = {
	[1] = "loader",
	[2] = "fast-loader",
	[3] = "express-loader",
	[4] = "express-loader",
	[5] = "express-loader",
}
BELTS = {
	[1] = "transport-belt",
	[2] = "fast-transport-belt",
	[3] = "express-transport-belt",
}
UNDERGROUND = {
	[1] = "underground-belt",
	[2] = "fast-underground-belt",
	[3] = "express-underground-belt",
}
BELT_COMPONENTS = {"belt_horizontal", "belt_vertical", "ending_bottom", "ending_side", "ending_top", "starting_bottom", "starting_side", "starting_top"}
PREREQS = {
	[1] = {"logistics"},
	[2] = {"logistics-2", "deadlock-loaders-1"},
	[3] = {"logistics-3", "deadlock-loaders-2"},
}
BASE_RESEARCH = {
	[1] = "logistics",
	[2] = "logistics-2",
	[3] = "logistics-3",
}

if mods["boblogistics"] then 
	TIER_COLOURS[4] = {r=10,g=225,b=25,a=255}
	TIER_COLOURS[5] = {r=165,g=10,b=225,a=255}
	BELTS[4] = "green-transport-belt"
	BELTS[5] = "purple-transport-belt"
	UNDERGROUND[4] = "green-underground-belt"
	UNDERGROUND[5] = "purple-underground-belt"
	PREREQS[4] = {"bob-logistics-4", "deadlock-loaders-3"}
	PREREQS[5] = {"bob-logistics-5", "deadlock-loaders-4"}
	BASE_RESEARCH[4] = "bob-logistics-4"
	BASE_RESEARCH[5] = "bob-logistics-5"
	if settings.startup["bobmods-logistics-extremelyfastbelt"].value then TIERS = 5 else TIERS = 4 end
elseif mods["FactorioExtended-Transport"] then 
	TIER_COLOURS[4] = {r=10,g=225,b=25,a=255}
	TIER_COLOURS[5] = {r=10,g=25,b=225,a=255}
	BELTS[4] = "blistering-transport-belt"
	BELTS[5] = "furious-transport-belt"
	UNDERGROUND[4] = "blistering-transport-belt-to-ground"
	UNDERGROUND[5] = "furious-transport-belt-to-ground"
	PREREQS[4] = {"logistics-4", "deadlock-loaders-3"}
	PREREQS[5] = {"logistics-5", "deadlock-loaders-4"}
	BASE_RESEARCH[4] = "logistics-4"
	BASE_RESEARCH[5] = "logistics-5"
	TIERS = 5
end

