require("prototypes.globals")

-- the loader entity
for i=1,TIERS do
	local entity = table.deepcopy(data.raw["loader"][LOADERS[i]])
	entity.name = "deadlock-loader-entity-"..i
	entity.localised_name = {"entity-name.deadlock-loader-"..i}
	entity.icons = data.raw["item"]["deadlock-loader-item"..i]
	entity.icon_size = 32
	entity.map_color = multiply_colour(TIER_COLOURS[i], 0.833)
	entity.vehicle_impact_sound = { filename = "__base__/sound/car-metal-impact.ogg", volume = 1.0 }	
	entity.open_sound = { filename = "__base__/sound/wooden-chest-open.ogg", volume = 1.0 }	
	entity.close_sound = { filename = "__base__/sound/wooden-chest-close.ogg", volume = 1.0 }	
	entity.collision_box = { {-0.45, -0.45}, {0.45, 0.45} }
	entity.collision_mask = {"item-layer", "object-layer", "player-layer", "water-tile"}
	entity.selection_box = { {-0.5, -0.5}, {0.5, 0.5} }
    entity.minable = { hardness = 0.2, mining_time = 0.5, result = "deadlock-loader-item-"..i }
	entity.belt_distance = 0
    entity.container_distance = 1.0
    entity.belt_length = 0.5
	entity.speed = 0.03125 * i
	entity.structure = {
		direction_in = {
			sheets = {
				{
					hr_version = {
						filename = "__DeadlockLoaders__/graphics/hr-loader-base"..THEME_SUFFIX..".png",
						height = 64,
						priority = "extra-high",
						width = 80,
						scale = 0.5,
						shift = { 0.125, 0 }
					},
					filename = "__DeadlockLoaders__/graphics/lr-loader-base"..THEME_SUFFIX..".png",
					height = 32,
					priority = "extra-high",
					width = 40,
					scale = 1,
					shift = { 0.125, 0 }
				},
				{
					hr_version = {
						filename = "__DeadlockLoaders__/graphics/hr-loader-mask.png",
						height = 64,
						priority = "extra-high",
						width = 80,
						scale = 0.5,
						tint = TIER_COLOURS[i],
						shift = { 0.125, 0 }
					},
					filename = "__DeadlockLoaders__/graphics/lr-loader-mask.png",
					height = 32,
					priority = "extra-high",
					width = 40,
					scale = 1,
					tint = TIER_COLOURS[i],
					shift = { 0.125, 0 }
				},
			},
		},
		direction_out = {
			sheets = {
				{
					hr_version = {
						filename = "__DeadlockLoaders__/graphics/hr-loader-base"..THEME_SUFFIX..".png",
						height = 64,
						priority = "extra-high",
						width = 80,
						scale = 0.5,
						shift = { 0.125, 0 },
					},
					filename = "__DeadlockLoaders__/graphics/lr-loader-base"..THEME_SUFFIX..".png",
					height = 32,
					priority = "extra-high",
					width = 40,
					scale = 1,
					shift = { 0.125, 0 },
				},
				{
					hr_version = {
						filename = "__DeadlockLoaders__/graphics/hr-loader-mask.png",
						height = 64,
						priority = "extra-high",
						width = 80,
						scale = 0.5,
						tint = TIER_COLOURS[i],
						shift = { 0.125, 0 },
						y = 64
					},
					filename = "__DeadlockLoaders__/graphics/lr-loader-mask.png",
					height = 32,
					priority = "extra-high",
					width = 40,
					scale = 1,
					tint = TIER_COLOURS[i],
					shift = { 0.125, 0 },
					y = 32
				},
			},
		}
	}
	-- bob's nasty low-res belts
	if mods["boblogistics"] and i > 3 then
		for _,v in pairs(BELT_COMPONENTS) do
			entity[v]["filename"] = "__boblogistics__/graphics/entity/transport-belt/"..BELTS[i]..".png"
			entity[v]["hr_version"] = nil
		end
	elseif mods["FactorioExtended-Transport"] and i > 3 then
		for _,v in pairs(BELT_COMPONENTS) do
			entity[v]["filename"] = "__FactorioExtended-Transport__/graphics/entity/transport-belt/"..BELTS[i]..".png"
			entity[v]["hr_version"]["filename"] = "__FactorioExtended-Transport__/graphics/entity/transport-belt/hr-"..BELTS[i]..".png"
		end
	end
	data:extend({entity})
	--log(serpent.block(entity))
end

-- optionally restyle underneathies
if settings.startup["deadlock-loaders-underneathie-style"].value then
	for i=1,TIERS do
		entity = data.raw["underground-belt"][UNDERGROUND[i]]
		entity.structure = {
			direction_in = {
				sheets = {
					{
						hr_version = {
							filename = "__DeadlockLoaders__/graphics/hr-under-base"..THEME_SUFFIX..".png",
							height = 64,
							priority = "extra-high",
							width = 80,
							scale = 0.5,
							shift = { 0.125, 0 },
						},
						filename = "__DeadlockLoaders__/graphics/lr-under-base"..THEME_SUFFIX..".png",
						height = 32,
						priority = "extra-high",
						width = 40,
						scale = 1,
						shift = { 0.125, 0 },
					},
					{
						hr_version = {
							filename = "__DeadlockLoaders__/graphics/hr-under-mask.png",
							height = 64,
							priority = "extra-high",
							width = 80,
							scale = 0.5,
							tint = TIER_COLOURS[i],
							shift = { 0.125, 0 },
							y = 64,
						},
						filename = "__DeadlockLoaders__/graphics/lr-under-mask.png",
						height = 32,
						priority = "extra-high",
						width = 40,
						scale = 1,
						tint = TIER_COLOURS[i],
						shift = { 0.125, 0 },
						y = 32,
					},
				},
			},
			direction_out = {
				sheets = {
					{
						hr_version = {
							filename = "__DeadlockLoaders__/graphics/hr-under-base"..THEME_SUFFIX..".png",
							height = 64,
							priority = "extra-high",
							width = 80,
							scale = 0.5,
							shift = { 0.125, 0 },
						},
						filename = "__DeadlockLoaders__/graphics/lr-under-base"..THEME_SUFFIX..".png",
						height = 32,
						priority = "extra-high",
						width = 40,
						scale = 1,
						shift = { 0.125, 0 },
					},
					{
						hr_version = {
							filename = "__DeadlockLoaders__/graphics/hr-under-mask.png",
							height = 64,
							priority = "extra-high",
							width = 80,
							scale = 0.5,
							tint = TIER_COLOURS[i],
							shift = { 0.125, 0 },
						},
						filename = "__DeadlockLoaders__/graphics/lr-under-mask.png",
						height = 32,
						priority = "extra-high",
						width = 40,
						scale = 1,
						tint = TIER_COLOURS[i],
						shift = { 0.125, 0 },
					},
				},
			}
		}
		local item = data.raw["item"][UNDERGROUND[i]]
		item.icon = nil
		item.icons = {
				{ icon = "__DeadlockLoaders__/graphics/under-icon-base"..THEME_SUFFIX..".png" },
				{ icon = "__DeadlockLoaders__/graphics/under-icon-mask.png", tint = TIER_COLOURS[i] },
		}
		item.icon_size = 32
		entity.icon = nil
		entity.icons = item.icons
		entity.icon_size = 32
	end
end

