require "prototypes.globals"

-- debug logging
function debug(message)
	if LOGGING then log(message) end
end

-- generate items and recipes for crated vanilla items
GLOBAL_ORDER = 0
function generate_crates(this_item, crateitem, subgroup)
	-- The crated item
	if not data.raw.item[this_item] then
		log("ERROR: DCM asked to crate an item that doesn't exist ("..this_item..")")
		return
	end
	local menu_order = string.format("%03d",GLOBAL_ORDER)
	GLOBAL_ORDER = GLOBAL_ORDER + 1	
	local itemcopy = table.deepcopy(data.raw.item[this_item])
	local new_stack_size = itemcopy.stack_size/STACK_DIVIDER
	itemcopy.name = "deadlock-crate-" .. this_item
	itemcopy.localised_name = {"item-name.deadlock-crate-item", new_stack_size, {"item-name." .. this_item}}
	itemcopy.order = menu_order
	itemcopy.icons = {
		{
			icon = "__base__/graphics/icons/"..crateitem..".png",
		},
		{
			icon = itemcopy.icon,
			scale = 0.75,
			shift = {0, 0},
			tint = {r=0,g=0,b=0,a=0.75},
		},
		{
			icon = itemcopy.icon,
			scale = 0.65,
			shift = {0, 0},
		},
	}
	itemcopy.stack_size = STACK_DIVIDER
	itemcopy.subgroup = "deadlock-crates-pack-"..subgroup
	itemcopy.place_as_tile = nil
	itemcopy.fuel_value = nil
	itemcopy.fuel_category = nil
	itemcopy.fuel_acceleration_multiplier = nil
	itemcopy.fuel_top_speed_multiplier = nil
	itemcopy.overload_multiplier = 16
	itemcopy.allow_decomposition = false
	itemcopy.main_product = nil
	-- The packing recipe
	data:extend { itemcopy,
		{
			type = "recipe",
			name = "deadlock-packrecipe-"..this_item,
			localised_name = {"recipe-name.deadlock-packing-recipe", {"item-name." .. this_item}},
			order = menu_order,
			category = "packing",
			subgroup = "deadlock-crates-pack-"..subgroup,
			enabled = false,
			ingredients = {
				{crateitem,1},
				{this_item,new_stack_size},
			},
			icon_size = 32,
			icons = {
				{
					icon = "__base__/graphics/icons/"..crateitem..".png",
				},
				{
					icon = itemcopy.icon,
					scale = 0.75,
					shift = {0, 0},
					tint = {r=0,g=0,b=0,a=0.75},
				},
				{
					icon = itemcopy.icon,
					scale = 0.65,
					shift = {0, 0},
				},
				{
					icon = "__DeadlockCrating__/graphics/arrow-d.png",
					scale = 0.5,
					shift = {0, 8},
				},
			},
			result = "deadlock-crate-"..this_item,
			energy_required = 3*new_stack_size/40,
			allow_decomposition = false,
			main_product = nil,
		},
		-- The unpacking recipe
		{
			type = "recipe",
			name = "deadlock-unpackrecipe-"..this_item,
			localised_name = {"recipe-name.deadlock-unpacking-recipe", {"item-name." .. this_item}},
			order = menu_order,
			category = "packing",
			subgroup = "deadlock-crates-unpack-"..subgroup,
			enabled = false,
			ingredients = {
				{"deadlock-crate-"..this_item, 1},
			},
			icon_size = 32,
			icons = {
				{
					icon = "__base__/graphics/icons/"..crateitem..".png",
				},
				{
					icon = itemcopy.icon,
					scale = 0.75,
					shift = {0, 0},
					tint = {r=0,g=0,b=0,a=0.75},
				},
				{
					icon = itemcopy.icon,
					scale = 0.65,
					shift = {0, 0},
				},
				{
					icon = "__DeadlockCrating__/graphics/arrow-u.png",
					scale = 0.5,
					shift = {0, -8},
				},
			},
			results = {
				{crateitem, 1},
				{this_item, new_stack_size},
			},
			energy_required = 3*new_stack_size/40,
			allow_decomposition = false,
			main_product = nil,
		},
	}
	debug("DCM: crates created ("..this_item..")")
end

-- make the stacking recipes depend on a technology
function add_crates_to_tech(item_name, target_technology)
	if not target_technology then
		log("DCM: Skipping technology insert, no tech specified ("..item_name..")")
		return
	end
	if not data.raw.recipe["deadlock-unpackrecipe-"..item_name] then
		log("ERROR: DCM asked to use non-existent uncrating recipe for tech ("..target_technology..")")
		return
	end
	if not data.raw.recipe["deadlock-packrecipe-"..item_name] then
		log("ERROR: DCM asked to use non-existent crating recipe for tech ("..target_technology..")")
		return
	end
	if not data.raw.technology[target_technology] then
		log("ERROR: DCM asked to use non-existent technology ("..target_technology..")")
		return
	end
	table.insert(data.raw.technology[target_technology].effects,
		{
		type = "unlock-recipe",
		recipe = "deadlock-packrecipe-"..item_name,
		}
	)
	table.insert(data.raw.technology[target_technology].effects,
		{
		type = "unlock-recipe",
		recipe = "deadlock-unpackrecipe-"..item_name,
		}
	)
	debug("DCM: Modified technology ("..item_name..")")
end


-- public stuff
deadlock_crating = {}
function deadlock_crating.create(item_name, target_tech)
	debug("DCM: importing mod item ("..item_name..") ...")
	generate_crates(item_name, "wooden-chest", 4)
	add_crates_to_tech(item_name, target_tech)
end