local Data = require "stdlib.data.data"
local Entity = require "stdlib.data.entity"
local Item = require "stdlib.data.item"
local Recipe = require "stdlib.data.recipe"
local Technology = require "stdlib.data.technology"

local banned_fluids = {
  "crystal-matrix", "crystal-seedling", "crystal-slurry",
  "water-viscous-mud", "water-heavy-mud", "water-concentrated-mud", "water-light-mud", "water-thin-mud",
  "water-mineralized", "water-saline",
  "water-red-waste", "water-greenyellow-waste", "water-green-waste",
}

local banned_items = {
  "catalysator-green", "catalysator-orange",
  "filter-ceramic", "filter-ceramic-used",
  "milling-drum", "milling-drum-used",
  "geode-blue", "geode-cyan", "geode-lightgreen", "geode-purple", "geode-red", "geode-yellow",
  "crystal-dust",
  "electro-whinning-cell", "electro-whinning-cell-2", "electro-whinning-cell-3",
  "liquifier-3", "liquifier-4",
  "ore-powderizer", "ore-powderizer-2", "ore-powderizer-3",
  "solid-clay", "solid-limestone", "solid-mud", "solid-sand",
  "solid-lithium", "solid-salt",
  "salination-plant", "salination-plant-2",
  "seafloor-pump",
  "washing-plant","washing-plant-2",
  "hydro-plant-2"
}

for _, ore in pairs({"ore5", "ore6"}) do
  table.insert(banned_items, "angels-"..ore)
  table.insert(banned_items, "angels-"..ore.."-crushed")
  table.insert(banned_items, "angels-"..ore.."-chunk")
  table.insert(banned_items, "angels-"..ore.."-crystal")
  table.insert(banned_items, "angels-"..ore.."-pure")
end

for _, ore in pairs({"ore8", "ore9"}) do
  table.insert(banned_items, "angels-"..ore.."-crushed")
  table.insert(banned_items, "angels-"..ore.."-powder")
  table.insert(banned_fluids, "angels-"..ore.."-sludge")
  table.insert(banned_items, "angels-"..ore.."-dust")
  table.insert(banned_fluids, "angels-"..ore.."-solution")
  table.insert(banned_fluids, "angels-"..ore.."-anode-sludge")
  table.insert(banned_fluids, "angels-"..ore.."-slime")
  table.insert(banned_items, "angels-"..ore.."-crystal")
end

for _, fluid in pairs(banned_fluids) do
  table.insert(banned_items, fluid.."-barrel")
end

-- [[ Hide banned items ]]
for _, item in pairs(banned_items) do
  Item(item):add_flag("hidden")
end

-- [[ Move the several iron/copper smeltings around ]]

Recipe("angels-iron-pebbles-smelting")
:set_fields({allow_decomposition = false})
  :replace_icon({{
    icon = "__base__/graphics/icons/iron-plate.png"
  },{
    icon = "__angelsrefining__/graphics/icons/iron-pebbles.png",
    scale = 0.5,
    shift = {-8,-8}
  }})
Recipe("angels-iron-nugget-smelting")
  :set_fields({allow_decomposition = false})
  :replace_icon({{
    icon = "__base__/graphics/icons/iron-plate.png"
  },{
    icon = "__angelsrefining__/graphics/icons/iron-nugget.png",
    scale = 0.5,
    shift = {-8,-8}
  }})
Recipe("iron-plate")
  :replace_icon({{
    icon = "__base__/graphics/icons/iron-plate.png"
  },{
    icon = "__base__/graphics/icons/iron-ore.png",
    scale = 0.5,
    shift = {-8,-8}
  }}, 32)

Recipe("angels-copper-pebbles-smelting")
  :set_fields({allow_decomposition = false})
  :replace_icon({{
    icon = "__base__/graphics/icons/copper-plate.png"
  },{
    icon = "__angelsrefining__/graphics/icons/copper-pebbles.png",
    scale = 0.5,
    shift = {-8,-8}
  }})
Recipe("angels-copper-nugget-smelting")
  :set_fields({allow_decomposition = false})
  :replace_icon({{
    icon = "__base__/graphics/icons/copper-plate.png"
  },{
    icon = "__angelsrefining__/graphics/icons/copper-nugget.png",
    scale = 0.5,
    shift = {-8,-8}
  }})
Recipe("copper-plate")
  :replace_icon({{
    icon = "__base__/graphics/icons/copper-plate.png"
  },{
    icon = "__base__/graphics/icons/copper-ore.png",
    scale = 0.5,
    shift = {-8,-8}
  }}, 32)

-- [[ Remove banned fluid handling from research unlocks ]]
for _, fluid in pairs(banned_fluids) do
  Recipe("fill-"..fluid.."-barrel")
    :remove_unlock()
  Recipe("empty-"..fluid.."-barrel")
    :remove_unlock()
end

-- TODO: Remove slag & catalysator-brown if YAIOM isn't installed
if not data.raw.item.yaiom then
  -- [[ Remove slag and brown catalysator if there's no YAIOM ]]
  Recipe("catalysator-brown")
    :remove_unlock()
end

-- [[ Remove the orange catalyst too, not used ]]
Recipe("catalysator-orange")
  :remove_unlock()

Recipe("angels-iron-pebbles")
  :subgroup_order("processing-crafting", "bz[pebbles]-1[iron]")
Recipe("angels-copper-pebbles")
  :subgroup_order("processing-crafting", "bz[pebbles]-2[copper]")

-- [[ Condense sorting and ore processing recipes ]]
for i=1,6 do
  local ore = "angelsore"..i
  Recipe(ore.."-crushed")
    :subgroup_order("ore-processing-a", "a[make]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-crushed-processing")
    :subgroup_order("ore-processing-a", "b[sort]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-chunk")
    :subgroup_order("ore-processing-b", "a[make]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-chunk-processing")
    :subgroup_order("ore-processing-b", "b[sort]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-crystal")
    :subgroup_order("ore-processing-c", "a[make]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-crystal-processing")
    :subgroup_order("ore-processing-c", "b[sort]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-pure")
    :subgroup_order("ore-processing-d", "a[make]-ore"..i)
    :set_fields({allow_decomposition = false})
  Recipe(ore.."-pure-processing")
    :subgroup_order("ore-processing-d", "b[sort]-ore"..i)
    :set_fields({allow_decomposition = false})
end

Recipe("angelsore-crushed-mix1-processing")
  :subgroup_order("ore-processing-a", "c[refine]-a[iron]")
  :remove_unlock("advanced-ore-refining-1")
  :add_unlock("advanced-ore-refining-2")
  :set_fields({allow_decomposition = false})
Recipe("angelsore-crushed-mix3-processing")
  :subgroup_order("ore-processing-a", "c[refine]-b[copper]")
  :remove_unlock("advanced-ore-refining-1")
  :add_unlock("advanced-ore-refining-2")
  :set_fields({allow_decomposition = false})
-- [[ More ore slag processing into ore refining ]]
Recipe("angelsore-chunk-mix1-processing")
  :subgroup_order("ore-processing-d", "c[refine]-a[iron]")
  :remove_unlock("advanced-ore-refining-2")
  :add_unlock("advanced-ore-refining-3")
  :set_fields({allow_decomposition = false})
Recipe("angelsore-chunk-mix2-processing")
  :subgroup_order("ore-processing-d", "c[refine]-b[copper]")
  :remove_unlock("advanced-ore-refining-2")
  :add_unlock("advanced-ore-refining-3")
  :set_fields({allow_decomposition = false})

if data.raw.item.yaiom then
  Recipe("yaiom-orichalcum-filtration")
    :subgroup_order("yaiom-sorting", "a[make]-a")
    :set_fields({allow_decomposition = false})
  Recipe("yaiom-orichalcum-cleaning")
    :subgroup_order("yaiom-sorting", "a[make]-b")
    :set_fields({allow_decomposition = false})
  Recipe("yaiom-orichalcum-processing")
    :subgroup_order("yaiom-sorting", "a[make]-c")
    :set_fields({allow_decomposition = false})
  Recipe("yaiom-orichalcum-irradiation")
    :subgroup_order("yaiom-sorting", "a[make]-d")
    :set_fields({allow_decomposition = false})
end

Recipe("slag-processing-filtering-1")
  :subgroup_order("liquifying", "k[filter]-a")
Recipe("thermal-water-filtering-1")
  :subgroup_order("liquifying", "k[filter]-b")
Recipe("slag-processing-1")
  :subgroup_order("liquifying", "m[process]-1")
Recipe("slag-processing-2")
  :subgroup_order("liquifying", "m[process]-2")
Recipe("slag-processing-4")
  :subgroup_order("liquifying", "m[process]-3")
Recipe("slag-processing-5")
  :subgroup_order("liquifying", "m[process]-4")
Recipe("catalysator-brown")
  :subgroup_order("liquifying", "n[catalyst]-a")

-- [[ Move Water Treatment into Barreling ]]
Data("water-treatment", "item-subgroup")
  :subgroup_order(nil, "a")
  :set_fields({
    group = "angels-fluid-control"
  })
Data("angels-fluid-control", "item-subgroup")
  :subgroup_order(nil, "b")

Item("hydro-plant")
  :subgroup_order("water-treatment", "c")
Item("clarifier")
  :subgroup_order("water-treatment", "d")

Recipe("water-purification")
  :subgroup_order(nil, "a[treatment]-a")
Recipe("yellow-waste-water-purification")
  :subgroup_order("water-treatment", "b[cleaning]-a")

-- [[ Move the barrel recipe with the tank ]]
Recipe("empty-barrel")
  :subgroup_order("angels-fluid-control", "h")

-- [[ Disable leftover technology ]]
Technology("water-treatment-4")
  :set_fields({enabled = false})

-- [[ Add missing dependencies, tweak costs ]]
Technology("water-treatment")
  :add_prereq("steel-processing")
  :set_count(60)

Technology("water-treatment-2")
  :set_count(120)

Technology("ore-floatation")
  :add_prereq("water-treatment-2")

Technology("ore-leaching")
  :add_prereq("advanced-electronics")
  :set_count(160)

Technology("ore-refining")
  :add_prereq("advanced-electronics-2")
  :add_prereq("concrete")
  :add_pack("production-science-pack", 1)
  :set_count(320)

Technology("slag-processing-1")
  :add_prereq("sulfur-processing")
  :set_count(200)

Technology("slag-processing-2")
  :add_prereq("advanced-ore-refining-1")
  :set_count(300)

Technology("advanced-ore-refining-1")
  :add_prereq("steel-processing")

Technology("advanced-ore-refining-2")
  :add_prereq("advanced-electronics")
  :add_pack("science-pack-3", 1)
  :set_count(100)

Technology("advanced-ore-refining-3")
  :add_prereq("advanced-electronics-2")
  :add_pack("production-science-pack", 1)
  :set_count(200)

Technology("advanced-ore-refining-4")
  :add_pack("production-science-pack", 1)
  :add_pack("high-tech-science-pack", 1)
  :set_count(400)

Technology("thermal-water-extraction")
  :add_prereq("fluid-handling")
  :add_pack("production-science-pack", 1)
  :set_count(500)

-- [[ Add concrete to tier 3-4 machines ]]
  for _, recipe in pairs({"ore-refinery", "ore-refinery-2", "ore-leaching-plant-3"}) do
    Recipe(recipe)
    :replace_ingredient("brick", "concrete")
  end

-- [[ Add circuits to tier 2/3 crusher ]]
Recipe("ore-crusher-2")
  :add_ingredient({"electronic-circuit", 6})

Recipe("ore-crusher-3")
  :add_ingredient({"advanced-circuit", 6})

-- [[ And because I love you, heat exchangers use purified water ]]

Entity("heat-exchanger", "boiler").fluid_box.filter = "water-purified"
Technology("nuclear-power")
  :add_prereq("water-treatment")
