
data:extend(
{
	{
		type = "recipe",
		name = "yir_cw_cargo_green_recipe",
		category = "yir_rc_wsw", -- Workshop for Locomotives
		enabled = "true",
		energy_required = 3.00,
		ingredients = {			
			{ type = "item", name = "yir_frame_waggon" , amount = 1, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 1, },			
			{ type = "item", name = "y-res2" , amount = 3, },						
			{ type = "item", name = "yir_coin" , amount = 2, },					
		},
		results = {
			{ type = "item", name = "yir_cw_cargo_green", amount = 1, },
		},		
		order = "cw1", group = "yuoki_railway", subgroup = "yir_tankwagons2a",
	},	

	{
		type="item", name="yir_cw_cargo_green", icon="__z_yira_yuokirails__/graphics/2aw_cargo_green_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_tankwagons2a", order="cw1",  
		stack_size = 10, default_request_amount = 5,
		place_result="yir_cw_cargo_green", 
	},

	{
		type = "cargo-wagon",
		name = "yir_cw_cargo_green",
		icon = "__z_yira_yuokirails__/graphics/2aw_cargo_green_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 20,
		minable = {mining_time = 1, result = "yir_cw_cargo_green"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 400,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",
		collision_box = {{-0.6, -1.5}, {0.6, 1.1}},
		selection_box = {{-0.7, -2.6}, {1, 1.2}},
		weight = 750,
		max_speed = 1.2,
		braking_force = 2,
		friction_force = 0.0015,
		air_resistance = 0.002,
		connection_distance = 3.6,
		joint_distance = 1.8,
		energy_per_hit_point = 5,    
		resistances =
		{
			{type = "physical", decrease = 15, percent = 30 },
			{type = "impact",decrease = 50,percent = 60},
			{type = "acid",decrease = 10,percent = 20}
		},
		vertical_selection_shift = -0.5,
		--back_light = rolling_stock_back_light(),
		--stand_by_light = rolling_stock_stand_by_light(),
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filename = "__z_yira_yuokirails__/graphics/2aw_cargo_green_sheet.png",      
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  

	{
		type = "recipe",
		name = "yir_cw_cargo_blue_recipe",
		category = "yir_rc_wsw", -- Workshop for Locomotives
		enabled = "true",
		energy_required = 3.00,
		ingredients = {			
			{ type = "item", name = "yir_frame_waggon" , amount = 1, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 1, },			
			{ type = "item", name = "y-res1" , amount = 3, },						
			{ type = "item", name = "yir_coin" , amount = 2, },					
		},
		results = {
			{ type = "item", name = "yir_cw_cargo_blue", amount = 1, },
		},		
		order = "cw2", group = "yuoki_railway", subgroup = "yir_tankwagons2a",
	},	

	{
		type="item", name="yir_cw_cargo_blue", icon="__z_yira_yuokirails__/graphics/2aw_cargo_blue_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_tankwagons2a", order="cw2",  
		stack_size = 10, default_request_amount = 5,
		place_result="yir_cw_cargo_blue", 
	},

	{
		type = "cargo-wagon",
		name = "yir_cw_cargo_blue",
		icon = "__z_yira_yuokirails__/graphics/2aw_cargo_blue_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 20,
		minable = {mining_time = 1, result = "yir_cw_cargo_blue"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 400,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",
		collision_box = {{-0.6, -1.5}, {0.6, 1.1}},
		selection_box = {{-0.7, -2.6}, {1, 1.2}},
		weight = 750,
		max_speed = 1.2,
		braking_force = 2,
		friction_force = 0.0015,
		air_resistance = 0.002,
		connection_distance = 3.6,
		joint_distance = 1.8,
		energy_per_hit_point = 5,    
		resistances =
		{
			{type = "physical", decrease = 15, percent = 30 },
			{type = "impact",decrease = 50,percent = 60},
			{type = "acid",decrease = 10,percent = 20}			
		},
		vertical_selection_shift = -0.5,
		--back_light = rolling_stock_back_light(),
		--stand_by_light = rolling_stock_stand_by_light(),
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filename = "__z_yira_yuokirails__/graphics/2aw_cargo_blue_sheet.png",      
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  
	
	
	-- 4Achs-Blau
	{
		type = "recipe",
		name = "z_yira_4a_cw_yiblue_recipe",
		category = "yir_rc_wsw", -- Workshop for Cargo Wagons
		enabled = "true",
		energy_required = 4.00,
		ingredients = {
			{ type = "item", name = "yir_frame_waggon" , amount = 2, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 2, },			
			{ type = "item", name = "y-res1" , amount = 3, },						
			{ type = "item", name = "yir_coin" , amount = 2, },					
		},
		results = {
			{ type = "item", name = "z_yira_4a_cw_yiblue", amount = 1.0, },
		},	  
		order = "std-a", group = "yuoki_railway", subgroup = "yir_cargowagons_4A",
	},

	{
		type="item", name="z_yira_4a_cw_yiblue", icon="__z_yira_yuokirails__/graphics/4aw_cargo_yiblue_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_cargowagons_4A", order="a",  
		stack_size = 10, default_request_amount = 5,
		place_result="z_yira_4a_cw_yiblue", 
	},
	{
		type = "cargo-wagon",
		name = "z_yira_4a_cw_yiblue",
		icon = "__z_yira_yuokirails__/graphics/4aw_cargo_yiblue_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 30,
		minable = {mining_time = 1, result = "z_yira_4a_cw_yiblue"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 500,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",
		collision_box = {{-0.6, -2.4}, {0.6, 2.4}},
		selection_box = {{-1.0, -2.7}, {1, 3.2}},		
		connection_distance = 3, joint_distance = 4,
		weight = 2000,
		max_speed = 1.2, braking_force = 2, friction_force = 0.0015, air_resistance = 0.002,
		vertical_selection_shift = -0.5,
		energy_per_hit_point = 5,    
		
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filenames = { 
				"__z_yira_yuokirails__/graphics/4aw_cargo_blue_sheet.png",    					
			},			
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}			
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  	
	
	-- 4Achs-Grün
	{
		type = "recipe",
		name = "z_yira_4a_cw_yigreen_recipe",
		category = "yir_rc_wsw", -- Workshop for Cargo Wagons
		enabled = "true",
		energy_required = 4.00,
		ingredients = {
			{ type = "item", name = "yir_frame_waggon" , amount = 2, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 2, },			
			{ type = "item", name = "y-res2" , amount = 3, },						
			{ type = "item", name = "yir_coin" , amount = 2, },					
		},
		results = {
			{ type = "item", name = "z_yira_4a_cw_yigreen", amount = 1.0, },
		},	  
		order = "std-a", group = "yuoki_railway", subgroup = "yir_cargowagons_4A",
	},

	{
		type="item", name="z_yira_4a_cw_yigreen", icon="__z_yira_yuokirails__/graphics/4aw_cargo_yigreen_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_cargowagons_4A", order="a",  
		stack_size = 10, default_request_amount = 5,
		place_result="z_yira_4a_cw_yigreen", 
	},
	{
		type = "cargo-wagon",
		name = "z_yira_4a_cw_yigreen",
		icon = "__z_yira_yuokirails__/graphics/4aw_cargo_yigreen_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 30,
		minable = {mining_time = 1, result = "z_yira_4a_cw_yigreen"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 500,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",
		collision_box = {{-0.6, -2.4}, {0.6, 2.4}},
		selection_box = {{-1.0, -2.7}, {1, 3.2}},		
		connection_distance = 3, joint_distance = 4,
		weight = 2000,
		max_speed = 1.2, braking_force = 2, friction_force = 0.0015, air_resistance = 0.002,
		vertical_selection_shift = -0.5,
		energy_per_hit_point = 5,    
		
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filenames = { 
				"__z_yira_yuokirails__/graphics/4aw_cargo_green_sheet.png",    					
			},			
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}			
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  	


	-- 4Achs-Kisten
	{
		type = "recipe",
		name = "z_yira_4a_cw_kisten_recipe",
		category = "yir_rc_wsw", -- Workshop for Cargo Wagons
		enabled = "true",
		energy_required = 4.00,
		ingredients = {
			{ type = "item", name = "yir_frame_waggon" , amount = 2, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 2, },										
			{ type = "item", name = "wooden-chest" , amount = 2, },	
			{ type = "item", name = "yir_coin" , amount = 4, },					
		},
		results = {
			{ type = "item", name = "z_yira_4a_cw_kisten", amount = 1.0, },
		},	  
		order = "std-9a", group = "yuoki_railway", subgroup = "yir_cargowagons_4A",
	},

	{
		type="item", name="z_yira_4a_cw_kisten", icon="__z_yira_yuokirails__/graphics/4aw_cw_kiste1_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_cargowagons_4A", order="a",  
		stack_size = 10, default_request_amount = 5,
		place_result="z_yira_4a_cw_kisten", 
	},
	{
		type = "cargo-wagon",
		name = "z_yira_4a_cw_kisten",
		icon = "__z_yira_yuokirails__/graphics/4aw_cw_kiste1_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 30,
		minable = {mining_time = 1, result = "z_yira_4a_cw_kisten"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 500,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",					
		collision_box = {{-0.6, -2.4}, {0.6, 2.4}},
		selection_box = {{-1.0, -2.7}, {1, 3.2}},		
		connection_distance = 3, joint_distance = 4,
		weight = 2000,
		max_speed = 1.2, braking_force = 2, friction_force = 0.0015, air_resistance = 0.002,
		vertical_selection_shift = -0.5,
		energy_per_hit_point = 5,    
		
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filenames = { 
				"__z_yira_yuokirails__/graphics/4aw_cw_kiste1_sheet.png",    					
			},			
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}			
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  	


	-- 4Achs-Stuff
	{
		type = "recipe",
		name = "z_yira_4a_cw_stuff1_recipe",
		category = "yir_rc_wsw", -- Workshop for Cargo Wagons
		enabled = "true",
		energy_required = 4.00,
		ingredients = {
			{ type = "item", name = "yir_frame_waggon" , amount = 2, },			
			{ type = "item", name = "yir_radsatz_waggon" , amount = 2, },						
			{ type = "item", name = "yi_magnetron" , amount = 4, },		
			{ type = "item", name = "yir_coin" , amount = 4, },					
		},
		results = {
			{ type = "item", name = "z_yira_4a_cw_stuff1", amount = 1.0, },
		},	  
		order = "std-9b", group = "yuoki_railway", subgroup = "yir_cargowagons_4A",
	},

	{
		type="item", name="z_yira_4a_cw_stuff1", icon="__z_yira_yuokirails__/graphics/4aw_cw_stuff1_icon.png", flags={"goes-to-quickbar"}, 
		group="yuoki_railway", subgroup="yir_cargowagons_4A", order="a",  
		stack_size = 10, default_request_amount = 5,
		place_result="z_yira_4a_cw_stuff1", 
	},
	{
		type = "cargo-wagon",
		name = "z_yira_4a_cw_stuff1",
		icon = "__z_yira_yuokirails__/graphics/4aw_cw_stuff1_icon.png",
		flags = {"placeable-neutral", "player-creation", "placeable-off-grid", "not-on-map"},
		inventory_size = 30,
		minable = {mining_time = 1, result = "z_yira_4a_cw_stuff1"},
		mined_sound = {filename = "__core__/sound/deconstruct-medium.ogg"},
		max_health = 500,
		corpse = "medium-remnants",
		dying_explosion = "medium-explosion",
		collision_box = {{-0.6, -2.4}, {0.6, 2.4}},
		selection_box = {{-1.0, -2.7}, {1, 3.2}},		
		connection_distance = 3, joint_distance = 4,
		weight = 2000,
		max_speed = 1.2, braking_force = 2, friction_force = 0.0015, air_resistance = 0.002,
		vertical_selection_shift = -0.5,
		energy_per_hit_point = 5,    
		
		pictures =
		{
			priority = "very-low",
			width = 256,
			height = 256,
			back_equals_front = true,
			direction_count = 64,
			filenames = { 
				"__z_yira_yuokirails__/graphics/4aw_cw_stuff1_sheet.png",    					
			},			
			line_length = 8,
			lines_per_file = 8,
			shift = {0.42, -1.125}			
		},
		wheels = standard_train_wheels,
		rail_category = "regular",
		drive_over_tie_trigger = drive_over_tie(),
		tie_distance = 50,
		working_sound =
		{
			sound =
			{
				filename = "__base__/sound/train-wheels.ogg",
				volume = 0.5
			},
			match_volume_to_activity = true,
		},
		crash_trigger = crash_trigger(),
		open_sound = { filename = "__base__/sound/machine-open.ogg", volume = 0.85 },
		close_sound = { filename = "__base__/sound/machine-close.ogg", volume = 0.75 },
		sound_minimum_speed = 0.5;
		vehicle_impact_sound =  { filename = "__base__/sound/car-wood-impact.ogg", volume = 1.0 },
	},  	

	
	
})