data:extend(
{
	--[[
	-- items
	{
		type = "item",
		name = "y-tinylamp",
		icon = "__Yuoki__/graphics/icons/lamp-1-icon.png",
		flags = {"goes-to-quickbar"},
		group = "yuoki",
		subgroup = "y-lamps",
		place_result = "y-tinylamp",
		stack_size = 50, default_request_amount = 10, 
		order = "la",
	},

	{
		type = "item",
		name = "y-powerlamp",
		icon = "__Yuoki__/graphics/entity/lamps/hl2_icon.png",
		flags = {"goes-to-quickbar"},
		group = "yuoki",
		subgroup = "y-lamps",
		place_result = "y-powerlamp",
		stack_size = 50, default_request_amount = 10, 
		order = "lb",
	},

	{
		type = "item",
		name = "y-lamp-alien",
		icon = "__Yuoki__/graphics/icons/alien_lampe_icon.png",
		flags = {"goes-to-quickbar"},
		group = "yuoki",
		subgroup = "y-lamps",
		place_result = "y-lamp-alien",
		stack_size = 40, default_request_amount = 10, 
		order = "lc",
	},


	{
		type = "item",
		name = "yi-monument1",
		icon = "__Yuoki__/graphics/entity/monument-1-icon.png",
		flags = {"goes-to-quickbar"},
		group = "yuoki",
		subgroup = "y-lamps",
		place_result = "yi-monument1",
		stack_size = 5,
		order = "ld",
	},
	
	{ type = "item", name = "y_lamp_red", place_result = "y_lamp_red", icon = "__Yuoki__/graphics/entity/lamps/y_lamp_red_icon.png", flags = {"goes-to-quickbar"}, subgroup = "y-lamps", stack_size = 50, order = "2a", default_request_amount = 10, },
	{ type = "item", name = "y_lamp_green", place_result = "y_lamp_green", icon = "__Yuoki__/graphics/entity/lamps/y_lamp_green_icon.png", flags = {"goes-to-quickbar"}, subgroup = "y-lamps", stack_size = 50, order = "2b", default_request_amount = 10,  },
	{ type = "item", name = "y_lamp_blue", place_result = "y_lamp_blue", icon = "__Yuoki__/graphics/entity/lamps/y_lamp_blue_icon.png", flags = {"goes-to-quickbar"}, subgroup = "y-lamps", stack_size = 50, order = "2c", default_request_amount = 10,  },
	{ type = "item", name = "y_lamp_yellow", place_result = "y_lamp_yellow", icon = "__Yuoki__/graphics/entity/lamps/y_lamp_yellow_icon.png", flags = {"goes-to-quickbar"}, subgroup = "y-lamps", stack_size = 50, order = "2d", default_request_amount = 10,  },
		
	-- recipe
	{
		type = "recipe",
		name = "y-tinylamp-recipe",
		enabled = true,
		ingredients = 
		{    	  	
			{"iron-plate", 1},
			{"copper-cable", 1}		  
		},
		group = "yuoki",
		subgroup = "y-lamps",		
		result = "y-tinylamp",    
		order = "la",
	},
	{
		type = "recipe",
		name = "y-powerlamp-recipe",
		icon = "__Yuoki__/graphics/entity/lamps/hl2_icon.png",
		enabled = true,
		ingredients = 
		{    	  	
			{"y-raw-fuelnium", 1},
			{"steel-plate", 1},
			{"copper-plate", 2}		
		},
		results=
		{
			{type="item", name="y-powerlamp", amount=1, },      	  						
			{type="item", name="y_rwtechsign", amount=1, },      	  						
		},				
		main_product="y-powerlamp",
		group = "yuoki",
		subgroup = "y-lamps",				 
		order = "lb",
	},

	{
		type = "recipe",
		name = "y-lamp-alien-recipe",
		enabled = true,
		ingredients = 
		{    	  	
			{"steel-plate", 3},
			{"y-infused-uca2", 1},			
			{"y_rwtechsign", 1},	
		},
		group = "yuoki",
		subgroup = "y-lamps",		
		result = "y-lamp-alien",   
		result_count = 3,
		order = "lc",
	},	
	{
		type = "recipe",
		name = "yi-monument1-recipe", enabled = true,
		icon = "__Yuoki__/graphics/entity/monument-1-icon.png",
		ingredients = {{"y-crystal-cnd", 6}, {"y-unicomp-raw", 12}, {"steel-plate", 10}, {"y-orange-stuff", 15}},
		group = "yuoki",
		subgroup = "y-lamps",	
		results=
		{
			{type="item", name="yi-monument1", amount=1, },      	  						
			{type="item", name="y_rwtechsign", amount=10, },      	  						
		},			
		main_product="yi-monument1",
		order = "ld",
	},
	
	-- new lamps
	{
		type = "recipe",
		name = "y_lamp_red_recipe",
		enabled = true,
		ingredients = {{"y_structure_element", 1},{"y-chip-1", 1},},		
		subgroup = "y-lamps", order = "2a",		
		result = "y_lamp_red",  
	},	
	{
		type = "recipe",
		name = "y_lamp_green_recipe",
		enabled = true,
		ingredients = {{"y_structure_element", 1},{"y-chip-1", 1},},		
		subgroup = "y-lamps", order = "2b",		
		result = "y_lamp_green",  
	},
	{
		type = "recipe",
		name = "y_lamp_blue_recipe",
		enabled = true,
		ingredients = {{"y_structure_element", 1},{"y-chip-1", 1},},		
		subgroup = "y-lamps", order = "2c",		
		result = "y_lamp_blue",  
	},
	{
		type = "recipe",
		name = "y_lamp_yellow_recipe",
		enabled = true,
		ingredients = {{"y_structure_element", 1},{"y-chip-1", 1},},		
		subgroup = "y-lamps", order = "2d",		
		result = "y_lamp_yellow",  
	},	
	]]
		
		
	-- entity
	{
		type = "lamp",
		name = "yir_lamp_modern",
		icon = "__yi_railway__/graphics/icons/yir_lamp_modern_icon.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.5, mining_time = 0.5, result = "yir_lamp_modern"},
		max_health = 50,
		corpse = "small-remnants",
		collision_box = {{-0.1, -0.1}, {0.1, 0.1}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		energy_source =
		{
			type = "electric",
			usage_priority = "secondary-input"
		},
		energy_usage_per_tick = "25KW",
		light = {intensity = 0.9, size = 150},
		picture_off =
		{
			filename = "__yi_railway__/graphics/entity/yir_lamp_modern_off.png",
			priority = "high",
			width = 256,
			height = 256, scale = 1,			
			shift = {0, -3.5}
		},
		picture_on =
		{
			filename = "__yi_railway__/graphics/entity/yir_lamp_modern_on.png",
			priority = "high",
			width = 256,
			height = 256, scale = 1,			
			shift = {0, -3.5}
		},
		circuit_wire_max_distance = 20
	},

	{
		type = "lamp",
		name = "yir_lamp_old1",
		icon = "__yi_railway__/graphics/icons/yir_lamp_old1_icon.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.5, mining_time = 0.5, result = "yir_lamp_old1"},
		max_health = 50,
		corpse = "small-remnants",
		collision_box = {{-0.1, -0.1}, {0.1, 0.1}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		energy_source =
		{
			type = "electric",
			usage_priority = "secondary-input"
		},
		energy_usage_per_tick = "10KW",
		light = {intensity = 0.9, size = 100},
		tint = {r=1.0, g=1.0, b=0.6, a=0.8},
		picture_off =
		{
			filename = "__yi_railway__/graphics/entity/yir_lamp_old1_off.png",
			priority = "high",
			width = 256,
			height = 256, scale = 0.5,			
			shift = {0.5, -1.5}
		},
		picture_on =
		{
			filename = "__yi_railway__/graphics/entity/yir_lamp_old1_on.png",
			priority = "high",
			width = 256,
			height = 256, scale = 0.5,			
			shift = {0.5, -1.5}
		},
		circuit_wire_max_distance = 20,
	},
	{
		type = "lamp",
		name = "yir_lamp_clock",
		icon = "__yi_railway__/graphics/icons/yir_clock_icon.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.5, mining_time = 0.5, result = "yir_lamp_clock"},
		max_health = 50,
		corpse = "small-remnants",
		collision_box = {{-0.1, -0.1}, {0.1, 0.1}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		energy_source =
		{
			type = "electric",
			usage_priority = "secondary-input"
		},
		energy_usage_per_tick = "20KW",
		light = {intensity = 0.9, size = 70, },
		tint = {r=1.0, g=1.0, b=0.6, a=0.8},
		picture_off =
		{
			filename = "__yi_railway__/graphics/entity/yir_clock_off.png",
			priority = "high",
			width = 256,
			height = 256, scale = 0.5,			
			shift = {1.5, -1.5}
		},
		picture_on =
		{
			filename = "__yi_railway__/graphics/entity/yir_clock_on.png",
			priority = "high",
			width = 256,
			height = 256, scale = 0.5,			
			shift = {1.5, -1.5}
		},
		circuit_wire_max_distance = 20,
	},
		
})