-- known issues
--		The cause of death does have a localised_name, but I haven't found out yet how to use that with chart tags because they need a normal string.

global.corpses = global.corpses or {}

script.on_event(defines.events.on_player_died, function(event)
	local player = game.players[event.player_index]
	local text = player.name
	if event.cause ~= nil then
		text = text .. " was killed by " .. event.cause.name
	end
	local charttag = player.force.add_chart_tag(player.surface, {position = player.position, text = text})
	table.insert(global.corpses, {position = player.position, charttag = charttag})
end)

script.on_event(defines.events.on_player_mined_entity, function(event)
	if event.entity.name == "character-corpse" then
		for corpse, data in pairs(global.corpses) do
			if data.position.x == event.entity.position.x and data.position.y == event.entity.position.y and data.charttag.valid then
				data.charttag.destroy()
				global.corpses[corpse] = nil
				return
			end
		end
	end
end)
