pipepictures_hv = function()
return {
	straight_vertical_single =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sv_b.png",
		--filename = "__yi_engines__/graphics/entity/pipe-hc/pipe-straight-vertical-window.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_vertical =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sv_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_vertical_window =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_vclean_b.png",
		--filename = "__yi_engines__/graphics/entity/pipe-hc/pipe-straight-vertical-single.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_horizontal_single =
	{		
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sh_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},	
	straight_horizontal_window =
	{		
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_hclean_b.png",
		priority = "extra-high",
		width = 40,
		height = 40,		
	},
	straight_horizontal =
	{	
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sh_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},	
	corner_up_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ur_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_up_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ul_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_down_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_dr_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_down_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_dl_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_up =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tu_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_down =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_td_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tr_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tl_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	cross =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_cross_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_up =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ed_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_down =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_eu_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_el_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_er_b.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	horizontal_window_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 32
	},
	vertical_window_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 32
	},
	fluid_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 20
	},
	low_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	middle_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	high_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	gas_flow =
	{
		filename = "__base__/graphics/entity/pipe/steam.png",
		priority = "extra-high",
		line_length = 10,
		width = 24,
		height = 15,
		frame_count = 60,
		axially_symmetrical = false,
		direction_count = 1,
		hr_version =
		{
			filename = "__base__/graphics/entity/pipe/hr-steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 48,
			height = 30,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1
		}
	}	
}
end


pipepictures_ec = function()
return {
	straight_vertical_single =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sv.png",
		--filename = "__yi_engines__/graphics/entity/pipe-hc/pipe-straight-vertical-window.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_vertical =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sv.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_vertical_window =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_vclean.png",
		--filename = "__yi_engines__/graphics/entity/pipe-hc/pipe-straight-vertical-single.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	straight_horizontal_single =
	{		
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sh.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},	
	straight_horizontal_window =
	{		
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_hclean.png",
		priority = "extra-high",
		width = 40,
		height = 40,
		shift = {-0.125,0}
	},
	straight_horizontal =
	{	
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_sh.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},	
	corner_up_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ur.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_up_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ul.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_down_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_dr.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	corner_down_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_dl.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_up =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tu.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_down =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_td.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tr.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	t_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_tl.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	cross =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_cross.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_up =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_ed.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_down =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_eu.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_right =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_el.png",
		priority = "extra-high",
		width = 40,
		height = 40
	},
	ending_left =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_er.png",
		priority = "extra-high",
		width = 40,
		height = 40,
		shift = { -0.05,0},
	},
	horizontal_window_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 32
	},
	vertical_window_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 32
	},
	fluid_background =
	{
		filename = "__Yuoki__/graphics/entity/pipe-hc/clear.png",
		priority = "extra-high",
		width = 32,
		height = 20
	},
	low_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	middle_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	high_temperature_flow =
	{
		filename = "__base__/graphics/entity/pipe/fluid-flow.png",
		priority = "extra-high",
		width = 128,
		height = 18
	},
	gas_flow =
	{
		filename = "__base__/graphics/entity/pipe/steam.png",
		priority = "extra-high",
		line_length = 10,
		width = 24,
		height = 15,
		frame_count = 60,
		axially_symmetrical = false,
		direction_count = 1,
		hr_version =
		{
			filename = "__base__/graphics/entity/pipe/hr-steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 48,
			height = 30,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1
		}
	}	
}
end


data:extend(
{
	{
		type = "pipe",
		name = "y-pipe-h",
		icon = "__Yuoki__/graphics/icons/pipe-h.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "pipe"},
		max_health = 50,
		corpse = "small-remnants",
		resistances =
		{
			{
				type = "fire",
				percent = 90
			}
		},
		fast_replaceable_group = "pipe",
		collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 1,
			pipe_connections =
			{
				--{ position = {0, -1} },
				{ position = {1, 0} },
				--{ position = {0, 1} },
				{ position = {-1, 0} }
			},
		},
		pictures = pipepictures_hv(),
		horizontal_window_bounding_box = {{-0.25, -0.25}, {0.25, 0.15625}},
		vertical_window_bounding_box = {{-0.28125, -0.40625}, {0.03125, 0.125}}
	},
	
	{
		type = "pipe",
		name = "y-pipe-v",
		icon = "__Yuoki__/graphics/icons/pipe-v.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "pipe"},
		max_health = 50,
		corpse = "small-remnants",
		resistances =
		{
			{
				type = "fire",
				percent = 90
			}
		},
		fast_replaceable_group = "pipe",
		collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 1,
			pipe_connections =
			{
				{ position = {0, -1} },
				--{ position = {1, 0} },
				{ position = {0, 1} },
				--{ position = {-1, 0} }
			},
		},
		pictures = pipepictures_hv(),
		horizontal_window_bounding_box = {{-0.25, -0.25}, {0.25, 0.15625}},
		vertical_window_bounding_box = {{-0.28125, -0.40625}, {0.03125, 0.125}}
	},

	-- PipeBuffer also flow restriction test
	{
		type = "storage-tank",
		name = "y-valve-direction-buffer",
		icon = "__Yuoki__/graphics/icons/pressure_pipe_icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y-valve-direction-buffer"},
		max_health = 150,
		corpse = "small-remnants",
		collision_box = {{-0.3, -0.3}, {0.3, 0.3}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 5,						
			base_level = 0,
			--pipe_covers = pipecoverspictures(),
			pipe_connections =
			{
				
				{ type="input", position = {-1, 0},},
				{ type="output", position = { 1, 0} },
				--{ position = {1, 2} },
				--{ position = {-2, -1} },
			},			
		},
		two_direction_only = false,
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={
			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/valve_sheet.png",
					priority = "high",
					frames = 4,
					width = 64,
					height = 64,
					scale = 0.8,
					shift = {0.0, -0.25}
				}			
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 16,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},		
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		}
			
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			}
		},
		circuit_wire_max_distance = 15,		
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
		},
			
	},

	{
		type = "pipe",
		name = "y-pipe-hc",
		icon = "__Yuoki__/graphics/icons/pipe-hc.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "y-pipe-hc"},
		max_health = 80, corpse = "small-remnants",
		resistances ={{type = "fire",percent = 50,}},
		fast_replaceable_group = "pipe",
		collision_box = {{-0.29, -0.29}, {0.29, 0.29}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 0.8,
			base_level = 0,
			pipe_connections =
			{
				{ position = {0, -1} },
				{ position = {1, 0} },
				{ position = {0, 1} },
				{ position = {-1, 0} }
			},
		},
		pictures = pipepictures_hv(),
		working_sound =
		{
			sound = {
				{
					filename = "__base__/sound/pipe.ogg",
					volume = 0.65
				},
			},
			match_volume_to_activity = true,
			max_sounds_per_type = 3
		},
		horizontal_window_bounding_box = {{-0.25, -0.25}, {0.25, 0.15625}},
		vertical_window_bounding_box = {{-0.28125, -0.40625}, {0.03125, 0.125}}
	},

	{
		type = "pipe-to-ground",
		name = "y-pipe-to-ground-hc",
		icon = "__Yuoki__/graphics/icons/pipe-tg-hc.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "y-pipe-to-ground-hc"},
		max_health = 80,
		corpse = "small-remnants",
		resistances =
		{
			{
				type = "fire",
				percent = 80
			}
		},
		collision_box = {{-0.29, -0.29}, {0.29, 0.2}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 0.8,
			--pipe_covers = pipecoverspictures(),
			pipe_connections =
			{
				{ position = {0, -1} },
				{
					position = {0, 1},
					max_underground_distance = 20,
				}
			},
		},
		underground_sprite =
		{
			filename = "__core__/graphics/arrows/underground-lines.png",
			priority = "high",
			width = 64,
			height = 64,
			scale = 0.5,
		},
		pictures =
		{
			up =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gu_b.png",
				priority = "high",
				width = 40,
				height = 40 --, shift = {0.10, -0.04}
			},
			down =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gd_b.png",
				priority = "high",
				width = 40,
				height = 40 --, shift = {0.05, 0}
			},
			left =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gl_b.png",
				priority = "high",
				width = 40,
				height = 40, shift = { 0.1, 0.075}
			},
			right =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gr_b.png",
				priority = "high",
				width = 40,
				height = 40, shift = {0.1, 0.075},
			},
		}
	},
	{
		type = "pipe",
		name = "y-pipe-ec",
		icon = "__Yuoki__/graphics/icons/pipe-ec.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "y-pipe-ec"},
		max_health = 100, corpse = "small-remnants",
		resistances ={{type = "fire",percent = 50,}},
		fast_replaceable_group = "pipe",
		collision_box = {{-0.29, -0.29}, {0.29, 0.29}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 1.3,
			pipe_connections =
			{
				{ position = {0, -1} },
				{ position = {1, 0} },
				{ position = {0, 1} },
				{ position = {-1, 0} }
			},
		},
		pictures = pipepictures_ec(),
		working_sound =
		{
			sound = {
				{
					filename = "__base__/sound/pipe.ogg",
					volume = 0.65
				},
			},
			match_volume_to_activity = true,
			max_sounds_per_type = 3
		},
		horizontal_window_bounding_box = {{-0.25, -0.25}, {0.25, 0.15625}},
		vertical_window_bounding_box = {{-0.28125, -0.40625}, {0.03125, 0.125}}
	},

	{
		type = "pipe-to-ground",
		name = "y-pipe-to-ground-ec",
		icon = "__Yuoki__/graphics/icons/pipe-tg-ec.png",
		flags = {"placeable-neutral", "player-creation"},
		minable = {hardness = 0.2, mining_time = 0.5, result = "y-pipe-to-ground-ec"},
		max_health = 100,
		corpse = "small-remnants",
		collision_box = {{-0.29, -0.29}, {0.29, 0.2}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 1.3,
			base_level = 0,
			--pipe_covers = pipecoverspictures(),
			pipe_connections =
			{
				{ position = {0, -1} },
				{
					position = {0, 1},
					max_underground_distance = 30,
				}
			},
		},
		underground_sprite =
		{
			filename = "__core__/graphics/arrows/underground-lines.png",
			priority = "high",
			width = 64,
			height = 64,
			scale = 0.5,
		},
		pictures =
		{
			up =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gu.png",
				priority = "high",
				width = 40,
				height = 40 --, shift = {0.10, -0.04}
			},
			down =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gd.png",
				priority = "high",
				width = 40,
				height = 40 --, shift = {0.05, 0}
			},
			left =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gl.png",
				priority = "high",
				width = 40,
				height = 40, shift = { 0.1, 0.075}
			},
			right =
			{
				filename = "__Yuoki__/graphics/entity/pipe-hc/u_pipe_gr.png",
				priority = "high",
				width = 40,
				height = 40, shift = { 0.1, 0.075}
			},
		}
	},
	
	
	
	{
		type = "storage-tank",
		name = "y-tank-1000",
		icon = "__Yuoki__/graphics/icons/tank-1000-icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y-tank-1000"},
		max_health = 150,
		corpse = "small-remnants",
		collision_box = {{-0.7, -0.7}, {0.7, 0.7}},
		selection_box = {{-1.0, -1.0}, {1.0, 1.0}},
		fluid_box =
		{
			base_area = 400,
			base_level = 0,
			--pipe_covers = pipecoverspictures(),
			pipe_connections =
			{
				{ position = {  -0.5,  1.5} },
				{ position = {   0.5, -1.5} },
			},			
		},
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={

			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/tank_35n.png",
					priority = "high",
					frames = 2,
					width = 96,
					height = 96,
					shift = { 0.31, 0.0 },
				}
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 32,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			},
		}
			
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			},
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			}
		},
		circuit_wire_max_distance = 7.5,
		working_sound =
		{
			sound = {
				filename = "__base__/sound/storage-tank.ogg",
				volume = 0.8
			},
			apparent_volume = 1.5,
			
		},
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
		},
	},
	{
		type = "storage-tank",
		name = "y-tank-4500",
		icon = "__Yuoki__/graphics/entity/tank-4500-icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y-tank-4500"},
		max_health = 250,
		corpse = "small-remnants",
		collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
		selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
		fluid_box =
		{
			base_area = 900, base_level = -1,
			--pipe_covers = pipecoverspictures(),
			pipe_connections = {{ position = {  0,  2} },{ position = {  0, -2} },{ position = {  2,  0} },{ position = { -2,  0} },},			
		},
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={

			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/ugt_9k.png",
					priority = "high",
					frames = 1, width = 256, height = 256, scale = 0.5,
					shift = { 0.0, 0.25 },
				}
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 32,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		},
			
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			},
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			}
		},
		circuit_wire_max_distance = 7.5,				
		working_sound =
		{
			sound = {
				filename = "__base__/sound/storage-tank.ogg",
				volume = 0.8
			},
			apparent_volume = 1.5,			
		},
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
		},
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		}
		
	},
	{
		type = "storage-tank",
		name = "y-tank-8000",
		icon = "__Yuoki__/graphics/entity/tank-8000-icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y-tank-8000"},
		max_health = 300,
		corpse = "small-remnants",
		collision_box = {{-1.7, -1.7}, {1.7, 1.7}},
		selection_box = {{-2.0, -2.0}, {2.0, 2.0}},
		fluid_box =
		{
			base_area = 2400, base_level = 0,
			
			--[[
			pipe_connections =
			{				
				{ type="input", position = {-2, 0},},
				{ type="input", position = { 2, 0} },						
				{ position = {0, -2} },       
				{ position = {0, 2} },        
			},			
			]]
			pipe_connections = {{ position = {  2.5, -1.5} },{ position = {  1.5, -2.5} },{ position = { -1.5,  2.5} },{ position = { -2.5,  1.5} },},			
		},
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={

			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/ugt_24k.png",
					priority = "high",
					frames = 2, width = 384, height = 384, scale = 0.5,					
					shift = { 0.0, 0.0 },
				}
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 32,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		},		
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			},
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			}
		},
		circuit_wire_max_distance = 7.5,				
		working_sound =
		{
			sound = {
				filename = "__base__/sound/storage-tank.ogg",
				volume = 0.8
			},
			apparent_volume = 1.5,			
		},
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
		},
	},
	
	{
		type = "storage-tank",
		name = "y-tank-24k",
		icon = "__Yuoki__/graphics/entity/tank-48k-icon.png",
		flags = {"placeable-player", "player-creation"}, minable = {hardness = 0.2, mining_time = 3, result = "y-tank-24k"}, corpse = "medium-remnants",
		max_health = 350,		
		collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
		selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
		fluid_box =
		{
			base_area = 5000, base_level = -1,
			--pipe_covers = pipecoverspictures(),			
			pipe_connections = {{ position = {  0,  2} },{ position = {  0, -2} },{ position = {  2,  0} },{ position = { -2,  0} },},			
		},
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={

			picture = {
				sheet={
					filename = "__Yuoki__/graphics/entity/tank-48k-e.png",
					priority = "high",
					frames = 1, width = 128, height = 112,
					shift = { 0.315, 0.15 },
				}
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 32,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			}		,	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		},
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			},
			{
				shadow =
				{
					red = {2.0, 1.0},
					green = {2.0, 1.0},
				},
				wire =
				{
					red = {1.0, -0.0},
					green = {1.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 1.0},
					green = {0.0, 1.0},
				},
				wire =
				{
					red = {-1, -0.25},
					green = {-1, -0.25},
				}
			}
		},
		circuit_wire_max_distance = 15,				
		working_sound = { sound = { filename = "__base__/sound/storage-tank.ogg", volume = 0.8 }, apparent_volume = 1.5, },
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
		},
	},
	
	{
		type = "storage-tank",
		name = "y_flowcheck_10",
		icon = "__Yuoki__/graphics/icons/flow_indicator_icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y_flowcheck_10"},
		max_health = 50,
		corpse = "small-remnants",
		collision_box = {{-0.4, -0.4}, {0.4, 0.4}},
		selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
		fluid_box =
		{
			base_area = 1,
			base_level = 0,			
			pipe_connections =
			{
				{ position = {  -1,  0} },
				{ position = {   1,  0} },
				{ position = {   0, -1} },
				{ position = {   0,  1} },
			},			
		},
		two_direction_only = false,
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={
			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/flow_indicator.png",
					priority = "high",
					frames = 1,
					width = 64,
					height = 64,
					shift = { 0.25, -0.125 },
				}
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 32,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		},		
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {0.0, 0.0},
					green = {0.0, 0.0},
				},
				wire =
				{
					red = {0.0, -0.0},
					green = {0.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 0.0},
					green = {0.0, 0.0},
				},
				wire =
				{
					red = {0.0, -0.0},
					green = {0.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 0.0},
					green = {0.0, 0.0},
				},
				wire =
				{
					red = {0.0, -0.0},
					green = {0.0, -0.0},
				}
			},
			{
				shadow =
				{
					red = {0.0, 0.0},
					green = {0.0, 0.0},
				},
				wire =
				{
					red = {0.0, -0.0},
					green = {0.0, -0.0},
				}
			},
			
		},
		circuit_wire_max_distance = 15,
		working_sound =
		{
			sound = {
				filename = "__base__/sound/storage-tank.ogg",
				volume = 0.8
			},
			apparent_volume = 1.5,
			
		},
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
			get_circuit_connector_sprites({-0.1875, -0.375}, nil, 7),
			get_circuit_connector_sprites({0.375, -0.53125}, nil, 1),
		},
	},	


	-- Buffer Station also flow restriction test
	{
		type = "storage-tank",
		name = "y_buffer_station",
		icon = "__Yuoki__/graphics/entity/special_tank3_icon.png",
		flags = {"placeable-player", "player-creation"},
		minable = {hardness = 0.2, mining_time = 3, result = "y_buffer_station"},
		max_health = 500,
		corpse = "small-remnants",
		collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
		selection_box = {{-1.5, -1.5}, {1.5, 1.5}},

		fluid_box =
		{
			base_area = 300,						
			base_level = 0,
			--pipe_covers = pipecoverspictures(),
			pipe_connections =
			{				
				{ type="input", position = {-2, 0},},
				{ type="output", position = { 2, 0} },						
				{ position = {0, -2} },       
				{ position = {0, 2} },        
			},			
		},
		
		two_direction_only = false,
		window_bounding_box = {{-0.05, -0.5}, {0.05, 0.0}},
		pictures={
			picture =
			{
				sheet={
					filename = "__Yuoki__/graphics/entity/special_tank3_sheet.png",
					priority = "high",
					frames = 4,
					width = 256,
					height = 256,
					scale = 0.5,
					shift = {0.435, 0.05}
				}			
			},
			fluid_background =
			{
				filename = "__base__/graphics/entity/storage-tank/fluid-background.png",
				priority = "extra-high",
				width = 16,
				height = 15
			},
			window_background =
			{
				filename = "__base__/graphics/entity/storage-tank/window-background.png",
				priority = "extra-high",
				width = 17,
				height = 24
			},
			flow_sprite =
			{
				filename = "__base__/graphics/entity/pipe/fluid-flow-low-temperature.png",
				priority = "extra-high",
				width = 160,
				height = 20
			},	
		gas_flow =
		{
			filename = "__base__/graphics/entity/pipe/steam.png",
			priority = "extra-high",
			line_length = 10,
			width = 24,
			height = 15,
			frame_count = 60,
			axially_symmetrical = false,
			direction_count = 1,
			animation_speed = 0.25,
			hr_version =
			{
				filename = "__base__/graphics/entity/pipe/hr-steam.png",
				priority = "extra-high",
				line_length = 10,
				width = 48,
				height = 30,
				frame_count = 60,
				axially_symmetrical = false,
				animation_speed = 0.25,
				direction_count = 1
			}
		},		
		},
		flow_length_in_ticks = 360,
		circuit_wire_connection_points =
		{
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			},
			{
				shadow =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				},
				wire =
				{
					red = {-0.55, -0.15},
					green = {-0.75, -0.15},
				}
			}
		},
		circuit_wire_max_distance = 15,		
		circuit_connector_sprites =
		{
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
			get_circuit_connector_sprites({-0.35, -0.15}, nil, 7),
		},	
		
	},


	
})	
