if settings.startup["bobmods-assembly-chemicalplants"].value == true then

data:extend(
{
  {
    type = "item-subgroup",
    name = "bob-chemical-machine",
    group = "production",
    order = "e-c",
  },
}
)

data.raw["assembling-machine"]["chemical-plant"].fast_replaceable_group = "chemical-plant"
data.raw["assembling-machine"]["chemical-plant"].order = "e[chemical-plant-1]"

data.raw.item["chemical-plant"].stack_size = 50
data.raw.item["chemical-plant"].subgroup = "bob-chemical-machine"
data.raw.item["chemical-plant"].order = "e[chemical-plant-1]"


function bob_chemical_plant_facing(tint, x)
return {
  layers =
  {
      {
        filename = "__base__/graphics/entity/chemical-plant/chemical-plant.png",
        width = 122,
        x = x * 122,
        height = 134,
        frame_count = 1,
        shift = util.by_pixel(-5, -4.5),
        hr_version = {
          filename = "__base__/graphics/entity/chemical-plant/hr-chemical-plant.png",
          x = x * 244,
          width = 244,
          height = 268,
          frame_count = 1,
          shift = util.by_pixel(-5, -4.5),
          scale = 0.5
        }
      },

      {
        filename = "__bobassembly__/graphics/entity/chemical-plants/chemical-plant-mask.png",
        x = x * 156,
        width = 156,
        height = 141,
        frame_count = 1,
        tint = tint,
        shift = {0.5, -0.078125}
      },

      {
        filename = "__base__/graphics/entity/chemical-plant/chemical-plant-shadow.png",
        x = x * 175,
        width = 175,
        height = 110,
        frame_count = 1,
        shift = util.by_pixel(31.5, 11),
        draw_as_shadow = true,
        hr_version = {
          filename = "__base__/graphics/entity/chemical-plant/hr-chemical-plant-shadow.png",
          x = x * 350,
          width = 350,
          height = 219,
          frame_count = 1,
          shift = util.by_pixel(31.5, 10.75),
          draw_as_shadow = true,
          scale = 0.5
        }
      }
  }
}
end


function bob_chemical_plant_animation(tint)
return {
  north = bob_chemical_plant_facing(tint, 0),
  east = bob_chemical_plant_facing(tint, 1),
  south = bob_chemical_plant_facing(tint, 2),
  west = bob_chemical_plant_facing(tint, 3)
}
end




function bob_chemical_plant_fluid_boxes()
  return {
    {
      production_type = "input",
      pipe_covers = pipecoverspictures(),
      base_area = 10,
      base_level = -1,
      pipe_connections = {{ type="input", position = {-1, -2} }}
    },
    {
      production_type = "input",
      pipe_covers = pipecoverspictures(),
      base_area = 10,
      base_level = -1,
      pipe_connections = {{ type="input", position = {1, -2} }}
    },
    {
      production_type = "output",
      pipe_covers = pipecoverspictures(),
      base_level = 1,
      pipe_connections = {{ position = {-1, 2} }}
    },
    {
      production_type = "output",
      pipe_covers = pipecoverspictures(),
      base_level = 1,
      pipe_connections = {{ position = {1, 2} }}
    }
  }
end

function bob_chemical_plant_working_visualisations()
  return {
      {
        north_position = util.by_pixel(30, -24),
        east_position = util.by_pixel(-11, -1),
        south_position = util.by_pixel(-30, -48),
        west_position = util.by_pixel(1, -49.5),
        apply_recipe_tint = "primary",
        animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-green-patch.png",
          frame_count = 32,
          width = 15,
          height = 10,
          animation_speed = 0.5,
          hr_version = {
            filename = "__base__/graphics/entity/chemical-plant/hr-boiling-green-patch.png",
            frame_count = 32,
            width = 30,
            height = 20,
            animation_speed = 0.5,
            scale = 0.5
          }
        }
      },
      {
        north_position = util.by_pixel(30, -24),
        east_position = util.by_pixel(-11, -1),
        south_position = util.by_pixel(-30, -48),
        west_position = util.by_pixel(1, -49.5),
        apply_recipe_tint = "secondary",
        animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-green-patch-mask.png",
          frame_count = 32,
          width = 15,
          height = 10,
          animation_speed = 0.5,
          hr_version = {
            filename = "__base__/graphics/entity/chemical-plant/hr-boiling-green-patch-mask.png",
            frame_count = 32,
            width = 30,
            height = 20,
            animation_speed = 0.5,
            scale = 0.5
          }
        }
      },

      {
        apply_recipe_tint = "tertiary",
        north_position = {0, 0},
        west_position = {0, 0},
        south_position = {0, 0},
        east_position = {0, 0},
        north_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          frame_count = 1,
          width = 87,
          height = 60,
          shift = util.by_pixel(0, -5),
          hr_version = {
            filename = "__base__/graphics/entity/chemical-plant/hr-boiling-window-green-patch.png",
            x = 0,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5
          }
        },
        east_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          x = 87,
          frame_count = 1,
          width = 87,
          height = 60,
          shift = util.by_pixel(0, -5),
          hr_version = {
            filename = "__base__/graphics/entity/chemical-plant/hr-boiling-window-green-patch.png",
            x = 174,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5
          }
        },
        south_animation =
        {
          filename = "__base__/graphics/entity/chemical-plant/boiling-window-green-patch.png",
          x = 174,
          frame_count = 1,
          width = 87,
          height = 60,
          shift = util.by_pixel(0, -5),
          hr_version = {
            filename = "__base__/graphics/entity/chemical-plant/hr-boiling-window-green-patch.png",
            x = 348,
            frame_count = 1,
            width = 174,
            height = 119,
            shift = util.by_pixel(0, -5.25),
            scale = 0.5
          }
        }
      }
      
  }
end





data:extend(
{
  {
    type = "item",
    name = "chemical-plant-2",
    icon = "__bobassembly__/graphics/icons/chemical-plant-2.png",
    flags = {"goes-to-quickbar"},
    subgroup = "bob-chemical-machine",
    order = "e[chemical-plant-2]",
    place_result = "chemical-plant-2",
    stack_size = 50
  },
  {
    type = "item",
    name = "chemical-plant-3",
    icon = "__bobassembly__/graphics/icons/chemical-plant-3.png",
    flags = {"goes-to-quickbar"},
    subgroup = "bob-chemical-machine",
    order = "e[chemical-plant-3]",
    place_result = "chemical-plant-3",
    stack_size = 50
  },
  {
    type = "item",
    name = "chemical-plant-4",
    icon = "__bobassembly__/graphics/icons/chemical-plant-4.png",
    flags = {"goes-to-quickbar"},
    subgroup = "bob-chemical-machine",
    order = "e[chemical-plant-4]",
    place_result = "chemical-plant-4",
    stack_size = 50
  },


  {
    type = "recipe",
    name = "chemical-plant-2",
    energy_required = 5,
    enabled = "false",
    ingredients =
    {
      {"chemical-plant", 1},
      {"steel-plate", 10},
      {"iron-gear-wheel", 5},
      {"advanced-circuit", 5},
      {"pipe", 5},
    },
    result = "chemical-plant-2"
  },

  {
    type = "recipe",
    name = "chemical-plant-3",
    energy_required = 5,
    enabled = "false",
    ingredients =
    {
      {"chemical-plant-2", 1},
      {"steel-plate", 10},
      {"iron-gear-wheel", 5},
      {"processing-unit", 10},
      {"pipe", 5},
    },
    result = "chemical-plant-3"
  },

  {
    type = "recipe",
    name = "chemical-plant-4",
    energy_required = 5,
    enabled = "false",
    ingredients =
    {
      {"chemical-plant-3", 1},
      {"steel-plate", 10},
      {"iron-gear-wheel", 5},
      {"processing-unit", 10},
      {"pipe", 5},
    },
    result = "chemical-plant-4"
  },


  {
    type = "assembling-machine",
    name = "chemical-plant-2",
    icon = "__bobassembly__/graphics/icons/chemical-plant-2.png",
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "chemical-plant-2"},
    max_health = 350,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    module_specification =
    {
      module_slots = 4,
    },
    ingredient_count = 6,
    crafting_speed = 2,
    energy_usage = "300kW",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    crafting_categories = {"chemistry"},
    fluid_boxes = bob_chemical_plant_fluid_boxes(),
    animation = bob_chemical_plant_animation({r = 0.5, g = 0.1, b = 0.7}),
    working_visualisations = bob_chemical_plant_working_visualisations(),
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/chemical-plant.ogg",
          volume = 0.8
        }
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    fast_replaceable_group = "chemical-plant",
  },


  {
    type = "assembling-machine",
    name = "chemical-plant-3",
    icon = "__bobassembly__/graphics/icons/chemical-plant-3.png",
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "chemical-plant-3"},
    max_health = 400,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    module_specification =
    {
      module_slots = 5,
    },
    ingredient_count = 8,
    crafting_speed = 2.75,
    energy_usage = "390kW",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    crafting_categories = {"chemistry"},
    fluid_boxes = bob_chemical_plant_fluid_boxes(),
    animation = bob_chemical_plant_animation({r = 0.7, g = 0.2, b = 0.1}),
    working_visualisations = bob_chemical_plant_working_visualisations(),
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/chemical-plant.ogg",
          volume = 0.8
        }
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    fast_replaceable_group = "chemical-plant",
  },

  {
    type = "assembling-machine",
    name = "chemical-plant-4",
    icon = "__bobassembly__/graphics/icons/chemical-plant-4.png",
    flags = {"placeable-neutral","placeable-player", "player-creation"},
    minable = {hardness = 0.2, mining_time = 0.5, result = "chemical-plant-4"},
    max_health = 500,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.4, -1.4}, {1.4, 1.4}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    allowed_effects = {"consumption", "speed", "productivity", "pollution"},
    module_specification =
    {
      module_slots = 6,
    },
    ingredient_count = 10,
    crafting_speed = 3.5,
    energy_usage = "480kW",
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions = 0.03 / 3.5
    },
    crafting_categories = {"chemistry"},
    fluid_boxes = bob_chemical_plant_fluid_boxes(),
    animation = bob_chemical_plant_animation({r = 0.1, g = 0.7, b = 0.1}),
    working_visualisations = bob_chemical_plant_working_visualisations(),
    working_sound =
    {
      sound = {
        {
          filename = "__base__/sound/chemical-plant.ogg",
          volume = 0.8
        }
      },
      idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 1.5,
    },
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    fast_replaceable_group = "chemical-plant",
  },


  {
    type = "technology",
    name = "chemical-plant-2",
    icon = "__bobassembly__/graphics/icons/technology/chemical-plant.png",
    icon_size = 128,
    prerequisites =
    {
      "advanced-electronics",
    },
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "chemical-plant-2"
      },
    },
    unit =
    {
      count = 50,
      ingredients = 
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
      },
      time = 30
    },
    upgrade = true,
    order = "d-a-c2"
  },

  {
    type = "technology",
    name = "chemical-plant-3",
    icon = "__bobassembly__/graphics/icons/technology/chemical-plant.png",
    icon_size = 128,
    prerequisites =
    {
      "chemical-plant-2",
      "advanced-electronics-2",
    },
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "chemical-plant-3"
      },
    },
    unit =
    {
      count = 75,
      ingredients = 
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
      },
      time = 30
    },
    upgrade = true,
    order = "d-a-c3"
  },

  {
    type = "technology",
    name = "chemical-plant-4",
    icon = "__bobassembly__/graphics/icons/technology/chemical-plant.png",
    icon_size = 128,
    prerequisites =
    {
      "chemical-plant-3",
    },
    effects =
    {
      {
        type = "unlock-recipe",
        recipe = "chemical-plant-4"
      },
    },
    unit =
    {
      count = 100,
      ingredients = 
      {
        {"science-pack-1", 1},
        {"science-pack-2", 1},
        {"science-pack-3", 1},
        {"production-science-pack", 1},
      },
      time = 30
    },
    upgrade = true,
    order = "d-a-c4"
  },
}
)

end
