local omniston_subcategories = {}
local omniston_recipes = {}
local omniston_technology = {}

local fluid_subcategories = {}
local fluid_recipes = {}
local fluid_technology = {}
local ord={"a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q"}

local sorting = {
    type = "item-subgroup",
    name = "omniston",
	group = "omnimatter",
	order = "aa",
	}
omniston_subcategories[#omniston_subcategories+1]=sorting
	
data:extend(omniston_subcategories)

function get_tier_mult(r,c)
	local peak = math.floor(3*omni.fluid_levels/2)+1
	if r==1 and c==1 then
		return 1
	elseif r==c and r<=peak then
		return omni.pure_tech_level_increase
	elseif r>peak and c==2*peak-r+omni.fluid_levels%2 then
		return -omni.pure_tech_level_increase
	else
		return get_tier_mult(r-1,c)+get_tier_mult(r,c+1)
	end
end

local get_omniston_solvation_icon=function(lvl)
	local ic ={}
	ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/liquid-omniston.png"}
	--ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..lvl..".png"}
	return ic
end

local get_omnic_acid_icon=function(lvl)
	local ic ={}
	ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/omnic-acid.png"}
	--ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..lvl..".png"}
	return ic
end

local get_omnisludge_icon=function(lvl)
	local ic ={}
	ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/omni-sludge.png"}
	--ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..lvl..".png"}
	return ic
end

local get_crystalization_icon=function(lvl)
	local ic ={}
	ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/omnite.png"}
	--ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..lvl..".png"}
	return ic
end

local get_omniston_req=function(lvl)
	local req = {}
	req[#req+1]="omnic-hydrolyzation-"..lvl
	if (lvl-1)%omni.fluid_levels_per_tier == 0 then
		--req[#req+1]="omni-sorting-electric-"..((lvl-1)/omni.fluid_levels_per_tier+1)
		if lvl > 1 and omni.fluid_dependency < omni.fluid_levels_per_tier then
			req[#req+1]="omniston-solvation-"..(lvl-1)
		end
	else
		req[#req+1]="omniston-solvation-"..(lvl-1)
	end
	return req
end

local get_omnic_req=function(lvl)
	local req = {}
	if (lvl-1)%omni.fluid_levels_per_tier == 0 then
		req[#req+1]="omni-sorting-electric-"..((lvl-1)/omni.fluid_levels_per_tier+1)
		if lvl > 1 and omni.fluid_dependency < omni.fluid_levels_per_tier then
			req[#req+1]="omnic-hydrolyzation-"..(lvl-1)
		end
	else
		req[#req+1]="omnic-hydrolyzation-"..(lvl-1)
	end
	return req
end

local get_sludge_req=function(lvl)
	local req = {}
	req[#req+1]="omnic-hydrolyzation-"..lvl
	if (lvl-1)%omni.fluid_levels_per_tier == 0 then
		req[#req+1]="omni-sorting-electric-"..((lvl-1)/omni.fluid_levels_per_tier+1)
		if lvl > 1 and omni.fluid_dependency < omni.fluid_levels_per_tier then
			req[#req+1]="stone-omnisolvent-"..(lvl-1)
		end
	else
		req[#req+1]="stone-omnisolvent-"..(lvl-1)
	end
	return req
end


local get_distillation_tech_icon=function(item)
    local icon = ""
    if not item.mod then
		icon = "__omnimatter__"
	else
		icon = "__"..item.mod.."__"
	end
	icon=icon.."/graphics/extraction/"..item.fluid.name..".png"
    return icon
end

local get_distillation_req=function(tier,item, level)
	local req = {}
	req[#req+1]="omniston-solvation-"..level
	if (level-1)%omni.fluid_levels_per_tier == 0 then
		if data.raw.technology["omni-sorting-electric-"..((level-1)/omni.fluid_levels_per_tier+tier)] then
			req[#req+1]="omni-sorting-electric-"..((level-1)/omni.fluid_levels_per_tier+tier)
			if level > 1 and omni.fluid_dependency < omni.fluid_levels_per_tier then
				req[#req+1]="distillation-"..item.name.."-"..(level-1)
			end
		else
			req[#req+1]="distillation-"..item.name.."-"..(level-1)
		end
	else
		req[#req+1]="distillation-"..item.name.."-"..(level-1)
	end
	return req
end

local get_solvation_tech_cost = function(lvl)
	local c = {}
	local size = 2+((lvl-1)-(lvl-1)%omni.fluid_levels_per_tier)/omni.fluid_levels_per_tier
	local length = math.min(size,#omni.sciencepacks)
	for l=1,length do
		local q = 0
		if omni.linear_science then
			q = 1+omni.science_constant*(size-l)
		else
			q=round(math.pow(omni.science_constant,size-l))
		end
		c[#c+1] = {omni.sciencepacks[l],q}
	end
	return c
end

for i=1, omni.fluid_levels do
	local quant = 24
	local loc_key = {i}
	local icons = get_omniston_solvation_icon(i)
	
	--OMNISTON
	local solvation = {
	type = "recipe",
	name = "omniston-solvation-"..ord[i],
    localised_name = {"recipe-name.omniston_solvation", loc_key},
    --localised_description = {"recipe-description.compress-item", loc_key},
	category = "chemistry",
	subgroup = "omnifluids",
    enabled = false,
    ingredients = {
    {"pulverized-omnite", quant},
	{type="fluid", name="omnic-acid", amount=240},
    },
	order = "a[angelsore1-crushed]",
	icons = icons,
	results = {
	{type = "fluid", name = "omniston", amount=omni.omniston_ratio*(120+(i-1)*120/(omni.fluid_levels-1))},
	--{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
	},
    energy_required = 5*(math.floor(i/2+0.5)), --Must fix so this matches tiers and grows
    }
	omniston_recipes[#omniston_recipes+1] = solvation
	
	local req = get_omniston_req(i)
	local cost = get_solvation_tech_cost(i)
	local tech ={
	name = "omniston-solvation-"..i,
    localised_name = {"technology-name.omniston_solvation", loc_key},
	type = "technology",
	icon = "__omnimatter__/graphics/technology/omniston-tech.png",
	icon_size = 128,
	prerequisites = req,
	effects =
	{
	  {
		type = "unlock-recipe",
		recipe = "omniston-solvation-"..ord[i]
	  },--[[
	  {
		type = "unlock-recipe",
		recipe = "omnite-crystalization-"..i
	  },]]
	},
	unit  =
	{
	  count = 25*get_tier_mult(i,1),
	  ingredients = cost,
	  time = 15
	},
	order = "c-a"
	}
	omniston_technology[#omniston_technology+1] = tech
	
	--OMNIC ACID
	local water = "water"
	if angelsmods and angelsmods.refining then water = "water-purified" end
	icons = get_omnic_acid_icon(i)
	local acid = {
	type = "recipe",
	name = "omnic-hydrolyzation-"..ord[i],
    localised_name = {"recipe-name.omnic-acid", loc_key},
    --localised_description = {"recipe-description.compress-item", loc_key},
	category = "chemistry",
	subgroup = "omnifluids",
    enabled = false,
    ingredients = {
    {"crushed-omnite", quant},
	{type="fluid", name=water, amount=240},
	{type="fluid", name="steam", amount=240},
    },
	order = "a[angelsore1-crushed]",
	icons = icons,
	results = {
	{type = "fluid", name = "omnic-acid", amount=omni.acid_ratio*(120+(i-1)*120/(omni.fluid_levels-1))},
	--{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
	},
    energy_required = 5--*(math.floor(i/2+0.5)), --Must fix so this matches tiers and grows
    }
	omniston_recipes[#omniston_recipes+1] = acid
	
	req = get_omnic_req(i)
	local acid_tech ={
	name = "omnic-hydrolyzation-"..i,
    localised_name = {"technology-name.omnic_acid", loc_key},
	type = "technology",
	icon = "__omnimatter__/graphics/extraction/omnic-acid.png",
	icon_size = 128,
	prerequisites = req,
	effects =
	{
	  {
		type = "unlock-recipe",
		recipe = "omnic-hydrolyzation-"..ord[i]
	  },
	},
	unit  =
	{
	  count = 25*get_tier_mult(i,1),
	  ingredients = cost,
	  time = 15
	},
	order = "c-a"
	}
	omniston_technology[#omniston_technology+1] = acid_tech
	
	--Omnisludge
	local ratio = 26/15
	local cat = "chemistry"
	if angelsmods and angelsmods.refining then cat = "liquifying" end
	icons = get_omnisludge_icon(i)
	local sludge = {
	type = "recipe",
	name = "stone-omnisolvent-"..ord[i],
    localised_name = {"recipe-name.omnisludge", loc_key},
    --localised_description = {"recipe-description.compress-item", loc_key},
	category = cat,
	subgroup = "omnifluids",
    enabled = false,
    ingredients = {
    {"pulverized-stone", quant},
	{type="fluid", name="omnic-acid", amount=240}
    },
	order = "a[angelsore1-crushed]",
	icons = icons,
	results = {
	{type = "fluid", name = "omni-sludge", amount=ratio*(120+(i-1)*120/(omni.fluid_levels-1))},
	--{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
	},
    energy_required = 5*(math.floor(i/2+0.5)), --Must fix so this matches tiers and grows
    }
	omniston_recipes[#omniston_recipes+1] = sludge
	
	req = get_sludge_req(i)
	local sludge_tech ={
	name = "stone-omnisolvent-"..i,
    localised_name = {"technology-name.omnisludge", loc_key},
	type = "technology",
	icon = "__omnimatter__/graphics/extraction/omni-sludge.png",
	icon_size = 128,
	prerequisites = req,
	effects =
	{
	  {
		type = "unlock-recipe",
		recipe = "stone-omnisolvent-"..ord[i]
	  },
	},
	unit  =
	{
	  count = 25*get_tier_mult(i,1),
	  ingredients = cost,
	  time = 15
	},
	order = "c-a"
	}
	omniston_technology[#omniston_technology+1] = sludge_tech
	
	if not mods["omnimatter_crystal"] then
	--Crystalization
	local ratio = 16/19
	local cat = "chemistry"
	if angelsmods and angelsmods.refining then cat = "crystallizing" end
	icons = get_crystalization_icon(i)
	local sludge = {
	type = "recipe",
	name = "omnite-crystalization-"..i,
    localised_name = {"recipe-name.omnite-crystalization", loc_key},
    --localised_description = {"recipe-description.compress-item", loc_key},
	category = cat,
	subgroup = "omnite-crystalization",
    enabled = false,
    ingredients = {
	{type="fluid", name="omni-sludge", amount=60}
    },
	order = "a[angelsore1-crushed]",
	icons = icons,
	results = {
	{type = "item", name = "omnite", amount=(6+(i-1)*6/(omni.fluid_levels-1))},
	--{type = "item", name = "stone-crushed", amount_min = stone_min[t], amount_max = stone_max[t], probability = stone_prob[t]},
	},
    energy_required = 5*(math.floor(i/2+0.5)), --Must fix so this matches tiers and grows
    }
	omniston_recipes[#omniston_recipes+1] = sludge
	end
end
	
data:extend(omniston_recipes)
data:extend(omniston_technology)

local get_distillation_icon = function(fluid,tier)
    local ic = {}
    if fluid.icons then
        for _ , icon in pairs(fluid.icons) do
            ic[#ic+1] = icon
        end
    else
        ic[#ic+1] = {icon = fluid.icon}
    end
    --ic[#ic+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..tier..".png"}
    return ic

end

for _,f in pairs(omnifluid) do
	for i=1,omni.fluid_levels do
		local loc_key={"fluid-name."..f.fluid.name}
		local ic = get_distillation_icon(f.fluid,i) 
		local distillation = {
		type = "recipe",
		name = "distillation-"..f.fluid.name.."-"..ord[i],
		
		localised_name = {"recipe-name.fluid_disillation", loc_key},
		--localised_description = {"recipe-description.compress-item", loc_key},
		category = "chemistry",
		subgroup = "omnifluids",
		enabled = false,
		ingredients = {
		{type="fluid", name="omniston", amount=240}
		},
		order = "a[angelsore1-crushed]",
		icons = ic,
		results = {
		{type = "fluid", name = f.fluid.name, amount=f.ratio*(120+120*(i-1)/(omni.fluid_levels-1))},
		},
		energy_required = 5*(math.floor(i/2+0.5)), --Must fix so this matches tiers and grows
		}
		fluid_recipes[#fluid_recipes+1] = distillation
		
		local req = get_distillation_req(f.tier,f.fluid,i)
		local cost = get_solvation_tech_cost(i)
		ic = get_distillation_tech_icon(f)
		local tech ={
		name = "distillation-"..f.fluid.name.."-"..i,
		localised_name = {"technology-name.omniston_solvation", loc_key},
		type = "technology",
		icon = ic,
		icon_size = 128,
		prerequisites = req,
		effects =
		{
		  {
			type = "unlock-recipe",
			recipe = "distillation-"..f.fluid.name.."-"..ord[i]
		  },
		},
		unit  =
		{
		  count = 25*get_tier_mult(i,1),
		  ingredients = cost,
		  time = 15
		},
		order = "c-a"
		}
		fluid_technology[#fluid_technology+1] = tech
	end
end
if #omnifluid > 0 then
	data:extend(fluid_recipes)
	data:extend(fluid_technology)
end