    --Loop through all of the items in the category
	
local pure_extraction_recipes = {}
local pure_extraction_technology = {}
local pure_extraction_subcategories = {}

local impure_extraction_recipes = {}
local impure_extraction_technology = {}
local impure_extraction_subcategories = {}


local get_extraction_quant = function(lvl)
	return round((-13+24*omni.pure_levels_per_tier+5*lvl)/(-1+3*omni.pure_levels_per_tier))	
end

local get_extraction_prob = function(lvl)
	local q = get_extraction_quant(lvl)
	local r = (-13+24*omni.pure_levels_per_tier+5*lvl)/(-1+3*omni.pure_levels_per_tier)*(-4+9*omni.pure_levels_per_tier+lvl)/(-4+12*omni.pure_levels_per_tier)
	return r/q
	
end

local get_stone_prob = function(lvl)
	local q = (12-get_extraction_quant(lvl)*get_extraction_prob(lvl))
	
	return q/get_extraction_quant(lvl)
end

function get_tier_mult(r,c)
	local peak = math.floor(3*omni.pure_levels_per_tier/2)+1
	if r==1 and c==1 then
		return 1
	elseif r==c and r<=peak then
		return omni.pure_tech_level_increase
	elseif r>peak and c==2*peak-r+omni.pure_levels_per_tier%2 then
		if  r==3*omni.pure_levels_per_tier then
			return omni.pure_tech_level_increase
		else
			return -omni.pure_tech_level_increase
		end
	else
		return get_tier_mult(r-1,c)+get_tier_mult(r,c+1)
	end
end

local get_item_icons = function(item,tier)
    --Build the icons table
    local icons = {}
    if item.icons then
        for _ , icon in pairs(item.icons) do
            icons[#icons+1] = icon
        end
    else
        icons[#icons+1] = {icon = item.icon}
    end
    --icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..tier..".png"}
    return icons
end
local get_tech_icons = function(item)
    --Build the icons table
    local icon = ""
    if not item.mod then
		icon = "__omnimatter__"
	else
		icon = "__"..item.mod.."__"
	end
	icon=icon.."/graphics/extraction/"..item.ore.name..".png"
    return icon
end

local reqpure = function(tier,level,item)
	local req = {}
	if level%omni.pure_levels_per_tier==1 then
		req[#req+1]="omni-sorting-electric-"..(level-1)/omni.pure_levels_per_tier+tier
		if level > 1 and omni.pure_dependency < omni.pure_levels_per_tier then
			req[#req+1]="omni-sorting-"..item.name.."-"..(level-1)
		end
	else
		req[#req+1]="omni-sorting-"..item.name.."-"..(level-1)
	end
	if omni.impure_dependency<omni.impure_levels_per_tier and level==1 then
		req[#req+1]="omni-impure-"..item.name.."-extraction-"..omni.impure_levels_per_tier
	end
	return req
end

local techcost = function(lvl,tier)
	local c = {}
	local size = tier+((lvl-1)-(lvl-1)%omni.pure_levels_per_tier)/omni.pure_levels_per_tier
	local length = math.min(size,#omni.sciencepacks)
	for l=1,length do
		local q = 0
		if omni.linear_science then
			q = 1+omni.science_constant*(size-l)
		else
			q=round(math.pow(omni.science_constant,size-l))
		end
		c[#c+1] = {omni.sciencepacks[l],q}
	end
	return c
end


	--omni.pure_dependency > omni.pure_levels_per_tier
	--omni.max_tier
	
--Pure extraction
local ord={"a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r"}
local ore_count = 0
local tier_count = {}
local omnitiers = {}
for i=1,#omnisource do
	--Check for hidden flag to skip later

	local item = omnisource[i].ore
	local tier = omnisource[i].tier
	if not tier_count[tier] then tier_count[tier] = 0 end
	tier_count[tier]=tier_count[tier]+1
	
	if not omnitiers[tier] then omnitiers[tier]={} end
	omnitiers[tier][#omnitiers[tier]+1]=item
	
	ore_count=ore_count+1
	
	local sub_group = "items"
    local order = "compressed-"..item.type.."-"..item.name
    --local techname = get_tech("items")
    local icons = get_item_icons(item,tier)
	
	--Automated subcategories
	
	for t=1,3*omni.pure_levels_per_tier do
		
		local icons = get_item_icons(item,t)
		local r = {}
        local loc_key = {"item-name."..item.name}
		
		

		--Pure extraction recipes
		local loc_key = {"item-name."..item.name,t}
		local quant = get_extraction_quant(t)
		local prob = get_extraction_prob(t)
		local stone_prob = get_stone_prob(t)
		local res = {}
		res[#res+1]={type = "item", name = item.name, amount_min = quant-2, amount_max = quant+2, probability = prob}
		if t<3*omni.pure_levels_per_tier and stone_prob > 0 then
			res[#res+1] = {type = "item", name = "stone-crushed", amount_min = quant-2, amount_max = quant+2, probability = stone_prob}
		end
		local nr = ord[t]
		--if t<10 then nr=t else nr=math.floor(t/10).."-"..t%10 end
		local extraction = {
		type = "recipe",
		name = item.name.."-extraction-"..nr,
        localised_name = {"recipe-name.pure_extraction", loc_key},
        localised_description = {"recipe-description.pure_extraction", loc_key},
		category = "omnite-extraction",
		subgroup = "omnisolids",
        enabled = false,
        ingredients = {
        {"omnite", 12}
        },
        --subgroup = "compressor-"..sub_group,
		order = "a[angelsore1-crushed]",
		icons = icons,
        --inter_item_count = item_count,
		results = res,
        energy_required = 5*(math.floor((t-1+(tier-1)/2)/omni.pure_levels_per_tier)+1), --Must fix so this matches tiers and grows
        }
		pure_extraction_recipes[#pure_extraction_recipes+1] = extraction
		
		loc_key = {"item-name."..item.name}
		--Pure Technologies
		local techicons = get_tech_icons(omnisource[i])
		local req = reqpure(tier,t,item)
		local cost = techcost(t,tier)
		
		local tech = 	{ -- Sp 1
		name = "omni-sorting-"..item.name.."-"..t,
        localised_name = {"technology-name.pure_extraction", loc_key},
		type = "technology",
		icon = techicons,
		icon_size = 128,
		prerequisites = req,
		effects =
		{
		  {
			type = "unlock-recipe",
			recipe = item.name.."-extraction-"..nr
		  },
		},
		unit  =
		{
		  count = round(25*math.pow(omni.pure_tech_tier_increase,tier)*get_tier_mult(t,1)),
		  ingredients = cost,
		  time = 15
		},
		order = "c-a"
		}
		pure_extraction_technology[#pure_extraction_technology+1] = tech
	end
end
data:extend(pure_extraction_technology)
data:extend(pure_extraction_recipes)

local impure_icons =function(t,kind)
    local icons = {}
	if kind then
		
		icons[#icons+1] = {icon = kind.icon}
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/specialized-impure-extraction.png"}
		--icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..t..".png"}
	else
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/omnite.png"}
		icons[#icons+1] = {icon = "__omnimatter__/graphics/icons/extraction-"..t..".png"}
	end
    return icons
end

local get_impurities = function(ore,tier)
	local tierores = {}
	for _,o in pairs(omnisource) do
		if o.tier == tier and o.ore.name ~= ore then
			tierores[#tierores+1]=o.ore.name
		end
	end
	local pickedores = {ore}
	local c=math.random(12)
	if ore then c=string.byte(ore,math.random(string.len(ore)))%12 end
	math.randomseed(c+omni.impure_levels_per_tier*omni.impure_dependency-omni.pure_levels_per_tier+tier*#tierores)
	while #tierores>0 and #pickedores<4 do
		local pick = math.random(1,#tierores)
		pickedores[#pickedores+1]=tierores[pick]
		table.remove(tierores,pick)
		--log("in loop tier count: "..#tierores)
	end
	return pickedores
end
local proper_result = function(tier, level,focus)
	local res = {}
	local impurities = get_impurities(focus,tier)
	if #impurities ~=1 then
		if level == 0 then
			local avg = 2
			for _,imp in pairs(impurities) do
				local p = avg/#impurities 
				res[#res+1] = {type = "item", name = imp, amount_min = avg-1, amount_max = avg+1, probability = p}
			end
		else
			local count = #impurities+level
			local avg = level +2
			res[#res+1] = {type = "item", name = focus, amount_min = avg-1, amount_max = avg+1, probability = (level+1)/count*4/avg}
			for _,imp in pairs(impurities) do
				if imp ~= focus then
					res[#res+1] = {type = "item", name = imp, amount_min = level, amount_max = level+2, probability = 4/(count*(level+1))}
				end
			end
		end
	else
		local p = (2+2*level/omni.impure_levels_per_tier)/4
		res[#res+1] = {type = "item", name = impurities[1], amount_min = 3, amount_max = 5, probability = p}
	end
	res[#res+1]={type = "item", name = "stone-crushed", amount=6}
	return res
end

local get_impure_tech_icon = function(item)
	local ic = {}
    if not item.mod then
		ic = "__omnimatter__"
	else
		ic = "__"..item.mod.."__"
	end
	ic=ic.."/graphics/extraction/impure_"..item.name..".png"
    return ic
end

local get_impure_req = function(lvl,tier,item)
    --Build the icons table
    local req = {}
	if lvl == 1 and tier == 1 then
		req[#req+1]="omni-extraction-impure-base"
	elseif lvl==1 then
		req[#req+1]="omni-sorting-electric-"..(tier-1)
	else
		req[#req+1]="omni-impure-"..item.name.."-extraction-"..(lvl-1)
	end
	
    return req
end

--Impure recipies
for t=1,omni.max_tier do
	--Base mix
	local icons = impure_icons(t)
	local res = proper_result(t,0)

	
	--local icons = impure_icons(t)
	
	local loc_key = {t}
	local cat = "omnite-extraction"
	if t==1 then cat = "omnite-extraction-both" end
	local extraction = {
	type = "recipe",
	name = "base-impure-extraction-"..t,
    localised_name = {"recipe-name.base_impure", loc_key},
    localised_description = {"recipe-description.base_impure", loc_key},
	category = cat,
	subgroup = "omni-impure-basic",
    enabled = false,
    ingredients = {
    {"omnite", 10}
    },
       --subgroup = "compressor-"..sub_group,
	order = "a[angelsore1-crushed]",
	icons = icons,
       --inter_item_count = item_count,
	results = res,
    energy_required = 5*(math.floor(t/2+0.5)), 
    }
	impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
	if t==1 then
		local cnt = 30*omni.beginning_tech_help
		local tech = 	{ -- Sp 1
		name = "omni-extraction-impure-base",
		--localised_name = {"recipe-name.base_impure", loc_key},
		type = "technology",
		icon = "__omnimatter__/graphics/technology/omnimatter.png",
		icon_size = 128,
		prerequisites = {},
		effects =
		{
		  {
			type = "unlock-recipe",
			recipe = "base-impure-extraction-"..t
		  },
		},
		unit =
		{
		  count = cnt,
		  ingredients = {
		  {"science-pack-1", 1},
		  },
		  time = 15
		},
		order = "c-a"
		}
		impure_extraction_technology[#impure_extraction_technology+1] = tech
	
	end
	
	math.randomseed(string.len("emperorzelos")+12)
	
	for i=1, #omnisource do
		if omnisource[i].tier == t then
			for l=1,omni.impure_levels_per_tier do
				res = proper_result(t,l,omnisource[i].ore.name)
				icons = impure_icons(l,omnisource[i].ore)
				
				local cat={}
				
				if t==1 then cat = "omnite-extraction-both" else cat = "omnite-extraction" end
				loc_key = {"item-name."..omnisource[i].ore.name,l}
				--impure focused recipe
				local extraction = {
				type = "recipe",
				name = "impure-"..omnisource[i].ore.name.."-extraction-"..l,
				localised_name = {"recipe-name.impure_focused", {"item-name."..omnisource[i].ore.name,l}},
				localised_description = {"recipe-description.focused_impure", loc_key},
				category = cat,
				subgroup = "omni-impure-solids",
				enabled = false,
				ingredients = {
				{"omnite", 10}
				},
				   --subgroup = "compressor-"..sub_group,
				order = "a[angelsore1-crushed]",
				icons = icons,
				   --inter_item_count = item_count,
				results = res,
				energy_required = 5*(math.floor(t/2+0.5)), 
				}
				impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
				
				local req = get_impure_req(l,t,omnisource[i].ore)
				icons = get_impure_tech_icon(omnisource[i].ore)
				local count = 25*t*l
				local cost = techcost(1,t)
				if t==1 then count=count*omni.beginning_tech_help end
				local tech = 	{
				name = "omni-impure-"..omnisource[i].ore.name.."-extraction-"..l,
				localised_name = {"technology-name.impure_focused", {"item-name."..omnisource[i].ore.name,l}},
				type = "technology",
				--icons = icons,
				icon = icons,
				icon_size = 128,
				prerequisites = req,
				effects =
				{
				  {
					type = "unlock-recipe",
					recipe = "impure-"..omnisource[i].ore.name.."-extraction-"..l
				  },
				},
				unit =
				{
				  count = count,
				  ingredients = cost,
				  time = 10
				},
				order = "c-a"
				}
				impure_extraction_technology[#impure_extraction_technology+1] = tech
			end
			--tech_add_prerequisite("omni-sorting-electric-"..t,"omni-impure-"..omnisource[i].ore.name.."-extraction-3")
		end
	end
	
	--impure_extraction_recipes[#impure_extraction_recipes+1] = extraction
end
data:extend(impure_extraction_technology)
data:extend(impure_extraction_recipes)
	

	--  {type = "item", name = "angels-ore1", amount_min = 6, amount_max = 10, probability = 0.75},
	--  {type = "item", name = "stone-crushed", amount_min = 4, amount_max = 8, probability = 1.00},
	
	