local geartier = {"iron-gear-wheel"}
local bearingtier = {}

local electronictier = {"electronic-circuit","advanced-circuit","processing-unit"}

local metaltier = {"iron-plate","steel-plate"}

local alloytier = {}


if data.raw.item["basic-circuit-board"] then
	electronictier={"basic-circuit-board","electronic-circuit","advanced-circuit","processing-unit","advanced-processing-unit"}
end



if bobmods and bobmods.plates then
geartier[#geartier+1] = "steel-gear-wheel"
geartier[#geartier+1] = "brass-gear-wheel"
geartier[#geartier+1] = "titanium-gear-wheel"
geartier[#geartier+1] = "tungsten-gear-wheel"
geartier[#geartier+1] = "nitinol-gear-wheel"
--Gear Tier max 6

bearingtier[#bearingtier+1]="steel-bearing"
bearingtier[#bearingtier+1]="nil"
bearingtier[#bearingtier+1]="titanium-bearing"
bearingtier[#bearingtier+1]="ceramic-bearing"
bearingtier[#bearingtier+1]="nitinol-bearing"
--Bearing Tier max 4

metaltier[#metaltier+1]="aluminium-plate"
metaltier[#metaltier+1]="tungsten-plate"
--Plate tier 4

alloytier[#alloytier+1]="brass-alloy"
alloytier[#alloytier+1]="invar-alloy"
alloytier[#alloytier+1]="electrum-alloy"
alloytier[#alloytier+1]="nitinol-alloy"
alloytier[#alloytier+1]="cobalt-steel-alloy"
end
local omnitractor_recipes = {}
local omnitractor_item = {}
local omnitractor_technology = {}
local omnitractor_entities = {}

local timestier = {1,1.5,2.2,3.5,5}

--"electronic-circuit"
local get_icons = function(tier)
    --Build the icons table
    local icons = {{icon = "__omnimatter__/graphics/icons/electric-omnitractor.png"},{icon = "__omnimatter__/graphics/icons/extraction-"..tier..".png"}}
    return icons
end

local get_pure_req = function(i)
	local r = {}
	--omni.pure_dependency
	--omni.pure_levels_per_tier
	for _,item in pairs(omnisource) do
		if item.tier < i and item.tier >= i-3 then
			r[#r+1]="omni-sorting-"..item.ore.name.."-"..omni.pure_levels_per_tier*(i-item.tier-1)+omni.pure_dependency
			--omni.impure_dependency
		end
		if item.tier == i then
			r[#r+1]="omni-impure-"..item.ore.name.."-extraction-"..omni.impure_dependency
		end
	end
	if i>1 and i*omni.fluid_levels_per_tier < omni.fluid_levels then
		r[#r+1]="omniston-solvation-"..(i-2)*omni.fluid_levels_per_tier+omni.fluid_dependency
		r[#r+1]="omnic-hydrolyzation-"..(i-2)*omni.fluid_levels_per_tier+omni.fluid_dependency
		r[#r+1]="stone-omnisolvent-"..(i-2)*omni.fluid_levels_per_tier+omni.fluid_dependency
	end
	for _,item in pairs(omnifluid) do
		if item.tier < i and item.tier >= i-3 then
			if omni.fluid_levels_per_tier*(i-item.tier-1)+omni.fluid_dependency <= omni.fluid_levels then
				r[#r+1]="distillation-"..item.fluid.name.."-"..omni.fluid_levels_per_tier*(i-item.tier-1)+omni.fluid_dependency
			elseif omni.fluid_levels_per_tier*(i-item.tier-1)+omni.fluid_dependency > omni.fluid_levels then
				r[#r+1]="distillation-"..item.fluid.name.."-"..omni.fluid_levels
			end
		end
	end
	return r
end

local get_tech_times = function(tier)
	local t = 50*timestier[tier]
	return t
end
local get_tech_cost = function(tier)
	local c = {}
	for lvl=1,tier do
		c[#c+1] = {omni.sciencepacks[lvl],math.pow(2,tier-lvl)}
	end
	return c
end

get_component = function(material,tier)
	if material[tier] == nil or material[tier]=="nil" then
		return get_component(material,tier-1)
	else
		return material[tier]
	end
end

get_component_quant = function(base,material,tier)
	if material[tier] == nil or material[tier]=="nil" then
		return 2*get_component_quant(base,material,tier-1)
	else
		return base
	end
end

local get_tractor_cost = function(tier)
	local tc = {}
	tc[#tc+1]={get_component(geartier,tier),get_component_quant(10,geartier,tier)}
	tc[#tc+1]={get_component(electronictier,tier),get_component_quant(5,electronictier,tier)}
	tc[#tc+1]={get_component(metaltier,tier),get_component_quant(20,metaltier,tier)}
	if tier > 1 and bobmods and bobmods.plates then
		tc[#tc+1]={get_component(bearingtier,tier-1),get_component_quant(5,bearingtier,tier-1)} 
	end
	if tier > 1 then
		tc[#tc+1]={"omnitractor-"..tier-1,1}
	else
		tc[#tc+1]={"burner-omnitractor-1",1}		
	end
	return tc
end

for i=1,omni.max_tier do


	local ic = get_icons(i)

	local req = get_pure_req(i)
	local times = get_tech_times(i)
	local cost = get_tech_cost(i)
	local ingr = get_tractor_cost(i)
	local loc_key = {i}
	
	local omnitractorrecipe = {
	type = "recipe",
	name = "omnitractor-"..i,
    localised_name = {"recipe-name.omnitractor", loc_key},
    localised_description = {"recipe-description.compress-item", loc_key},
	subgroup = "omnitractor",
    enabled = false,
    ingredients = ingr,
       --subgroup = "compressor-"..sub_group,
	order = "a[angelsore1-crushed]",
	icons = ic,
       --inter_item_count = item_count,
	results = {
	{type = "item", name = "omnitractor-"..i, amount=1},
	},
    energy_required = 5,
    }
	omnitractor_recipes[#omnitractor_recipes+1]=omnitractorrecipe
	
	local omnitractortech = {
    type = "technology",
    name = "omni-sorting-electric-"..i,
    localised_name = {"technology-name.omnitractor-electric", loc_key},
    icon = "__omnimatter__/graphics/technology/electric-omnitraction.png",
	icon_size = 128,
	prerequisites =req,
    effects =
    {
	  {
        type = "unlock-recipe"	,
        recipe = "omnitractor-"..i
      },
    },
	
    unit =
    {
      count = times,
      ingredients = cost,
      time = 15*i
    },
    order = "c-a"
    }
	
	omnitractor_technology[#omnitractor_technology+1]=omnitractortech
	
	--Item
	local omnitractoritem={
    type = "item",
    name = "omnitractor-"..i,
    localised_name = {"item-name.omnitractor-electric", loc_key},
    icons = ic,
	flags = {"goes-to-quickbar"},
    subgroup = "omnitractor",
    order = "a[burner-ore-crusher]",
    place_result = "omnitractor-"..i,
    stack_size = 10,
    }
	omnitractor_item[#omnitractor_item+1]=omnitractoritem
	--entity
	local omnitractorentity = { -- Entity Electric Omnitracator 1
	
    type = "assembling-machine",
    name = "omnitractor-"..i,
    localised_name = {"entity-name.omnitractor-electric", loc_key},
    icons = ic,
	flags = {"placeable-neutral","player-creation"},
    minable = {mining_time = 1, result = "omnitractor-"..i},
	fast_replaceable_group = "omnitractor",
    max_health = 300,
	corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
	module_specification =
    {
      module_slots = i
    },
    allowed_effects = {"consumption", "speed", "pollution", "productivity"},
    crafting_categories = {"omnite-extraction-both","omnite-extraction"},
    crafting_speed = 1+i/2,
	source_inventory_size = 1,
    energy_source =
    {
	  type = "electric",
	  usage_priority = "secondary-input",
	  emissions = 0.04 / 3.5
	},
      smoke =
      {
        {
          name = "smoke",
          deviation = {0.1, 0.1},
          frequency = 5,
          position = {1.0, -0.8},
          starting_vertical_speed = 0.08,
          starting_frame_deviation = 60
        }
      },
    energy_usage = (100+25*i).."kW",
    ingredient_count = 2,
    animation ={
	layers={
	{
        filename = "__omnimatter__/graphics/entity/buildings/centri.png",
		priority = "extra-high",
        width = 237,
        height = 214,
        frame_count = 64,
		line_length = 8,
        shift = {0.00, -0.05},
		scale = 0.5,
		animation_speed = 0.5
	},
	}
	},
    vehicle_impact_sound =  { filename = "__base__/sound/car-metal-impact.ogg", volume = 0.65 },
    working_sound =
    {
      sound = { filename = "__omnimatter__/sound/ore-crusher.ogg", volume = 0.8 },
	  idle_sound = { filename = "__base__/sound/idle1.ogg", volume = 0.6 },
      apparent_volume = 2,
    },
    }
	omnitractor_entities[#omnitractor_entities+1]=omnitractorentity
end
data:extend(omnitractor_technology)
data:extend(omnitractor_entities)
data:extend(omnitractor_item)
data:extend(omnitractor_recipes)