if not omni then omni = {} end

omnisource={}
tiercount={0,0,0}
omnifluid={}
uniomnitiers={}

function omni.add_resource(r,t,s,m)
  omnisource[#omnisource+1]={mod=m,tier = t, ore = r,techicon = s}
  tiercount[t]=tiercount[t]+1
end
function omni.add_fluid(r,t,q,s,m)
  omnifluid[#omnifluid+1]={mod=m,tier = t,ratio=q, fluid = r,techicon = s}
end

function sortTiers()
	for _,source in pairs(omnisource) do
		uniomnitiers[source.tier]={}
		uniomnitiers[source.tier][#uniomnitiers[source.tier]+1]=source.ore
	end
end

function recipe_add_result(recipe, item)
  if data.raw.recipe[recipe] and bobmods.lib.item.get_type(bobmods.lib.item.basic_item(item).name) then
    bobmods.lib.result_check(data.raw.recipe[recipe])
    bobmods.lib.item.add(data.raw.recipe[recipe].results, item)
  else
    if not data.raw.recipe[recipe] then
      log("Recipe " .. recipe .. " does not exist.")
    end
    if not bobmods.lib.item.get_basic_type(bobmods.lib.item.basic_item(item).name) then
      log("Item " .. bobmods.lib.item.basic_item(item).name .. " does not exist.")
    end
  end
end

function recipe_remove_result(recipe, item)
  if data.raw.recipe[recipe] then
    bobmods.lib.result_check(data.raw.recipe[recipe])
    bobmods.lib.item.remove(data.raw.recipe[recipe].results, item)
  else
    log("Recipe " .. recipe .. " does not exist.")
  end
end

function tech_add_recipe_unlock(technology, recipe)
  if data.raw.technology[technology] and data.raw.recipe[recipe] then
    local addit = true
    if not data.raw.technology[technology].effects then
      data.raw.technology[technology].effects = {}
    end
    for i, effect in pairs(data.raw.technology[technology].effects) do
      if effect.type == "unlock-recipe" and effect.recipe == recipe then addit = false end
    end
    if addit then table.insert(data.raw.technology[technology].effects,{type = "unlock-recipe", recipe = recipe}) end
  else
    if not data.raw.technology[technology] then
      log("Technology " .. technology .. " does not exist.")
    end
    if not data.raw.recipe[recipe] then
      log("Recipe " .. recipe .. " does not exist.")
    end
  end
end

function tech_add_prerequisite(technology, prerequisite)
  if data.raw.technology[technology] and data.raw.technology[prerequisite] then
    local addit = true
    if data.raw.technology[technology].prerequisites then
      for i, check in ipairs(data.raw.technology[technology].prerequisites) do
        if check == prerequisite then addit = false end
      end
    else
      data.raw.technology[technology].prerequisites = {}
    end
    if addit then table.insert(data.raw.technology[technology].prerequisites, prerequisite) end
  else
    if not data.raw.technology[technology] then
      log("Technology " .. technology .. " does not exist.")
    end
    if not data.raw.technology[prerequisite] then
      log("Technology " .. prerequisite .. " does not exist.")
    end
  end
end

function tech_remove_recipe_unlock(technology, recipe)
  if data.raw.technology[technology] and data.raw.technology[technology].effects then
    for i, effect in pairs(data.raw.technology[technology].effects) do
      if effect.type == "unlock-recipe" and effect.recipe == recipe then
        table.remove(data.raw.technology[technology].effects,i)
      end
    end
  else
    if not data.raw.technology[technology] then
      log("Technology " .. technology .. " does not exist.")
    end
  end
end
