
local ord={"a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r"}
--Strings
function omni.lib.start_with(a,b)
	return string.sub(a,1,string.len(b)) == b
end

function omni.lib.end_with(a,b)
	return string.sub(a,string.len(a)-string.len(b)+1) == b
end

function omni.lib.recipe_change_category(recipe, category)
	if data.raw.recipe[recipe] and data.raw["recipe-category"][item] then
		data.raw.recipe[recipe].category = category	
	end
end

--mathematics

function omni.lib.round_up(number)
	local decimal = number-math.floor(number)
	if decimal > 0 then return math.floor(number)+1 else return math.floor(number) end
end

--Omni specific
function omni.lib.omni_recipe_fluid_change_category(fluid, category)
	if data.raw.recipe[fluid.."-a"] then
		for i=1,omni.matter.get_constant("fluid level") do
			data.raw.recipe[fluid.."-"..ord[i]].category = category	
		end
	end
end
function omni.lib.lowest_omnite_cost(item)
	for _,recipe in pairs(data.raw.recipe) do
	
	end
end


local fit_ingredients = function(ingredients,multiple)
	local substance = {}
	local amount = {}
	for i=1,#ingredients do
		substance[#substance+1]=ingredients[i].name
		amount[#amount]=ingredients[i].amount*multiple
	end
	return {name=substance,amount=amount}
end
local sort_dependency = function(list)
	local l = {}
	l[1] = list[1]
	
end

local fix_content_list = function(list)
	local substance = {}
	local amount = {}
	for _,ing in pairs(list) do
		substance[#substance+1]=ing.name
		amount[#amount]=ing.amount
	end
	return {name=substance,amount=amount}
end

function omni.lib.achain_omnite_cost(item,chain)
	local cost = 0
	local target_amount = 0
	local required_ingrediences = {}
	for _,result in pairs(data.raw.recipe[chain[1]].results) do
		if result.type == "item" and result.name == item then
			if result.amount then
				target_amount = omni.lib.round_up(1/result.amount)
			else
				target_amount = omni.lib.round_up(1/((result.amount_min+result.amount_max)/2*result.probability))
			end
			break
		end
	end
	
	required_ingredients=data.raw.recipe[chain[1]].ingredients
	required_ingredients=fit_ingredients(required_ingredients,target_amount)
	local list = chain--sort_dependency(chain)
	log("size: "..#list)
	log("exists: "..chain[2])
	if data.raw.recipe[chain[2]] then log("yes") else log("no") end
	--table.remove(list,1)
	for i=2,#chain do
		local sorted_ingredients = fix_content_list(data.raw.recipe[chain[i]].ingredients)
		local sorted_results = fix_content_list(data.raw.recipe[list[i]].results)
		local intersect = omni.lib.table_intersection(sorted_results.name,required_ingredients.name)
		if intersect then
			for j,res in pairs(sorted_results.name) do
				
			end
		end
	end	
	
	return cost
end

function omni.lib.chain_omnite_cost(item,chain)
	local cost = 0
	local target_amount = 0
	local required_ingrediences = {}
	for _,result in pairs(data.raw.recipe[chain[1]].results) do
		if result.type == "item" and result.name == item then
			if result.amount then
				target_amount = omni.lib.round_up(1/result.amount)
			else
				target_amount = omni.lib.round_up(1/((result.amount_min+result.amount_max)/2*result.probability))
			end
			break
		end
	end
	
	required_ingredients=data.raw.recipe[chain[1]].ingredients
	required_ingredients=fit_ingredients(required_ingredients,target_amount)
	local list = chain--sort_dependency(chain)
	--table.remove(list,1)
	for i=2,#chain do
		local sorted_ingredients = fix_content_list(data.raw.recipe[chain[i]].ingredients)
		local sorted_results = fix_content_list(data.raw.recipe[list[i]].results)
		local intersect = omni.lib.table_intersection(sorted_results.name,required_ingredients.name)
		if intersect then
			for j,res in pairs(sorted_results.name) do
				
			end
		end
	end	
	
	return cost
end


--Modifications
function omni.lib.add_number_item(item, val)
	if data.raw.item[item] then
		data.raw.item[item].icons={{icon=data.raw.item[item].icon},{icon = "__omnimatter__/graphics/icons/extraction-"..val..".png"}}
		data.raw.item[item].icon=nil
	end
end

function omni.lib.set_item_icon(item,icon, tint)
	data.raw.item[item].icon = icon
	if tint then omni.lib.change_icon_tint(item,tint) end
end

function omni.lib.change_icon_tint(item, tint)
	local t = {}
	if tint.r then t=tint else t={r=tint[1],g=tint[2],b=tint[3]} end
	local icons = {{icon = data.raw.item[item].icon, tint=t}}
	--data.raw.item[item].icon = icons
	data.raw.item[item].icons = icons
end

function omni.lib.remove_recipe_all_techs(name)
	for _,tech in pairs(data.raw.technology) do
		if tech.effects then
			for i,eff in pairs(tech.effects) do
				if eff.type == "unlock-recipe" and eff.recipe == name then
					table.remove(data.raw.technology[tech.name].effects,i)
				end
			end
		end
	end
end

function omni.lib.add_recipe_ingredient(recipe, ingredient)
	if data.raw.recipe[recipe].ingredients then
		table.insert(data.raw.recipe[recipe].ingredients,ingredient)
	elseif data.raw.recipe[recipe].normal.ingredients then
		table.insert(data.raw.recipe[recipe].normal.ingredients,ingredient)	
		table.insert(data.raw.recipe[recipe].expensive.ingredients,ingredient)	
	end
end

function omni.lib.remove_recipe_ingredient(recipe, ingredient)
	if data.raw.recipe[recipe].ingredients then
		for i,ing in pairs(data.raw.recipe[recipe].ingredients) do
			if ing.name == ingredient then
				table.remove(data.raw.recipe[recipe].ingredients,i)
			end
		end
	elseif data.raw.recipe[recipe].normal.ingredients then
		for i,ing in pairs(data.raw.recipe[recipe].normal.ingredients) do
			if ing.name == ingredient then
				table.remove(data.raw.recipe[recipe].normal.ingredients,i)
			end
		end
		for i,ing in pairs(data.raw.recipe[recipe].expensive.ingredients) do
			if ing.name == ingredient then
				table.remove(data.raw.recipe[recipe].expensive.ingredients,i)
			end
		end
	end
end

function omni.lib.add_unlock_recipe(tech, recipe)
	table.insert(data.raw.technology[tech].effects,{type="unlock-recipe",recipe = recipe})
end

function omni.lib.change_recipe_category(recipe, category)
	data.raw.recipe[recipe].category=category
end

function omni.lib.replace_science_pack(tech,old, new)
	local r = new
	if not r then r = "omni-pack" end
	if data.raw.technology[tech] then
		for i,ing in pairs(data.raw.technology[tech].unit.ingredients) do
			if ing[1]==old then
				data.raw.technology[tech].unit.ingredients[i][1]=r
			end
		end
	else
		log(tech.." cannot be found, replacement of "..old.." with "..r.." has failed.")
	end
end


function omni.lib.add_science_pack(tech,pack)
	if data.raw.technology[tech] then
		if type(pack) == "table" then
			table.insert(data.raw.technology[tech].unit.ingredients,pack)
		elseif type(pack) == "string" then
			table.insert(data.raw.technology[tech].unit.ingredients,{pack,1})
		elseif type(pack)=="number" then
			table.insert(data.raw.technology[tech].unit.ingredients,{"omni-pack",pack})
		else
			table.insert(data.raw.technology[tech].unit.ingredients,{"omni-pack",1})		
		end
	else
		log("Cannot find "..tech..", ignoring it.")
	end
end

function omni.lib.remove_science_pack(tech,pack)
	for i,ing in pairs(data.raw.technology[tech].unit.ingredients) do
		if ing[1]==pack then
			table.remove(data.raw.technology[tech].unit.ingredients,i)
		end
	end
end

function omni.lib.replace_prerequisite(tech,old, new)
	for i,req in pairs(data.raw.technology[tech].prerequisites) do
		if req==old then
			data.raw.technology[tech].prerequisites[i]=new
		end
	end
end

function omni.lib.set_prerequisite(tech, req)
	if type(req) == "table" then
		data.raw.technology[tech].prerequisites = req
	else
		data.raw.technology[tech].prerequisites = {req}
	end
end

--checks
--[[
Checks a recipe contains a specific material as the result
]]
function omni.lib.recipe_result_contains(recipe, item)
	for _,res in pairs(data.raw.recipe[recipe].results) do
		local r = {}
		if res.name then
			r=res
		else
			r={type="item",name=res[1],amount=res[2]}
		end
		if type(item) == "table" then
			if omni.lib.is_in_table(r.name,item) then return true end
		else
			if r.name==item then return true end
		end		
	end
	return false
end

--String
--[[
Checks if a string contains anything within the provided list
]]
function omni.lib.string_contained_list(str, list)
	for i=1, #list do
		if string.find(str,list[i]) then return true end
	end
	return false
end

--Set theoretical
--[[
Checks if a table contains a specific element
]]
function omni.lib.is_in_table(element, tab)
	for i=1, #tab do
		if tab[i]==element then return true end
	end
	return false
end
--[[
A function that takes two tables and gives out the elements they have in common
]]
function omni.lib.table_intersection(t, d)
	local inter={}
	for i=1,#t do
		if omni.lib.is_in_table(d,t[i]) then inter[#inter+1]=t[i] end
	end
	if #inter > 0 then return inter else return nil end
end

