local deepcopy = util.table.deepcopy --luacheck: ignore util
--need recipes to convert to coal/heavy oil to get rid of em!

--cooked fish
data.raw.capsule["raw-fish"].fuel_value = "1MJ"
data.raw.capsule["raw-fish"].fuel_category = "chemical"

local recipe_cooked_fish = {
    type = "recipe",
    name = "cooked-fish",
    category = "smelting",
    energy_required = 3.5,
    ingredients = {{ "raw-fish", 2}},
    result = "cooked-fish",
    enabled = true
}

local item_cooked_fish = {
    type = "capsule",
    name = "cooked-fish",
    icon = "__BiterBacon__/graphics/icons/cooked-fish.png",
    flags = {"goes-to-quickbar"},
    subgroup = "raw-resource",
    fuel_value = "1MJ",
    fuel_category = "chemical",
    capsule_action =
    {
        type = "use-on-self",
        attack_parameters =
        {
            type = "projectile",
            ammo_category = "capsule",
            cooldown = 30,
            range = 0,
            ammo_type =
            {
                category = "capsule",
                target_type = "position",
                action =
                {
                    type = "direct",
                    action_delivery =
                    {
                        type = "instant",
                        target_effects =
                        {
                            type = "damage",
                            damage = {type = "physical", amount = -40}
                        }
                    }
                }
            }
        }
    },
    order = "f-e-a-a",
    stack_size = 50
}

--raw biter meat
local item_raw_biter_meat = {
    type = "capsule",
    name = "raw-biter-meat",
    icon = "__BiterBacon__/graphics/icons/raw-pork.png",
    flags = {"goes-to-quickbar"},
    subgroup = "raw-resource",
    fuel_value = "1MJ",
    fuel_category = "chemical",
    capsule_action =
    {
        type = "use-on-self",
        attack_parameters =
        {
            type = "projectile",
            ammo_category = "capsule",
            cooldown = 30,
            range = 0,
            ammo_type =
            {
                category = "capsule",
                target_type = "position",
                action =
                {
                    type = "direct",
                    action_delivery =
                    {
                        type = "instant",
                        target_effects =
                        {
                            type = "damage",
                            damage = {type = "physical", amount = -20}
                        }
                    }
                }
            }
        }
    },
    order = "f-e-a-c",
    stack_size = 100
}

--biter bacon
local recipe_biter_bacon = {
    type = "recipe",
    name = "cooked-biter-meat",
    category = "smelting",
    energy_required = 3.5,
    ingredients = {{ "raw-biter-meat", 2}},
    result = "cooked-biter-meat",
    enabled = true
}

local item_biter_bacon = {
    type = "capsule",
    name = "cooked-biter-meat",
    icon = "__BiterBacon__/graphics/icons/cooked-bacon.png",
    flags = {"goes-to-quickbar"},
    subgroup = "raw-resource",
    fuel_value = "1MJ",
    fuel_category = "chemical",
    capsule_action =
    {
        type = "use-on-self",
        attack_parameters =
        {
            type = "projectile",
            ammo_category = "capsule",
            cooldown = 30,
            range = 0,
            ammo_type =
            {
                category = "capsule",
                target_type = "position",
                action =
                {
                    type = "direct",
                    action_delivery =
                    {
                        type = "instant",
                        target_effects =
                        {
                            type = "damage",
                            damage = {type = "physical", amount = -50}
                        }
                    }
                }
            }
        }
    },
    order = "f-e-a-d",
    stack_size = 50
}

local recipe_cooked_fish_to_oil = {
    type = "recipe",
    name = "cooked-fish-to-oil",
    category = "crafting-with-fluid",
    energy_required = 1.5,
    ingredients = {
        {type = "item", name = "cooked-fish", amount = 8}
    },
    results = {
        {type = "fluid", name = "heavy-oil", amount = 20}
    },
    enabled = true
}

local recipe_cooked_biter_meat_to_oil = deepcopy(recipe_cooked_fish_to_oil)
recipe_cooked_biter_meat_to_oil.name = "cooked-biter-meat-to-oil"
recipe_cooked_biter_meat_to_oil.ingredients[1] = {type = "item", name = "cooked-biter-meat", amount = 8}

 data:extend{
     recipe_cooked_fish, item_cooked_fish, item_raw_biter_meat, recipe_biter_bacon, item_biter_bacon, recipe_cooked_fish_to_oil, recipe_cooked_biter_meat_to_oil,
 }
