data:extend({

	-- water->MF heat-transmission
	{
	  type = "recipe",
	  name = "ye_water2mf_recipe",
	  category = "yrcat_transform", 
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "water" , amount = 500.0, minimum_temperature = 15},
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 5.0, temperature = 90, },
	  },
	  icon = "__yi_engines__/graphics/steam.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},


	-- make steam - needs lua-code
	{
	  type = "recipe",
	  name = "ye_makesteam_recipe",
	  category = "yrcat-heater", -- overheater for steam
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "water" , amount = 200.0, minimum_temperature = 15},
	  },
	  results = {
		{ type = "fluid", name = "steam", amount = 2400.0, temperature = 1000, },
	  },
	  icon = "__yi_engines__/graphics/steam.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- gearbox transmission without lubricant
	{
	  type = "recipe",
	  name = "y-mf2b-recipe",
	  category = "yrcat-mf2", -- gearbox
	  enabled = "true",
	  energy_required = 0.50,
	  ingredients = {
		{ type = "fluid", name = "y-mechanical-force" , amount = 1.6, },
		{ type = "fluid", name = "water" , amount = 50, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 1.4, temperature = 215, },
	  },
	  icon = "__yi_engines__/graphics/gears_br.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- steam to mechanical power
	{
	  type = "recipe",
	  name = "ye_steam2mf_recipe",
	  category = "yrcat_turbine", -- steam to mechanical power
	  enabled = "true",
	  energy_required = 1.20,
	  ingredients = {
		{ type = "fluid", name = "steam" , amount = 4800, minimum_temperature = 250},
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 24.0, temperature = 400, },
		{ type = "fluid", name = "water", amount = 380, temperature = 75,},
	  },
	  icon = "__yi_engines__/graphics/mf-1.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},


	-- quantrium-reactor power-generation recipe 1
	{
	  type = "recipe",
	  name = "y-mf1-q1-recipe",
	  category = "yrcat-mf1q", -- mechanical force quantrinum-reactor
	  enabled = "true",
	  energy_required = 2.00,
	  ingredients = {
		{ type = "item", name = "y-infused-uca2" , amount = 1.0, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 300.0, temperature = 275,},
	  },
	  icon = "__yi_engines__/graphics/gear_xtra.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- quantrium-reactor power-generation recipe 2
	{
	  type = "recipe",
	  name = "y-mf1-q2-recipe",
	  category = "yrcat-mf1q", -- mechanical force quantrinum-reactor
	  enabled = "true",
	  energy_required = 2.00,
	  ingredients = {
		{ type = "item", name = "y-quantrinum" , amount = 1.0, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 500.0, temperature = 350,},
	  },
	  icon = "__yi_engines__/graphics/gear_xtra.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- quantrium-reactor power-generation recipe 3
	{
	  type = "recipe",
	  name = "y-mf1-q3-recipe",
	  category = "yrcat-mf1q", -- mechanical force quantrinum-reactor
	  enabled = "true",
	  energy_required = 2.00,
	  ingredients = {
		{ type = "item", name = "y-quantrinum-charge" , amount = 1.0, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 1500.0, temperature = 485,},
	  },
	  icon = "__yi_engines__/graphics/gear_xtra.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- gearbox transmission with lubricant
	{
	  type = "recipe",
	  name = "y-mf2a-recipe",
	  category = "yrcat-mf2", -- gearbox
	  enabled = "true",
	  energy_required = 0.25,
	  ingredients = {
		{ type = "fluid", name = "y-mechanical-force" , amount = 2.6, },
		{ type = "fluid", name = "lubricant" , amount = 0.1, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 2.5, temperature = 250, },
	  },
	  icon = "__yi_engines__/graphics/gears_br.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- without lubricant, still water for cooling - sfe
	{
	  type = "recipe",
	  name = "y-mf1a1-recipe",
	  category = "yrcat-mf1a", -- mechanical force primary - sfe
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "water" , amount = 20.0, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 18, temperature = 160, },
	  },
	  icon = "__yi_engines__/graphics/gear_basic.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- Hydromechanical Power
	{
	  type = "recipe",
	  name = "y-mf1b-recipe",
	  category = "yrcat-mf1b", -- mechanical force primary - ffe
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "heavy-oil" , amount = 30, },
		{ type = "fluid", name = "lubricant" , amount = 2, },
		{ type = "fluid", name = "water" , amount = 150, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 40, temperature = 250, },
	  },
	  icon = "__yi_engines__/graphics/gear_wet.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- 
	{
	  type = "recipe",
	  name = "y-mf1d-recipe",
	  category = "yrcat-mf1b", -- mechanical force primary - ffe
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "light-oil" , amount = 20, },
		{ type = "fluid", name = "lubricant" , amount = 2, },
		{ type = "fluid", name = "water" , amount = 150, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 40, temperature = 280, },
	  },
	  icon = "__yi_engines__/graphics/gear_wet.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- SFE - burn corn-oil - self lubricant
	{
	  type = "recipe",
	  name = "y-mf1e-recipe",
	  category = "yrcat-mf1b", -- mechanical force primary - ffe
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "ye_cornoil" , amount = 30, },
		{ type = "fluid", name = "water" , amount = 150, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 32, temperature = 180, },
	  },
	  icon = "__yi_engines__/graphics/gear_wet.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},

	-- 
	{
	  type = "recipe",
	  name = "y-mf1a-recipe",
	  category = "yrcat-mf1a", -- mechanical force primary - sfe
	  enabled = "true",
	  energy_required = 1.00,
	  ingredients = {
		{ type = "fluid", name = "water" , amount = 100, },
		{ type = "fluid", name = "lubricant" , amount = 2, },
	  },
	  results = {
		{ type = "fluid", name = "y-mechanical-force", amount = 30, temperature = 210, },
	  },
	  icon = "__yi_engines__/graphics/gear_wet.png",
	  order = "0", group = "yi_engines", subgroup = "yie-fluids",
	},
	
})