
function add_trail_to_ammo(ammo, trail)
	local action1 = ammo.ammo_type.action[1] or ammo.ammo_type.action
	if not action1 then return end
	local action_delivery1 = action1.action_delivery[1] or action1.action_delivery
	if not action_delivery1 then return end
	if not action_delivery1.source_effects then action_delivery1.source_effects = {} end
	if (not action_delivery1.source_effects[1]) and action_delivery1.source_effects.type then
		action_delivery1.source_effects = {action_delivery1.source_effects}
	end
	table.insert(action_delivery1.source_effects, trail)
end

for ammo_name, ammo in pairs(data.raw.ammo) do
	if ammo.ammo_type and ammo.ammo_type.category and ammo.ammo_type.category == "bullet" then
		if ammo_name == 'firearm-magazine' then
			add_trail_to_ammo(ammo, { type = "create-explosion", entity_name = "bullet-beam-yellow-faint" })
		elseif ammo_name == 'piercing-rounds-magazine' then
			add_trail_to_ammo(ammo, { type = "create-explosion", entity_name = "bullet-beam-red-faint" })
		elseif ammo_name == 'uranium-rounds-magazine' then
			add_trail_to_ammo(ammo, { type = "create-explosion", entity_name = "bullet-beam-olive" })
		else
			add_trail_to_ammo(ammo, { type = "create-explosion", entity_name = "bullet-beam-cyan" })
		end
	end
end
