require "util"

script.on_init(function()

-- For Testing
 game.surfaces['nauvis'].daytime = .7
--game.surfaces['nauvis'].daytime = .49
 --game.speed = 5
 
-- Constants
global.TicksToUpdateBitersTarget =  600
global.SpawnMultiplier = 10
global.SpawnEveryXTicks = 600
global.MaxAttemptsAtPlacingUnit = 20
global.SpawnRadius = 300
global.MediumBiterRound = 10
global.BigBiterRound = 18
global.BehemothBiterRound = 25
global.BehemothSpitterRound = 32
global.MegaBiterRound = 40

-- Drop chance (out of 1000)
global.ChanceToDropAmmo = 100
global.ChanceToDropLaserTurret = 4

-- Counters
global.Round = 0
global.isNightTime = false
global.CurrentRoundSpawnDuration = 0
global.CurrentTicksToUpdateBitersTarget = global.TicksToUpdateBitersTarget
global.UnitsSpawnedThisRound = 0
global.CheckNumberUnitsAliveCounter = 0;
global.TotalRoundEnemies = 0 
global.RoundForUnitCount = global.Round

-- Others
global.typeofunittospawn = "small-biter"
global.AmmoToDrop = "firearm-magazine"
global.Difficulty = settings.global["Survival-Difficulty"].value
SetDifficulty()

end)



script.on_event(defines.events, function(event)
   if event.name == defines.events.on_tick then
     -- handle on tick
	
     -- Set Rounds
     if (game.surfaces['nauvis'].daytime >= .5 and game.surfaces['nauvis'].daytime < .7 and global.isNightTime == false ) then
     -- New Round Begins
      NewRoundBegins()
      
     elseif (game.surfaces['nauvis'].daytime >= .7 and global.isNightTime == true ) then
     
      -- Round Ends
      SendPrintToAllPlayers("Round Over")
      game.surfaces['nauvis'].freeze_daytime(false)
      
      global.isNightTime = false;
      
     end
     
     if (global.isNightTime == true) then
     
     -- Spawn units every x ticks until all units have spawned this round
      global.CurrentRoundSpawnDuration = global.CurrentRoundSpawnDuration +1;
      if (global.CurrentRoundSpawnDuration >= global.SpawnEveryXTicks and global.UnitsSpawnedThisRound < global.TotalRoundEnemies) then
	  
	--	SendPrintToAllPlayers("global.UnitsSpawnedThisRound: " .. global.UnitsSpawnedThisRound .. " Total Enemies: " .. global.TotalRoundEnemies)
		-- only if there are less than 80 units on map (can't have more than 80 units on the map at once for some reason)
		local allbiters = game.surfaces['nauvis'].count_entities_filtered{force=game.forces.enemy,type="unit"}
--		if (allbiters <= math.max(80-(global.RoundForUnitCount*#game.players),0)) then
			spawnEnemies()
--		end
		global.CurrentRoundSpawnDuration = 0
        
      end
	  
	  if (game.tick % 60 == 0) then
			for _, player in pairs(game.players) do
			  if player.gui.top.SurvivalGUI then update_useful_info(player) end
			end
		  end
      
      UpdateEnemyTargetLocation()
      
      CheckToSeeIfRoundOver()
      
     end
     if (global.isNightTime == false) then
       
     end
	 
     
 end
  if event.name == defines.events.on_entity_died then
  
    if (event.entity.force==game.forces.enemy) then
    
--      SendPrintToAllPlayers("Enemy Died")
      -- Chance to drop ammo
      if (math.random(0,1000) <= global.ChanceToDropAmmo) then
          game.surfaces['nauvis'].create_entity{name="item-on-ground",position=event.entity.position,stack={name=global.AmmoToDrop, count=10}}
     
		elseif (math.random(0,1000) <= global.ChanceToDropLaserTurret) then
			game.surfaces['nauvis'].create_entity{name="item-on-ground",position=event.entity.position,stack={name="laser-turret", count=1}}
	  end
	  
    end
  end

 end)
 
 function NewRoundBegins()
      game.surfaces['nauvis'].freeze_daytime(true)
		global.isNightTime = true;
       global.Round = global.Round + 1;
       
       -- global.RoundForUnitCount resets when big units come out
       global.RoundForUnitCount = global.RoundForUnitCount + 1
      SendPrintToAllPlayers("Round "..global.Round .. " begins.")
	  SendPrintToAllPlayers(#game.players.." players")
	  
      if (global.Round == 5) then
        global.RoundForUnitCount = 10
      end
	  
      if (global.Round == global.MediumBiterRound) then
        global.typeofunittospawn = "medium-biter"
        global.RoundForUnitCount = 1
      end
	  
      
      if (global.Round == global.BigBiterRound) then
		global.AmmoToDrop = "piercing-rounds-magazine"
        global.typeofunittospawn = "big-biter"
        global.RoundForUnitCount = 1
        
      end
      
      if (global.Round == global.BehemothBiterRound) then
        global.typeofunittospawn = "behemoth-biter"
        global.RoundForUnitCount = 1
		global.SpawnMultiplier = global.SpawnMultiplier/2
      end
      
	  if (global.Round == global.BehemothSpitterRound) then
        global.typeofunittospawn = "behemoth-spitter"
        global.RoundForUnitCount = 5
      end
	  
	  if (global.Round == global.MegaBiterRound) then
        global.typeofunittospawn = "mega-biter"
		global.RoundForUnitCount = 5
      end
	  
	
	  
      
       -- Spawn a new unit every x ticks during nighttime
      global.TotalRoundEnemies = global.SpawnMultiplier * global.RoundForUnitCount * #game.players
	  
      SendPrintToAllPlayers(global.TotalRoundEnemies.." enemies this round")
  --    SendPrintToAllPlayers(global.UnitsSpawnedThisRound .." enemies spawned")
	  SendPrintToAllPlayers(global.typeofunittospawn)
      
 end
 

 function CheckToSeeIfRoundOver()
 
   -- To determine if a round has ended
       if (global.UnitsSpawnedThisRound >= global.TotalRoundEnemies) then
        -- Every 10 seconds, check to see how many enemies are alive
        if (global.CheckNumberUnitsAliveCounter == 600) then
          global.CheckNumberUnitsAliveCounter = 0
       
          local allbiters = game.surfaces['nauvis'].count_entities_filtered{force=game.forces.enemy,type="unit"}

          -- Round over when all units are dead, back to day time
          if (allbiters == 0) then
            game.surfaces['nauvis'].daytime = .7
            global.UnitsSpawnedThisRound = 0
            global.CheckNumberUnitsAliveCounter = 0
            global.CurrentRoundSpawnDuration = 0
			
          end
         end
         global.CheckNumberUnitsAliveCounter = global.CheckNumberUnitsAliveCounter+1
       end
 
 end
 
 
 
 function spawnEnemies()
 
   for index,player in pairs(game.players) do 
		 if( game.players[index].connected) then
		 
		    
				local playerpos = game.players[index].position
				local numbertospawn = global.RoundForUnitCount
				local counter = 0
				while counter < numbertospawn do
				
					local enemyspawnpoint = GetSpawnLocation(index)
				
					-- so that they dont overlap
					enemyspawnpoint.x = enemyspawnpoint.x + counter
					
					local placecounter = 0;
					local canplace = game.surfaces['nauvis'].can_place_entity{name=global.typeofunittospawn,position=enemyspawnpoint}
					while (canplace == false and placecounter<global.MaxAttemptsAtPlacingUnit) do
						placecounter = placecounter + 1
						enemyspawnpoint.x = enemyspawnpoint.x + 1
						canplace = game.surfaces['nauvis'].can_place_entity{name=global.typeofunittospawn,position=enemyspawnpoint}
					end
					
				-- Spawn an enemy 
					if (canplace) then
						local thisbiter = game.surfaces['nauvis'].create_entity{name=global.typeofunittospawn,position=enemyspawnpoint,force=game.forces.enemy, target=playerpos}
						
						-- Send him to  player 1
						thisbiter.set_command({type=defines.command.go_to_location, destination=playerpos})
						
						global.UnitsSpawnedThisRound = global.UnitsSpawnedThisRound + 1
						
						counter = counter + 1
						
						SendPrintToAllPlayers("sending "..numbertospawn.. " biters")
					end
			end
			
		 end
      end
	
  
 end
 
 global.spawncounter = 0
 ----------------------------------- Spawns in a circle around the player ------------------------------
 function GetSpawnLocation()
 
	local playerpos = game.players[1].position
	local interval = mod(global.spawncounter,8)
	global.spawncounter = global.spawncounter + 1
	
--	SendPrintToAllPlayers("interval ".. interval)
--	SendPrintToAllPlayers("spawncounter ".. global.spawncounter)
	
	if (interval == 0) then
		playerpos.y = playerpos.y - global.SpawnRadius;
		playerpos.x = playerpos.x;
	elseif (interval == 1) then
		playerpos.y = playerpos.y - global.SpawnRadius;
		playerpos.x = playerpos.x + global.SpawnRadius;
	elseif (interval == 2) then
		playerpos.y = playerpos.y;
		playerpos.x = playerpos.x + global.SpawnRadius;
	elseif (interval == 3) then
		playerpos.y = playerpos.y + global.SpawnRadius;
		playerpos.x = playerpos.x + global.SpawnRadius;
	elseif (interval == 4) then
		playerpos.y = playerpos.y + global.SpawnRadius;
		playerpos.x = playerpos.x;
	elseif (interval == 5) then
		playerpos.y = playerpos.y + global.SpawnRadius;
		playerpos.x = playerpos.x - global.SpawnRadius;
	elseif (interval == 6) then
		playerpos.y = playerpos.y;
		playerpos.x = playerpos.x - global.SpawnRadius;
	elseif (interval == 7) then
		playerpos.y = playerpos.y - global.SpawnRadius;
		playerpos.x = playerpos.x - global.SpawnRadius;
		
	end
	return playerpos
 end
 
  function UpdateEnemyTargetLocation()
 
 -- Update all enemies, have their target location go to wherever the player has moved to
      global.CurrentTicksToUpdateBitersTarget = global.CurrentTicksToUpdateBitersTarget-1
      if (global.CurrentTicksToUpdateBitersTarget == 0) then
        global.CurrentTicksToUpdateBitersTarget = global.TicksToUpdateBitersTarget
        local allbiters = game.surfaces['nauvis'].find_entities_filtered{force=game.forces.enemy,type="unit"}
        for i,v in pairs(allbiters)  do
          local totalplayers = #game.players
          local playertotargetindex = mod(i,totalplayers)+1
          -- Take turns, have units target each player
		  if(game.players[playertotargetindex].connected) then
			v.set_command({type=defines.command.go_to_location, destination=game.players[playertotargetindex].position})
		  end
		  -- /c game.players[1].print(game.players[2].position.x)
        end
      end
 
 end

 -------------------------------------------------- Helper Functions -------------------------------------------
 
 function mod(a, b)
return a - (math.floor(a/b)*b)
end

  function SendPrintToAllPlayers(message)
 
   for i,v in pairs(game.players)  do
          v.print(message)
   end
 
 end
 
 function KillAllEnemyUnits()
 
  local allbiters = game.surfaces['nauvis'].find_entities_filtered{force=game.forces.enemy,type="unit"}
        for i,v in pairs(allbiters)  do
          v.destroy() 
        end
 
 end
 
 
 ------------------------------------------ GUI -----------------------------------------------------------
 
 
function toggle_survivalmode_gui(player)
	
  if player.gui.top.SurvivalGUI then
    player.gui.top.SurvivalGUI.destroy()
  else
    local frame = player.gui.top.add{type="frame", name="SurvivalGUI", direction="vertical", caption = "Survival Mode"}
    frame.add{type="label", name="Round"}
	frame.add{type="label", name="BitersRound"}
	frame.add{type="label", name="EnemiesAlive"}
	
    update_useful_info(player)
  end
end

function update_useful_info(player)
	local frame = player.gui.top.SurvivalGUI

	frame.Round.caption = "Round: " ..global.Round 
	local allbiters = game.surfaces['nauvis'].count_entities_filtered{force=game.forces.enemy,type="unit"}
	frame.EnemiesAlive.caption = "Enemies Alive: " .. allbiters
  
	frame.BitersRound.caption = "Rounds until"
	if (global.Round < global.MediumBiterRound) then
		frame.BitersRound.caption = frame.BitersRound.caption .. " Medium Biters: " .. (global.MediumBiterRound-global.Round)
	elseif (global.Round < global.BigBiterRound) then
		frame.BitersRound.caption = frame.BitersRound.caption .. " Big Biters: " .. (global.BigBiterRound-global.Round)
	elseif (global.Round < global.BehemothBiterRound) then
		frame.BitersRound.caption = frame.BitersRound.caption .. " Behemoth Biters: " .. (global.BehemothBiterRound-global.Round)
	elseif (global.Round < global.BehemothSpitterRound) then
		frame.BitersRound.caption = frame.BitersRound.caption .. " Behemoth Spitters: " .. (global.BehemothSpitterRound-global.Round)
	elseif (global.Round < global.MegaBiterRound) then
		frame.BitersRound.caption = frame.BitersRound.caption .. " Mega Biters: " .. (global.MegaBiterRound-global.Round)
	end
end

function SetDifficulty()

	if (global.Difficulty == "Beginner") then
		global.SpawnEveryXTicks = 800
		global.SpawnMultiplier = 6
		global.MediumBiterRound = 20
		global.BigBiterRound = 30
		global.BehemothBiterRound = 40
		global.BehemothSpitterRound = 50
		global.MegaBiterRound = 60
	elseif (global.Difficulty == "Easy") then
		global.SpawnEveryXTicks = 700
		global.SpawnMultiplier = 8
		global.MediumBiterRound = 15
		global.BigBiterRound = 26
		global.BehemothBiterRound = 35
		global.BehemothSpitterRound = 42
		global.MegaBiterRound = 50
	elseif (global.Difficulty == "Normal") then
		global.SpawnEveryXTicks = 600
		global.SpawnMultiplier = 10
		global.MediumBiterRound = 10
		global.BigBiterRound = 18
		global.BehemothBiterRound = 25
		global.BehemothSpitterRound = 32
		global.MegaBiterRound = 40
	elseif (global.Difficulty == "Hard") then
		global.SpawnEveryXTicks = 500
		global.SpawnMultiplier = 12
		global.MediumBiterRound = 8
		global.BigBiterRound = 16
		global.BehemothBiterRound = 22
		global.BehemothSpitterRound = 28
		global.MegaBiterRound = 35
	elseif (global.Difficulty == "Extreme") then
		global.SpawnEveryXTicks = 400
		global.SpawnMultiplier = 14
		global.MediumBiterRound = 6
		global.BigBiterRound = 12
		global.BehemothBiterRound = 18
		global.BehemothSpitterRound = 24
		global.MegaBiterRound = 30
	end

end

script.on_event("toggle-survivalmode-gui", function(event) toggle_survivalmode_gui(game.players[event.player_index]) end)
script.on_event(defines.events.on_player_created, 
	function(event) 
	toggle_survivalmode_gui(game.players[event.player_index])
	SendPrintToAllPlayers("Survival mode Difficulty: " .. global.Difficulty)
	end)
