local unit_types = {"unit-spawner", "unit", "turret"}
--local unit_names = {"biter", "spitter", "worm"}

for _, types in pairs(unit_types) do
    for _, unit in pairs(data.raw[types]) do
        if unit.max_health > 0 and (unit.name:find("biter") or unit.name:find("spitter") or unit.name:find("worm")) then
            log(unit.name)
            if not unit.loot then unit.loot = {} end
            local probability = .1
            if unit.type == "unit-spawner" then
                probability = .2
            end
            unit.loot[#unit.loot+1] = {
                count_max = math.max(1, (math.min(unit.max_health, 1000)/100)/2),
                count_min = 1,
                item = "raw-biter-meat",
                probability = probability
            }
        end
    end
end
