----------------------------------------------------
-- Copyright 2017 - https://opensource.org/licenses/MIT
----------------------------------------------------

----------------------------------------------------
-- New colours and their mapped values
----------------------------------------------------

local colour_map =
{
    -- This is mostly here to shift the layout of the signals
    {type="virtual", name="signal-darkgrey", color={r=0.2,g=0.2,b=0.2,a=0.75}},

    -- Light colours
    {type="virtual", name="signal-hotpink", color={r=1,g=0.41,b=0.7,a=0.5}},
    {type="virtual", name="signal-orange", color={r=1,g=0.64,b=0,a=0.6}},
    {type="virtual", name="signal-chartreuse", color={r=0,g=1,b=0.5,a=0.5}},
    {type="virtual", name="signal-purple", color={r=0.5,g=0,b=1,a=0.8}},

    -- Darker/paler versions
    {type="virtual", name="signal-darkpink", color={r=0.5,g=0,b=0.25,a=0.35}},
    {type="virtual", name="signal-darkorange", color={r=0.5,g=0.2,b=0,a=0.45}},
    {type="virtual", name="signal-palegreen", color={r=0,g=0.5,b=0.25,a=0.25}},
    {type="virtual", name="signal-paleblue", color={r=0,g=0.25,b=0.5,a=0.25}},
}

----------------------------------------------------
-- Create new virtual signals
----------------------------------------------------

local function icontint(c)
    return {r=c.r, g=c.g, b=c.b, a=0.8}
end

for id, c in pairs(colour_map) do
    local ordername = string.gsub(c.name, "signal(-)", "")
    data:extend
    {
        {
            type = "virtual-signal",
            name = c.name,
            icons =
            {
                {
                    icon = "__base__/graphics/icons/signal/signal_grey.png",
                    tint = icontint(c.color)
                },
            },
            subgroup = "virtual-signal-color",
            -- Tweak order so these sort after base colours
            order = "d[colours]-[" .. id .. ordername .. "]"
        }
    }
end

----------------------------------------------------
-- Add colour values for existing signals
----------------------------------------------------

-- These signals already exist but do not have colour mappings
local existing_signals =
{
    {type="virtual", name="signal-black", color={r=0,g=0,b=0,a=0.75}},
    {type="virtual", name="signal-grey", color={r=0.5,g=0.5,b=0.5,a=0.5}},

    -- Just some basics for now
    {type="item", name="iron-ore", color={r=0,g=0.25,b=0.5,a=0.75}},
    {type="item", name="copper-ore", color={r=1,g=0.55,b=0,a=0.75}},
    {type="item", name="uranium-ore", color={r=0.15,g=1.0,b=0.25,a=0.95}},

    {type="item", name="iron-plate", color={r=0.75,g=0.75,b=0.85,a=0.85}},
    {type="item", name="copper-plate", color={r=1,g=0.5,b=0,a=0.85}},
    {type="item", name="steel-plate", color={r=0.7,g=0.7,b=0.7,a=0.85}},

    -- These were initially based on the base_color property of the corresponding fluids
    -- then tweaked to look nicer when applied to the small-lamp
    {type="fluid", name="water", color={a=0.7,b=0.75,g=0.425,r=0}},
    {type="fluid", name="crude-oil", color={a=0.7, b=0.1, g=0.1, r=0.1}},
    {type="fluid", name="heavy-oil", color={a=0.7, b=0, g=0.05, r=0.625}},
    {type="fluid", name="light-oil", color={a=0.7, b=0, g=0.4125, r=0.7125}},
    {type="fluid", name="petroleum-gas", color={a=0.7, b=0.375, g=0.125, r=0.375}},
    {type="fluid", name="lubricant", color={a=0.7, b=0.0375, g=0.525, r=0.1875}},
    {type="fluid", name="sulfuric-acid", color={a=0.7, b=0.125, g=0.8125, r=0.9375}},
}

for _, c in pairs(existing_signals) do
    table.insert(colour_map, c)
end


-- Generate "random" colours for letters and numbers

local function randcolour()
    return
    {
        r = (math.random(0, 255)) / 255.0,
        g = (math.random(0, 255)) / 255.0,
        b = (math.random(0, 255)) / 255.0,
        a = (math.random(25, 75)) / 100.0,
    }
end

for id=0,9 do
    table.insert(colour_map, {
        type="virtual",
        name="signal-"..id,
        color = randcolour()
    })
end

for id=string.byte("A"),string.byte("Z") do
    table.insert(colour_map, {
        type="virtual",
        name="signal-"..string.char(id),
        color = randcolour()
    })
end

----------------------------------------------------
-- Update all lamps that use signal_to_color_mapping
----------------------------------------------------
-- Base game only has entity["small-lamp"]

for _, e in pairs(data.raw.lamp) do
    if e.signal_to_color_mapping then
        for _, value in pairs(colour_map) do
            table.insert(e.signal_to_color_mapping, value)
        end
    end
end
