local function autoplace_settings(settings)

	local peaks = {}

    peaks[1] = {
            influence = -0.09
    }
    peaks[2] = {
            influence = 0.4,
            noise_layer = "trees",
            noise_octaves_difference = -1,
            noise_persistence = 0.8
    }

	local terrain = {
		influence = settings.terrain_influence or 0.3,
		min_influence = 0,
	}
	for noise_layer, range in pairs(settings.terrain) do
		terrain[noise_layer.."_optimal"] = (range[1] + range[2]) / 2
		terrain[noise_layer.."_range"] = (range[2] - range[1]) / 2
		terrain[noise_layer.."_max_range"] = (range[2] - range[1]) / 2 + (biome[noise_layer.."_range"][3] - biome[noise_layer.."_range"][3])/ biome[noise_layer.."_steps"]
	end
	peaks[3] = terrain

	return {
		order = "a[tree]-b[forest]",
		max_probability = settings.max,
		random_probability_penalty = 0.001,
		sharpness = 0.4,
		peaks = peaks
	}
end

local colors = {
	red = {
		{r = 217, g = 73, b = 73},
		{r = 207, g = 27, b = 44},
		{r = 121, g = 18, b = 43},
		{r = 154, g = 46, b = 25},
		{r = 183, g = 27, b = 18},
		{r = 148, g = 28, b = 19},
		{r = 122, g = 27, b = 16},
		{r = 156, g = 73, b = 25},
		{r = 115, g = 74, b = 35},
		{r = 156, g = 73, b = 25},
		{r = 184, g = 86, b = 19},
	},
	red_dark = {
		{r = 114, g = 18, b = 18},
		{r = 66, g = 30, b = 22},
		{r = 80, g = 31, b = 42},
		{r = 95, g = 43, b = 22},
		{r = 101, g = 14, b = 10},
		{r = 83, g = 30, b = 19},
		{r = 83, g = 60, b = 29},
		{r = 116, g = 43, b = 22},
	},
	orange = {
		{r = 222, g = 148, b = 43},
		{r = 219, g = 85, b = 2},
		{r = 196, g = 57, b = 20},
		{r = 169, g = 89, b = 17},
		{r = 135, g = 79, b = 13},
		{r = 211, g = 132, b = 37},
		{r = 241, g = 164, b = 12},
		{r = 95, g = 77, b = 30},
	},
	yellow = {
		{r = 207, g = 194, b = 46},
		{r = 214, g = 162, b = 46},
		{r = 151, g = 139, b = 65},
		{r = 224, g = 232, b = 14},
		{r = 180, g = 154, b = 9},
		{r = 135, g = 145, b = 32},
		{r = 219, g = 192, b = 2},
	},
	brown = {
		{r = 170, g = 128, b = 29},
		{r = 96, g = 76, b = 29},
		{r = 109, g = 83, b = 14},
		{r = 83, g = 61, b = 29},
		{r = 94, g = 60, b = 19},
		{r = 109, g = 54, b = 14},
		{r = 109, g = 97, b = 14},
	},
	olive = {
		{r = 191, g = 194, b = 45},
		{r = 84, g = 95, b = 42},
		{r = 94, g = 105, b = 38},
		{r = 172, g = 174, b = 3},
		{r = 142, g = 171, b = 5},
		{r = 110, g = 133, b = 25},
		{r = 96, g = 106, b = 58},
		{r = 129, g = 138, b = 25},
	},
	green = {
		{r = 90, g = 139, b = 33},
		{r = 18, g = 89, b = 10},
		{r = 63, g = 85, b = 18},
		{r = 41, g = 90, b = 18},
		{r = 87, g = 134, b = 32},
		{r = 72, g = 134, b = 41},
		{r = 78, g = 132, b = 20},
		{r = 40, g = 135, b = 31},
	},
	green_dark = {
		{r = 24, g = 90, b = 17},
		{r = 19, g = 89, b = 11},
		{r = 55, g = 67, b = 9},
		{r = 66, g = 78, b = 23},
		{r = 58, g = 65, b = 32},
		{r = 43, g = 81, b = 19},
		{r = 20, g = 74, b = 20},
		{r = 39, g = 57, b = 19},
	},
	teal = {
		{r = 31, g = 212, b = 179},
		{r = 12, g = 77, b = 29},
		{r = 25, g = 143, b = 58},
		{r = 36, g = 183, b = 112},
		{r = 79, g = 140, b = 85},
		{r = 115, g = 162, b = 141},
		{r = 74, g = 132, b = 101},
	},
	cyan = {
		{r = 67, g = 180, b = 217},
		{r = 164, g = 199, b = 198},
		{r = 114, g = 167, b = 166},
		{r = 79, g = 125, b = 128},
		{r = 20, g = 93, b = 96},
		{r = 41, g = 76, b = 78},
		{r = 71, g = 134, b = 110},
		{r = 58, g = 171, b = 175},
	},
	blue = {
		{r = 38, g = 62, b = 182},
		{r = 59, g = 92, b = 107},
		{r = 28, g = 88, b = 188},
		{r = 42, g = 60, b = 77},
		{r = 57, g = 61, b = 136},
		{r = 32, g = 117, b = 179},
		{r = 37, g = 100, b = 168},
		{r = 23, g = 51, b = 94},
	},
	purple = {
		{r = 91, g = 37, b = 129},
		{r = 61, g = 49, b = 137},
		{r = 76, g = 59, b = 107},
		{r = 35, g = 16, b = 69},
		{r = 111, g = 70, b = 184},
		{r = 106, g = 97, b = 123},
		{r = 163, g = 138, b = 206},
		{r = 75, g = 77, b = 79},
	},
	pink = {
		{r = 242, g = 175, b = 214},
		{r = 104, g = 25, b = 99},
		{r = 144, g = 83, b = 123},
		{r = 184, g = 167, b = 183},
		{r = 135, g = 76, b = 158},
		{r = 240, g = 168, b = 236},
		{r = 225, g = 68, b = 217},
		{r = 167, g = 134, b = 146},
	},
	white = {
		{r = 209, g = 226, b = 207},
		{r = 156, g = 157, b = 154},
		{r = 203, g = 190, b = 212},
		{r = 213, g = 214, b = 212},
		{r = 217, g = 230, b = 201},
		{r = 163, g = 198, b = 196},
		{r = 247, g = 247, b = 245},
		{r = 172, g = 178, b = 180},
		{r = 229, g = 230, b = 226},
		{r = 255, g = 255, b = 255},
	},
}

local function update_tree(info)
	local tree = data.raw.tree[info.base];
	tree.autoplace = autoplace_settings(info.autoplace)
	if info.colors then
		tree.colors = {}
		local c = 0
		for _, colorset_name in pairs(info.colors) do
			for _2, color in pairs(colors[colorset_name]) do
				c = c + 1
				tree.colors[c] = color
			end
		end
	end
	--tree.localised_name = {info.base}
end
local function add_tree(info)
	local tree = table.deepcopy(data.raw.tree[info.base]);
	tree.name = info.name
	tree.autoplace = autoplace_settings(info.autoplace)
	if info.colors then
		tree.colors = {}
		local c = 0
		for _, colorset_name in pairs(info.colors) do
			for _2, color in pairs(colors[colorset_name]) do
				c = c + 1
				tree.colors[c] = color
			end
		end
	end
	tree.localised_name = { "entity-name.tree-01"}
	--tree.localised_name = {info.name}
	data:extend({tree})
end

--[[
base settings:
tree 01 {{{35, 1}, {25, 0.35}}} 																		-- olive green, yellowish -- Y spike normalish, orange trunk
tree 02 {{{25, 0.7}, {10, 0.5}}} -- green 																-- A or I shaped coniferish, red trunk
tree 02(red) {{{25, 0.5}, {10, 0.4}}} autoplace_extra = { random_probability_penalty = 3e-3 }, yellows reds greens
tree 03 {{{30, 1}, {20, 0.7}}} --light-v2-green -- brown/yel/red 										-- Spun rope branching  Y, pale yellow trunk
tree 04 {{{20, 0.8}, {5, 0.4}}} --green 																-- Thick trunk T, deep red purplish trunk
tree 05 {{{20, 0.8}, {5, 0.4}}} -- green L-2 															-- I or P shape brown trunk
tree 06 {{{35, 0.15}, {10, 0.05}, 0.19}}, { max_probability = 0.3 }, --green 							-- Weeping willow - grey trunk A shape
tree 06(brown) {{{35, 0.2}, {10, 0.05}, 0.2}}, { max_probability = 0.3 }, --brownish-orange-light
tree 07 {{{35, 0.25}, {5, 0.15}, 0.21}} { max_probability = 0.3495 }, --yellow/brownish-almost-green 	-- Weeping willow I shape (sad looking) white trunk
tree 08 {{{0.3, 10}, {0, 0}}} --green-yellow-for-desert  -- orange / brownish-light  --reddish 			-- Narrow T shape, a-shaped trunk grey trunk
tree 08(brown) {{{0.1, 0}, {-10, 0}}}  -- orange / brownish-light
tree 08(red)  {{{0.3, 0}, {-10, 0.1}}}  --reddish
tree 09 {{{35, 0.4}, {25, 0.3}, 0.21}} { max_probability = 0.5 }, --DARK-green L-2  					-- Very thick trunk, T shaped, yellowish grey trunk
tree 09(brown) {{{35, 0.25}, {15, 0.15}, 0.21}} { max_probability = 0.35 }  -- greenish / brownish/ reddish -light- for desert
tree 09(red) {{{25, 0.25}, {5, 0.15}, 0.21}}  { max_probability = 0.3495 }, --red - for green-grass

green-coral {{{35, 0.4}, {20, 0.2}}}
]]--

-- move existing and lower probablility
-- green
update_tree({base="tree-01", 		autoplace={max=0.1, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[3],biome.temperature[5]}}}})
-- cool grass
update_tree({base="tree-02", 		autoplace={max=0.1, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[1],biome.temperature[3]}}}})
update_tree({base="tree-02-red", 	autoplace={max=0.1, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[3]}}}})
-- yellow grass
update_tree({base="tree-03", 		autoplace={max=0.1, terrain={water={biome.water[3], biome.water["e"]}, temperature={biome.temperature[5],biome.temperature[6]}}}})
-- red grass
update_tree({base="tree-04", 		autoplace={max=0.1, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[7],biome.temperature[8]}}}})
-- any wet grass
update_tree({base="tree-05", 		autoplace={max=0.1, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[8]}}}})
-- cool grass
update_tree({base="tree-06", 		autoplace={max=0.1, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[4]}}}})
-- cool dirt
update_tree({base="tree-06-brown", 	autoplace={max=0.1, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[1],biome.temperature[4]}}}})
-- cool dirt
update_tree({base="tree-07", 	autoplace={max=0.1, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[1],biome.temperature[3]}}}})
-- warm dirt
update_tree({base="tree-08", 		autoplace={max=0.1, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[3],biome.temperature[8]}}}})
update_tree({base="tree-08-brown", 	autoplace={max=0.1, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[3],biome.temperature[8]}}}})
update_tree({base="tree-08-red", 	autoplace={max=0.1, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[3],biome.temperature[8]}}}})
-- warm deserts
update_tree({base="tree-09", 		autoplace={max=0.1, terrain={water={biome.water[0], biome.water[3]}, temperature={biome.temperature[5],biome.temperature[8]}}}})
update_tree({base="tree-09-brown", 	autoplace={max=0.1, terrain={water={biome.water[0], biome.water[3]}, temperature={biome.temperature[4],biome.temperature[8]}}}})
update_tree({base="tree-09-red", 	autoplace={max=0.1, terrain={water={biome.water[0], biome.water[3]}, temperature={biome.temperature[3],biome.temperature[8]}}}})



-- red grass
add_tree({name="tree-04-red", 		base="tree-04", autoplace={max=0.4, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[7],biome.temperature[8]}}}, colors = {"purple", "red"} })
add_tree({name="tree-04-orange", 	base="tree-08",	autoplace={max=0.6, terrain={water={biome.water[4], biome.water[5]},  temperature={biome.temperature[7],biome.temperature[8]}}}, colors = {"red", "orange"} })
-- orange grass
add_tree({name="tree-02-orange", 	base="tree-02",	autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[4],biome.temperature[6]}}}, colors = {"yellow", "olive", "orange"} })
add_tree({name="tree-01-orange", 	base="tree-01", autoplace={max=0.5, terrain={water={biome.water[4], biome.water["e"]}, temperature={biome.temperature[6],biome.temperature[7]}}}, colors = {"orange", "olive"} })
-- yellow grass
add_tree({name="tree-08-yellow", 	base="tree-08",	autoplace={max=0.5, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[5],biome.temperature[6]}}}, colors = {"brown", "yellow"} })
add_tree({name="tree-09-yellow", 	base="tree-09", autoplace={max=0.8, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[5],biome.temperature[6]}}}, colors = {"olive", "green", "yellow"} })
-- green grass
add_tree({name="tree-08-green", 	base="tree-08", autoplace={max=0.2, terrain={water={biome.water[3], biome.water[5]}, temperature={biome.temperature[3],biome.temperature[5]}}}, colors = {"green", "green_dark", "brown"} })
add_tree({name="tree-01-olive", 	base="tree-01", autoplace={max=0.7, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[3],biome.temperature[5]}}}, colors = {"olive", "green", "green_dark"}})
add_tree({name="tree-01-green", 	base="tree-01", autoplace={max=0.6, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[3],biome.temperature[4]}}}, colors = {"green", "green_dark"}})
add_tree({name="tree-05-green", 	base="tree-05", autoplace={max=0.8, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[4],biome.temperature[5]}}}, colors = {"green", "brown"} })
-- blue grass
add_tree({name="tree-05-teal", 		base="tree-05",	autoplace={max=0.5, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[2],biome.temperature[3]}}}, colors = {"teal", "cyan"} })
add_tree({name="tree-07-purple", 	base="tree-07", autoplace={max=0.4, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[1],biome.temperature[2]}}}, colors = {"blue", "purple"} })
add_tree({name="tree-06-blue", 		base="tree-06",	autoplace={max=0.7, terrain={water={biome.water[4], biome.water[5]}, temperature={biome.temperature[1],biome.temperature[3]}}}, colors = {"blue", "cyan"} })
-- purple grass
add_tree({name="tree-06-purple", 	base="tree-06",	autoplace={max=0.8, terrain={water={biome.water[5], biome.water["e"]}, temperature={biome.temperature[1],biome.temperature[3]}}}, colors = {"pink", "purple"} })

-- red dirt
add_tree({name="tree-02-ruby",		base="tree-02",	autoplace={max=0.4, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[6],biome.temperature[8]}}}, colors = {"red", "orange"}})
-- yellow dirt
add_tree({name="tree-02-yellow", 	base="tree-02",	autoplace={max=0.4, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[3],biome.temperature[6]}}}, colors = {"yellow", "olive"} })
-- grey dirt
add_tree({name="tree-06-cyan", 		base="tree-06", autoplace={max=0.4, terrain={water={biome.water[2], biome.water[4]}, temperature={biome.temperature[1],biome.temperature[3]}}}, colors = {"blue", "cyan", "brown"} })

-- red desert
add_tree({name="tree-09-ruby",		base="tree-09",	autoplace={max=0.2, terrain={water={biome.water[0], biome.water[2]}, temperature={biome.temperature[6],biome.temperature[8]}}}, colors = {"red_dark", "red"} })
-- yellow desert
add_tree({name="tree-09-yellow",	base="tree-09", autoplace={max=0.2, terrain={water={biome.water[0], biome.water[2]}, temperature={biome.temperature[3],biome.temperature[6]}}}, colors = {"yellow", "orange", "red"} })
-- grey desert
add_tree({name="tree-09-pink",		base="tree-09", autoplace={max=0.15, terrain={water={biome.water[0], biome.water[2]}, temperature={biome.temperature[2],biome.temperature[3]}}}, colors = {"red", "pink", "white"} })
add_tree({name="tree-09-grey",		base="tree-09", autoplace={max=0.1, terrain={water={biome.water[0], biome.water[2]}, temperature={biome.temperature[1],biome.temperature[2]}}}, colors = {"cyan", "pink", "white"} })

-- snow
add_tree({name="tree-02-white", 	base="tree-02", autoplace={max=0.8, terrain={water={biome.water[3], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[1]}}}, colors = {"white", "green_dark"} })
add_tree({name="tree-02-white-sparse", 	base="tree-02", autoplace={max=0.1, terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[0],biome.temperature[1]}}}, colors = {"white", "green_dark", "green"} })

--lava
add_tree({name="coral-lava-01", 	base="tree-02",	autoplace={max=0.4, terrain={water={biome.water[0], biome.water["e"]}, temperature={biome.temperature[8],biome.temperature["e"]}}}, colors = {"red", "orange", "pink"} })

local snow_variations =
	{
        {
          branch_generation = {
            entity_name = "branch-particle",
            frame_speed = 0.1,
            initial_height = 2,
            initial_height_deviation = 2,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            repeat_count = 15,
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaf_generation = {
            entity_name = "leaf-particle",
            initial_height = 2,
            initial_height_deviation = 1,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-a-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 3,
            height = 164,
            shift = {0.1, -2},
            width = 113
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-a-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 4,
            height = 226,
            shift = {2.45, -1.3},
            width = 300
          }
        },
        {
          branch_generation = {
            entity_name = "branch-particle",
            frame_speed = 0.1,
            initial_height = 2,
            initial_height_deviation = 2,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            repeat_count = 15,
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaf_generation = {
            entity_name = "leaf-particle",
            initial_height = 2,
            initial_height_deviation = 1,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-b-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 3,
            height = 143,
            shift = {0.2, -1.9},
            width = 279/3
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-b-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 4,
            height = 152,
            shift = {0.85, -1.75},
            width = 540/4
          }
        },
        {
          branch_generation = {
            entity_name = "branch-particle",
            frame_speed = 0.1,
            initial_height = 2,
            initial_height_deviation = 2,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            repeat_count = 15,
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaf_generation = {
            entity_name = "leaf-particle",
            initial_height = 2,
            initial_height_deviation = 1,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            speed_from_center = 0.01,
            type = "create-particle"
          },
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-c-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 3,
            height = 258,
            shift = {-0.25, -3},
            width = 534/3
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/10/tree-10-c-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 4,
            height = 321,
            shift = {2.45, -2},
            width = 1400/4
          }
        },
	}
data.raw.tree["tree-02-white"].variations = snow_variations
data.raw.tree["tree-02-white-sparse"].variations = snow_variations

local lava_coral_branch_generation = {
            entity_name = "branch-particle",
            frame_speed = 0.1,
            initial_height = 2,
            initial_height_deviation = 2,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            repeat_count = 15,
            speed_from_center = 0.01,
            type = "create-particle"
          }
local lava_coral_leaf_generation = {
            entity_name = "leaf-particle",
            initial_height = 2,
            initial_height_deviation = 1,
            offset_deviation = {
              {
                -0.5,
                -0.5
              },
              {
                0.5,
                0.5
              }
            },
            speed_from_center = 0.01,
            type = "create-particle"
          }
local lava_coral_variations =
	{
        {
          branch_generation = lava_coral_branch_generation,
          leaf_generation = lava_coral_leaf_generation,
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-a-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 1,
            width = 67,
            height = 57,
            shift = {0, (100 - 57)/-64-0.4},
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-a-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 2,
            width = 254/2,
            height = 100,
            shift = {(254/2 - 67)/64, 0-0.4},
          }
        },
        {
          branch_generation = lava_coral_branch_generation,
          leaf_generation = lava_coral_leaf_generation,
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-b-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 1,
            width = 87,
            height = 59,
            shift = {0, (110 - 59)/-64-0.6},
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-b-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 2,
            width = 302/2,
            height = 110,
            shift = {(302/2 - 87)/64, 0-0.6},
          }
        },
        {
          branch_generation = lava_coral_branch_generation,
          leaf_generation = lava_coral_leaf_generation,
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-c-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 1,
            width = 72,
            height = 74,
            shift = {0, (110 - 74)/-64-0.2},
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-c-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 2,
            width = 232/2,
            height = 110,
            shift = {(232/2 - 72)/64, 0-0.2},
          }
        },
        {
          branch_generation = lava_coral_branch_generation,
          leaf_generation = lava_coral_leaf_generation,
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-d-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 1,
            width = 59,
            height = 65,
            shift = {0, (110 - 65)/-64-1},
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-d-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 2,
            width = 236/2,
            height = 110,
            shift = {(236/2 - 59)/64, 0-1},
          }
        },
        {
          branch_generation = lava_coral_branch_generation,
          leaf_generation = lava_coral_leaf_generation,
          leaves = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-e-leaves.png",
            flags = {
              "mipmap"
            },
            frame_count = 1,
            width = 65,
            height = 81,
            shift = {0, (110 - 81)/-64-0.8},
          },
          trunk = {
            filename = "__alien-biomes__/graphics/entity/tree/coral-01/coral-01-e-trunk.png",
            flags = {
              "mipmap"
            },
            frame_count = 2,
            width = 200/2,
            height = 110,
            shift = {(200/2 - 65)/64, 0-0.8},
          }
        },
	}
data.raw.tree["coral-lava-01"].variations = lava_coral_variations
